#include "util.h"

void core1main(void);
char debugData[SENTENCE_LEN*3]="";								//made up of three sentences
int dataReady=0;												//global to handle data between cores
int core1Fail=0;												//to check on Core0
uint64_t __uninitialized_ram(savedTime);

int main(){
	if(watchdog_caused_reboot()){
	}else{
		savedTime=0;
	}
	memcpy((uint8_t*)&cur,&flashimage, FLASH_SECTOR_SIZE);		//load saved flash parameters	
	validateCC();												//check and validate country code, sets to XX if invalid
    sleep_ms(500);												//settle
	initAll();
	multicore_reset_core1();
	multicore_launch_core1(core1main);
	initialConnect();											//try to connect promptly if available
	printMenu();
	savedTime=0;												//reset until next set
	while(1){		
		checkMenu();
		checkWIFI();
		if(dataReady){											//print
			if(cur.d.debugOn){printf(debugData);}
			dataReady=0;										//hand back for next
		}
		sleep_ms(20);
	}
    return 0;
}

//Core 1 handles the NMEA output independently of Core 0
void __no_inline_not_in_flash_func(core1main)(void){	//run from RAM to avoid potential interference during flash writes
//void core1main(void){	//use this for flash
	datetime_t gps;												//for NMEA output
	uint32_t next=0;
	char talker0='G';
	char talker1='P';
	char RMCsent[SENTENCE_LEN]="";
	char GGAsent[SENTENCE_LEN]="";
	char GSAsent[SENTENCE_LEN]="";	
	char latlonStr[SCAN_LEN]="";
	char timeStr[SCAN_LEN]="";
	int state;
	dms localLat,localLon;
	long activeBaud=cur.d.baudrate;
	multicore_lockout_victim_init();							//this is only needed to allow flash writing
	uart_init(uart0, activeBaud); 
    gpio_set_function(0, GPIO_FUNC_UART);						//TX only, no RX    
	gpio_init(PPS_PIN);											//control of GPIO for PPS
	gpio_set_dir(PPS_PIN, GPIO_OUT);
	gpio_put(PPS_PIN,0);
	while(1){
		next=stampNow()+1;										//get data for next second and prepare; always means fractional seconds are zero
		state=ledState;											//capture snapshot of state:map system state to pseudo-GPS state
		localLat=getDMS(cur.d.lat);
		localLon=getDMS(cur.d.lon);		
		talker0=cur.d.talker[0];
		talker1=cur.d.talker[1];
		gps=getDateTime(next);									//decode timestamp to datetime object
		//set up common strings
		//lat/lon data eg 5321.6802,N,00630.3372,W
		latlonStr[0]=0;
		sprintf(latlonStr,"%02d%02d.%04d,%c,%03d%02d.%04d,%c",localLat.d,localLat.m,localLat.s,localLat.lat,localLon.d,localLon.m,localLon.s,localLon.lon);
		//time data eg 092750.000
		timeStr[0]=0;
		sprintf(timeStr,"%02d%02d%02d.%03d",gps.hour,gps.min,gps.sec,0);
		//set up RMC sentence
		RMCsent[0]=0;
		sprintf(RMCsent,"$%c%cRMC,%s,%c,%s,0.00,000.00,%02d%02d%02d,,,*",talker0,talker1,timeStr,(ledState>1)?'A':'V',latlonStr,gps.day,gps.month,gps.year%100);  		
		addChecksum(RMCsent);
		//set up GGA sentence
		GGAsent[0]=0;
		sprintf(GGAsent,"$%c%cGGA,%s,%s,%c,04,1.0,0.0,M,0.0,M,,*",talker0,talker1,timeStr,latlonStr,(ledState>1)?'1':'0');  		
		addChecksum(GGAsent);
		//set up GSA sentence
		GSAsent[0]=0;
		sprintf(GSAsent,"$%c%cGSA,A,%c,,,,,,,,,,,,,1.00,1.00,1.00,*",talker0,talker1,(ledState>1)?'3':'1');
		addChecksum(GSAsent);
		if(activeBaud!=cur.d.baudrate){							//handle baud rate change
			activeBaud=cur.d.baudrate;
			uart_set_baudrate(uart0, activeBaud); 
		}		
		if(next>=stampNow()){									//unless there's a glitch
			while(next>stampNow()){sleep_ms(10);}				//wait until next second to output				
		}		
		gpio_put(PPS_PIN,1);									//high
		uart_puts(uart0, RMCsent);
		uart_puts(uart0, "\r\n");
		uart_puts(uart0, GGAsent);
		uart_puts(uart0, "\r\n");
		uart_puts(uart0, GSAsent);
		uart_puts(uart0, "\r\n");
		if(dataReady==0){
			core1Fail=0;
			debugData[0]=0;										//null, then add data
			sprintf(debugData,"%s\r\n%s\r\n%s\r\n",RMCsent,GGAsent,GSAsent);
			dataReady=1;
		}else{
			core1Fail++;
			if(core1Fail>CORE1_FAIL_LIMIT){						//reboot as other core not reading data, not responding
				saveAndReset();
			}
		}
		gpio_put(PPS_PIN,0);									//low
	}
}