from maix import camera, display, image, nn, app, gpio, pinmap, time

# Load YOLOv5 model for smoking detection
detector = nn.YOLOv5(model="/root/models/smoking.mud")

# Initialize camera with model's input resolution
cam = camera.Camera(detector.input_width(), detector.input_height(), detector.input_format())
dis = display.Display()

# Define the pins for the LEDs
pinmap.set_pin_function("A15", "GPIOA15")
led_smoker = gpio.GPIO("GPIOA15", gpio.Mode.OUT)  # LED for smoker detected
led_smoker.value(0)  # Turn off initially

pinmap.set_pin_function("A16", "GPIOA16")
led_no_smoker = gpio.GPIO("GPIOA16", gpio.Mode.OUT)  # LED for no smoker detected
led_no_smoker.value(1)  # Green LED ON initially (indicating no smoker)

snapshot_taken = False  # Flag to avoid multiple snapshots per detection

while not app.need_exit():
    img = cam.read()
    objs = detector.detect(img, conf_th=0.5, iou_th=0.45)

    smoker_detected = False  # Flag to track if a smoker is detected

    for obj in objs:
        label = detector.labels[obj.class_id]
        
        # Ensure 'smoke' is the correct label in your model
        if label.lower() == "smoke":
            smoker_detected = True
            img.draw_rect(obj.x, obj.y, obj.w, obj.h, color=image.COLOR_RED)
            msg = f'{label}: {obj.score:.2f}'
            img.draw_string(obj.x, obj.y, msg, color=image.COLOR_RED)

            # Take a snapshot only if not already taken
            if not snapshot_taken:
                formatted_time = time.localtime()  # Get current time in MaixPy format
                time_str = f"{formatted_time.year}-{formatted_time.month:02d}-{formatted_time.day:02d} {formatted_time.hour:02d}:{formatted_time.minute:02d}:{formatted_time.second:02d}"
                
                metadata = f"Time: {time_str}\nConfidence: {obj.score:.2f}\nBBox: ({obj.x},{obj.y},{obj.w},{obj.h})"
                print(metadata)

                # Draw metadata on the image before saving
                img.draw_string(5, 5, f"Time: {time_str}", color=image.COLOR_WHITE, scale=1)
                #img.draw_string(5, 25, f"Conf: {obj.score:.2f}", color=image.COLOR_WHITE, scale=1)
                #img.draw_string(5, 45, f"BBox: ({obj.x},{obj.y},{obj.w},{obj.h})", color=image.COLOR_WHITE, scale=1)

                save_path = "/snapshot/snapshot.jpg"  # Ensure SD card is mounted
                img.save(save_path)
                print(f"Snapshot saved at {save_path}")
                snapshot_taken = True  # Prevent continuous snapshot saving

    # Control LEDs based on detection
    if smoker_detected:
        led_smoker.value(1)  # Red LED ON if smoker detected
        led_no_smoker.value(0)  # Green LED OFF
    else:
        led_smoker.value(0)  # Red LED OFF
        led_no_smoker.value(1)  # Green LED ON
        snapshot_taken = False  # Reset flag when no smoker is detected

    dis.show(img)