//SSD1306/SH1106 OLED implementation for 8-bit PICs
//uses horizontal scanning of fonts and bitmaps to match output order

#ifndef OLED_H
#define OLED_H
#include <xc.h>
#include "portbits.h"
#include "globalPins.h"

#define OLED_BLANK_CHAR (' ')

//#define USE_EEPROM_X_OFFSET
#ifdef USE_EEPROM_X_OFFSET
extern __eeprom signed char oledXoffset;
extern const char xAlign[];
#define OLED_X_OFFSET_MIN (-9)
#define OLED_X_OFFSET_MAX (9)
#endif

#define OLED_ADDRESS 0x78   //8bit write address, read address is +1
//#define OLED_ADDRESS 0x7A   //8bit write address, read address is +1

//copies data to VRAM image for debugging etc
//#define OLED_USE_VRAM
#ifdef OLED_USE_VRAM
extern unsigned char OLED_VRAM[8][128];
//extern unsigned char oledVramX,oledVramY; //keep local
void I2CvramByte(unsigned char n);  //alias to I2Cbyte, but filter data to VRAM image
#include "uart.h"
#define sendAbyte uartSend
#define TRIG_PIN a0
#else
//straight substitution
#define I2CvramByte I2Cbyte
#endif  //OLED_USE_VRAM

//for flippable text display
#define TEXT_RH 1
#define TEXT_LH 2
#define OLED_CONNECTOR_AT_TOP 1
#define OLED_CONNECTOR_AT_BOTTOM 2

extern unsigned char OLEDcol,OLEDpage; //column variable
extern char OLEDbuf[11];  //for numeric displays

//soft I2C:
void I2Cstop(void);
void I2Cstart(void);        //assume in valid state
void I2Cinit(void);
void I2Cdeinit(void);         //power off, not much point unless OLEDPWR is defined
void I2Cbyte(unsigned char n);  //send byte, unrolled inline version is slightly faster
void I2Cbitdelay(void); //adjust to suit processor speed, bus speed etc
//OLED
void OLEDsendCommand(unsigned char c);
void OLEDsendData(unsigned char c);
void OLEDbrightness(unsigned char b);
void OLEDclear(unsigned char c);        //bit pattern c
void OLEDinit(void);
void OLEDsetpage(unsigned char p);
void OLEDsetcolumn(unsigned char c);
void OLEDflip(char c);      //to suit flip orientation according to textFlip
void OLEDchar(const char c,const char* f);//single character, OLEDcol/OLEDpage handled internally
void OLEDcharRev(const char c,const char* f);   //reversed
void OLEDchararray(const char* c, const char* f);    //char array version of above
void OLEDbitmap(const char* b); //show bitmap at current column/row
void OLEDscanlong(unsigned long n);
void OLEDscanshort(unsigned int n);     //converts an unsigned int into a decimal
void OLEDsetpos(unsigned char p,unsigned char c);   //set OLEDpage and column to streamline, needs to occur after address write
void OLEDlzb(char n);   //blank OLEDbuf[] up to/including n (ie 8 is all except last)
void OLEDblock(char x, char y, unsigned char c);    //draw solid block of pattern c (ie OLEDblock(128,64,n)<> OLEDclear(n)

#ifdef OLED_USE_VRAM
//VRAM dumper
void dumpVRAM(void);    //send image of VRAM
#define CR_CHAR 13
const char dibitChar[]={' ',0xDF,0xDC,0xDB};
#endif  //OLED_USE_VRAM

#endif  //OLED_H

