#include "config.h"
#include <xc.h>
#include "globalPins.h"
#include "uart.h"
#include "oled.h"
#include "font.h"
#include "gps.h"
#include "timer1.h"
#include <stdlib.h>     //for atof

#define KNOTS_MPH (1.15078) 
#define KNOTS_KPH (1.852)

//set units here, use 1 for knots
#define KNOTS_FACTOR KNOTS_KPH
//set unit symbol here, any char
#define UNITS_SYMBOL 'K'

//~22Hz gives just over 2s
#define GPS_DATA_TIMEOUT (50)

volatile unsigned char gpsdata=0;
float speed_kts=0;
float speed_adjusted=0;
unsigned int speed=0;   //int for processing

int main(void){    
    unsigned char a;
    unsigned char gpsstate=0;
    OSCCONbits.IRCF = 0b1111; //use 16MHz HFINTOSC
    ANSELA=0;
    ANSELC=0;
    uart_init();
    OLEDinit();
    OLEDclear(0);
	timer1init();
    GIE = 1;      //global interrupt enable    
    while (1) {
        while(uart_available()){
            a=uart_receive();
            gps_feed(a);    
            gpsdata=GPS_DATA_TIMEOUT;
        }
        gpsstate=((vfields[2][0]=='A')?4:0)+((gpsvalid)?2:0)+((gpsdata)?1:0);      //7=> data 'A' 3=> cx ok, 1=> no fix, 0=> no data
        OLEDcol=0;
        OLEDpage=0;
        if(gpsstate==7){    //fully operational
            speed_kts=(float)atof(&vfields[7][0]);
            speed_adjusted=0;   //sensible default if units error
            speed_adjusted=(float)(speed_kts*KNOTS_FACTOR);
            speed=(unsigned int)speed_adjusted;
            if(speed>999){speed=999;}
            OLEDscanshort(speed);
            OLEDlzb(8);
            gpsnewdata=0;
            OLEDchar(OLEDbuf[7],arial);
            OLEDchar(OLEDbuf[8],arial);
            OLEDchar(OLEDbuf[9],arial);
        }else if((gpsstate&1)==0){  //no data at all
            OLEDchar(SPACE_CHAR,arial);
            OLEDchar(SPACE_CHAR,arial);
            OLEDchar(DASH_CHAR,arial);
        }else if((gpsstate&2)==0){  //valid RMC sentences being received
            OLEDchar(SPACE_CHAR,arial);
            OLEDchar(DASH_CHAR,arial);        
            OLEDchar(DASH_CHAR,arial);        
        }else if((gpsstate&4)==0){  //waiting for satellite lock
            OLEDchar(DASH_CHAR,arial);        
            OLEDchar(DASH_CHAR,arial);        
            OLEDchar(DASH_CHAR,arial);            
        }
        OLEDchar(UNITS_SYMBOL,arial);        
        OLEDcol=0;
        OLEDpage=4;
        OLEDchar(gpsstate+'0',arial);
        OLEDchar(vfields[2][0],arial);
        OLEDchar(gpsnewdata+'0',arial);
    }
}

void __interrupt() isr(void){
    uartISR();
    if(PIR1bits.TMR1IF && PIE1bits.TMR1IE){              //Timer1 interrupt
        PIR1bits.TMR1IF=0;            //clear flag
        if(gpsvalid){gpsvalid--;}      //count down, takes about 11s to get from 255
        if(gpsdata){gpsdata--;}      //count down, takes about 11s to get from 255
    }    
}