#ifndef PORTBITS_H
#define	PORTBITS_H
/*
 * Generic unified port access structs for PIC16F1455 (should be ok for '1459)
 * #define checks ensure only actual port members are defined
 * can use port (a0..e3) defines for access to all port control structs
 * portbits.
 * trisbits.
 * latbits.
 *  * Compiles to same BCF/BSF opcode as standard port names
 */

#include <xc.h> // include processor files - each processor file is guarded.  
//should work for most 16F1xxxx parts

typedef struct {
        unsigned int 
#ifdef _PORTA_RA0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _PORTA_RA1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _PORTA_RA2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _PORTA_RA3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _PORTA_RA4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _PORTA_RA5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _PORTA_RA6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _PORTA_RA7_SIZE
    a7
#endif
    :1; unsigned int
#ifdef _PORTB_RB0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _PORTB_RB1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _PORTB_RB2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _PORTB_RB3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _PORTB_RB4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _PORTB_RB5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _PORTB_RB6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _PORTB_RB7_SIZE
    b7
#endif
    :1; unsigned int
#ifdef _PORTC_RC0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _PORTC_RC1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _PORTC_RC2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _PORTC_RC3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _PORTC_RC4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _PORTC_RC5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _PORTC_RC6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _PORTC_RC7_SIZE
    c7
#endif
    :1; unsigned int
#ifdef _PORTD_RD0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _PORTD_RD1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _PORTD_RD2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _PORTD_RD3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _PORTD_RD4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _PORTD_RD5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _PORTD_RD6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _PORTD_RD7_SIZE
    d7
#endif
    :1; unsigned int
#ifdef _PORTE_RE0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _PORTE_RE1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _PORTE_RE2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _PORTE_RE3_SIZE
    e3
#endif
    :1;
} portbits_t;

extern volatile portbits_t portbits __at(0x00C);

typedef struct {
        unsigned int 
#ifdef _TRISA_TRISA0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA7_SIZE
    a7
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB7_SIZE
    b7
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC7_SIZE
    c7
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD7_SIZE
    d7
#endif
    :1; unsigned int
#ifdef _TRISE_TRISE0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _TRISE_TRISE1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _TRISE_TRISE2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _TRISE_TRISE3_SIZE
    e3
#endif
    :1;
} trisbits_t;

extern volatile trisbits_t trisbits __at(0x08C);

typedef struct {
        unsigned int 
#ifdef _LATA_LATA0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _LATA_LATA1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _LATA_LATA2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _LATA_LATA3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _LATA_LATA4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _LATA_LATA5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _LATA_LATA6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _LATA_LATA7_SIZE
    a7
#endif
    :1; unsigned int
#ifdef _LATB_LATB0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _LATB_LATB1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _LATB_LATB2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _LATB_LATB3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _LATB_LATB4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _LATB_LATB5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _LATB_LATB6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _LATB_LATB7_SIZE
    b7
#endif
    :1; unsigned int
#ifdef _LATC_LATC0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _LATC_LATC1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _LATC_LATC2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _LATC_LATC3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _LATC_LATC4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _LATC_LATC5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _LATC_LATC6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _LATC_LATC7_SIZE
    c7
#endif
    :1; unsigned int
#ifdef _LATD_LATD0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _LATD_LATD1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _LATD_LATD2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _LATD_LATD3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _LATD_LATD4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _LATD_LATD5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _LATD_LATD6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _LATD_LATD7_SIZE
    d7
#endif
    :1; unsigned int
#ifdef _LATE_LATE0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _LATE_LATE1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _LATE_LATE2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _LATE_LATE3_SIZE
    e3
#endif
    :1;
} latbits_t;

extern volatile latbits_t latbits __at(0x10C);

#endif	/* PORTBITS_H */

