//UART implementation for 16F1455
//RC4 = TX, RC5 = RX
// this version has TX disabled
#include "uart.h"

//for buffered operation
volatile char uart_rx_buffer[UART_BUFFER_SIZE];
volatile unsigned int uart_rx_buffer_head,uart_rx_buffer_tail;

void uart_init(){           //assume fixed baud rate (set by SPBRG/H)
    uart_rx_buffer_head=0;
    uart_rx_buffer_tail=0;
    TRISCbits.TRISC5=1;     //RX is input
    TXSTA = 0x04;       	//disable TX, High speed baud rate
    RCSTA = 0x90;       	//enable RX, continuous receive
    BAUDCON = 0x08;     	//16 bit BRG
    SPBRG = 0xE1;           //9600
    SPBRGH = 0x04;

//    SPBRG = 0xC3;           //4800
//    SPBRGH = 0x09;

	if (RCSTAbits.OERR){
		RCSTAbits.SPEN = 0;  // reset the port
		RCREG;
		RCSTAbits.SPEN = 1;  // and keep going.
	}
    PIE1bits.RCIE=1;         //receive interrupt, only enable transmit interrupt if buffer full
	INTCONbits.PEIE = 1;     //peripheral interrupt enable
}

char uart_receive(){                  //returns -1 on no data
  char c;
  if(uart_rx_buffer_head==uart_rx_buffer_tail){
      return 0xFF;    //empty
  }
  c=uart_rx_buffer[uart_rx_buffer_tail];
  uart_rx_buffer_tail=(uart_rx_buffer_tail+1)%UART_BUFFER_SIZE;
  return c;
}

int uart_available(){                //    
    return (uart_rx_buffer_head+UART_BUFFER_SIZE-uart_rx_buffer_tail)%UART_BUFFER_SIZE;
}

void uartISR(void){ //call from ISR in main.c
	unsigned char c;
    if(PIR1bits.RCIF){              //RX interrupt flagged
    	if (RCSTAbits.OERR){        //overrun error, need to fix to continue
        	RCSTAbits.CREN = 0;     //reset the port
    		RCREG;
        	RCSTAbits.CREN = 1;     // and keep going.
        }
        c = RCREG;                  //do a read anyway
        if(((uart_rx_buffer_head+1)%UART_BUFFER_SIZE)!=uart_rx_buffer_tail){        //if space available
            uart_rx_buffer[uart_rx_buffer_head]=c;                                  //add to buffer
            uart_rx_buffer_head=(uart_rx_buffer_head+1)%UART_BUFFER_SIZE;           
        }
    }    
}

