#ifndef GPS_H
#define	GPS_H

//GPS NMEA1803 parser
//RMC fields are passed to vfields when valid
//0: GPRMC
//1: Time
//2: Fix (A/V)
//3: LAT
//4: N/S
//5: LON
//6: E/W
//7: Speed (knots)
//8: Track (degrees)
//9: date
//10: magnetic variation, degrees
//11: E/W

#include <xc.h> // include processor files - each processor file is guarded.  

#define GPS_FIELD_SIZE 15
#define GPS_FIELD_COUNT 15
#define GPS_RMC 1
#define GPS_VALID_TICKS (50)

extern char hex[17];                                        //convert value to hex
extern unsigned char gpsvalid;                              //valid flag, zero on invalid, nonzero otherwise
extern char vfields[GPS_FIELD_COUNT][GPS_FIELD_SIZE];       //valid field data
extern char bfields[GPS_FIELD_COUNT][GPS_FIELD_SIZE];       //buffered field data
extern char gpsnewdata;      //flag

void gps_feed(char c);      //feed a character from stream into parser
char unhex(char h);         //convert char '0'-'F' to value

#endif	/* GPS_H */

