#include "gps.h"
//GPS NMEA1803 parser

char hex[17]="0123456789ABCDEF";        //convert value to hex
unsigned char gpsvalid=0;               //valid flag, zero on invalid, nonzero otherwise
char vfields[GPS_FIELD_COUNT][GPS_FIELD_SIZE];       //valid field data
char bfields[GPS_FIELD_COUNT][GPS_FIELD_SIZE];       //buffered field data
char gpsnewdata=0;      //flag

void gps_feed(char c){      //feed a character from stream into parser
    unsigned char i,j;               //loop counters
    static unsigned char cx=0;       //checksum
    static unsigned char scx=0;      //checksum stored when * received
    static unsigned char cxrx=0;     //received checksum from stream
    static unsigned char fieldno=0;    //current field
    static char field[GPS_FIELD_SIZE]=""; 
    static unsigned char fieldptr=0;
    static unsigned char sentencetype=0;
    cx=cx^c;                //update checksum
    if(c=='$'){
        fieldptr=0;
        fieldno++;
        if(fieldno>GPS_FIELD_COUNT-1){fieldno=GPS_FIELD_COUNT-1;}
        fieldno=0;
        cx=0;
        sentencetype=0;
    }
    else if(c==','){
        if((field[0]=='G')&&(field[1]=='P')&&(field[2]=='R')&&(field[3]=='M')&&(field[4]=='C')){sentencetype=GPS_RMC;}        
        for(i=0;i<GPS_FIELD_SIZE;i++){
            bfields[fieldno][i]=field[i];
            if(i>=fieldptr){bfields[fieldno][i]=0;}       //null extra data
        }
        fieldptr=0;
        fieldno++;
        if(fieldno>GPS_FIELD_COUNT-1){fieldno=GPS_FIELD_COUNT-1;}
    }
    else if(c==13){     //end of line
        if((sentencetype==GPS_RMC)&&(scx==cxrx)){           //RMC sentence and checksum matches
            gpsvalid=GPS_VALID_TICKS;
            gpsnewdata=1;
            for(j=0;j<GPS_FIELD_COUNT;j++){
                for(i=0;i<GPS_FIELD_SIZE;i++){
                    vfields[j][i]=bfields[j][i];
                }
            }
        }
    }
    else if(c=='*'){     //start of checksum
        for(i=0;i<GPS_FIELD_SIZE;i++){      //start of checksum is also end of field
            bfields[fieldno][i]=field[i];
            if(i>=fieldptr){bfields[fieldno][i]=0;}       //null extra data
        }
        fieldptr=0;
        fieldno++;
        if(fieldno>GPS_FIELD_COUNT-1){fieldno=GPS_FIELD_COUNT-1;}
        cxrx=0;
        scx=cx^'*';                              //store checksum, remove '*'
    }
    else{       //any other character
        field[fieldptr]=c;
        if(fieldptr<GPS_FIELD_SIZE-1){fieldptr++;}
        cxrx=(unsigned char)((cxrx<<4)|unhex(c));  //received checksum        
    }
}

char unhex(char h){         //convert char '0'-'F' to value
    if((h>='0')&&(h<='9')){return h-'0';}
    if((h>='a')&&(h<='f')){return h-'a'+10;}
    if((h>='A')&&(h<='F')){return h-'A'+10;}
    return 0;
}
