; SIRENE7b.INC: = SIRENE8b.INC using one pin to drive PIEZO
; BENABADJI Hichem - ORAN - Dec. 23rd, 2024

;-----------------------------------------------------------------------------
; declare in the main file:
;-----------------------------------------------------------------------------
;#define	PIEZO	GPIO, 2		; piezo for alarm
;; siren
;	frequency, counter
;	cycles1, cycles2
;	steps

;-----------------------------------------------------------------------------
; ToneHo sound, approx. 2 kHz (never apply permanent DC voltage to piezo)
;-----------------------------------------------------------------------------
ToneHo
	clrf  cycles1
Ho
	bcf   PIEZO		; PIEZO LOW...
	DELAY257us		;...during 0.258 ms

	bsf   PIEZO		; PIEZO HIGH...
	DELAY257us		;...during 0.258 ms

	decfsz cycles1, f
	goto   Ho		; repeat Ho tone during 0.516 * 256 = 132,096 ms

	bcf   PIEZO		; turn off piezo
	retlw	0

;-----------------------------------------------------------------------------
; ToneHi sound, approx. 4 kHz (never apply permanent DC voltage to piezo)
;-----------------------------------------------------------------------------
ToneHi
	clrf  cycles1
Hi
	bcf   PIEZO		; PIEZO LOW ...
	DELAY128us 		;...during 0.129 ms
	bsf   PIEZO		; PIEZO HIGH ...
	DELAY128us 		;...during 0.129 ms
	
	bcf   PIEZO		; PIEZO LOW ...
	DELAY128us 		;...during 0.129 ms
	bsf   PIEZO		; PIEZO HIGH ...
	DELAY128us 		;...during 0.129 ms
	
	decfsz cycles1, f
	goto   Hi		; repeat Hi tone during 0.516 * 256 = 132,096 ms

	bcf   PIEZO		; turn off piezo
	retlw	0

;-----------------------------------------------------------------------------
; Display sound, in 6-bit binary bips: 
; da-da-da-da-da-da = 0 ; ti-ti-ti-ti-ti-ti = 63
;-----------------------------------------------------------------------------
DispSonore
; do Tfridge - 50
	movlw	.50
	subwf	Tfridge, w		; w <- Tfridge - 50
	btfss	STATUS, C		; w >= 0 ?
	goto	lessThan50		; no
	
	movwf	celsius			; celsius = Tfridge - 50

	MOVLF	.7, steps	; put 7 to test 6 bit
	rlf		celsius, f	; throw away bit7
	rlf		celsius, f	; throw away bit6
testbitK
	decf steps, f		; decrement steps
	btfsc	STATUS, Z	; steps <> 0 ?
	goto	fini		; no, i.e. steps = 0
 
;------------
	MOVLF	.5, cpt3
	CALL	Delay100ms	; do 100ms delay
	clrwdt
	
	rlf		celsius, f		; C <- bitK
	btfss	STATUS, C		; C == 1 ?
	goto	bitLOW
	goto	bitHIGH
bitLOW
	CALL	ToneHo
	goto	testbitK
bitHIGH
	CALL	ToneHi
	goto	testbitK

lessThan50
	MOVLF	.50, Tfridge ;;; for test only
	goto	DispSonore	 ;;; for test only

fini
	retlw	0
