; DONA2.ASM: LDR55 thru AN0 + Siren Sound (use PIC10F222)
; BENABADJI Hichem - ORAN - Dec. 24th, 2024

;controller	EQU	10F220
controller	EQU	10F222

	if	controller == 10F220
		List P = 10F220
#include <P10F220.inc>
	endif
	
	if	controller == 10F222
		List P = 10F222
#include <P10F222.inc>
	endif

;	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _MCPU_OFF & _IOFSCS_4MHZ
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _MCPU_OFF & _IOFSCS_4MHZ
 
;------------------------------ define hardware -------------------------------
;internal 4MHz

#define	 LDR55		GPIO, 0
#define	 LDR55pu	GPIO, 1
#define	 PIEZO		GPIO, 2

;------------------------------ define constants ------------------------------

#define	 OPTIONVAL	b'11001111' ; <765>=110: no wakeup; no pullup; use GP2, not TOCKI
								; <3210>=1111: WDT prescaler 1:128 => timeout # 2.3 s
								
	CONSTANT  CBLOCK16 = 0x10 ; 16 bytes RAM for PIC10F200/204/220
	CONSTANT  CBLOCK23 = 0x09 ; 23 bytes RAM for PIC10F222
	CONSTANT  CBLOCK24 = 0x08 ; 24 bytes RAM for PIC10F202/206

;REF06V	  EQU	.60 	  ; internal band gap 0.60V
;REF06V	  EQU	.59 	  ; internal band gap 0.59V

;Hysteresis
LDR55MIN	  EQU	.40		; lightness < MIN. num.count 
LDR55MAX	  EQU	.128	; darkness > MAX. num.count 

INTERBIPMAX	  EQU	.30		; 30 * WDT=2.3s ==> about 1 minute

;------------------------------ define variables ------------------------------

	CBLOCK	CBLOCK23	; beginning of RAM (PIC10F222)

; delay
	cpt1, cpt2,	cpt3	; counters
	interbip			; delay between 2 successives alarm bip
; siren
	frequency, counter
	cycles1, cycles2
	steps
; others
	Tfridge, celsius

	ENDC
;11 bytes used
;------------------------------------------------------------------------------
; macro to put a literal value (constant) into a register
;------------------------------------------------------------------------------
MOVLF	macro	literal, file	; literal -> file
	movlw	literal
	movwf	file
	endm

;-------------------------- Delay 128 us (for 4 MHz)---------------------------
DELAY128us	macro
	MOVLW	.42
	MOVWF	cpt1		; 2 us
	DECFSZ	cpt1, f		; cpt1-- and test if nul
	GOTO	$-1			; no, then loop (3 us * 42 = 126 us)
	endm

;-------------------------- Delay 257 us (for 4 MHz)---------------------------
DELAY257us	macro
	MOVLW	.85
	MOVWF	cpt1		; 2 us
	DECFSZ	cpt1, f		; cpt1-- and test if nul
	GOTO	$-1			; no, then loop (3 us * 85 = 255 us)
	endm

;//////////////////////////////////////////////////////////////////////////////
;	MAIN PROGRAM
;//////////////////////////////////////////////////////////////////////////////
	ORG   0
	goto	Main
;//////////////////////////////////////////////////////////////////////////////

#include "IF8B16B3.INC"
#include "SIRENE7b.INC"

;------------------------------------------------------------------------------
; Delay approx. 1 s (4 MHz)
;------------------------------------------------------------------------------
Delay1s
	MOVLF	.10, cpt3
Delay100ms
	MOVLF	.100, cpt2
Delay1ms
	MOVLF	.250, cpt1
etiq1
	nop					;1us \
	decfsz	cpt1, f	 	;1us  |=> internal loop: 4 * 250 = 1000 us = 1 ms delay
	goto	etiq1		;2us /

	decfsz	cpt2, f	
	goto    Delay1ms

	decfsz	cpt3, f	
	goto    Delay100ms
	retlw	0

;-------------------------- Delay 99 us (for 4 MHz)---------------------------
Delay99us				; 2 us for CALL
	MOVLF  .31, cpt1	; 2 us
	decfsz	cpt1, f		; cpt1-- and test if nul
	goto	$-1			; no, then loop (3 us * 31 = 93 us)
	retlw	0			; 2 us for RETURN
;-----------------------------------------------------------------------------
meas8bit
	movwf	ADCON0

	CALL	Delay99us
		
	bsf		ADCON0, GO	; initiate one A/D conversion
	btfsc	ADCON0, GO	; A/D conversion complete ?
	goto	$-1			; no

	bcf		ADCON0, ADON	; ADC off => lower power consumption
	retlw	0
;------------------------------------------------------------------------------
cfgInit
;cfg OPTION
	movlw  OPTIONVAL
	OPTION
;cfg GPIO
	movlw  b'00001001'
	TRIS   GPIO			; GP0 input, but GP1 & GP2 outputs
	clrf   GPIO
	nop
	bsf	   LDR55pu		; enable pullup for LDR55
;cfg ADC
	movlw	b'01000000'
	movwf	ADCON0		; GP0=AN0, GP1 digital, channel 00, ADC off 
	retlw	0

;//////////////////////////////////////////////////////////////////////////////
Main
 	btfss	STATUS, NOT_TO	; <4> cleared upon a WDT reset
 	goto	fromWDTreset 
;pwrON 
;calibrate OSCCAL with the value inside the last flash address
	;movlw	48h			; particular calibration value for my PIC10F222 sample
	movwf	OSCCAL		; trim the internal oscillator accuracy to 1% at 4 MHz
	
	MOVLF	.1, interbip

fromWDTreset ;---------------------------------------------
;;;after wakeup, OPTION, TRISGPIO & ADCON0 must be reconfigured !!!
;p.36/78 (DS41270B.PDF: PIC10F220/222 datasheet, 2006)

;re-cfg OPTION, TRISGPIO & ADCON0
	CALL	cfgInit
;;;endof fromWDTreset;-------------------------------------

LDR55meas
	movlw	b'01000001'	; AN0 only, channel 0 only, ADC on
	CALL	meas8bit
	
	; if (ADRES < LDR55MIN) goto lightHIGH
	SIregLTval8b  ADRES, LDR55MIN, lightHIGH
	; if (ADRES >= LDR55MAX) goto lightLOW
	SIregGEval8b  ADRES, LDR55MAX, lightLOW

lightLOW
	decfsz interbip, f		; interbip-- and test if nul
	goto	skipbip
	
	movlw	INTERBIPMAX
	movwf	interbip

	MOVLF	.57, Tfridge
	call	DispSonore	; Display sound, in 6-bit binary bips
skipbip	
	clrwdt
	GOTO  beforeSLEEP	; it is not illuminated  

lightHIGH


beforeSLEEP
	movlw  b'00001011'
	TRIS   GPIO			; GP0, GP1 inputs but GP2 output

;deadtime of #2.3 s
	MOVLW  OPTIONVAL	; <765>=110: no wakeup; no pullup; use GP2, not TOCKI
	OPTION				; and WDT prescaler 1:128 => timeout # 2.3 s
;veilleuse
	sleep				; sleep clears WDT

	END
