#include "WiFiS3.h"
#define SECRET_SSID ""
#define SECRET_PASS ""
IPAddress server(192,168,1,101);
//const char server[] = "weatherlogger.local";

int status = WL_IDLE_STATUS;
IPAddress localIp;
#define WIFI_TIMEOUT 30000
WiFiClient client;

#include "XC4630d.c"
#include "Arial_round_16x24.c"
#define FGC CYAN
#define BGC BLACK

//from webpage
#define PAGE_LEN 2048
char page[PAGE_LEN];
int lastHeader=-1;
unsigned long fetchMillis=0;
#define ARRAY_LEN 50
char titleCurrent[ARRAY_LEN]="";
char tempCurrent[ARRAY_LEN]="";
char humCurrent[ARRAY_LEN]="";
char csvCurrent[ARRAY_LEN]="";
char statusCurrent[ARRAY_LEN]="";
char dtCurrent[ARRAY_LEN]=""; //date and time
unsigned int dsnDays=0;
unsigned int dsnSec=0;
float dsnFloat=0;
unsigned int curDays=0; //calculated from millis() and offset
unsigned int curSec=0;
char dispBuf[11];//buffer for number display
#define VALID_TIMEOUT 3600000

//for de-chunking
#define MAX_CHUNK 1024
char chunkResult[MAX_CHUNK]="";

//date and time:
const byte dim[]={0,31,28,31,30,31,30,31,31,30,31,30,31};   //days in month
const byte dimLY[]={0,31,29,31,30,31,30,31,31,30,31,30,31};   //days in month, leap year
unsigned int retYear=0;
unsigned int retMonth=0;
unsigned int retDate=0;
char dataValid=0;
unsigned int timeValid=0;

void setup() {
  unsigned int i;
  Serial.begin(115200);
  XC4630_init();
  XC4630_rotate(4);
  XC4630_clear(BGC);          //Blank screen
  XC4630_fontCharArray(40,68,"Weather Monitor",FGC,BGC,Arial_round_16x24);
  Serial.println("Starting");
  if (WiFi.status() == WL_NO_MODULE) {
    errorAndReboot("Communication with WiFi module failed!");
  }
  status = WiFi.begin(SECRET_SSID, SECRET_PASS);
  while (status != WL_CONNECTED) {
    Serial.print(".");
    delay(300);
    status=WiFi.status();
    if(millis()>WIFI_TIMEOUT){errorAndReboot("Could not connect to WiFi");}
  }
  localIp = WiFi.localIP();
  Serial.println();  
  Serial.print("IP Address: ");
  Serial.println(localIp);    
}

void loop() {
  unsigned int pageLen;
  unsigned int i;
  if(dataValid){
    if((millis()-timeValid)>VALID_TIMEOUT){
      dataValid=0;  //reset
      XC4630_clear(BGC);          //Blank screen on data becoming invalid
    }
  }
  XC4630_fontCharArray(0,225,"LOOKING UP WEATHER STATION            ",FGC,BGC,SmallFont);
  pageLen=fetchHTML();
  if(pageLen>0){  //valid data
  XC4630_fontCharArray(0,225,"VALID DATA RECEIVED                   ",FGC,BGC,SmallFont);
    //Serial.println(page); //raw page
    timeValid=fetchMillis;
    if(dataValid==0){
      XC4630_clear(BGC);          //Blank screen on data becoming valid
    }
    dataValid=1;
    getTitle(page);
    getStatusCurrent(page);
    getTemp(page);  //scan page and store in tempCurrent
    getHum(page);
    getCSVcurrent(page);
    getdtCurrent(page);
    getDateTime();
    Serial.println("Success");
    Serial.println("Found Data:");
    Serial.println(titleCurrent);
    Serial.println(statusCurrent);
    Serial.println(tempCurrent);
    Serial.println(humCurrent);
    Serial.println(csvCurrent);
    Serial.println(dtCurrent);
    Serial.println(dsnSec);
    Serial.println(dsnDays);
    Serial.println(dsnFloat,4);
    fixPad(titleCurrent,' ',20);
    fixPad(statusCurrent,' ',40);
    fixPad(tempCurrent,' ',10);
    fixPad(humCurrent,' ',10);
  }else{
    XC4630_fontCharArray(0,225,"NO DATA RECEIVED                      ",FGC,BGC,SmallFont);
  }
  if(dataValid){
    XC4630_fontCharArray(0,0,titleCurrent,FGC,BGC,Arial_round_16x24);
    XC4630_fontCharArray(0,225,statusCurrent,FGC,BGC,SmallFont);

    XC4630_fontCharArray(  0, 40,"Temp:",FGC,BGC,GroteskBold32x64);
    XC4630_fontCharArray(160, 40,tempCurrent,FGC,BGC,GroteskBold32x64);
    XC4630_fontCharArray( 16,120,"Hum:",FGC,BGC,GroteskBold32x64);
    XC4630_fontCharArray(144,120,humCurrent,FGC,BGC,GroteskBold32x64);
  }else{
    XC4630_fontCharArray(40,68,"Weather Monitor",FGC,BGC,Arial_round_16x24);
    XC4630_fontCharArray(32,148,"waiting for data",FGC,BGC,Arial_round_16x24);
  }
  Serial.print("TIMER:");
  Serial.println(fetchMillis);
  for(i=0;i<200;i++){   //tight loop to update time display until time for another fetch
    if(timeValid){
      getCur();
      if(curDays){
        getYMD(curDays);
        putDate();
        XC4630_fontCharArray(0,200,dispBuf,FGC,BGC,Arial_round_16x24);
        putTime();
        XC4630_fontCharArray(176,200,dispBuf,FGC,BGC,Arial_round_16x24);
      }
    }
    delay(300);
  }
}

void getCur(void){
  curDays=0;  //clear and flag as invalid until set
  curSec=0;
  if(timeValid==0){return;}  
  unsigned int n=millis()-timeValid;
  n=n/1000; //millis to seconds
  curSec=dsnSec+n;
  curDays=dsnDays+(curSec/86400); //add days
  curSec=curSec%86400;  //seconds in a day
}

void errorAndReboot(const char* s){
  Serial.println(s);
  delay(100);
  NVIC_SystemReset();
}

unsigned int fetchHTML(void){ //fetch / and scan
  unsigned long t0=millis(); //for timeout
  unsigned int p=0;
  char c;
  int g,i;
  if (client.connect(server, 80)) {
    Serial.println("connected to server");
    // Make a HTTP request:
    client.println("GET / HTTP/1.1");
    client.println("Connection: close");
    client.println();
    lastHeader=getHeader();
    Serial.print("Result:");
    Serial.println(lastHeader);
    g=getChunk();
    //while(client.connected() && ((millis()-t0)<5000) && (g>0) &&(p+g<PAGE_LEN)){      
    while(((millis()-t0)<5000) && (g>0) &&(p+g<PAGE_LEN)){      
      for(i=0;i<g;i++){
        page[p+i]=chunkResult[i];
      }
      p=p+g;
      //Serial.println(chunkResult);
      g=getChunk();
    }
    Serial.print(p);
    Serial.println(" bytes received");
    page[p]=0;  //terminate
    //Serial.println(page);
  }else{
    Serial.println("Could not conect");
  }
  fetchMillis=t0;
  return p;
}

int getChunk(void){  //assuming client with chunked data available, returns length, put in chunkResult up to MAX_CHUNK
  int n=-1;
  int a;
  char c;
  int p;
  //if(!client.connected()){return -1;}
  waitForClientAvailable(500);
  a=client.available();
  if(a<5){return -1;} //not enough data
  n=getChunkHeader();
  //Serial.print("n in getChunk:");
  //Serial.println(n);
  if(n<1){return n;}
  if(n>MAX_CHUNK-2){n=MAX_CHUNK-2;}
  if(n>a){n=a;}
  for(p=0;p<n;p++){
    chunkResult[p]=client.read();
  }
  chunkResult[n]=0;
  return n;
}

int getChunkHeader(void){
  int n=0;
  int i=-1;
  char c='0';
  while(i<0){ //skip possible leading CRLF
  if(!client.available()){return -1;}
    c=client.read();
    i=unhex(c);
  }
  while(i>=0){
    //if(!client.available()){return -1;}
    //Serial.print("CA:");
    //Serial.println(client.available());
    n=n*16+i;
    c=client.read();
    i=unhex(c);
  }
  if(c!=13){return -1;}
  if(client.read()!=10){return -1;}
  return n;
}

int unhex(char c){
  if((c>='0')&&(c<='9')){return c-'0';}
  if((c>='A')&&(c<='F')){return c-'A'+10;}
  if((c>='a')&&(c<='f')){return c-'a'+10;}
  return -1;
}

int getHeader(void){  //assuming client with data available, returns HTTP or other error
//expecting something like:
/*
HTTP/1.1 200 OK
Content-Type: text/html
Accept-Ranges: none
Transfer-Encoding: chunked
Connection: close
*/
  //use chunkResult as scratchpad
  char c=0;
  int cp=0;  //previous
  int cpp=0;// next previous
  char done=0;
  unsigned int p=0;  
  int ret=-1;
  if(!client.connected()){return -1;}
  waitForClientAvailable(500);
  while(!done){
    if(client.available()){
      //Serial.println(client.available());
      while (client.available()) {
        c=client.read();
        //Serial.write(c);
        //if(c<32){Serial.print(int(c));}
        chunkResult[p++]=c;
        chunkResult[p]=0; //terminate
        if(p>MAX_CHUNK-2){return -1;} //overflow?
        if((c>='0')&&(c<='9')){
          if((cp>='0')&&(cp<='9')){
            if((cpp>='0')&&(cpp<='9')){
              if(ret<=0){ //don't overwrite
                ret=(cpp-'0')*100+(cp-'0')*10+c-'0';
                //Serial.println(ret);
              }
            }
          }
        }
        if((cpp==10)&&(cp==13)&&(c==10)){ //finished
          return ret;
        }
        cpp=cp;
        cp=c;
      }
    }else{
      delay(500);
      if(!client.available()){done=1;}//timeout
    }
  }
  return -1;
}

void waitForClientAvailable(unsigned int t){  //wait for t millis or client available
  unsigned int i;
  for(i=0;i<(t/10);i++){
    if(client.available()){return;}
    delay(10);
  }
}

void getdtCurrent(const char* pg){
  int p;
  int i;
  int n=0;
  p=findIn("Time is",pg);
  //Serial.print("FIND:");
  //Serial.println(p);
  if(p<0){return;}
  p=p+7;
  i=p;
  for(i=p;i<p+24;i++){
    if(isTempChar(pg[i])){
      dtCurrent[n++]=pg[i];
    }
  }
  dtCurrent[n]=0;
}

void getStatusCurrent(const char* pg){
  int p;
  int i;
  int n=0;
  p=findIn("STATUS:",pg);
  //Serial.print("FIND:");
  //Serial.println(p);
  if(p<0){return;}
  p=p+7;
  i=p;
  while((pg[i]>31) && (n<ARRAY_LEN-2)){
    statusCurrent[n]=pg[i];
    n++;
    i++;
  }
  statusCurrent[n]=0;
}

void getCSVcurrent(const char* pg){
  int p;
  int i;
  int n=0;
  p=findIn("Current file:<a href=\"",pg);
  //Serial.print("FIND:");
  //Serial.println(p);
  if(p<0){return;}
  p=p+22;
  i=p;
  while((pg[i]!='"') && (n<ARRAY_LEN-2)){
    csvCurrent[n]=pg[i];
    n++;
    i++;
  }
  csvCurrent[n]=0;
}

void getTitle(const char* pg){
  int p;
  int i;
  int n=0;
  p=findIn("<title>",pg);
  //Serial.print("FIND:");
  //Serial.println(p);
  if(p<0){return;}
  p=p+7;
  i=p;
  while((pg[i]!='<') && (n<ARRAY_LEN-2)){
    titleCurrent[n]=pg[i];
    n++;
    i++;
  }
  titleCurrent[n]=0;
}

void getHum(const char* pg){
  int p;
  int i;
  int n=0;
  p=findIn("Humidity:",pg);
  //Serial.print("FIND:");
  //Serial.println(p);
  if(p<0){return;}
  p=p+9;  //skip past Humidity:
  for(i=p;i<p+15;i++){
    if(isTempChar(pg[i])){
      humCurrent[n++]=pg[i];
    }
  }
  humCurrent[n]=0;
  for(i=0;i<n;i++){
    if(humCurrent[i]=='&'){humCurrent[i]='%';}
  }
}

void getTemp(const char* pg){  //scan page and store in tempCurrent
  int p;
  int i;
  int n=0;
  p=findIn("Temp:",pg);
  //Serial.print("FIND:");
  //Serial.println(p);
  if(p<0){return;}
  p=p+5;  //skip past Temp:
  for(i=p;i<p+15;i++){
    if(isTempChar(pg[i])){
      tempCurrent[n++]=pg[i];
    }
  }
  tempCurrent[n]=0;
  for(i=0;i<n;i++){
    if(tempCurrent[i]=='&'){tempCurrent[i]='`';}  //degrees in LCD font
  }
}

char isTempChar(char n){
  if((n>='0')&&(n<='9')){return 1;}
  if(n=='.'){return 1;}
  if(n=='&'){return 1;}
  return 0;
}

int findIn(const char* f, const char* s){
  int flen=strlen(f);
  int slen=strlen(s);
  int i;
  if(slen<flen){return -1;}
  for(i=0;i<slen-flen;i++){
    if(match(f,&s[i],flen)){return i;}
  }
  return -1;
}

char match(const char* a, const char* b, unsigned int n){
  unsigned int i;
  for(i=0;i<n;i++){
    if(a[i]!=b[i]){return 0;}
  }
  return 1;
}

void fixPad(char* s, char p, unsigned int n){  //pad or truncate s to length n with character p
  unsigned int i;
  if(strlen(s)<=n){
    for(i=strlen(s);i<n;i++){s[i]=p;} //pad if needed
  }
  s[n]=0; //and truncate /terminate
}

unsigned int getDSN(unsigned int year, unsigned int month, unsigned int date){
  unsigned int s;
  s=date+1; //align to epoch  1/1/1900
  while(month>1){
    if(isLeapYear(year)){
      s=s+dimLY[month-1];
    }else{
      s=s+dim[month-1];
    }
    month--;
  }
  while(year>1900){
    if(isLeapYear(year-1)){
      s=s+366;
    }else{
      s=s+365;
    }
    year--;
  }
  return s;
}

void getDateTime(void){  //fill dsnDays,dsnSec,dsnFloat from dtCurrent (eg "16350924012025")
  int i;
  unsigned int s,d;
  unsigned int year, month, date;
  if(strlen(dtCurrent)!=14){return;}  //error
  for(i=0;i<14;i++){if((dtCurrent[i]<'0')||(dtCurrent[i]>'9')){return;}} //not numeric}
  s=(dtCurrent[5]-'0')+(dtCurrent[4]-'0')*10+(dtCurrent[3]-'0')*60+(dtCurrent[2]-'0')*600+(dtCurrent[1]-'0')*3600+(dtCurrent[0]-'0')*36000;
  dsnSec=s;
  year=(dtCurrent[13]-'0')+(dtCurrent[12]-'0')*10+(dtCurrent[11]-'0')*100+(dtCurrent[10]-'0')*1000;
  month=(dtCurrent[9]-'0')+(dtCurrent[8]-'0')*10;
  date=(dtCurrent[7]-'0')+(dtCurrent[6]-'0')*10;
  dsnDays=getDSN(year,month,date);
  dsnFloat=(float)dsnDays+((float)dsnSec)/86400.0;
}

char isLeapYear(unsigned int y){
  if(y%4){return 0;}
  if((y%400)==0){return 1;}
  if((y%100)==0){return 0;}
  return 1;
}

void getYMD(unsigned int dsn){  
  retYear=1900;
  retMonth=1;
  retDate=0;
  if((dsn<2)||(dsn>100000)){return;} //error
  retDate=dsn-1;  //1/1/1900 has timestamp 0, ie date of 0 is 1
  while(retDate>365){
    if(isLeapYear(retYear)){
      retDate--;
    }
    retYear++;
    retDate=retDate-365;
  }
  if(isLeapYear(retYear)){
    while(retDate>dimLY[retMonth]){                   //count months
      retDate=retDate-dimLY[retMonth];
      retMonth++;
    }
  }else{
    while(retDate>dim[retMonth]){                   //count months
      retDate=retDate-dim[retMonth];
      retMonth++;
    }
  }
  if((retDate==0)&&(retMonth==1)){                //fix glitch on 31/12 of leap years
    retYear--;
    retDate=31;
    retMonth=12;
  }
}

void putDate(void){
  if(retDate<10){
    dispBuf[0]=' ';
  }else{
    dispBuf[0]=(retDate/10)%10+'0';
  }
  dispBuf[1]=retDate%10+'0';
  dispBuf[2]='/';
  if(retMonth<10){
    dispBuf[3]=' ';
  }else{
    dispBuf[3]='1';
  }
  dispBuf[4]=retMonth%10+'0';
  dispBuf[5]='/';
  dispBuf[6]=(retYear/1000)%10+'0';
  dispBuf[7]=(retYear/100)%10+'0';
  dispBuf[8]=(retYear/10)%10+'0';
  dispBuf[9]=(retYear/1)%10+'0';
  dispBuf[10]=0;
}

void putTime(void){
  if(curSec<36000){
    dispBuf[0]=' ';
  }else{
    dispBuf[0]=(curSec/36000)%10+'0';
  }
  dispBuf[1]=(curSec/3600)%10+'0';
  dispBuf[2]=':';
  dispBuf[3]=(curSec/600)%6+'0';
  dispBuf[4]=(curSec/60)%10+'0';
  dispBuf[5]=':';
  dispBuf[6]=(curSec/10)%6+'0';
  dispBuf[7]=(curSec/1)%10+'0';
  dispBuf[8]=0;
}