
#ifdef ESP8266
 #include <ESP8266WiFi.h>
#else
 #include <WiFi.h>
#endif
#include <ModbusIP_ESP8266.h> // https://github.com/emelianov/modbus-esp8266
#include <Wire.h>

//Wifi
char ssid[] = "YourSSID";
char pass[] = "YourPassw";

//Display
#include <U8g2lib.h> //OLED display
U8G2_SSD1309_128X64_NONAME2_F_SW_I2C u8g2(U8G2_R0, 5, 4 ); //No rotation, CLK and SDA pins resp.

//MODBUS
const int REG = 30052;               // Replace with your Modbus register
IPAddress remote(192, 168, 50, 239);  // Replace with the LAN address of your inverter
uint16_t port = 502; // Replace with the Modbus port of your inverter. Note: most OEMs (except Solar Edge) use 502!

float KWatts;

ModbusIP mb;  //ModbusIP object

//temp sensors
#include <OneWire.h>             //Used by DS18b20 temp sensor
#include <DallasTemperature.h>   //Used by DS18b20 temp sensor
#define ONE_WIRE_BUS 2   // DS18B20 on GPIO2
float waterTemp = 0;
float hsinkTemp = 0;
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature DS18B20(&oneWire);

void setup() {
  Serial.begin(115200);
  Serial.println("");

  Wire.begin(4,5); //SDA and CLK resp.
  //u8g2.setI2CAddress(0x3D); // default i2c address for Waveshare 2.42" display
  u8g2.begin();
  DS18B20.begin();
  
     //display 
  u8g2.clearBuffer();
  u8g2.setFont(u8g2_font_helvB10_tr); // medium-large bold font
  u8g2.drawStr(10,20,"Connecting");
  u8g2.drawStr(25,40,"to WiFi...");
  u8g2.sendBuffer();
  
  WiFi.begin(ssid, pass);
  
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
 
  Serial.println("");
  Serial.println("WiFi connected");  
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());

//display 
  u8g2.clearBuffer(); 
  u8g2.setFont(u8g2_font_helvB10_tr); // medium-large bold font
  u8g2.drawStr(10,20,"Connected to");
  u8g2.drawStr(0,40,ssid);
  u8g2.sendBuffer();

  mb.client();
}

void loop() {
  getTemps();
  uint16_t res[2]={0,0};

 mb.connect(remote, port);
       if (mb.isConnected(remote)) {   // Check if connection to Modbus Slave is established
        mb.readHreg(remote, REG, (uint16_t*)res,2,cb,247);  // Initiate Read from 2 consecutive registers from Modbus Slave ID 247
        }else {
        Serial.println("Modbus slave NOT connected");  
        mb.connect(remote);           // Try to connect if no connection
        }
  mb.task();                      // Common local Modbus task
 
 KWatts = res[1];
    if (KWatts>40000){
    KWatts = KWatts - 65535;
    }
  Serial.println(KWatts);
   
   KWatts = KWatts/1000;
   Serial.printf ("KW is %.02f (-ve) is exporting) \r\n", KWatts);

 //display 
    u8g2.clearBuffer(); 
    u8g2.setFont(u8g2_font_helvB10_tr);
    u8g2.drawStr(0,18,"Water: ");
    char waterTStr[6];
    dtostrf(waterTemp,4,2,waterTStr); //4 char, 2 dec places
    u8g2.drawStr(65,18,waterTStr);
    u8g2.setFont(u8g2_font_chroma48medium8_8r);
    u8g2.drawStr(105,18,"C");

    u8g2.setFont(u8g2_font_helvB10_tr);
    u8g2.drawStr(0,33,"H'sink: ");
    char sinkTStr[6];
    dtostrf(hsinkTemp,4,2,sinkTStr);
    u8g2.drawStr(65,33,sinkTStr);
    u8g2.setFont(u8g2_font_chroma48medium8_8r);
    u8g2.drawStr(105,33,"C");

    u8g2.setFont(u8g2_font_helvB10_tr);
    u8g2.drawStr(0,48,"Exc pwr: ");
    char pwrStr[6];
    dtostrf(KWatts,4,2,pwrStr);
    u8g2.drawStr(65,48,pwrStr);
    u8g2.setFont(u8g2_font_chroma48medium8_8r);
    u8g2.drawStr(105,48,"KWatts");
    u8g2.sendBuffer();

    delay(3000); 
}

// -------- Functions ----------
void getTemps() {
  
  DS18B20.requestTemperatures();
  waterTemp = DS18B20.getTempCByIndex(1); // temperature reading of first temp sensor
  Serial.printf("Water temp is: %.2f \r\n", waterTemp); 
  while (waterTemp==-127.00){  // keep sampling temp until a proper reading is obtained
  waterTemp = DS18B20.getTempCByIndex(1); 
  }

  hsinkTemp = DS18B20.getTempCByIndex(0); // temperature reading of 2nd temp sensor
  Serial.printf("Heatsink temp is: %.2f \r\n", hsinkTemp);
  while (hsinkTemp==-127.00){  // keep sampling temp until a proper reading is obtained  
    hsinkTemp = DS18B20.getTempCByIndex(0); 
  }
}

// Modbus Transaction callback
bool cb(Modbus::ResultCode event, uint16_t transactionId, void* data) { 
  if (event != Modbus::EX_SUCCESS)                  // If transaction got an error
    Serial.printf("Modbus result: %02X\n", event);  // Display Modbus error code
  if (event == Modbus::EX_TIMEOUT) {    // If Transaction timeout took place
    mb.disconnect(remote);              // Close connection to slave and
    mb.dropTransactions();              // Cancel all waiting transactions
  }
  return true;
}
