#include "io.h"

void ioInit(void){
    ANSELA=0;
    ANSELC=0;
    trisbits.S1=1;
    wpubits.S1=1;
    trisbits.S2=1;
    wpubits.S2=1;
    trisbits.S3=1;
    wpubits.S3=1;
    latbits.S1=0;   //to not conflict if TRIS cleared
    latbits.S2=0;
    latbits.S3=0;
    trisbits.LEDP=0;
    latbits.LEDP=0;
    trisbits.LEDN=0;
    latbits.LEDN=0;    
    //so they're not floating, is overridden if debugging happens
    trisbits.PGD_PIN=1;
    wpubits.PGD_PIN=1;
    trisbits.PGC_PIN=1;
    wpubits.PGC_PIN=1;
}

void t0init(void){
    //8bit
    T0CON0=0;               //reset, 8-bit, 1:1    
    T0CON1bits.CS=2;        //FOSC/4=8MHz
    T0CON1bits.ASYNC=1;     //ASYNC
    T0CON1bits.T0CKPS=7;    //1:128
    T0CON0bits.OUTPS=15;    //1:16
    TMR0H=255;              //full period
    T0CON0bits.EN=1;        //on
    PIR0bits.TMR0IF=0;      //clear
    PIE0bits.TMR0IE=1;      //enable    
}

void setLED(char s){    //using colour defines
    if(s==GREEN){
        latbits.LEDP=1;
    }else{
        latbits.LEDP=0;            
    }
    if(s==RED){
        latbits.LEDN=1;
    }else{
        latbits.LEDN=0;            
    }
}

void ADCinit(void){
    ADCON0=0;            //reset
    //ADCON1= 0b11000000;  //1=right align, 100=1/4 FOSC, 00=NA, 00=V+REF=VDD
    ADCON1=0b10110000;  //1=right align, 011=ADCRC, 00=NA, 00=V+REF=VDD    
    ADACT=0;             //no auto trigger    
    ADCON0bits.ADON=1;   //turn on        
}

void ADCdeInit(void){
    ADCON0=0;            //reset    
}

int getADC(unsigned char c){   //get result from preselected channel
    ADCON0bits.CHS=c;
    ADCON0bits.ADGO=1;              //start reading
    while(ADCON0bits.ADGO){}        //wait till done
    return (int)ADRES;        
}

