/*
 * File:   main.c
 * Author: Tim Blythman
 */

//see Properties for _XTAL_FREQ (compiler/preprocessing/define macros) _XTAL_FREQ=(8000000UL)

#include "config.h"
#include <xc.h>
#include "io.h"
#include "portbits.h"
#include "st25dv.h"
#include "irtx.h"
#include "util.h"

char button=0;
irCode_t c={IR_NONE,0,0};
char i,t;

void main(void) {
    OSCFRQ=3;   //8MHz
    ioInit();
    setLED(GREEN);
    txPinInit();
    GIE=1;    
    t=TM_INTERVALS; //reset
    while(1){
        if(PRESSED(S1)&&PRESSED(S2)&&PRESSED(S3)){
            irCmd=IR_STOP;  //cancel whatever is being sent
            while(irState!=IR_IDLE){}   //wait for completion
            GIE=0;    
            SMinit();   //only start up when needed
            while(PRESSED(S1)||PRESSED(S2)||PRESSED(S3)){   //wait for release and flash
                setLED(GREEN);
                __delay_ms(100);
                setLED(RED);
                __delay_ms(100);
            }
            setLED(OFF);
            __delay_ms(300);
            if(SMprobe(ST25DV_USRMEM)){
                if(ST25DVscanNDEF()){
                    for(i=0;i<3;i++){
                        c=getCode(ndefText,i);
                        if(c.irType==IR_NONE){
                            setLED(RED);                        
                        }else{
                            setLED(GREEN);
                            curCodes[i]=c;
                        }
                        __delay_ms(1000);
                        setLED(OFF);
                        __delay_ms(100);                        
                    }
                }else{
                    setLED(OFF);    //LED off means NDEF not found
                    __delay_ms(1000);
                }
            }else{
                setLED(RED);    //no chip is hard fail
                __delay_ms(1000);            
            }
            GIE=1;  
            SMdeInit();
            setLED(GREEN);      //idle, OK
            t=TM_INTERVALS; //reset
        }
        if(irState==IR_IDLE){            
            if(PRESSED(S1)){
                sendCode(curCodes[0]);
                button=1;
                t=TM_INTERVALS; //reset
            }
            if(PRESSED(S2)){
                sendCode(curCodes[1]);
                button=2;
                t=TM_INTERVALS; //reset
            }
            if(PRESSED(S3)){
                sendCode(curCodes[2]);
                button=3;
                t=TM_INTERVALS; //reset
            }
        }else{
            if((button==1)&&(!PRESSED(S1))){irCmd=IR_STOP;button=0;}
            if((button==2)&&(!PRESSED(S2))){irCmd=IR_STOP;button=0;}
            if((button==3)&&(!PRESSED(S3))){irCmd=IR_STOP;button=0;}
        }
        if(irState==IR_IDLE){
            FVRCON=FVR_1V;
            ADCinit();
            __delay_ms(TM_DELAY);   //do this here to let FVR/ADC stabilise
            if(getADC(FVR_BUFFER)<ADC_REF_LIMIT){
                //setLED(GREEN);  
                batLED=GREEN;
            }else{
                //setLED(OFF);                //original
                //setLED(RED);                 //updated
                batLED=RED;
            }
            setLED(batLED);  
            ADCdeInit();
            FVRCON=FVR_OFF;
            if(t==0){   //sleep
                sleepAndWakeup();
                t=TM_INTERVALS; //reset
            }
            t--;
        }else{
            //setLED(RED);  //let ISR toggle LED
            t=TM_INTERVALS; //reset while transmitting
        }
    }
    return;
}
