#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"
#include "globalPins.h"

#define PRESSED(x) (portbits.x==0)
#define RED (1)
#define GREEN (2)
#define OFF (0)

#define FVR_OFF (0)
#define FVR_1V (129)
#define FVR_2V (130)
#define FVR_4V (131)
#define FVR_BUFFER (30)

void ioInit(void);  //basic IO
void t0init(void);  //for tick interrupt
void setLED(char s);    //using colour defines
void ADCinit(void);
void ADCdeInit(void);
int getADC(unsigned char c);   //get result from preselected channel

#endif	/* IO_H */

