#ifndef ST25DV_H
#define	ST25DV_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"
#include "st25dv.h"
#include "globalPins.h"

//some defs
#define ST25DV_ACK (0)
#define ST25DV_NAK (1)
#define ST25DV_WRITE(x) ((x)*2)
#define ST25DV_READ(x) ((x)*2+1)
#define ST25DV_SYSMEM (87)
#define ST25DV_USRMEM (83)

//RW SMB (aka I2C) for Tag chips
typedef struct {
    unsigned char d;    //data
    unsigned int a:1;   //ack
} smByte_t;
void SMstop(void);
void SMstart(void);
void SMinit(void);
void SMdeInit(void);        //for shutdown
smByte_t SMbyte(const smByte_t b);
void SMbitdelay(void);
char SMprobe(char a);   //check for ack/nak of address a on bus, true for ack

smByte_t ST25DVreadByte(unsigned int a);  //read a single byte at a
char ST25DVreadBytes(unsigned int a, char* p, unsigned int n);  //read n bytes into p from address a, returns true on success
char ST25DVwriteByte(unsigned int a,const char d);              //write a single byte, true for success
char ST25DVwrite4Byte(unsigned int a,const char* d,char n);     //write n<=4 bytes (in a single block), true for success
char ST25DVwriteBytes(unsigned int a,const char* d,unsigned int n);    //uses SMwrite4Byte to write arbitrary amounts
int assembleTextNDEF(char* dst, int dstSize, char* src, int srcSize);  //assemble for writing, returns full size
char ST25DVscanNDEF(void);        //process NDEF and put data into globals
    
typedef struct {
    unsigned int tnf:3; //type/name/format
    unsigned int il:1;  //ID length
    unsigned int sr:1;  //short record
    unsigned int cf:1;  //chunk flag
    unsigned int me:1;  //message end
    unsigned int mb:1;  //message begin    
} ndefRec_t;

extern char ioBuf[8]; //local use
extern unsigned int eeSize;
extern unsigned int ndefSize;
extern unsigned int payloadPtr;
extern unsigned int payloadSize;
extern unsigned int textPtr;
extern unsigned int textSize;
extern ndefRec_t ndef;
//can be up to 256; reduce to save RAM
#define NDEF_TEXT_SIZE (128)
extern char ndefText[NDEF_TEXT_SIZE];
#define NDEF_HEAD_SIZE (13)
extern const char ndefHead[NDEF_HEAD_SIZE];
#define MAX_NDEF_SIZE (NDEF_TEXT_SIZE)

#endif	/* ST25DV_H */

