#ifndef IRTX_H
#define	IRTX_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"
#include "globalPins.h"

#define IR_IDLE (0)
#define IR_RUNNING (1)
#define IR_REPEATING (2)
#define IR_STOP (0)
#define IR_START (1)
//types
/*
typedef enum {  //use same chars as identifiers
    IR_NONE=0,
    IR_RC5='5',
    IR_RC6='6',
    IR_NEC='N',
    IR_SIRC_12='S',            
    IR_SIRC_15='T',            
    IR_SIRC_20='U',            
} irTypes_t;
*/

//use X-macros to give us a function to check for valid enums
#define ENUM_VALUES \
    X(IR_RC5, '5')  \
    X(IR_RC6, '6')  \
    X(IR_NEC, 'N')  \
    X(IR_SIRC_12, 'S')  \
    X(IR_SIRC_15, 'T')  \
    X(IR_SIRC_20, 'U')  \
    X(IR_NONE, 0)
//build enum
#define X(a, b) a = b,
typedef enum {ENUM_VALUES} irTypes_t;
#undef X
//prototype for check function in .c
char isValidIRtype(irTypes_t t);

//struct to hold state
typedef struct {
    irTypes_t irType;
    unsigned int address;
    unsigned int data;
} irCode_t;

#define IR_SEQ_LEN 128
extern volatile unsigned char irState;  //status, readable from main
extern volatile unsigned char irCmd;    //command used by main

void txPinInit(void);   //do this once
void irTxInit(unsigned char per, unsigned char post);   //custom period/postscale to suit carrier and protocol
void irTxDeInit(void);  //shut down
void tmr2init(void);          //sets up a tick
char getBit(unsigned char *d, unsigned char i);  //get bit, assuming LSB first
unsigned char bitRev(unsigned char b);  //reverse bits (where needed for LSB vs MSB ordering)
unsigned char IRencode(irCode_t c);     //encode into pulseLengths etc
void encodeNECrepeat(void);       //special repeat sequence
void encodeNEC(void);             //protocol specific code
void encodeSIRC(void);            //protocol specific code
void encodeRC5(void);             //protocol specific code
void encodeRC6(void);    //from activeCode; protocol specific code
void manchesterBit(char c,unsigned char t);  //encode bit c with length t
void manchesterBitInv(char c,unsigned char t);  //encode bit c with length t (sense of RC5 is reverse to RC6)
void addPulse(unsigned char d, char b); //duration, bit
void padToInterval(unsigned int t);     //fill sequence with low until t

//IR code specific constants
//NEC:
//gives 38kHz carrier, 182us sub-period
#define NEC_INIT 52,7
//multiples of 182us periods
#define NEC_SHORT (3)
#define NEC_LONG (9)
#define NEC_START_MARK (48)
#define NEC_START_SPACE (24)
#define NEC_REPEAT_SPACE (12)
#define NEC_INTERVAL (595)

//gives 40kHz carrier, 300us sub-period
#define SIRC_INIT 50,12
//multiples of 300us periods
#define SIRC_SHORT (2)
#define SIRC_LONG (4)
#define SIRC_START (8)
#define SIRC_INTERVAL (150)

//gives 36kHz carrier, 220us sub-period
#define RC_INIT 55,8
//multiples of 220us periods
#define RC5_PULSE (4)
#define RC6_PULSE (2)
#define RC5_INTERVAL (513)
#define RC6_TOGGLE (4)
#define RC6_START (12)
#define RC6_INTERVAL (477)

#endif	/* IRTX_H */

