#ifndef UTIL_H
#define	UTIL_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include <string.h> //for strlen
#include "irtx.h"
#include "io.h"
#include "st25dv.h"

//parsing for text files to IR TX codes
//RC5- 5 bit add, 6 bit data, 1 toggle bit (not stored)
//RC6- 8 bit add, 8 bit data
//SIRC- 5,8,13 bit add, 7 bit data
//NEC- 8 bit add, 8 bit data, repeat frames are different

#define LINE_CHAR 10
#define TM_OUT 100
#define TM_INTERVALS 10
#define TM_DELAY (TM_OUT/TM_INTERVALS)
#define VBAT_LOW 2600
//assuming 1024mV reference
#define ADC_REF_LIMIT ((1024UL*1024UL)/VBAT_LOW)

extern irCode_t curCodes[3];
extern char batLED;

char getUint(char* c, unsigned int* n,char* s); //scan char array at c and put in n if valid, s characters consumed
irCode_t getCode(char* text, char n);   //scan text for code n
char validateCode(irCode_t* c); //check if valid type and values match types
void sendCode(irCode_t c);    //output this code
void sleepAndWakeup(void);    //wait for keys etc

#endif	/* UTIL_H */

