#include "util.h"

irCode_t curCodes[3]={
    {IR_NEC,0,21},
    {IR_NEC,0,7},
    {IR_NEC,0,67}    
};

char batLED=GREEN;

//codes for Jaycar XC3718:
//NEC => IR_NEC, address 0
//command/data:
//0x45    0x46    0x47  CH- CH  CH+
//0x44    0x40    0x43  PRV NXT PLAY
//0x07    0x15    0x09  -   +   EQ
//0x16    0x19    0x0D  0   100 200
//0x0C    0x18    0x5E  1   2   3
//0x08    0x1C    0x5A  4   5   6
//0x42    0x52    0x4A  7   8   9
 
char getUint(char* c, unsigned int* n,char* s){ //scan char array at c and put in n if valid
    unsigned long j=0;    //so we can check for overflow
    char p=0;
    char d;
    while(1){
        d=*(c+p);
        if((d>='0')&&(d<='9')){
            j=j*10+d-'0';
            p=p+1;
            if(j>65535){
                return 0;   //overflow
            }
        }else{
            if(p==0){
                return 0;   //nothing scanned
            }else{
                *n=(unsigned int)j; //all good
                *s=p;
                return 1;
            }
        }
    }
}

irCode_t getCode(char* text, char n){   //scan text for code n
    irCode_t c={IR_NONE,0,0};
    unsigned int p=0;
    unsigned int r;     //for value returned
    unsigned int len=strlen(text);
    char s=0;
    while((p<len) && n){
        if(text[p]==LINE_CHAR){n=n-1;}
        p=p+1;
    }
    //p is now at start of line n
    c.irType=text[p];
    p=p+2;
    if(getUint(&text[p],&r,&s)){
        c.address=r;
    }else{
        c.irType=IR_NONE;
        return c;
    }
    p=p+1+s;
    if(getUint(&text[p],&r,&s)){
        c.data=r;
    }else{
        c.irType=IR_NONE;
        return c;
    }
    validateCode(&c);
    return c;
}

//RC5- 5 bit add, 6 bit data, 1 toggle bit (not stored)
//RC6- 8 bit add, 8 bit data
//SIRC- 5,8,13 bit add, 7 bit data
//NEC- 8 bit add, 8 bit data, repeat frames are different
char validateCode(irCode_t* c){ //check if valid type and values match types
    //if(isValidIRtype(c->irType)==0){c->irType=IR_NONE;return 0;}  //is checked by default
    switch(c->irType){
        case IR_RC5:
            if(c->address>31){c->irType=IR_NONE;return 0;}
            if(c->data>63){c->irType=IR_NONE;return 0;}
            break;
        case IR_RC6:
            if(c->address>255){c->irType=IR_NONE;return 0;}
            if(c->data>255){c->irType=IR_NONE;return 0;}
            break;
        case IR_NEC:
            if(c->address>255){c->irType=IR_NONE;return 0;}
            if(c->data>255){c->irType=IR_NONE;return 0;}
            break;
        case IR_SIRC_12:    //5 address bits => 31
            if(c->address>31){c->irType=IR_NONE;return 0;}
            if(c->data>127){c->irType=IR_NONE;return 0;}
            break;
        case IR_SIRC_15:    //8 address bits => 255
            if(c->address>255){c->irType=IR_NONE;return 0;}
            if(c->data>127){c->irType=IR_NONE;return 0;}
            break;
        case IR_SIRC_20:    //13 address bits => 8191
            if(c->address>8191){c->irType=IR_NONE;return 0;}
            if(c->data>127){c->irType=IR_NONE;return 0;}
            break;
        default:
            c->irType=IR_NONE;return 0;
            break;
    }
    return 1;
}

void sendCode(irCode_t c){    //output this code
    if(IRencode(c)){
        switch(c.irType){
            case IR_NEC:irTxInit(NEC_INIT);break;
            case IR_SIRC_12:
            case IR_SIRC_15:
            case IR_SIRC_20:
                irTxInit(SIRC_INIT);break;
            case IR_RC5:
            case IR_RC6:
                irTxInit(RC_INIT);break;
            default: break;
        }
        if(INTCONbits.PEIE==1){irCmd=IR_START;} //only start if ready
    }    
}

void sleepAndWakeup(void){
    irTxDeInit();
    setLED(OFF);    
    SMdeInit();
    IOCAF=0;
    IOCCF=0;    //ensure no flags set whatsoever
    iocxpbits.S1=1;
    iocxpbits.S2=1;
    iocxpbits.S3=1;
    iocxnbits.S1=1;
    iocxnbits.S2=1;
    iocxnbits.S3=1;
    GIE=0;              //avoid jumping to ISR on wakeup
    PIE0bits.IOCIE=1;   //enable IOC interrupts for wakeup
    SLEEP();
    //while(!(PRESSED(S1)||PRESSED(S2)||PRESSED(S3))){}  //wait without sleeping for testing only
    NOP();
    PIE0bits.IOCIE=0;   //disable IOC interrupts
    setLED(batLED);
    txPinInit();
    GIE=1;
}