// Graphics data for the aquarium PicoDVI example.
// Unlike the flying toasters demo, this one uses a larger color palette
// and 2:1 packing as described as a possible upgrade in that code is not
// an option here. 1 byte/pixel, period.

const uint16_t palette[] = {
  0x0000, 0xFFFF, 0x0180, 0x0080, 0x0320, 0x0220, 0x0440, 0x3320, 0x6180,
  0x9B20, 0x3180, 0x9B26, 0xCCC6, 0xCE6C, 0x9CCC, 0x6326, 0x4228, 0x73AE,
  0x2104, 0x52AA, 0x632C, 0x8C51, 0x9CD3, 0x3186, 0xCB20, 0xFFE0, 0xFCC0,
  0xFE60, 0x6320, 0xBDD7, 0xAD55, 0x3193, 0x000A, 0x64D3, 0x9B33, 0xFFF3,
  0xDEFB, 0x0326, 0x04D9, 0xCFEC, 0xFB20, 0xF980, 0x0186, 0x6000, 0xC800,
  0x018C, 0x0339, 0xEF7D, 0x0006, 0x9CC0, 0xCB2C, 0xCCCC, 0x4208, 0x9B2C,
  0x7BCF, 0x4339, 0x18C3, 0xBDD7, 0x3000, 0xDEDB, 0xCE79, 0xCFFF, 0xFE6C,
  0x9E79, 0x64C0, 0x9980, 0x7000, 0x5000, 0x4000, 0x2000, 0xEF7D, 0xCCD3,
  0x0015, 0x333F, 0x633F, 0x64DF, 0x9800, 0xF800, 0x03A0, 0x318C, 0x64CC,
  0x032C, 0x34D3, 0x3679, 0x332C, 0x07F9, 0x0189, 0x0493, 0x049F, 0x032F,
  0x0576, 0x06F5, 0x7FB6, 0x0639, 0x071C, 0xB4C9, 0x4980, 0x9B23, 0x7BEC,
  0xB593, 0x9BE6, 0xE73C, 0xE736, 0xA800, 0x8800, 0xB800, 0xC806, 0xC80C,
  0xD800, 0xFCDF, 0xF986, 0xFB26, 0x9986, 0xFFEC, 0xFE73, 0xFFF9, 0x7800,
  0x7BE0, 0x7BEF, 0x03E0, 0xBDF7, 0x700E, 0x03EF, 0x0000,
};

// Gravel is a special case, being 192x64 pixels. Fish sprites that
// follow are all 64x64, and then the bubbles sprites are 64x16.

const uint8_t gravel[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00,
  0x75, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x75, 0x00, 0x74, 0x00, 0x00,
  0x74, 0x75, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x76, 0x74, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x74, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x74, 0x74, 0x74, 0x75, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x74, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x75, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x76, 0x76, 0x76, 0x00, 0x00, 0x74, 0x00, 0x74,
  0x75, 0x74, 0x00, 0x74, 0x00, 0x74, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x74, 0x00, 0x00, 0x00, 0x00, 0x75, 0x74, 0x74,
  0x00, 0x00, 0x00, 0x74, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x74, 0x00,
  0x00, 0x74, 0x00, 0x75, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x74,
  0x75, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x75, 0x74, 0x00, 0x00, 0x00,
  0x74, 0x00, 0x75, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x75, 0x74, 0x75, 0x74, 0x00, 0x00,
  0x74, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x74, 0x00,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x74, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x74, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x74, 0x76, 0x76, 0x76, 0x00, 0x00, 0x00, 0x00, 0x75, 0x74,
  0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x74, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74,
  0x74, 0x00, 0x74, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x75, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x75, 0x74, 0x74, 0x00, 0x00, 0x74, 0x74, 0x74, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x75,
  0x00, 0x00, 0x74, 0x75, 0x00, 0x74, 0x74, 0x00, 0x74, 0x75, 0x74, 0x75,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x74, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x75, 0x00,
  0x74, 0x75, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x74, 0x00, 0x00, 0x74, 0x75, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74,
  0x00, 0x75, 0x74, 0x00, 0x00, 0x74, 0x00, 0x75, 0x00, 0x74, 0x00, 0x75,
  0x00, 0x74, 0x76, 0x00, 0x76, 0x76, 0x00, 0x00, 0x00, 0x00, 0x74, 0x75,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74,
  0x75, 0x74, 0x00, 0x00, 0x74, 0x74, 0x75, 0x74, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x74, 0x74, 0x75, 0x00, 0x00, 0x74, 0x74, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x75, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x75,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x74, 0x00, 0x00, 0x74, 0x75, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x75, 0x74, 0x00, 0x74, 0x74,
  0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x75, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x74, 0x75, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x75, 0x00, 0x74, 0x75, 0x00, 0x74, 0x00, 0x00,
  0x74, 0x74, 0x75, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x75, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74,
  0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x75, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x74, 0x74, 0x00, 0x75, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x75, 0x00, 0x00, 0x00, 0x00, 0x74, 0x75, 0x74, 0x00, 0x74, 0x74,
  0x00, 0x00, 0x74, 0x75, 0x74, 0x75, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x75, 0x74, 0x00, 0x75, 0x00, 0x74, 0x00, 0x00, 0x75, 0x74, 0x00,
  0x74, 0x77, 0x00, 0x74, 0x74, 0x00, 0x75, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x74, 0x00, 0x74, 0x74, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x74, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x74, 0x75, 0x00, 0x00, 0x74, 0x75, 0x00, 0x74, 0x74, 0x75, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x75, 0x74, 0x00, 0x74, 0x75, 0x74,
  0x00, 0x00, 0x75, 0x00, 0x74, 0x75, 0x74, 0x74, 0x75, 0x00, 0x75, 0x00,
  0x75, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x74, 0x74, 0x75,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x74, 0x00, 0x74, 0x00, 0x75, 0x74,
  0x00, 0x00, 0x74, 0x00, 0x74, 0x74, 0x75, 0x00, 0x00, 0x00, 0x74, 0x74,
  0x75, 0x74, 0x00, 0x74, 0x00, 0x75, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x74, 0x76, 0x76, 0x76, 0x76, 0x74, 0x74, 0x00, 0x75, 0x74, 0x00,
  0x00, 0x74, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x75, 0x74, 0x00, 0x00, 0x00, 0x00, 0x75, 0x00, 0x75, 0x00,
  0x74, 0x75, 0x74, 0x74, 0x74, 0x00, 0x74, 0x00, 0x75, 0x74, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x74, 0x00, 0x00, 0x74,
  0x00, 0x00, 0x74, 0x75, 0x00, 0x74, 0x74, 0x75, 0x00, 0x75, 0x74, 0x00,
  0x75, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x74, 0x74,
  0x00, 0x00, 0x75, 0x00, 0x00, 0x75, 0x00, 0x74, 0x75, 0x74, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x00, 0x74,
  0x00, 0x75, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x75, 0x00, 0x74, 0x74,
  0x75, 0x74, 0x74, 0x75, 0x00, 0x74, 0x75, 0x74, 0x00, 0x00, 0x74, 0x74,
  0x74, 0x00, 0x75, 0x74, 0x00, 0x75, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x74, 0x00, 0x74, 0x74, 0x74, 0x00, 0x00, 0x75, 0x00, 0x74, 0x00, 0x00,
  0x74, 0x75, 0x00, 0x74, 0x75, 0x00, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74,
  0x74, 0x00, 0x74, 0x75, 0x74, 0x00, 0x74, 0x74, 0x75, 0x74, 0x74, 0x00,
  0x00, 0x74, 0x74, 0x74, 0x75, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x75,
  0x74, 0x76, 0x76, 0x76, 0x76, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x75, 0x74,
  0x74, 0x74, 0x74, 0x00, 0x75, 0x74, 0x74, 0x74, 0x74, 0x00, 0x74, 0x74,
  0x75, 0x00, 0x74, 0x75, 0x00, 0x74, 0x75, 0x74, 0x00, 0x74, 0x75, 0x74,
  0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x75, 0x00, 0x74, 0x00, 0x75,
  0x74, 0x74, 0x75, 0x74, 0x00, 0x75, 0x00, 0x74, 0x74, 0x74, 0x74, 0x74,
  0x00, 0x74, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x75, 0x74, 0x74, 0x00, 0x00, 0x74, 0x00, 0x75,
  0x00, 0x74, 0x75, 0x74, 0x00, 0x74, 0x74, 0x75, 0x74, 0x00, 0x74, 0x75,
  0x74, 0x00, 0x74, 0x74, 0x75, 0x74, 0x74, 0x00, 0x00, 0x74, 0x74, 0x75,
  0x74, 0x00, 0x75, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x74, 0x75, 0x00,
  0x74, 0x75, 0x74, 0x74, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x74, 0x75,
  0x74, 0x00, 0x74, 0x75, 0x00, 0x74, 0x00, 0x75, 0x74, 0x00, 0x75, 0x74,
  0x74, 0x75, 0x00, 0x00, 0x74, 0x00, 0x75, 0x00, 0x74, 0x75, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x75, 0x00, 0x00, 0x74, 0x75, 0x00, 0x74, 0x74, 0x00,
  0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x74, 0x75, 0x00, 0x00, 0x75, 0x74, 0x75, 0x74, 0x75, 0x00, 0x00,
  0x75, 0x74, 0x75, 0x74, 0x00, 0x00, 0x75, 0x74, 0x00, 0x75, 0x00, 0x00,
  0x74, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x75, 0x00, 0x74,
  0x00, 0x00, 0x75, 0x00, 0x00, 0x00, 0x00, 0x74, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x75, 0x74, 0x00, 0x74, 0x74, 0x74, 0x75, 0x75, 0x00, 0x75, 0x74,
  0x75, 0x00, 0x00, 0x74, 0x00, 0x75, 0x00, 0x74, 0x75, 0x74, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x00, 0x74, 0x74, 0x75, 0x00, 0x00, 0x00, 0x74, 0x74,
  0x00, 0x75, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x74, 0x75, 0x00, 0x00,
  0x74, 0x00, 0x75, 0x00, 0x74, 0x75, 0x00, 0x74, 0x74, 0x75, 0x75, 0x00,
  0x75, 0x00, 0x74, 0x00, 0x74, 0x75, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x75, 0x74, 0x00, 0x75, 0x74, 0x75, 0x00, 0x74, 0x00, 0x74, 0x75, 0x00,
  0x74, 0x75, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x75, 0x74,
  0x00, 0x00, 0x74, 0x74, 0x00, 0x74, 0x74, 0x74, 0x75, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x74, 0x74, 0x00, 0x74, 0x74, 0x00, 0x74, 0x74, 0x00, 0x75,
  0x74, 0x00, 0x00, 0x00, 0x74, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74,
  0x74, 0x76, 0x00, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x74, 0x74, 0x00, 0x74,
  0x00, 0x00, 0x74, 0x75, 0x00, 0x74, 0x74, 0x75, 0x00, 0x74, 0x74, 0x75,
  0x74, 0x00, 0x74, 0x75, 0x75, 0x74, 0x74, 0x00, 0x74, 0x74, 0x00, 0x75,
  0x00, 0x74, 0x00, 0x00, 0x76, 0x78, 0x76, 0x00, 0x75, 0x74, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x75, 0x00, 0x74, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x74, 0x00, 0x74, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x75, 0x74, 0x00, 0x75, 0x00, 0x00, 0x74, 0x75, 0x00, 0x74, 0x75,
  0x00, 0x74, 0x75, 0x74, 0x00, 0x75, 0x74, 0x00, 0x00, 0x74, 0x74, 0x74,
  0x00, 0x74, 0x74, 0x00, 0x74, 0x74, 0x00, 0x75, 0x74, 0x74, 0x00, 0x74,
  0x74, 0x75, 0x74, 0x00, 0x74, 0x74, 0x00, 0x74, 0x75, 0x74, 0x75, 0x74,
  0x74, 0x75, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x74, 0x00, 0x74,
  0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75,
  0x74, 0x75, 0x00, 0x00, 0x74, 0x00, 0x75, 0x74, 0x74, 0x00, 0x75, 0x00,
  0x00, 0x74, 0x75, 0x00, 0x00, 0x75, 0x74, 0x75, 0x00, 0x00, 0x75, 0x74,
  0x00, 0x74, 0x75, 0x74, 0x00, 0x00, 0x74, 0x00, 0x75, 0x74, 0x75, 0x74,
  0x75, 0x00, 0x00, 0x00, 0x00, 0x74, 0x75, 0x74, 0x00, 0x74, 0x00, 0x75,
  0x00, 0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75, 0x00, 0x75, 0x74, 0x75,
  0x74, 0x00, 0x74, 0x74, 0x75, 0x74, 0x00, 0x74, 0x00, 0x00, 0x75, 0x74,
  0x74, 0x75, 0x00, 0x74, 0x74, 0x75, 0x74, 0x00, 0x74, 0x75, 0x74, 0x00,
  0x00, 0x75, 0x74, 0x76, 0x78, 0x76, 0x76, 0x76, 0x00, 0x00, 0x00, 0x74,
  0x75, 0x74, 0x00, 0x74, 0x00, 0x00, 0x74, 0x75, 0x74, 0x75, 0x74, 0x00,
  0x74, 0x00, 0x75, 0x00, 0x74, 0x75, 0x74, 0x00, 0x74, 0x75, 0x74, 0x75,
  0x74, 0x00, 0x00, 0x74, 0x74, 0x75, 0x74, 0x74, 0x00, 0x75, 0x74, 0x00,
  0x74, 0x00, 0x74, 0x75, 0x74, 0x00, 0x75, 0x00, 0x00, 0x74, 0x75, 0x00,
  0x00, 0x75, 0x74, 0x75, 0x00, 0x00, 0x75, 0x74, 0x00, 0x75, 0x00, 0x74,
  0x75, 0x74, 0x74, 0x75, 0x00, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x00,
  0x75, 0x74, 0x75, 0x74, 0x00, 0x74, 0x00, 0x75, 0x00, 0x74, 0x75, 0x74,
  0x00, 0x74, 0x75, 0x74, 0x75, 0x74, 0x00, 0x00, 0x74, 0x75, 0x00, 0x00,
  0x74, 0x00, 0x74, 0x74, 0x75, 0x74, 0x77, 0x74, 0x75, 0x74, 0x74, 0x00,
  0x74, 0x00, 0x00, 0x74, 0x74, 0x00, 0x75, 0x74, 0x74, 0x74, 0x00, 0x75,
  0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x00, 0x75, 0x74, 0x74,
  0x00, 0x00, 0x74, 0x75, 0x74, 0x75, 0x00, 0x00, 0x74, 0x75, 0x74, 0x74,
  0x00, 0x75, 0x00, 0x74, 0x75, 0x00, 0x00, 0x74, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x74, 0x00, 0x00, 0x74, 0x00, 0x00, 0x74, 0x74, 0x75, 0x74, 0x74,
  0x75, 0x74, 0x74, 0x00, 0x00, 0x00, 0x00, 0x75, 0x00, 0x74, 0x74, 0x75,
  0x74, 0x00, 0x76, 0x78, 0x76, 0x76, 0x76, 0x00, 0x00, 0x00, 0x00, 0x75,
  0x74, 0x74, 0x00, 0x74, 0x75, 0x74, 0x75, 0x74, 0x00, 0x74, 0x00, 0x74,
  0x75, 0x74, 0x74, 0x00, 0x75, 0x00, 0x74, 0x75, 0x74, 0x00, 0x00, 0x75,
  0x74, 0x74, 0x75, 0x00, 0x00, 0x74, 0x74, 0x00, 0x00, 0x74, 0x75, 0x74,
  0x00, 0x74, 0x75, 0x74, 0x75, 0x74, 0x00, 0x74, 0x74, 0x00, 0x00, 0x74,
  0x74, 0x00, 0x75, 0x74, 0x74, 0x74, 0x00, 0x74, 0x75, 0x74, 0x74, 0x75,
  0x00, 0x74, 0x75, 0x74, 0x74, 0x75, 0x00, 0x74, 0x75, 0x74, 0x74, 0x75,
  0x74, 0x00, 0x74, 0x00, 0x74, 0x75, 0x74, 0x74, 0x00, 0x75, 0x00, 0x74,
  0x75, 0x74, 0x00, 0x00, 0x75, 0x74, 0x00, 0x75, 0x00, 0x00, 0x74, 0x74,
  0x75, 0x74, 0x00, 0x75, 0x00, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x00,
  0x74, 0x00, 0x74, 0x74, 0x75, 0x74, 0x00, 0x74, 0x75, 0x74, 0x00, 0x74,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x00, 0x74, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x75, 0x74, 0x74, 0x00, 0x74, 0x74, 0x00, 0x74, 0x75, 0x74, 0x75, 0x74,
  0x00, 0x74, 0x74, 0x75, 0x00, 0x74, 0x75, 0x00, 0x75, 0x74, 0x75, 0x74,
  0x00, 0x75, 0x74, 0x75, 0x74, 0x00, 0x74, 0x75, 0x00, 0x74, 0x75, 0x00,
  0x75, 0x74, 0x00, 0x75, 0x00, 0x74, 0x74, 0x74, 0x75, 0x00, 0x75, 0x74,
  0x00, 0x75, 0x74, 0x76, 0x00, 0x76, 0x76, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75,
  0x74, 0x74, 0x77, 0x74, 0x00, 0x74, 0x75, 0x00, 0x00, 0x74, 0x75, 0x00,
  0x74, 0x75, 0x74, 0x00, 0x74, 0x75, 0x75, 0x74, 0x75, 0x00, 0x00, 0x00,
  0x74, 0x75, 0x74, 0x74, 0x74, 0x00, 0x75, 0x74, 0x74, 0x00, 0x74, 0x74,
  0x75, 0x74, 0x00, 0x74, 0x75, 0x74, 0x00, 0x75, 0x00, 0x74, 0x79, 0x74,
  0x74, 0x79, 0x00, 0x74, 0x00, 0x74, 0x00, 0x75, 0x00, 0x74, 0x75, 0x74,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x77, 0x74, 0x00, 0x74, 0x75,
  0x00, 0x00, 0x74, 0x75, 0x00, 0x74, 0x75, 0x74, 0x00, 0x74, 0x75, 0x74,
  0x74, 0x00, 0x75, 0x00, 0x74, 0x75, 0x00, 0x74, 0x74, 0x00, 0x00, 0x75,
  0x75, 0x74, 0x00, 0x75, 0x74, 0x75, 0x00, 0x74, 0x75, 0x00, 0x75, 0x00,
  0x00, 0x74, 0x74, 0x77, 0x74, 0x00, 0x75, 0x00, 0x74, 0x75, 0x74, 0x00,
  0x00, 0x00, 0x00, 0x75, 0x74, 0x75, 0x74, 0x75, 0x00, 0x00, 0x74, 0x75,
  0x74, 0x00, 0x00, 0x74, 0x00, 0x74, 0x74, 0x74, 0x74, 0x75, 0x00, 0x75,
  0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x00, 0x74, 0x75, 0x00, 0x74,
  0x74, 0x75, 0x00, 0x74, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x74, 0x75,
  0x74, 0x74, 0x75, 0x00, 0x00, 0x00, 0x00, 0x74, 0x75, 0x74, 0x75, 0x74,
  0x75, 0x00, 0x75, 0x74, 0x75, 0x77, 0x74, 0x74, 0x00, 0x74, 0x75, 0x00,
  0x75, 0x00, 0x74, 0x74, 0x75, 0x74, 0x00, 0x74, 0x75, 0x74, 0x74, 0x75,
  0x00, 0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75, 0x74, 0x74, 0x74, 0x00,
  0x74, 0x74, 0x77, 0x75, 0x74, 0x00, 0x74, 0x75, 0x75, 0x74, 0x00, 0x75,
  0x74, 0x75, 0x00, 0x74, 0x75, 0x00, 0x74, 0x00, 0x76, 0x76, 0x76, 0x7A,
  0x79, 0x74, 0x74, 0x74, 0x74, 0x00, 0x74, 0x79, 0x75, 0x74, 0x00, 0x75,
  0x74, 0x74, 0x74, 0x75, 0x00, 0x00, 0x75, 0x74, 0x74, 0x00, 0x00, 0x74,
  0x00, 0x75, 0x74, 0x74, 0x75, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74, 0x00,
  0x00, 0x75, 0x00, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x00, 0x74,
  0x00, 0x75, 0x74, 0x00, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x74, 0x75,
  0x74, 0x75, 0x00, 0x00, 0x75, 0x74, 0x74, 0x00, 0x75, 0x74, 0x00, 0x74,
  0x75, 0x74, 0x75, 0x74, 0x74, 0x00, 0x75, 0x74, 0x74, 0x74, 0x75, 0x74,
  0x00, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x74,
  0x74, 0x75, 0x74, 0x00, 0x00, 0x75, 0x00, 0x74, 0x75, 0x74, 0x74, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x00, 0x75, 0x74, 0x74, 0x75, 0x77, 0x74,
  0x75, 0x74, 0x00, 0x00, 0x75, 0x74, 0x75, 0x74, 0x00, 0x00, 0x00, 0x74,
  0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x74,
  0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74,
  0x00, 0x74, 0x00, 0x74, 0x75, 0x74, 0x77, 0x74, 0x74, 0x75, 0x74, 0x75,
  0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x00, 0x00, 0x75, 0x74, 0x00,
  0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x76, 0x78, 0x76, 0x78, 0x76,
  0x76, 0x76, 0x76, 0x76, 0x74, 0x74, 0x75, 0x79, 0x74, 0x74, 0x75, 0x74,
  0x75, 0x00, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x00, 0x75, 0x74, 0x75,
  0x74, 0x74, 0x75, 0x00, 0x74, 0x75, 0x74, 0x75, 0x00, 0x74, 0x75, 0x74,
  0x75, 0x74, 0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75, 0x74, 0x75, 0x00,
  0x74, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x77, 0x74, 0x75, 0x74,
  0x00, 0x74, 0x00, 0x75, 0x74, 0x74, 0x75, 0x74, 0x00, 0x74, 0x75, 0x74,
  0x74, 0x75, 0x74, 0x74, 0x75, 0x75, 0x74, 0x74, 0x75, 0x75, 0x74, 0x75,
  0x74, 0x75, 0x00, 0x75, 0x74, 0x00, 0x00, 0x75, 0x74, 0x77, 0x74, 0x75,
  0x75, 0x00, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74,
  0x74, 0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x74, 0x75, 0x74, 0x74, 0x74,
  0x00, 0x00, 0x75, 0x74, 0x74, 0x00, 0x74, 0x74, 0x00, 0x75, 0x74, 0x75,
  0x00, 0x74, 0x74, 0x77, 0x74, 0x75, 0x74, 0x74, 0x74, 0x75, 0x77, 0x74,
  0x75, 0x74, 0x75, 0x74, 0x00, 0x74, 0x75, 0x74, 0x75, 0x77, 0x74, 0x75,
  0x74, 0x75, 0x74, 0x75, 0x00, 0x75, 0x74, 0x74, 0x75, 0x00, 0x75, 0x74,
  0x74, 0x00, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75,
  0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x76, 0x78, 0x76, 0x78, 0x76, 0x76,
  0x76, 0x78, 0x76, 0x76, 0x76, 0x00, 0x00, 0x74, 0x74, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x74, 0x00, 0x74, 0x74, 0x75, 0x74, 0x74, 0x74, 0x00, 0x75,
  0x74, 0x00, 0x74, 0x74, 0x75, 0x74, 0x00, 0x74, 0x74, 0x75, 0x74, 0x75,
  0x74, 0x74, 0x75, 0x74, 0x74, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74,
  0x75, 0x75, 0x74, 0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75, 0x74, 0x74,
  0x75, 0x74, 0x75, 0x74, 0x00, 0x75, 0x74, 0x75, 0x74, 0x75, 0x00, 0x74,
  0x75, 0x74, 0x00, 0x75, 0x74, 0x00, 0x74, 0x75, 0x00, 0x75, 0x74, 0x00,
  0x75, 0x74, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x74, 0x75, 0x75,
  0x74, 0x74, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x77, 0x75, 0x74, 0x77,
  0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x00, 0x75, 0x74, 0x75,
  0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x74, 0x75, 0x74,
  0x00, 0x75, 0x00, 0x74, 0x75, 0x74, 0x77, 0x74, 0x75, 0x74, 0x74, 0x75,
  0x74, 0x00, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x74, 0x74, 0x75, 0x74,
  0x75, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x74,
  0x75, 0x74, 0x74, 0x75, 0x74, 0x79, 0x78, 0x76, 0x78, 0x76, 0x78, 0x76,
  0x78, 0x76, 0x76, 0x76, 0x76, 0x76, 0x74, 0x00, 0x00, 0x00, 0x74, 0x74,
  0x00, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74,
  0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x77, 0x74,
  0x75, 0x75, 0x74, 0x77, 0x74, 0x75, 0x74, 0x74, 0x74, 0x75, 0x75, 0x75,
  0x74, 0x74, 0x75, 0x74, 0x75, 0x75, 0x00, 0x75, 0x74, 0x74, 0x77, 0x74,
  0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75, 0x74, 0x00, 0x75,
  0x00, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74,
  0x74, 0x75, 0x74, 0x77, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x74, 0x74,
  0x75, 0x74, 0x75, 0x00, 0x75, 0x74, 0x00, 0x75, 0x74, 0x75, 0x74, 0x74,
  0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74,
  0x75, 0x75, 0x74, 0x77, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75,
  0x74, 0x74, 0x75, 0x74, 0x74, 0x75, 0x75, 0x74, 0x74, 0x75, 0x74, 0x74,
  0x75, 0x75, 0x74, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74,
  0x74, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x74, 0x74, 0x75, 0x74,
  0x74, 0x75, 0x00, 0x75, 0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75, 0x74,
  0x75, 0x75, 0x00, 0x74, 0x79, 0x76, 0x76, 0x78, 0x76, 0x76, 0x76, 0x76,
  0x76, 0x78, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x74, 0x00, 0x74, 0x00,
  0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x74, 0x00, 0x75, 0x74, 0x75, 0x74,
  0x00, 0x75, 0x74, 0x77, 0x74, 0x74, 0x75, 0x74, 0x77, 0x74, 0x74, 0x75,
  0x74, 0x00, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x77, 0x74, 0x74, 0x74,
  0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74,
  0x75, 0x00, 0x74, 0x74, 0x74, 0x75, 0x75, 0x77, 0x74, 0x75, 0x74, 0x74,
  0x74, 0x74, 0x74, 0x77, 0x74, 0x75, 0x74, 0x74, 0x75, 0x75, 0x74, 0x74,
  0x77, 0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x74, 0x00, 0x75, 0x00, 0x75,
  0x74, 0x77, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x74, 0x75, 0x75, 0x74, 0x75, 0x00, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x74, 0x74, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74,
  0x75, 0x75, 0x74, 0x00, 0x75, 0x74, 0x74, 0x75, 0x75, 0x74, 0x75, 0x77,
  0x74, 0x74, 0x74, 0x77, 0x74, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74,
  0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75,
  0x74, 0x75, 0x75, 0x74, 0x75, 0x75, 0x76, 0x76, 0x78, 0x76, 0x76, 0x76,
  0x78, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x00, 0x76, 0x00, 0x00,
  0x00, 0x00, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x77, 0x74, 0x74,
  0x75, 0x74, 0x74, 0x75, 0x74, 0x77, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74,
  0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75,
  0x74, 0x74, 0x75, 0x75, 0x75, 0x74, 0x74, 0x74, 0x75, 0x74, 0x74, 0x75,
  0x74, 0x75, 0x75, 0x74, 0x74, 0x75, 0x77, 0x74, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x75, 0x74, 0x74, 0x75, 0x00, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x74, 0x74, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74,
  0x75, 0x00, 0x74, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75,
  0x74, 0x74, 0x75, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x00, 0x74, 0x75,
  0x74, 0x74, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75,
  0x75, 0x00, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x00, 0x76, 0x76,
  0x76, 0x76, 0x76, 0x76, 0x00, 0x74, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74,
  0x75, 0x75, 0x74, 0x75, 0x77, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74,
  0x74, 0x75, 0x75, 0x74, 0x75, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x78,
  0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x00, 0x76, 0x79, 0x00, 0x74,
  0x00, 0x74, 0x00, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75, 0x74, 0x74,
  0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x74, 0x74,
  0x74, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x74, 0x75, 0x74, 0x74,
  0x77, 0x74, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74,
  0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74,
  0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x74, 0x75, 0x74,
  0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x75,
  0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x74,
  0x75, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x74, 0x75,
  0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x00, 0x74, 0x74, 0x76, 0x78, 0x78,
  0x78, 0x78, 0x76, 0x79, 0x76, 0x00, 0x00, 0x74, 0x75, 0x75, 0x74, 0x74,
  0x74, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x74, 0x74, 0x75, 0x75, 0x74,
  0x75, 0x75, 0x75, 0x74, 0x75, 0x76, 0x75, 0x76, 0x76, 0x76, 0x76, 0x76,
  0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x00, 0x76, 0x00, 0x76, 0x00, 0x00,
  0x74, 0x00, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74,
  0x74, 0x75, 0x00, 0x74, 0x74, 0x75, 0x75, 0x74, 0x75, 0x00, 0x75, 0x74,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74,
  0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x77, 0x74, 0x74, 0x00, 0x75, 0x75,
  0x74, 0x75, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75,
  0x74, 0x00, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75,
  0x74, 0x00, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75,
  0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x74, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74,
  0x75, 0x74, 0x75, 0x75, 0x74, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75,
  0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x76, 0x78, 0x78, 0x78,
  0x76, 0x76, 0x76, 0x76, 0x76, 0x79, 0x74, 0x00, 0x74, 0x74, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x74, 0x75, 0x74, 0x74, 0x79, 0x76, 0x76, 0x75, 0x76, 0x76, 0x76, 0x76,
  0x76, 0x76, 0x76, 0x76, 0x00, 0x76, 0x76, 0x00, 0x76, 0x00, 0x00, 0x74,
  0x00, 0x74, 0x74, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x77, 0x74, 0x75,
  0x75, 0x74, 0x75, 0x75, 0x74, 0x00, 0x75, 0x75, 0x74, 0x74, 0x75, 0x75,
  0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75,
  0x75, 0x75, 0x75, 0x74, 0x74, 0x74, 0x75, 0x74, 0x74, 0x75, 0x75, 0x74,
  0x75, 0x00, 0x75, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74,
  0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75,
  0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75,
  0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75,
  0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x74, 0x77, 0x74,
  0x75, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x76, 0x78, 0x78, 0x78, 0x76,
  0x78, 0x76, 0x76, 0x76, 0x76, 0x76, 0x74, 0x79, 0x00, 0x74, 0x75, 0x74,
  0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74,
  0x75, 0x74, 0x74, 0x75, 0x74, 0x79, 0x79, 0x76, 0x76, 0x76, 0x76, 0x76,
  0x76, 0x79, 0x76, 0x79, 0x76, 0x74, 0x74, 0x00, 0x00, 0x00, 0x74, 0x00,
  0x74, 0x74, 0x74, 0x75, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74,
  0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x74,
  0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75,
  0x75, 0x74, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x75, 0x74, 0x74, 0x77, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75,
  0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75,
  0x74, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75,
  0x74, 0x75, 0x74, 0x74, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x74,
  0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D,
  0x75, 0x75, 0x75, 0x74, 0x74, 0x74, 0x75, 0x75, 0x74, 0x74, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x74, 0x74, 0x75, 0x00, 0x74, 0x74, 0x75, 0x75, 0x74,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x76, 0x76, 0x78, 0x76, 0x78,
  0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x74, 0x00, 0x74, 0x00, 0x74, 0x75,
  0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x74, 0x74, 0x75,
  0x74, 0x74, 0x75, 0x75, 0x74, 0x00, 0x74, 0x79, 0x79, 0x74, 0x79, 0x74,
  0x79, 0x00, 0x79, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x00, 0x74,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x74, 0x75, 0x74, 0x74, 0x75,
  0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x77, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x74,
  0x75, 0x74, 0x74, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74,
  0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x75, 0x74,
  0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x74, 0x74, 0x75, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x74, 0x75, 0x75, 0x74, 0x75,
  0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x76, 0x78, 0x76, 0x78, 0x76,
  0x76, 0x76, 0x76, 0x76, 0x76, 0x74, 0x79, 0x74, 0x00, 0x00, 0x74, 0x75,
  0x75, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74,
  0x75, 0x75, 0x75, 0x74, 0x74, 0x74, 0x00, 0x74, 0x00, 0x79, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x74, 0x74, 0x74, 0x74, 0x74, 0x75,
  0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74, 0x74, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x74, 0x75, 0x75, 0x74, 0x74, 0x74, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x79, 0x75,
  0x75, 0x74, 0x75, 0x75, 0x74, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75,
  0x74, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x75,
  0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75,
  0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x74, 0x75, 0x74,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x74, 0x75, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x76, 0x76, 0x76, 0x76, 0x76,
  0x76, 0x76, 0x76, 0x76, 0x74, 0x79, 0x74, 0x00, 0x00, 0x00, 0x75, 0x74,
  0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x74, 0x74, 0x75, 0x75, 0x75, 0x74, 0x74, 0x00, 0x00, 0x74, 0x00,
  0x00, 0x74, 0x00, 0x74, 0x74, 0x75, 0x74, 0x74, 0x74, 0x75, 0x74, 0x74,
  0x75, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75,
  0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74,
  0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x74, 0x4D, 0x75, 0x75, 0x79, 0x75, 0x74, 0x79, 0x75, 0x75, 0x75, 0x74,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x74,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74,
  0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x79, 0x79, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x74, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x74,
  0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x74, 0x74, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x79, 0x76, 0x76, 0x76, 0x76,
  0x76, 0x76, 0x74, 0x74, 0x74, 0x79, 0x00, 0x79, 0x00, 0x74, 0x74, 0x74,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x74, 0x74, 0x4D, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x74, 0x74, 0x77, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74,
  0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74,
  0x75, 0x75, 0x75, 0x4D, 0x75, 0x79, 0x74, 0x74, 0x74, 0x74, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x74, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x75, 0x74, 0x75, 0x74,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x74, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x78, 0x78, 0x76, 0x76, 0x74, 0x4D,
  0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x79, 0x74, 0x79, 0x74,
  0x79, 0x74, 0x79, 0x00, 0x79, 0x00, 0x00, 0x00, 0x74, 0x75, 0x74, 0x75,
  0x74, 0x74, 0x74, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x78, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x74, 0x75, 0x74, 0x75,
  0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x74, 0x75,
  0x75, 0x75, 0x74, 0x75, 0x75, 0x01, 0x78, 0x76, 0x76, 0x79, 0x79, 0x75,
  0x79, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x74, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x4D, 0x75, 0x75,
  0x75, 0x75, 0x4D, 0x75, 0x75, 0x78, 0x01, 0x76, 0x78, 0x76, 0x76, 0x74,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D,
  0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75,
  0x74, 0x00, 0x74, 0x74, 0x75, 0x74, 0x75, 0x74, 0x76, 0x74, 0x77, 0x75,
  0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75,
  0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75,
  0x74, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x01, 0x78, 0x78, 0x78, 0x76, 0x76, 0x79, 0x79,
  0x79, 0x79, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x4D, 0x75, 0x75, 0x74, 0x74, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x78,
  0x75, 0x75, 0x75, 0x78, 0x76, 0x78, 0x78, 0x78, 0x76, 0x76, 0x76, 0x74,
  0x79, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x74, 0x78, 0x75, 0x74, 0x75, 0x75, 0x4D, 0x75, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x4D, 0x75,
  0x75, 0x75, 0x74, 0x75, 0x4D, 0x74, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x00, 0x75, 0x75, 0x78, 0x75, 0x74, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x78, 0x75,
  0x75, 0x75, 0x4D, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75,
  0x75, 0x4D, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74,
  0x75, 0x75, 0x74, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x78, 0x75,
  0x4D, 0x75, 0x75, 0x75, 0x78, 0x78, 0x78, 0x76, 0x76, 0x76, 0x74, 0x79,
  0x4D, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x4D, 0x75,
  0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x74, 0x75, 0x78, 0x75, 0x75, 0x76, 0x76, 0x76, 0x76, 0x76, 0x79, 0x74,
  0x79, 0x75, 0x78, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x78, 0x75, 0x75,
  0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75,
  0x4D, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x4D, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x4D,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x4D, 0x75,
  0x75, 0x75, 0x75, 0x4D, 0x75, 0x78, 0x4D, 0x75, 0x4D, 0x75, 0x75, 0x75,
  0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x74,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x76, 0x76, 0x76, 0x76, 0x76, 0x79, 0x00, 0x75, 0x75, 0x4D, 0x75,
  0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x78, 0x79, 0x76, 0x76, 0x76, 0x76, 0x74, 0x79, 0x74,
  0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x74, 0x75,
  0x75, 0x74, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x4D, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x74, 0x75,
  0x75, 0x75, 0x75, 0x78, 0x75, 0x79, 0x75, 0x74, 0x74, 0x74, 0x74, 0x74,
  0x74, 0x78, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75,
  0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x4D, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x4D, 0x75,
  0x78, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x74, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x79,
  0x78, 0x78, 0x78, 0x78, 0x78, 0x76, 0x76, 0x79, 0x00, 0x75, 0x75, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x75, 0x79, 0x75, 0x75, 0x74, 0x74, 0x75, 0x75,
  0x75, 0x75, 0x4D, 0x75, 0x75, 0x79, 0x79, 0x79, 0x79, 0x74, 0x74, 0x75,
  0x74, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x4D, 0x75, 0x75, 0x75, 0x78, 0x75, 0x74, 0x75, 0x75, 0x4D, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x4D, 0x75, 0x75, 0x75, 0x76, 0x75, 0x76, 0x75, 0x79, 0x74, 0x75, 0x74,
  0x78, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x76, 0x75, 0x75, 0x74, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x74, 0x75, 0x75, 0x75, 0x78, 0x74, 0x75,
  0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x74, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x4D, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75,
  0x75, 0x4D, 0x75, 0x78, 0x75, 0x78, 0x74, 0x78, 0x75, 0x78, 0x75, 0x4D,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78,
  0x01, 0x78, 0x78, 0x76, 0x76, 0x76, 0x00, 0x76, 0x79, 0x00, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x75, 0x75, 0x76, 0x76, 0x76, 0x76, 0x79, 0x74, 0x76,
  0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x74, 0x74, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x74, 0x75, 0x75, 0x75, 0x4D, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75,
  0x75, 0x78, 0x74, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x75, 0x75, 0x4D, 0x78, 0x75, 0x75, 0x75, 0x4D, 0x75,
  0x4D, 0x75, 0x75, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D,
  0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x74,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x78, 0x74, 0x75, 0x4D,
  0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x78, 0x75,
  0x74, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x79, 0x01,
  0x78, 0x78, 0x76, 0x76, 0x76, 0x76, 0x76, 0x00, 0x79, 0x00, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x79, 0x76, 0x78, 0x78, 0x76, 0x76, 0x79, 0x74,
  0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x4D, 0x75,
  0x78, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75,
  0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75,
  0x74, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x4D,
  0x75, 0x78, 0x75, 0x4D, 0x75, 0x4D, 0x75, 0x78, 0x4D, 0x75, 0x75, 0x78,
  0x75, 0x78, 0x78, 0x78, 0x74, 0x79, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75,
  0x4D, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x78, 0x75, 0x75, 0x74, 0x75, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78,
  0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x78, 0x4D, 0x74, 0x78, 0x78,
  0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x00, 0x79, 0x79, 0x00, 0x75, 0x78,
  0x75, 0x4D, 0x75, 0x76, 0x75, 0x76, 0x78, 0x76, 0x76, 0x76, 0x00, 0x74,
  0x75, 0x78, 0x74, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x74, 0x78, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x78, 0x4D, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75,
  0x74, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D,
  0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x4D, 0x75,
  0x75, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x4D, 0x75, 0x74, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75,
  0x78, 0x78, 0x01, 0x78, 0x76, 0x76, 0x74, 0x79, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x4D, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x78, 0x4D, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x78, 0x4D, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75,
  0x75, 0x75, 0x76, 0x75, 0x74, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x78, 0x75,
  0x75, 0x4D, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x79,
  0x76, 0x76, 0x76, 0x76, 0x75, 0x79, 0x79, 0x79, 0x00, 0x79, 0x75, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x75, 0x76, 0x76, 0x79, 0x79, 0x00, 0x74, 0x75,
  0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x4D, 0x78, 0x75,
  0x75, 0x75, 0x76, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x74,
  0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x74, 0x75, 0x75,
  0x78, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x4D, 0x75, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x74, 0x78, 0x75, 0x78, 0x75, 0x4D,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x76, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75,
  0x78, 0x01, 0x01, 0x78, 0x78, 0x76, 0x76, 0x79, 0x79, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75,
  0x75, 0x76, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x75, 0x74, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x74, 0x78,
  0x75, 0x4D, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x74, 0x75,
  0x75, 0x75, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75,
  0x79, 0x79, 0x74, 0x79, 0x79, 0x00, 0x00, 0x00, 0x79, 0x75, 0x75, 0x4D,
  0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x76, 0x75, 0x75, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x4D, 0x75, 0x75, 0x4D, 0x78, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x75, 0x75, 0x74, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x4D, 0x75, 0x76, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78,
  0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x74, 0x75, 0x78, 0x74, 0x75, 0x4D,
  0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x74, 0x75, 0x75, 0x75, 0x75,
  0x78, 0x76, 0x78, 0x76, 0x76, 0x76, 0x74, 0x79, 0x74, 0x75, 0x4D, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x76, 0x75, 0x4D, 0x75, 0x78, 0x74,
  0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x75, 0x78, 0x75,
  0x4D, 0x75, 0x78, 0x75, 0x78, 0x75, 0x74, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x4D, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75,
  0x75, 0x74, 0x00, 0x00, 0x00, 0x74, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75,
  0x74, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75,
  0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75,
  0x75, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x75, 0x74, 0x75, 0x75, 0x78, 0x4D,
  0x75, 0x75, 0x78, 0x75, 0x76, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x76, 0x75,
  0x78, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x75, 0x75, 0x78,
  0x74, 0x75, 0x75, 0x78, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x76, 0x75, 0x75, 0x75, 0x78, 0x4D, 0x75, 0x75, 0x78,
  0x74, 0x79, 0x79, 0x74, 0x74, 0x74, 0x79, 0x74, 0x75, 0x75, 0x75, 0x75,
  0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75,
  0x75, 0x78, 0x75, 0x78, 0x4D, 0x75, 0x75, 0x75, 0x75, 0x76, 0x75, 0x75,
  0x75, 0x78, 0x75, 0x76, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x76, 0x75, 0x75, 0x4D, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x75, 0x75, 0x74, 0x75, 0x78, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75,
  0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75,
  0x4D, 0x75, 0x75, 0x78, 0x4D, 0x75, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x76, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x74, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x78, 0x78, 0x4D, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x4D, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x75, 0x79, 0x79, 0x79, 0x7A, 0x75, 0x75, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x78, 0x75, 0x4D, 0x75, 0x75, 0x75,
  0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x4D,
  0x75, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x78, 0x75,
  0x76, 0x75, 0x4D, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x76, 0x4D, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x75, 0x74, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x75, 0x75, 0x76, 0x75, 0x78, 0x4D, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x75, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x4D,
  0x75, 0x75, 0x78, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x75, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76,
  0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x76, 0x4D, 0x78, 0x75, 0x78,
  0x74, 0x78, 0x75, 0x74, 0x75, 0x78, 0x75, 0x76, 0x75, 0x75, 0x4D, 0x78,
  0x75, 0x76, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x4D, 0x78,
  0x75, 0x75, 0x74, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x74, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75,
  0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x4D, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x4D,
  0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x76, 0x75, 0x75, 0x75, 0x78,
  0x74, 0x78, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78,
  0x74, 0x75, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x78, 0x76, 0x75, 0x76, 0x76, 0x76, 0x76, 0x76, 0x75,
  0x74, 0x74, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x75, 0x4D, 0x75, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x76, 0x4D,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x75, 0x75, 0x76, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x78, 0x78, 0x78, 0x75,
  0x74, 0x75, 0x75, 0x75, 0x75, 0x4D, 0x78, 0x75, 0x78, 0x75, 0x75, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x4D, 0x78, 0x75, 0x78, 0x75, 0x75, 0x4D, 0x75, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x75, 0x76, 0x01, 0x01, 0x78, 0x78, 0x78, 0x78,
  0x76, 0x75, 0x74, 0x75, 0x75, 0x75, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78,
  0x4D, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x75, 0x75, 0x4D,
  0x75, 0x76, 0x75, 0x76, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x76, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x74, 0x75, 0x75, 0x78, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x76, 0x75, 0x76,
  0x75, 0x75, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x78, 0x01, 0x76, 0x78,
  0x76, 0x74, 0x79, 0x76, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x4D, 0x75,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x75, 0x75, 0x4D, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x76, 0x76, 0x01, 0x01, 0x78, 0x78, 0x78, 0x76, 0x76,
  0x76, 0x76, 0x76, 0x74, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x75, 0x4D, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x4D, 0x75, 0x75, 0x75, 0x78, 0x4D,
  0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x75, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x74, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x75, 0x75, 0x76, 0x75, 0x75, 0x78, 0x01, 0x78, 0x78, 0x76,
  0x76, 0x76, 0x74, 0x79, 0x75, 0x75, 0x75, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x78, 0x01, 0x78, 0x78, 0x78, 0x76, 0x76, 0x76,
  0x76, 0x76, 0x74, 0x79, 0x74, 0x75, 0x4D, 0x75, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x75, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x75, 0x4D, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x4D, 0x78, 0x75, 0x78, 0x75, 0x78, 0x76, 0x76, 0x76, 0x76,
  0x76, 0x76, 0x79, 0x74, 0x79, 0x75, 0x4D, 0x75, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x76, 0x78, 0x78, 0x78, 0x76, 0x76, 0x76, 0x76,
  0x76, 0x74, 0x79, 0x00, 0x74, 0x75, 0x74, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x4D, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x75, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x79, 0x76, 0x76, 0x76,
  0x79, 0x79, 0x79, 0x74, 0x79, 0x75, 0x75, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x76, 0x75, 0x78, 0x75, 0x79, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x79,
  0x79, 0x00, 0x00, 0x74, 0x74, 0x74, 0x75, 0x75, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x76, 0x75, 0x78, 0x4D, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x76, 0x76, 0x75, 0x79, 0x79, 0x79,
  0x79, 0x74, 0x74, 0x79, 0x75, 0x75, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x76, 0x79, 0x76, 0x79, 0x76, 0x79, 0x79, 0x00,
  0x00, 0x74, 0x74, 0x74, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x76, 0x76, 0x76, 0x76, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x75, 0x75, 0x75, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x75, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74,
  0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x76, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76,
  0x78, 0x78, 0x76, 0x76, 0x76, 0x75, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x78, 0x75, 0x78, 0x78, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75,
  0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x76,
  0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x75, 0x4D, 0x78, 0x75, 0x78, 0x75,
  0x76, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x78, 0x4D, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x76, 0x76,
  0x76, 0x76, 0x76, 0x76, 0x76, 0x74, 0x75, 0x75, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x76,
  0x75, 0x76, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78,
  0x75, 0x76, 0x75, 0x76, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75,
  0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x76,
  0x76, 0x76, 0x76, 0x76, 0x00, 0x76, 0x75, 0x75, 0x75, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75, 0x78, 0x75,
  0x78, 0x75, 0x78, 0x75, 0x76, 0x75, 0x78, 0x75, 0x78, 0x75, 0x76, 0x75,
};

const uint8_t sprite0LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0A, 0x00, 0x00, 0x00, 0x09,
  0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00,
  0x00, 0x09, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x0B, 0x09, 0x0B, 0x09, 0x09, 0x08, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x09, 0x0B, 0x09, 0x0B, 0x09, 0x0B, 0x09, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x08, 0x0B, 0x09, 0x0B,
  0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x08,
  0x08, 0x09, 0x0C, 0x09, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0x7B, 0x7B, 0x0C, 0x08, 0x09, 0x0C, 0x09, 0x09, 0x09, 0x08, 0x0A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0B, 0x0C, 0x7B, 0x7B, 0x0C, 0x08, 0x0C, 0x09, 0x09,
  0x09, 0x08, 0x0A, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x09, 0x0C, 0x0C, 0x08,
  0x09, 0x09, 0x09, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0x09, 0x09, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
  0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x08, 0x08, 0x08, 0x08, 0x0B, 0x0C,
  0x09, 0x08, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x09, 0x0A, 0x0A, 0x0A,
  0x0A, 0x0A, 0x08, 0x08, 0x08, 0x09, 0x09, 0x09, 0x08, 0x08, 0x0C, 0x09,
  0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A,
  0x0A, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x09,
  0x08, 0x08, 0x0C, 0x09, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x0A, 0x08, 0x08, 0x09, 0x0A, 0x0B, 0x0B, 0x09, 0x09, 0x0B,
  0x09, 0x09, 0x08, 0x0B, 0x0B, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x00, 0x0A,
  0x0B, 0x09, 0x09, 0x09, 0x0B, 0x08, 0x09, 0x08, 0x08, 0x0A, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0x0C, 0x0B, 0x0B, 0x0B, 0x0B, 0x08, 0x09,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0B, 0x0A, 0x08,
  0x08, 0x0B, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0x09, 0x09, 0x09, 0x09, 0x0C, 0x0B, 0x0B, 0x0B, 0x09, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x08, 0x08,
  0x08, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0A, 0x08, 0x08,
  0x08, 0x0B, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x09, 0x09, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x0B, 0x00, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x09, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C, 0x0B, 0x0B, 0x08,
  0x08, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x08, 0x0B, 0x0A, 0x08, 0x08, 0x08,
  0x0B, 0x0A, 0x08, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0B,
  0x09, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x08, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x0B, 0x0B,
  0x09, 0x08, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x0B, 0x0B, 0x09, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C,
  0x0B, 0x0B, 0x08, 0x08, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x08, 0x08, 0x0C, 0x0C,
  0x0A, 0x08, 0x08, 0x0B, 0x0A, 0x08, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09,
  0x09, 0x09, 0x0B, 0x0A, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x0B, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x09, 0x0B,
  0x0B, 0x0B, 0x0B, 0x09, 0x0A, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x0B, 0x0B, 0x0C, 0x09, 0x09,
  0x0B, 0x0B, 0x0C, 0x0A, 0x08, 0x08, 0x08, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x08,
  0x08, 0x0B, 0x0C, 0x0B, 0x08, 0x08, 0x0B, 0x08, 0x09, 0x09, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x09, 0x09, 0x09, 0x0B, 0x0A, 0x08, 0x09, 0x09, 0x0B, 0x09,
  0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09,
  0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x0B, 0x0A, 0x0A, 0x0D, 0x0E, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x09,
  0x09, 0x0B, 0x09, 0x09, 0x0B, 0x0C, 0x0C, 0x0B, 0x0B, 0x0B, 0x08, 0x00,
  0x00, 0x0D, 0x0D, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x08, 0x0B, 0x0B, 0x0C, 0x0B, 0x09, 0x08, 0x0B, 0x0A, 0x08,
  0x08, 0x08, 0x08, 0x00, 0x0D, 0x0E, 0x0E, 0x0F, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x09, 0x08, 0x08, 0x0B, 0x0A, 0x0B,
  0x09, 0x0B, 0x09, 0x09, 0x09, 0x09, 0x08, 0x0D, 0x0D, 0x0D, 0x0D, 0x0E,
  0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09,
  0x09, 0x0B, 0x09, 0x08, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x09, 0x0C, 0x0D,
  0x0E, 0x0E, 0x0E, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x08, 0x09, 0x09, 0x0B, 0x09, 0x0B, 0x0C, 0x0B, 0x0B,
  0x0B, 0x0B, 0x08, 0x0D, 0x0D, 0x0D, 0x0D, 0x0E, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x09, 0x09, 0x0B, 0x09,
  0x08, 0x0B, 0x08, 0x08, 0x08, 0x08, 0x0D, 0x0E, 0x0E, 0x0E, 0x0F, 0x0F,
  0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x09, 0x0C, 0x0B, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x08, 0x0D, 0x0D,
  0x0D, 0x0D, 0x0E, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x09, 0x08, 0x09, 0x0B, 0x09, 0x09,
  0x0B, 0x08, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x09,
  0x0B, 0x0C, 0x0B, 0x0B, 0x08, 0x0A, 0x00, 0x0F, 0x0D, 0x0E, 0x0F, 0x0F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x08, 0x0B, 0x0A, 0x08, 0x09, 0x00, 0x00, 0x0F,
  0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0B, 0x09, 0x09,
  0x09, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x09, 0x0B, 0x09, 0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x08, 0x0C, 0x0B,
  0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x0B, 0x0A, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x08, 0x0B, 0x09, 0x09, 0x0A, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0B, 0x09,
  0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0x0C, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x08, 0x0B, 0x0A, 0x08, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
  0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0B, 0x09, 0x09,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0x08, 0x0A, 0x0A, 0x0A, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x0C, 0x0B, 0x0A, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x08, 0x00, 0x00, 0x0A, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x08, 0x08,
  0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x09, 0x0A, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x09, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x09,
  0x08, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x09, 0x0C, 0x09, 0x09, 0x09,
  0x09, 0x09, 0x09, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A,
  0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x00, 0x00,
  0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask0LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
  0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3A, 0xBF,
  0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0xDF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1F, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
  0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
  0xFF, 0xE7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xEF, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x03,
  0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0x9E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x8C, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x0F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66,
  0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0x1E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xC8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite0LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x09, 0x09, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x09, 0x09,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
  0x09, 0x0B, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x0B, 0x09, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x0B, 0x09, 0x0B,
  0x09, 0x0B, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
  0x09, 0x09, 0x08, 0x0B, 0x0C, 0x09, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0C, 0x0C, 0x08, 0x08, 0x09, 0x0C, 0x09, 0x09, 0x09,
  0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x7B, 0x7B, 0x0C, 0x08, 0x0C,
  0x09, 0x09, 0x09, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0C, 0x7B,
  0x7B, 0x0C, 0x08, 0x0C, 0x09, 0x08, 0x08, 0x08, 0x08, 0x0B, 0x0C, 0x09,
  0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x0B, 0x0C, 0x09, 0x0C, 0x0C, 0x08, 0x09, 0x09, 0x08, 0x08, 0x08,
  0x09, 0x09, 0x0B, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x09, 0x09, 0x0B, 0x0B, 0x09, 0x09, 0x09, 0x09, 0x09,
  0x08, 0x0C, 0x09, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x08, 0x08, 0x08,
  0x08, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x09, 0x08, 0x08, 0x08, 0x08, 0x08,
  0x09, 0x09, 0x09, 0x08, 0x08, 0x0C, 0x09, 0x09, 0x09, 0x09, 0x0B, 0x09,
  0x09, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x09, 0x09, 0x08, 0x08, 0x0A, 0x0A,
  0x0A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x09, 0x08, 0x09, 0x00, 0x0B, 0x0B,
  0x0B, 0x09, 0x09, 0x0B, 0x08, 0x0B, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0B, 0x08,
  0x08, 0x0A, 0x0A, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0x0C, 0x0B, 0x0B, 0x08, 0x0B, 0x09, 0x09,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0B, 0x0B, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0B, 0x0A, 0x08,
  0x08, 0x09, 0x09, 0x09, 0x08, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x09, 0x09, 0x09, 0x0C, 0x0B, 0x0B, 0x0B, 0x0B, 0x09, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x08, 0x08, 0x08,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0B, 0x0A, 0x08, 0x08, 0x08,
  0x0B, 0x09, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09,
  0x09, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x0B, 0x0B, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x0B, 0x09, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C, 0x0B, 0x0B, 0x08, 0x08,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0B, 0x0A, 0x08, 0x08, 0x08, 0x0B,
  0x0A, 0x08, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x09, 0x0B, 0x09,
  0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x08, 0x08, 0x0B, 0x09, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09,
  0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x0B, 0x0B, 0x09,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x0B, 0x09, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C, 0x0B,
  0x0B, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x08, 0x0C, 0x0C, 0x0A,
  0x08, 0x08, 0x0B, 0x0A, 0x08, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x09,
  0x09, 0x0B, 0x0A, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x08, 0x09,
  0x0B, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x0B, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x09, 0x0B, 0x0B,
  0x0B, 0x0B, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x0B, 0x0C, 0x09, 0x09, 0x0B,
  0x0B, 0x0C, 0x0A, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x08,
  0x0B, 0x0C, 0x0B, 0x08, 0x08, 0x0B, 0x08, 0x09, 0x09, 0x08, 0x00, 0x00,
  0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x09, 0x09, 0x0B, 0x0A, 0x08, 0x09, 0x09, 0x0B, 0x09, 0x09,
  0x09, 0x08, 0x09, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09,
  0x09, 0x0B, 0x09, 0x09, 0x09, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x09,
  0x0B, 0x09, 0x09, 0x0B, 0x0C, 0x0C, 0x0B, 0x0B, 0x0B, 0x08, 0x00, 0x0E,
  0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x08, 0x0B, 0x0C, 0x0B, 0x09, 0x08, 0x0B, 0x0A, 0x08, 0x08,
  0x08, 0x08, 0x0D, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x08, 0x0B, 0x0A, 0x0B, 0x09,
  0x0B, 0x09, 0x09, 0x09, 0x09, 0x08, 0x0D, 0x0E, 0x0E, 0x0F, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09,
  0x0B, 0x09, 0x08, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x09, 0x0C, 0x0D, 0x0F,
  0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x09, 0x0B, 0x09, 0x0B, 0x0C, 0x0B, 0x0B, 0x0B,
  0x0B, 0x08, 0x0D, 0x0E, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0B, 0x09, 0x08,
  0x0B, 0x08, 0x08, 0x08, 0x08, 0x0D, 0x0E, 0x0F, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x0C, 0x0B, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x08, 0x0D, 0x0D, 0x0F,
  0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x08, 0x09, 0x0B, 0x09, 0x09, 0x0B,
  0x08, 0x0D, 0x0E, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0B,
  0x0C, 0x0B, 0x0B, 0x08, 0x00, 0x00, 0x0F, 0x0D, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x0B, 0x0A, 0x08, 0x09, 0x00, 0x00, 0x00, 0x0F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x0B, 0x09, 0x09, 0x09,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09,
  0x0B, 0x09, 0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x0C, 0x0B, 0x0B, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09,
  0x0B, 0x0A, 0x08, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x08, 0x09, 0x0B, 0x09, 0x09, 0x00, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x0B, 0x09, 0x09, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0C,
  0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x08, 0x0B, 0x0A, 0x08, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0B, 0x09, 0x09, 0x00, 0x09, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0B, 0x09,
  0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x09, 0x0C, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x0B, 0x0A, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0B, 0x09, 0x09, 0x00,
  0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
  0x0C, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x0B, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0C, 0x09, 0x00, 0x00, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x0C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x09, 0x09, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x08, 0x08, 0x0B, 0x08,
  0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask0LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F,
  0xFF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xC4, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xBF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x83,
  0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x0F, 0xFC, 0x00, 0x00,
  0x00, 0x00, 0x20, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
  0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
  0xFF, 0xC8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
  0xFF, 0xD8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x3E, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x03, 0xC0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0x07, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xA9, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite0RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x09, 0x00, 0x00, 0x00,
  0x0A, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x08, 0x09, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x08, 0x09, 0x09, 0x0B, 0x09, 0x0B, 0x09,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x0B,
  0x09, 0x0B, 0x09, 0x0B, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x09, 0x09, 0x0B, 0x09, 0x0B, 0x08, 0x09, 0x09, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x09, 0x09, 0x0C, 0x09, 0x08,
  0x08, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x08, 0x09, 0x09,
  0x09, 0x0C, 0x09, 0x08, 0x0C, 0x7B, 0x7B, 0x0C, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A,
  0x0A, 0x0A, 0x08, 0x09, 0x09, 0x09, 0x0C, 0x08, 0x0C, 0x7B, 0x7B, 0x0C,
  0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x09, 0x09, 0x09,
  0x08, 0x0C, 0x0C, 0x09, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x08, 0x09, 0x0C, 0x0B, 0x08, 0x08,
  0x08, 0x08, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x08, 0x08, 0x08, 0x08,
  0x08, 0x08, 0x08, 0x09, 0x09, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x09,
  0x0B, 0x09, 0x09, 0x09, 0x09, 0x0C, 0x08, 0x08, 0x09, 0x09, 0x09, 0x08,
  0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x09, 0x0B, 0x0B, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x09, 0x0C, 0x08, 0x08,
  0x09, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x0A,
  0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x0B, 0x0B, 0x08, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x0B,
  0x0B, 0x0A, 0x09, 0x08, 0x08, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x08, 0x08, 0x09, 0x08, 0x0B,
  0x09, 0x09, 0x09, 0x0B, 0x0A, 0x00, 0x0A, 0x0A, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x09, 0x08, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C, 0x0B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x09, 0x09, 0x0B, 0x08, 0x08, 0x0A, 0x0B, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0B, 0x0B, 0x0B, 0x0C, 0x09,
  0x09, 0x09, 0x09, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x08,
  0x08, 0x08, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x09, 0x09, 0x0B, 0x08, 0x08, 0x08, 0x0A, 0x0B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x0B, 0x09, 0x09, 0x0B, 0x09,
  0x09, 0x09, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x08,
  0x08, 0x0B, 0x0B, 0x0C, 0x0B, 0x0B, 0x0B, 0x0B, 0x09, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x09, 0x08, 0x0A, 0x0B, 0x08, 0x08, 0x08, 0x0A,
  0x0B, 0x08, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x09, 0x09, 0x0B,
  0x09, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x08, 0x09,
  0x0B, 0x0B, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x0A, 0x08, 0x08, 0x0B, 0x0B, 0x0C, 0x0B, 0x0B, 0x0B,
  0x0B, 0x09, 0x0B, 0x0B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x08, 0x0A,
  0x0B, 0x08, 0x08, 0x0A, 0x0C, 0x0C, 0x08, 0x08, 0x09, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x0A, 0x0B, 0x09, 0x09,
  0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x0A, 0x0A, 0x09, 0x0B, 0x0B, 0x0B, 0x0B, 0x09, 0x09, 0x09,
  0x09, 0x0B, 0x09, 0x09, 0x09, 0x0B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x08, 0x08, 0x08,
  0x0A, 0x0C, 0x0B, 0x0B, 0x09, 0x09, 0x0C, 0x0B, 0x0B, 0x08, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x09, 0x09, 0x08, 0x0B, 0x08, 0x08, 0x0B, 0x0C, 0x0B, 0x08,
  0x08, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09,
  0x08, 0x0A, 0x0B, 0x09, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x0D, 0x0A, 0x0A, 0x0B, 0x09, 0x09,
  0x09, 0x0B, 0x09, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x0D, 0x0D, 0x00,
  0x00, 0x08, 0x0B, 0x0B, 0x0B, 0x0C, 0x0C, 0x0B, 0x09, 0x09, 0x0B, 0x09,
  0x09, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F,
  0x0F, 0x0E, 0x0E, 0x0D, 0x00, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0B, 0x08,
  0x09, 0x0B, 0x0C, 0x0B, 0x0B, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x0E, 0x0D, 0x0D, 0x0D, 0x0D, 0x08, 0x09, 0x09,
  0x09, 0x09, 0x0B, 0x09, 0x0B, 0x0A, 0x0B, 0x08, 0x08, 0x09, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x0E, 0x0E,
  0x0D, 0x0C, 0x09, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x08, 0x09, 0x0B, 0x09,
  0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F,
  0x0E, 0x0D, 0x0D, 0x0D, 0x0D, 0x08, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C, 0x0B,
  0x09, 0x0B, 0x09, 0x09, 0x08, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0E, 0x0E, 0x0E, 0x0D, 0x08, 0x08,
  0x08, 0x08, 0x0B, 0x08, 0x09, 0x0B, 0x09, 0x09, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0E, 0x0E, 0x0D, 0x0D,
  0x0D, 0x0D, 0x08, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x0B, 0x0C, 0x09, 0x0A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F,
  0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0D, 0x08, 0x0B, 0x09, 0x09, 0x0B, 0x09,
  0x08, 0x09, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x0D, 0x0F, 0x00, 0x0A, 0x08,
  0x0B, 0x0B, 0x0C, 0x0B, 0x09, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F,
  0x0F, 0x00, 0x00, 0x09, 0x08, 0x0A, 0x0B, 0x08, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x09, 0x09, 0x09, 0x0B, 0x09,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
  0x09, 0x09, 0x0B, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x0C, 0x08, 0x0A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x0A, 0x0B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x09, 0x09, 0x0B, 0x08, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x0B, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B,
  0x0B, 0x0C, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x08, 0x0A, 0x0B, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x0B, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A,
  0x0A, 0x0B, 0x0C, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x0A,
  0x0A, 0x08, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x0B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x0A, 0x00, 0x00, 0x08, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x09,
  0x0C, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x08, 0x08, 0x09, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x00, 0x00, 0x08, 0x09, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x0C, 0x09, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x09, 0x09, 0x09,
  0x09, 0x09, 0x09, 0x0C, 0x09, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask0RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x8C, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
  0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF,
  0xFD, 0x5C, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFB, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFE, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF,
  0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE7, 0xFF,
  0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xF7, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFB, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xF0, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
  0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x4E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x9E, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F,
  0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x13, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite0RB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
  0x09, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x09, 0x09, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x0B, 0x09,
  0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x0B, 0x09, 0x09, 0x0B, 0x09, 0x09,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x09, 0x0B, 0x09,
  0x0B, 0x09, 0x0B, 0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x09, 0x09, 0x09, 0x0C, 0x0B, 0x08, 0x09, 0x09, 0x09, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x0A, 0x09, 0x09, 0x09, 0x0C, 0x09, 0x08, 0x08, 0x0C,
  0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x09, 0x09, 0x09,
  0x0C, 0x08, 0x0C, 0x7B, 0x7B, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x09, 0x0C, 0x0B, 0x08,
  0x08, 0x08, 0x08, 0x09, 0x0C, 0x08, 0x0C, 0x7B, 0x7B, 0x0C, 0x09, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x08, 0x09,
  0x09, 0x0B, 0x09, 0x09, 0x08, 0x08, 0x08, 0x09, 0x09, 0x08, 0x0C, 0x0C,
  0x09, 0x0C, 0x0B, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x08,
  0x08, 0x08, 0x08, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x09, 0x0C, 0x08,
  0x09, 0x09, 0x09, 0x09, 0x09, 0x0B, 0x0B, 0x09, 0x09, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09,
  0x09, 0x09, 0x0C, 0x08, 0x08, 0x09, 0x09, 0x09, 0x08, 0x08, 0x08, 0x08,
  0x08, 0x09, 0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x0B, 0x08,
  0x0B, 0x09, 0x09, 0x0B, 0x0B, 0x0B, 0x00, 0x09, 0x08, 0x09, 0x08, 0x08,
  0x08, 0x08, 0x08, 0x0A, 0x0A, 0x0A, 0x08, 0x08, 0x09, 0x09, 0x0B, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x09, 0x09, 0x0B, 0x08, 0x0B, 0x0B, 0x0C, 0x0B, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x0A, 0x0A, 0x08,
  0x08, 0x0B, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0x08, 0x09, 0x09, 0x09, 0x08, 0x08, 0x0A, 0x0B, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C,
  0x09, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x08, 0x08, 0x08, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x09, 0x09, 0x09, 0x0B, 0x08, 0x08, 0x08, 0x0A,
  0x0B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0B, 0x0B, 0x09, 0x09, 0x09, 0x0B,
  0x09, 0x09, 0x09, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x08, 0x08, 0x0B, 0x0B, 0x0C, 0x0B, 0x0B, 0x0B, 0x0B, 0x09, 0x0B, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x09, 0x09, 0x08, 0x0A, 0x0B, 0x08, 0x08, 0x08,
  0x0A, 0x0B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x09, 0x0B, 0x08, 0x08, 0x09, 0x09,
  0x0B, 0x09, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x09, 0x0B, 0x0B, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09,
  0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x0B, 0x0B, 0x0C, 0x0B, 0x0B,
  0x0B, 0x0B, 0x09, 0x0B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x09, 0x08,
  0x0A, 0x0B, 0x08, 0x08, 0x0A, 0x0C, 0x0C, 0x08, 0x09, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0B,
  0x09, 0x08, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x0A, 0x0B, 0x09,
  0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x0B, 0x0B, 0x0B, 0x0B, 0x09, 0x09,
  0x09, 0x09, 0x0B, 0x09, 0x09, 0x0B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
  0x08, 0x0A, 0x0C, 0x0B, 0x0B, 0x09, 0x09, 0x0C, 0x0B, 0x08, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A,
  0x00, 0x00, 0x08, 0x09, 0x09, 0x08, 0x0B, 0x08, 0x08, 0x0B, 0x0C, 0x0B,
  0x08, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0x09, 0x08, 0x09, 0x09, 0x09, 0x0B, 0x09,
  0x09, 0x08, 0x0A, 0x0B, 0x09, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x09,
  0x09, 0x09, 0x0B, 0x09, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x09, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F,
  0x0E, 0x00, 0x08, 0x0B, 0x0B, 0x0B, 0x0C, 0x0C, 0x0B, 0x09, 0x09, 0x0B,
  0x09, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0D, 0x08, 0x08, 0x08, 0x08, 0x0A, 0x0B,
  0x08, 0x09, 0x0B, 0x0C, 0x0B, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0E, 0x0E, 0x0D, 0x08, 0x09,
  0x09, 0x09, 0x09, 0x0B, 0x09, 0x0B, 0x0A, 0x0B, 0x08, 0x09, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F,
  0x0F, 0x0D, 0x0C, 0x09, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x08, 0x09, 0x0B,
  0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x0E, 0x0E, 0x0D, 0x08, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C,
  0x0B, 0x09, 0x0B, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0E, 0x0D, 0x08,
  0x08, 0x08, 0x08, 0x0B, 0x08, 0x09, 0x0B, 0x09, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F,
  0x0F, 0x0D, 0x0D, 0x08, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x0B, 0x0C, 0x09,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x0E, 0x0E, 0x0D, 0x08, 0x0B, 0x09, 0x09, 0x0B,
  0x09, 0x08, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0F, 0x00, 0x00,
  0x08, 0x0B, 0x0B, 0x0C, 0x0B, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x09, 0x08, 0x0A, 0x0B, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x09, 0x0B,
  0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x09, 0x09, 0x0B, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x09, 0x0B, 0x09, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x0C,
  0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x08, 0x0A, 0x0B, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x00, 0x09, 0x09, 0x0B, 0x09, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09,
  0x0B, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0x0B, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x08, 0x0A, 0x0B, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x09,
  0x09, 0x0B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x09, 0x09, 0x0B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x0C, 0x09,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x0A, 0x0B, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x00, 0x09, 0x09, 0x0B, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0C,
  0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x08, 0x09, 0x0B, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x09, 0x0C, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x09, 0x09, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0C, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x0B, 0x08, 0x08,
  0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x0A,
  0x00, 0x0A, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask0RB[] = {
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1C, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFF,
  0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x23, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF,
  0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0xFD, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0xC1, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, 0x0E, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xF0, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFE, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF,
  0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xFF,
  0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xFF,
  0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFE, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5E, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x17, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x04, 0xE0, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x95, 0x00, 0x00, 0x00,
};

const uint8_t sprite1LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x11, 0x11,
  0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11,
  0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13,
  0x13, 0x13, 0x13, 0x13, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x11, 0x11, 0x14, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x11, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x11, 0x11, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13,
  0x13, 0x13, 0x13, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14,
  0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x14, 0x11, 0x11, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x14, 0x14, 0x14, 0x13,
  0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14,
  0x11, 0x14, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13,
  0x10, 0x10, 0x10, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x11, 0x14,
  0x14, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x11, 0x14, 0x11,
  0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x13, 0x13, 0x10, 0x10, 0x14, 0x11, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11,
  0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14,
  0x11, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14,
  0x11, 0x14, 0x11, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13,
  0x10, 0x14, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x11, 0x11, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x14, 0x14, 0x14, 0x11, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x13, 0x10, 0x10, 0x14, 0x11, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x14, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14,
  0x11, 0x14, 0x11, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x10, 0x10,
  0x14, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x14, 0x14, 0x13,
  0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x14, 0x11,
  0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x14, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14,
  0x13, 0x14, 0x13, 0x10, 0x10, 0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11,
  0x14, 0x14, 0x10, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14,
  0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14,
  0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14,
  0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13, 0x10, 0x10, 0x11, 0x12,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x14, 0x14, 0x10, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x14, 0x11,
  0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11,
  0x14, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x13,
  0x13, 0x10, 0x14, 0x11, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x14, 0x10, 0x13, 0x14, 0x13,
  0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x14, 0x11, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x13, 0x14,
  0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10,
  0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x14, 0x10, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13,
  0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13,
  0x13, 0x13, 0x10, 0x10, 0x10, 0x14, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x13, 0x10, 0x13, 0x14, 0x13, 0x14,
  0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x14, 0x12, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x14, 0x10, 0x13,
  0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
  0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14,
  0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10,
  0x10, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x14, 0x10, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x15, 0x15, 0x15, 0x16, 0x16, 0x16,
  0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
  0x11, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x13, 0x13,
  0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x14, 0x13, 0x10, 0x13, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x15, 0x15, 0x16, 0x16,
  0x16, 0x16, 0x15, 0x11, 0x12, 0x12, 0x12, 0x12, 0x16, 0x16, 0x16, 0x16,
  0x16, 0x16, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x11, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x10, 0x13, 0x13,
  0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x15,
  0x15, 0x15, 0x15, 0x11, 0x12, 0x12, 0x12, 0x15, 0x12, 0x12, 0x12, 0x12,
  0x15, 0x12, 0x12, 0x12, 0x12, 0x16, 0x16, 0x16, 0x16, 0x15, 0x15, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x13, 0x13, 0x13,
  0x13, 0x10, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11,
  0x14, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11,
  0x11, 0x11, 0x15, 0x16, 0x16, 0x16, 0x12, 0x15, 0x12, 0x12, 0x12, 0x15,
  0x12, 0x12, 0x12, 0x12, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x15, 0x12,
  0x16, 0x16, 0x16, 0x16, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x14,
  0x14, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x14, 0x10, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14,
  0x14, 0x14, 0x11, 0x11, 0x16, 0x16, 0x16, 0x16, 0x17, 0x12, 0x17, 0x11,
  0x12, 0x12, 0x12, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x15, 0x12, 0x12,
  0x12, 0x12, 0x11, 0x12, 0x17, 0x12, 0x15, 0x16, 0x16, 0x16, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x13, 0x10, 0x13,
  0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x15, 0x15, 0x17,
  0x12, 0x17, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x14, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x14, 0x12, 0x12, 0x11, 0x12, 0x12, 0x12, 0x17, 0x15, 0x17,
  0x17, 0x16, 0x16, 0x16, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x13, 0x13,
  0x13, 0x13, 0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11,
  0x14, 0x10, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x11, 0x16, 0x16, 0x17,
  0x17, 0x15, 0x17, 0x12, 0x17, 0x12, 0x14, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x14, 0x12, 0x12, 0x12, 0x12, 0x12, 0x14, 0x12, 0x12, 0x14, 0x12, 0x12,
  0x17, 0x12, 0x11, 0x12, 0x17, 0x17, 0x17, 0x16, 0x16, 0x11, 0x11, 0x11,
  0x11, 0x14, 0x13, 0x13, 0x13, 0x13, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x14, 0x13, 0x10, 0x13, 0x14, 0x14, 0x14, 0x14,
  0x11, 0x16, 0x17, 0x17, 0x17, 0x15, 0x12, 0x17, 0x12, 0x17, 0x14, 0x17,
  0x12, 0x12, 0x12, 0x12, 0x14, 0x12, 0x12, 0x12, 0x12, 0x12, 0x14, 0x12,
  0x12, 0x14, 0x12, 0x17, 0x12, 0x14, 0x12, 0x17, 0x17, 0x17, 0x11, 0x17,
  0x16, 0x16, 0x11, 0x11, 0x11, 0x14, 0x13, 0x13, 0x13, 0x13, 0x11, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x10, 0x13, 0x10,
  0x14, 0x14, 0x14, 0x11, 0x11, 0x15, 0x15, 0x17, 0x15, 0x17, 0x17, 0x12,
  0x17, 0x12, 0x14, 0x12, 0x17, 0x12, 0x17, 0x12, 0x12, 0x14, 0x12, 0x12,
  0x12, 0x12, 0x14, 0x12, 0x12, 0x14, 0x17, 0x12, 0x17, 0x14, 0x17, 0x12,
  0x17, 0x17, 0x11, 0x17, 0x10, 0x16, 0x11, 0x11, 0x11, 0x14, 0x13, 0x13,
  0x13, 0x10, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x11, 0x14, 0x10, 0x13, 0x14, 0x15, 0x15, 0x15, 0x15, 0x10, 0x10, 0x17,
  0x14, 0x17, 0x17, 0x17, 0x12, 0x17, 0x14, 0x17, 0x12, 0x17, 0x12, 0x17,
  0x12, 0x14, 0x12, 0x12, 0x12, 0x12, 0x14, 0x12, 0x17, 0x14, 0x12, 0x17,
  0x12, 0x14, 0x12, 0x17, 0x17, 0x11, 0x17, 0x17, 0x11, 0x16, 0x16, 0x11,
  0x11, 0x14, 0x13, 0x13, 0x13, 0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x13, 0x10, 0x14, 0x14, 0x11, 0x11,
  0x10, 0x10, 0x10, 0x17, 0x14, 0x17, 0x17, 0x17, 0x17, 0x12, 0x14, 0x12,
  0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x14, 0x12, 0x12, 0x14, 0x17, 0x12,
  0x17, 0x12, 0x14, 0x12, 0x17, 0x14, 0x17, 0x17, 0x17, 0x14, 0x17, 0x10,
  0x11, 0x10, 0x16, 0x16, 0x11, 0x14, 0x13, 0x13, 0x10, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x14, 0x14, 0x13,
  0x14, 0x14, 0x14, 0x11, 0x10, 0x10, 0x10, 0x17, 0x14, 0x17, 0x17, 0x17,
  0x12, 0x17, 0x12, 0x14, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17,
  0x12, 0x14, 0x12, 0x17, 0x12, 0x17, 0x14, 0x17, 0x12, 0x14, 0x17, 0x17,
  0x17, 0x14, 0x10, 0x10, 0x14, 0x10, 0x10, 0x16, 0x11, 0x14, 0x13, 0x10,
  0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11, 0x10, 0x17,
  0x17, 0x14, 0x17, 0x17, 0x17, 0x17, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12,
  0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x17,
  0x17, 0x14, 0x17, 0x17, 0x17, 0x14, 0x10, 0x10, 0x14, 0x10, 0x10, 0x11,
  0x14, 0x14, 0x10, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x14, 0x14, 0x11, 0x11,
  0x10, 0x10, 0x11, 0x10, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17,
  0x12, 0x17, 0x17, 0x17, 0x14, 0x17, 0x17, 0x10, 0x14, 0x10, 0x10, 0x10,
  0x14, 0x10, 0x10, 0x11, 0x14, 0x13, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11,
  0x14, 0x14, 0x14, 0x11, 0x14, 0x10, 0x10, 0x11, 0x10, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x14, 0x14, 0x11, 0x11, 0x14, 0x11, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x14, 0x11, 0x11, 0x14, 0x11, 0x10,
  0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x14,
  0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x14,
  0x11, 0x11, 0x14, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x10, 0x10, 0x11, 0x11,
  0x11, 0x11, 0x14, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x14, 0x11, 0x11, 0x11, 0x11, 0x13, 0x13, 0x14, 0x10, 0x10,
  0x10, 0x10, 0x11, 0x10, 0x10, 0x10, 0x10, 0x11, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x11, 0x10, 0x10, 0x10, 0x11, 0x11, 0x14, 0x14, 0x14, 0x11,
  0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x11,
  0x11, 0x14, 0x13, 0x10, 0x10, 0x10, 0x11, 0x10, 0x10, 0x10, 0x11, 0x10,
  0x10, 0x10, 0x11, 0x10, 0x10, 0x10, 0x11, 0x13, 0x13, 0x13, 0x13, 0x11,
  0x13, 0x13, 0x13, 0x13, 0x11, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x11, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x00, 0x13, 0x13, 0x13, 0x11, 0x13,
  0x13, 0x13, 0x11, 0x13, 0x13, 0x13, 0x11, 0x13, 0x13, 0x13, 0x13, 0x11,
  0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x14,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11,
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00,
  0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask1LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F,
  0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x23, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x00,
  0x00, 0x20, 0xDF, 0xFF, 0xF1, 0x04, 0x04, 0x00, 0x00, 0x21, 0x02, 0x22,
  0x11, 0x02, 0x02, 0x00, 0x00, 0x11, 0x02, 0x22, 0x11, 0x02, 0x02, 0x00,
  0x00, 0x11, 0x04, 0x22, 0x11, 0x00, 0x01, 0x00, 0x00, 0x21, 0x04, 0x22,
  0x11, 0x02, 0x00, 0x80, 0x00, 0x01, 0x04, 0x22, 0x11, 0x02, 0x00, 0x80,
  0x00, 0x01, 0x04, 0x20, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite1LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x11, 0x11, 0x11, 0x11, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x11, 0x11,
  0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x11, 0x11, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13,
  0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x10, 0x11, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x14, 0x13, 0x13, 0x14, 0x13, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10,
  0x10, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x11, 0x11, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x14, 0x14,
  0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x14, 0x11,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10,
  0x10, 0x11, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11,
  0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x11, 0x14,
  0x11, 0x14, 0x14, 0x11, 0x14, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14,
  0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x11, 0x11, 0x11, 0x14, 0x14, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x14, 0x11, 0x14, 0x11, 0x14,
  0x11, 0x14, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x14,
  0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x14, 0x14, 0x14, 0x11, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x13, 0x13, 0x13, 0x10, 0x14, 0x14, 0x11, 0x12, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x14, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x14, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x11, 0x14, 0x11,
  0x14, 0x11, 0x14, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13, 0x10, 0x10, 0x14,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x14, 0x14, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x14, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x14, 0x13, 0x14, 0x13,
  0x13, 0x13, 0x10, 0x10, 0x14, 0x11, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11,
  0x14, 0x14, 0x13, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x11, 0x14, 0x11, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x11, 0x14, 0x14,
  0x14, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13, 0x10, 0x10, 0x14, 0x14, 0x12,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x11, 0x11, 0x14, 0x14, 0x10, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x14, 0x14, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11,
  0x14, 0x11, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14,
  0x11, 0x14, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13,
  0x10, 0x10, 0x10, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x14, 0x10, 0x10, 0x13, 0x13, 0x13,
  0x13, 0x13, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x10, 0x14, 0x12, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x13, 0x14, 0x13,
  0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10,
  0x10, 0x10, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11,
  0x14, 0x10, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13,
  0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13,
  0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x14, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x11, 0x14, 0x13, 0x10, 0x13, 0x14, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10,
  0x14, 0x11, 0x00, 0x00, 0x10, 0x11, 0x11, 0x14, 0x10, 0x13, 0x14, 0x13,
  0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11,
  0x11, 0x11, 0x11, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
  0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14,
  0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
  0x13, 0x13, 0x10, 0x10, 0x14, 0x11, 0x11, 0x00, 0x11, 0x11, 0x14, 0x10,
  0x13, 0x13, 0x13, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x11, 0x11, 0x11, 0x15, 0x15, 0x15, 0x16, 0x16, 0x16, 0x16,
  0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
  0x11, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x13, 0x13,
  0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x11, 0x00,
  0x11, 0x11, 0x14, 0x13, 0x10, 0x13, 0x14, 0x13, 0x13, 0x14, 0x13, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x15, 0x15, 0x16, 0x16, 0x16,
  0x16, 0x15, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x16, 0x16, 0x16, 0x16,
  0x16, 0x16, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
  0x10, 0x10, 0x11, 0x00, 0x11, 0x11, 0x14, 0x10, 0x13, 0x13, 0x13, 0x14,
  0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x15, 0x15,
  0x15, 0x15, 0x11, 0x12, 0x12, 0x12, 0x15, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x15, 0x12, 0x12, 0x12, 0x12, 0x16, 0x16, 0x16, 0x16, 0x15, 0x15, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x13, 0x13, 0x13,
  0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x11, 0x12, 0x11, 0x11, 0x14, 0x13,
  0x13, 0x13, 0x14, 0x13, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11,
  0x11, 0x15, 0x16, 0x16, 0x16, 0x12, 0x15, 0x12, 0x12, 0x12, 0x15, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x15, 0x12,
  0x16, 0x16, 0x16, 0x16, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x14,
  0x14, 0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x12,
  0x11, 0x11, 0x14, 0x10, 0x13, 0x13, 0x13, 0x14, 0x14, 0x13, 0x14, 0x14,
  0x14, 0x11, 0x11, 0x16, 0x16, 0x16, 0x16, 0x17, 0x12, 0x17, 0x11, 0x12,
  0x12, 0x12, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x15, 0x12, 0x12,
  0x12, 0x12, 0x11, 0x12, 0x17, 0x12, 0x15, 0x16, 0x16, 0x16, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x13, 0x13, 0x13, 0x13, 0x13,
  0x13, 0x10, 0x14, 0x12, 0x11, 0x11, 0x14, 0x13, 0x10, 0x13, 0x14, 0x13,
  0x13, 0x14, 0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x15, 0x15, 0x17, 0x12,
  0x17, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x14, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x14, 0x12, 0x12, 0x11, 0x12, 0x12, 0x12, 0x17, 0x15, 0x17,
  0x17, 0x16, 0x16, 0x16, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x14,
  0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x14, 0x12, 0x11, 0x14, 0x10, 0x10,
  0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x11, 0x16, 0x16, 0x17, 0x17, 0x15,
  0x17, 0x17, 0x12, 0x17, 0x12, 0x14, 0x12, 0x12, 0x12, 0x12, 0x12, 0x14,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x14, 0x12, 0x12, 0x14, 0x12, 0x12,
  0x17, 0x12, 0x11, 0x12, 0x12, 0x17, 0x17, 0x17, 0x16, 0x16, 0x11, 0x11,
  0x11, 0x11, 0x14, 0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14, 0x12,
  0x11, 0x14, 0x13, 0x13, 0x10, 0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x16,
  0x17, 0x17, 0x17, 0x15, 0x12, 0x12, 0x17, 0x12, 0x17, 0x14, 0x17, 0x12,
  0x12, 0x12, 0x12, 0x14, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x14, 0x12,
  0x12, 0x14, 0x12, 0x17, 0x12, 0x14, 0x12, 0x17, 0x17, 0x17, 0x17, 0x11,
  0x17, 0x16, 0x16, 0x11, 0x11, 0x11, 0x11, 0x14, 0x14, 0x13, 0x13, 0x13,
  0x13, 0x13, 0x14, 0x12, 0x11, 0x14, 0x10, 0x10, 0x13, 0x10, 0x14, 0x14,
  0x14, 0x11, 0x11, 0x15, 0x15, 0x17, 0x15, 0x17, 0x17, 0x17, 0x12, 0x17,
  0x12, 0x14, 0x12, 0x17, 0x12, 0x17, 0x12, 0x12, 0x14, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x14, 0x12, 0x12, 0x14, 0x17, 0x12, 0x17, 0x14, 0x17, 0x12,
  0x12, 0x17, 0x17, 0x11, 0x17, 0x10, 0x16, 0x11, 0x11, 0x11, 0x11, 0x14,
  0x14, 0x13, 0x13, 0x13, 0x13, 0x10, 0x11, 0x00, 0x11, 0x11, 0x14, 0x14,
  0x10, 0x13, 0x14, 0x15, 0x15, 0x15, 0x15, 0x10, 0x10, 0x17, 0x14, 0x17,
  0x17, 0x17, 0x17, 0x12, 0x17, 0x14, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12,
  0x14, 0x12, 0x12, 0x12, 0x12, 0x12, 0x14, 0x12, 0x17, 0x14, 0x12, 0x17,
  0x12, 0x14, 0x12, 0x17, 0x17, 0x17, 0x11, 0x17, 0x17, 0x11, 0x16, 0x16,
  0x11, 0x11, 0x11, 0x14, 0x14, 0x13, 0x13, 0x13, 0x13, 0x14, 0x11, 0x00,
  0x11, 0x11, 0x14, 0x14, 0x13, 0x10, 0x14, 0x14, 0x11, 0x11, 0x10, 0x10,
  0x10, 0x17, 0x14, 0x17, 0x17, 0x17, 0x17, 0x17, 0x12, 0x14, 0x12, 0x17,
  0x12, 0x17, 0x12, 0x17, 0x12, 0x14, 0x14, 0x12, 0x12, 0x14, 0x17, 0x12,
  0x17, 0x12, 0x14, 0x12, 0x17, 0x14, 0x17, 0x17, 0x17, 0x17, 0x14, 0x17,
  0x10, 0x11, 0x10, 0x16, 0x16, 0x11, 0x11, 0x14, 0x14, 0x13, 0x13, 0x13,
  0x10, 0x11, 0x00, 0x00, 0x00, 0x11, 0x14, 0x14, 0x14, 0x13, 0x14, 0x14,
  0x14, 0x11, 0x10, 0x10, 0x10, 0x17, 0x14, 0x17, 0x17, 0x17, 0x17, 0x12,
  0x17, 0x12, 0x14, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x12, 0x17,
  0x12, 0x14, 0x12, 0x17, 0x12, 0x17, 0x14, 0x17, 0x12, 0x14, 0x17, 0x17,
  0x17, 0x17, 0x14, 0x10, 0x10, 0x14, 0x10, 0x10, 0x16, 0x11, 0x14, 0x14,
  0x14, 0x13, 0x13, 0x10, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11,
  0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11, 0x10, 0x17, 0x17, 0x14,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17,
  0x12, 0x17, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x17,
  0x17, 0x14, 0x17, 0x17, 0x17, 0x17, 0x14, 0x10, 0x10, 0x14, 0x10, 0x10,
  0x11, 0x14, 0x14, 0x14, 0x13, 0x10, 0x10, 0x14, 0x11, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x14, 0x14, 0x11, 0x11, 0x10, 0x10,
  0x11, 0x10, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17,
  0x12, 0x17, 0x17, 0x17, 0x14, 0x17, 0x17, 0x10, 0x10, 0x14, 0x10, 0x10,
  0x10, 0x14, 0x10, 0x10, 0x11, 0x14, 0x14, 0x13, 0x10, 0x14, 0x14, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x14, 0x14,
  0x11, 0x14, 0x14, 0x10, 0x10, 0x11, 0x10, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x14, 0x14, 0x11, 0x11, 0x14, 0x14,
  0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x14, 0x11, 0x11, 0x14, 0x14, 0x10, 0x10, 0x10,
  0x10, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11,
  0x14, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x13, 0x13, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x10, 0x10,
  0x10, 0x10, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x10,
  0x10, 0x10, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11,
  0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x14, 0x13, 0x10, 0x10, 0x10,
  0x10, 0x11, 0x10, 0x10, 0x10, 0x11, 0x10, 0x10, 0x10, 0x11, 0x11, 0x10,
  0x10, 0x10, 0x11, 0x13, 0x13, 0x13, 0x13, 0x11, 0x13, 0x13, 0x13, 0x13,
  0x13, 0x11, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x10, 0x14, 0x14,
  0x00, 0x13, 0x13, 0x13, 0x13, 0x11, 0x13, 0x13, 0x13, 0x11, 0x13, 0x13,
  0x13, 0x11, 0x11, 0x13, 0x13, 0x13, 0x13, 0x11, 0x10, 0x00, 0x00, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
  0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11,
  0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask1LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x3F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x8F, 0xFF, 0xFF,
  0xFF, 0xFF, 0x88, 0x00, 0x00, 0x87, 0x7F, 0xFF, 0xF9, 0x02, 0x04, 0x00,
  0x00, 0x84, 0x04, 0x42, 0x11, 0x01, 0x04, 0x00, 0x00, 0x84, 0x08, 0x42,
  0x11, 0x01, 0x04, 0x00, 0x01, 0x82, 0x08, 0x42, 0x10, 0x80, 0x04, 0x00,
  0x01, 0x02, 0x04, 0x42, 0x10, 0x82, 0x02, 0x00, 0x00, 0x02, 0x04, 0x42,
  0x10, 0x80, 0x00, 0x00, 0x00, 0x02, 0x04, 0x40, 0x00, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite1RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x11, 0x11, 0x11, 0x11,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11,
  0x13, 0x13, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x13, 0x14, 0x13, 0x13, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x11, 0x11, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x13, 0x14, 0x11, 0x11,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x11, 0x11, 0x13, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14,
  0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x10, 0x10, 0x10, 0x13, 0x13, 0x13,
  0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x14, 0x11, 0x14,
  0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x10, 0x10, 0x10,
  0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x14, 0x11,
  0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x13, 0x14, 0x14, 0x14, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x14,
  0x10, 0x10, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x11, 0x14,
  0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14,
  0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x13, 0x14, 0x14, 0x11, 0x11, 0x11,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x11, 0x14, 0x14, 0x10, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x14, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x14, 0x14, 0x14, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x14, 0x10, 0x10, 0x13, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x11, 0x14, 0x14, 0x14,
  0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x11, 0x11, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x14, 0x10, 0x10, 0x13, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x14, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x14, 0x14, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x14, 0x10,
  0x10, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x14,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x13, 0x14, 0x13, 0x13, 0x14, 0x14, 0x11, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x12, 0x11, 0x10, 0x10, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14,
  0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11,
  0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11,
  0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x10, 0x14, 0x14,
  0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x12, 0x11, 0x14, 0x10, 0x13, 0x13, 0x13, 0x14, 0x13,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14,
  0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x13, 0x10, 0x14, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x10, 0x10, 0x13,
  0x13, 0x13, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x10, 0x14, 0x11, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x14,
  0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13,
  0x14, 0x13, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x12, 0x14, 0x10, 0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x13, 0x14, 0x13, 0x13, 0x13, 0x10, 0x14, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x14, 0x10, 0x10, 0x13, 0x13, 0x13,
  0x13, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x10, 0x13, 0x14, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x10,
  0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14,
  0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x15,
  0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x13, 0x10, 0x14, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x11, 0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x15, 0x15,
  0x15, 0x15, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x15,
  0x15, 0x15, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13,
  0x14, 0x13, 0x14, 0x13, 0x13, 0x13, 0x10, 0x14, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13,
  0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x15,
  0x15, 0x15, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x12, 0x12, 0x12, 0x12,
  0x11, 0x15, 0x16, 0x16, 0x16, 0x16, 0x15, 0x15, 0x11, 0x11, 0x11, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x10, 0x13, 0x14,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x10, 0x13,
  0x13, 0x13, 0x13, 0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x15, 0x15, 0x16, 0x16, 0x16, 0x16, 0x12, 0x12, 0x12, 0x12, 0x15,
  0x12, 0x12, 0x12, 0x12, 0x15, 0x12, 0x12, 0x12, 0x11, 0x15, 0x15, 0x15,
  0x15, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13,
  0x13, 0x13, 0x10, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x14, 0x14, 0x14, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x16, 0x16, 0x16, 0x16, 0x12, 0x15, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x11, 0x12, 0x12, 0x12, 0x12, 0x15, 0x12, 0x12, 0x12,
  0x15, 0x12, 0x16, 0x16, 0x16, 0x15, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13, 0x14, 0x11, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x16, 0x16, 0x16, 0x15, 0x12, 0x17,
  0x12, 0x11, 0x12, 0x12, 0x12, 0x12, 0x15, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x11, 0x12, 0x12, 0x12, 0x11, 0x17, 0x12, 0x17, 0x16, 0x16, 0x16, 0x16,
  0x11, 0x11, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x13, 0x13, 0x10, 0x14,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x14, 0x13, 0x13,
  0x13, 0x13, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x16, 0x16, 0x16, 0x17,
  0x17, 0x15, 0x17, 0x12, 0x12, 0x12, 0x11, 0x12, 0x12, 0x14, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x14, 0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x17, 0x12,
  0x17, 0x15, 0x15, 0x16, 0x16, 0x16, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14,
  0x13, 0x10, 0x13, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x11, 0x13, 0x13, 0x13, 0x13, 0x14, 0x11, 0x11, 0x11, 0x11, 0x16,
  0x16, 0x17, 0x17, 0x17, 0x12, 0x11, 0x12, 0x17, 0x12, 0x12, 0x14, 0x12,
  0x12, 0x14, 0x12, 0x12, 0x12, 0x12, 0x12, 0x14, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x14, 0x12, 0x17, 0x12, 0x17, 0x15, 0x17, 0x17, 0x16, 0x16, 0x11,
  0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x10, 0x14, 0x11, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x13, 0x13, 0x13, 0x13, 0x14, 0x11,
  0x11, 0x11, 0x16, 0x16, 0x17, 0x11, 0x17, 0x17, 0x17, 0x12, 0x14, 0x12,
  0x17, 0x12, 0x14, 0x12, 0x12, 0x14, 0x12, 0x12, 0x12, 0x12, 0x12, 0x14,
  0x12, 0x12, 0x12, 0x12, 0x17, 0x14, 0x17, 0x12, 0x17, 0x12, 0x15, 0x17,
  0x17, 0x17, 0x16, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x10, 0x13, 0x14,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x10, 0x13,
  0x13, 0x13, 0x14, 0x11, 0x11, 0x11, 0x16, 0x10, 0x17, 0x11, 0x17, 0x17,
  0x12, 0x17, 0x14, 0x17, 0x12, 0x17, 0x14, 0x12, 0x12, 0x14, 0x12, 0x12,
  0x12, 0x12, 0x14, 0x12, 0x12, 0x17, 0x12, 0x17, 0x12, 0x14, 0x12, 0x17,
  0x12, 0x17, 0x17, 0x15, 0x17, 0x15, 0x15, 0x11, 0x11, 0x14, 0x14, 0x14,
  0x10, 0x13, 0x10, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x14, 0x13, 0x13, 0x13, 0x14, 0x11, 0x11, 0x16, 0x16, 0x11,
  0x17, 0x17, 0x11, 0x17, 0x17, 0x12, 0x14, 0x12, 0x17, 0x12, 0x14, 0x17,
  0x12, 0x14, 0x12, 0x12, 0x12, 0x12, 0x14, 0x12, 0x17, 0x12, 0x17, 0x12,
  0x17, 0x14, 0x17, 0x12, 0x17, 0x17, 0x17, 0x14, 0x17, 0x10, 0x10, 0x15,
  0x15, 0x15, 0x15, 0x14, 0x13, 0x10, 0x14, 0x11, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x10, 0x13, 0x13, 0x14, 0x11,
  0x16, 0x16, 0x10, 0x11, 0x10, 0x17, 0x14, 0x17, 0x17, 0x17, 0x14, 0x17,
  0x12, 0x14, 0x12, 0x17, 0x12, 0x17, 0x14, 0x12, 0x12, 0x14, 0x12, 0x17,
  0x12, 0x17, 0x12, 0x17, 0x12, 0x14, 0x12, 0x17, 0x17, 0x17, 0x17, 0x14,
  0x17, 0x10, 0x10, 0x10, 0x11, 0x11, 0x14, 0x14, 0x10, 0x13, 0x14, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x14,
  0x10, 0x13, 0x14, 0x11, 0x16, 0x10, 0x10, 0x14, 0x10, 0x10, 0x14, 0x17,
  0x17, 0x17, 0x14, 0x12, 0x17, 0x14, 0x17, 0x12, 0x17, 0x12, 0x14, 0x12,
  0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x14, 0x12, 0x17, 0x12,
  0x17, 0x17, 0x17, 0x14, 0x17, 0x10, 0x10, 0x10, 0x11, 0x14, 0x14, 0x14,
  0x13, 0x14, 0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x14, 0x10, 0x14, 0x14, 0x11, 0x10, 0x10, 0x14,
  0x10, 0x10, 0x14, 0x17, 0x17, 0x17, 0x14, 0x17, 0x17, 0x17, 0x12, 0x17,
  0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17,
  0x12, 0x17, 0x17, 0x17, 0x17, 0x17, 0x14, 0x17, 0x17, 0x10, 0x11, 0x11,
  0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x13, 0x14,
  0x11, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x14, 0x10, 0x17, 0x17, 0x14,
  0x17, 0x17, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12,
  0x17, 0x12, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x10, 0x11, 0x10, 0x10, 0x11, 0x11, 0x14, 0x14, 0x14, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x11, 0x14, 0x11, 0x11, 0x14, 0x14, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x10, 0x11, 0x10, 0x10, 0x14, 0x11, 0x14, 0x14, 0x14,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x14, 0x14, 0x11, 0x11, 0x11,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x11, 0x14, 0x11,
  0x11, 0x14, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x10, 0x14, 0x11, 0x11, 0x11, 0x11, 0x10, 0x10, 0x11, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x10,
  0x10, 0x14, 0x11, 0x11, 0x14, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11,
  0x11, 0x14, 0x14, 0x14, 0x11, 0x11, 0x10, 0x10, 0x10, 0x11, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x11, 0x10, 0x10, 0x10, 0x10, 0x11, 0x10, 0x10,
  0x10, 0x10, 0x14, 0x13, 0x13, 0x11, 0x11, 0x11, 0x11, 0x14, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x11, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x10, 0x10, 0x11, 0x13, 0x13, 0x13, 0x13, 0x11, 0x13, 0x13, 0x13,
  0x13, 0x11, 0x10, 0x10, 0x10, 0x11, 0x10, 0x10, 0x10, 0x11, 0x10, 0x10,
  0x10, 0x11, 0x10, 0x10, 0x10, 0x13, 0x14, 0x11, 0x11, 0x11, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x11, 0x13, 0x13, 0x13, 0x13, 0x11, 0x13, 0x13,
  0x13, 0x11, 0x13, 0x13, 0x13, 0x11, 0x13, 0x13, 0x13, 0x00, 0x14, 0x14,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask1RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFE, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x30, 0xFF, 0xFF, 0xFF, 0xFF, 0xC4, 0x00,
  0x00, 0x20, 0x20, 0x8F, 0xFF, 0xFB, 0x04, 0x00, 0x00, 0x40, 0x40, 0x88,
  0x44, 0x40, 0x84, 0x00, 0x00, 0x40, 0x40, 0x88, 0x44, 0x40, 0x88, 0x00,
  0x00, 0x80, 0x00, 0x88, 0x44, 0x20, 0x88, 0x00, 0x01, 0x00, 0x40, 0x88,
  0x44, 0x20, 0x84, 0x00, 0x01, 0x00, 0x40, 0x88, 0x44, 0x20, 0x80, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x04, 0x20, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite1RB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x12, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13,
  0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x10, 0x10, 0x10, 0x10, 0x13, 0x13, 0x13,
  0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x13, 0x11, 0x11, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x10, 0x10, 0x10, 0x13, 0x13,
  0x13, 0x13, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13,
  0x13, 0x14, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x10, 0x10, 0x10,
  0x13, 0x13, 0x13, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x11, 0x11, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x11, 0x10,
  0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x11, 0x14, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14,
  0x14, 0x14, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x11, 0x11, 0x10, 0x10, 0x10, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x14,
  0x14, 0x14, 0x11, 0x14, 0x11, 0x14, 0x14, 0x11, 0x14, 0x11, 0x14, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x11, 0x11, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x11, 0x14, 0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x14,
  0x13, 0x14, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x14, 0x11, 0x14,
  0x11, 0x14, 0x11, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x13, 0x14,
  0x14, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x12, 0x11, 0x14, 0x14, 0x10, 0x13, 0x13, 0x13,
  0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x11, 0x14, 0x14, 0x14, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x10, 0x10, 0x13,
  0x13, 0x13, 0x14, 0x13, 0x14, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x14, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14,
  0x14, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x11, 0x14,
  0x10, 0x10, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x14, 0x11, 0x14, 0x11,
  0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13,
  0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x11, 0x11, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x12, 0x14, 0x14, 0x10, 0x10, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x14,
  0x14, 0x14, 0x11, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x11, 0x14, 0x11,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x13, 0x14, 0x14,
  0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x14, 0x10, 0x10, 0x10, 0x13, 0x13, 0x13, 0x14,
  0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x11,
  0x14, 0x11, 0x14, 0x11, 0x14, 0x11, 0x11, 0x14, 0x11, 0x14, 0x11, 0x14,
  0x11, 0x14, 0x11, 0x14, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x13, 0x10, 0x14, 0x14, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x14, 0x10, 0x10, 0x10, 0x10, 0x13,
  0x13, 0x13, 0x13, 0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x14, 0x11, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x10, 0x10,
  0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x13,
  0x13, 0x14, 0x13, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x14, 0x10, 0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13,
  0x14, 0x13, 0x14, 0x13, 0x13, 0x13, 0x10, 0x14, 0x11, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x14, 0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
  0x13, 0x13, 0x13, 0x13, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x14, 0x13, 0x10, 0x13,
  0x14, 0x11, 0x11, 0x00, 0x00, 0x11, 0x11, 0x14, 0x10, 0x10, 0x13, 0x13,
  0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14,
  0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x15,
  0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11,
  0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x14, 0x13,
  0x13, 0x14, 0x13, 0x10, 0x14, 0x11, 0x11, 0x10, 0x00, 0x11, 0x10, 0x10,
  0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11, 0x15, 0x15, 0x15, 0x15,
  0x15, 0x15, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
  0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x13, 0x14, 0x13, 0x14, 0x14, 0x13, 0x13, 0x13, 0x10, 0x14, 0x11, 0x11,
  0x00, 0x11, 0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
  0x13, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x15,
  0x15, 0x15, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x11, 0x15, 0x16, 0x16, 0x16, 0x16, 0x15, 0x15, 0x11, 0x11, 0x11,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x13, 0x14, 0x13, 0x10,
  0x13, 0x14, 0x11, 0x11, 0x12, 0x11, 0x10, 0x10, 0x13, 0x13, 0x13, 0x13,
  0x13, 0x13, 0x13, 0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x15, 0x15, 0x16, 0x16, 0x16, 0x16, 0x12, 0x12, 0x12, 0x12, 0x15,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x15, 0x12, 0x12, 0x12, 0x11, 0x15, 0x15,
  0x15, 0x15, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x13, 0x14,
  0x14, 0x13, 0x13, 0x13, 0x10, 0x14, 0x11, 0x11, 0x12, 0x10, 0x10, 0x10,
  0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x16, 0x16, 0x16, 0x16, 0x12, 0x15, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x15, 0x12, 0x12,
  0x12, 0x15, 0x12, 0x16, 0x16, 0x16, 0x15, 0x11, 0x11, 0x11, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x13, 0x13, 0x14, 0x13, 0x13, 0x13, 0x14, 0x11, 0x11,
  0x12, 0x14, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14, 0x14, 0x14,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x16, 0x16, 0x16, 0x15, 0x12, 0x17,
  0x12, 0x11, 0x12, 0x12, 0x12, 0x12, 0x15, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x11, 0x12, 0x12, 0x12, 0x11, 0x17, 0x12, 0x17, 0x16, 0x16, 0x16,
  0x16, 0x11, 0x11, 0x14, 0x14, 0x14, 0x13, 0x14, 0x14, 0x13, 0x13, 0x13,
  0x10, 0x14, 0x11, 0x11, 0x12, 0x14, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13,
  0x14, 0x14, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x16, 0x16, 0x16, 0x17,
  0x17, 0x15, 0x17, 0x12, 0x12, 0x12, 0x11, 0x12, 0x12, 0x14, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x14, 0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x17,
  0x12, 0x17, 0x15, 0x15, 0x16, 0x16, 0x16, 0x14, 0x14, 0x14, 0x14, 0x13,
  0x13, 0x14, 0x13, 0x10, 0x13, 0x14, 0x11, 0x11, 0x12, 0x14, 0x13, 0x13,
  0x13, 0x13, 0x13, 0x13, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11, 0x16, 0x16,
  0x17, 0x17, 0x17, 0x12, 0x12, 0x11, 0x12, 0x17, 0x12, 0x12, 0x14, 0x12,
  0x12, 0x14, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x14, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x14, 0x12, 0x17, 0x12, 0x17, 0x17, 0x15, 0x17, 0x17, 0x16,
  0x16, 0x11, 0x14, 0x14, 0x14, 0x13, 0x14, 0x13, 0x10, 0x10, 0x14, 0x11,
  0x12, 0x14, 0x13, 0x13, 0x13, 0x13, 0x13, 0x14, 0x14, 0x11, 0x11, 0x11,
  0x11, 0x16, 0x16, 0x17, 0x11, 0x17, 0x17, 0x17, 0x17, 0x12, 0x14, 0x12,
  0x17, 0x12, 0x14, 0x12, 0x12, 0x14, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x14, 0x12, 0x12, 0x12, 0x12, 0x17, 0x14, 0x17, 0x12, 0x17, 0x12, 0x12,
  0x15, 0x17, 0x17, 0x17, 0x16, 0x11, 0x14, 0x14, 0x14, 0x14, 0x13, 0x10,
  0x13, 0x13, 0x14, 0x11, 0x00, 0x11, 0x10, 0x13, 0x13, 0x13, 0x13, 0x14,
  0x14, 0x11, 0x11, 0x11, 0x11, 0x16, 0x10, 0x17, 0x11, 0x17, 0x17, 0x12,
  0x12, 0x17, 0x14, 0x17, 0x12, 0x17, 0x14, 0x12, 0x12, 0x14, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x14, 0x12, 0x12, 0x17, 0x12, 0x17, 0x12, 0x14, 0x12,
  0x17, 0x12, 0x17, 0x17, 0x17, 0x15, 0x17, 0x15, 0x15, 0x11, 0x11, 0x14,
  0x14, 0x14, 0x10, 0x13, 0x10, 0x10, 0x14, 0x11, 0x00, 0x11, 0x14, 0x13,
  0x13, 0x13, 0x13, 0x14, 0x14, 0x11, 0x11, 0x11, 0x16, 0x16, 0x11, 0x17,
  0x17, 0x11, 0x17, 0x17, 0x17, 0x12, 0x14, 0x12, 0x17, 0x12, 0x14, 0x17,
  0x12, 0x14, 0x12, 0x12, 0x12, 0x12, 0x12, 0x14, 0x12, 0x17, 0x12, 0x17,
  0x12, 0x17, 0x14, 0x17, 0x12, 0x17, 0x17, 0x17, 0x17, 0x14, 0x17, 0x10,
  0x10, 0x15, 0x15, 0x15, 0x15, 0x14, 0x13, 0x10, 0x14, 0x14, 0x11, 0x11,
  0x00, 0x00, 0x11, 0x10, 0x13, 0x13, 0x13, 0x14, 0x14, 0x11, 0x11, 0x16,
  0x16, 0x10, 0x11, 0x10, 0x17, 0x14, 0x17, 0x17, 0x17, 0x17, 0x14, 0x17,
  0x12, 0x14, 0x12, 0x17, 0x12, 0x17, 0x14, 0x12, 0x12, 0x14, 0x14, 0x12,
  0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x14, 0x12, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x14, 0x17, 0x10, 0x10, 0x10, 0x11, 0x11, 0x14, 0x14, 0x10, 0x13,
  0x14, 0x14, 0x11, 0x11, 0x00, 0x00, 0x11, 0x14, 0x10, 0x13, 0x13, 0x14,
  0x14, 0x14, 0x11, 0x16, 0x10, 0x10, 0x14, 0x10, 0x10, 0x14, 0x17, 0x17,
  0x17, 0x17, 0x14, 0x12, 0x17, 0x14, 0x17, 0x12, 0x17, 0x12, 0x14, 0x12,
  0x17, 0x12, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x14, 0x12, 0x17,
  0x12, 0x17, 0x17, 0x17, 0x17, 0x14, 0x17, 0x10, 0x10, 0x10, 0x11, 0x14,
  0x14, 0x14, 0x13, 0x14, 0x14, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11,
  0x14, 0x10, 0x10, 0x13, 0x14, 0x14, 0x14, 0x11, 0x10, 0x10, 0x14, 0x10,
  0x10, 0x14, 0x17, 0x17, 0x17, 0x17, 0x14, 0x17, 0x17, 0x17, 0x12, 0x17,
  0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12,
  0x17, 0x12, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x14, 0x17, 0x17, 0x10,
  0x11, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x14, 0x14, 0x10, 0x13, 0x14, 0x14, 0x11,
  0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x17, 0x17, 0x14,
  0x17, 0x17, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x17, 0x12, 0x12, 0x17,
  0x12, 0x17, 0x12, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x10, 0x11, 0x10, 0x10, 0x11, 0x11, 0x14, 0x14, 0x14, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11,
  0x14, 0x14, 0x11, 0x11, 0x14, 0x14, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x11, 0x10, 0x10, 0x14, 0x14, 0x11,
  0x14, 0x14, 0x14, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x14, 0x11, 0x11, 0x11, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x14,
  0x14, 0x11, 0x11, 0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11,
  0x14, 0x14, 0x14, 0x14, 0x11, 0x11, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14,
  0x11, 0x11, 0x10, 0x10, 0x10, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x11, 0x10, 0x10, 0x10, 0x10, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x14, 0x13, 0x13, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x11, 0x13,
  0x13, 0x13, 0x13, 0x13, 0x11, 0x13, 0x13, 0x13, 0x13, 0x11, 0x10, 0x10,
  0x10, 0x11, 0x11, 0x10, 0x10, 0x10, 0x11, 0x10, 0x10, 0x10, 0x11, 0x10,
  0x10, 0x10, 0x10, 0x13, 0x14, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x10,
  0x11, 0x13, 0x13, 0x13, 0x13, 0x11, 0x11, 0x13, 0x13, 0x13, 0x11, 0x13,
  0x13, 0x13, 0x11, 0x13, 0x13, 0x13, 0x13, 0x00, 0x14, 0x14, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask1RB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x11, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF1, 0x00, 0x00, 0x20, 0x40, 0x9F, 0xFF, 0xFE, 0xE1, 0x00,
  0x00, 0x20, 0x80, 0x88, 0x42, 0x20, 0x21, 0x00, 0x00, 0x20, 0x80, 0x88,
  0x42, 0x10, 0x21, 0x00, 0x00, 0x20, 0x01, 0x08, 0x42, 0x10, 0x41, 0x80,
  0x00, 0x40, 0x41, 0x08, 0x42, 0x20, 0x40, 0x80, 0x00, 0x00, 0x01, 0x08,
  0x42, 0x20, 0x40, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x20, 0x40, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite2LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00,
  0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00,
  0x00, 0x18, 0x18, 0x19, 0x18, 0x1A, 0x19, 0x00, 0x18, 0x19, 0x00, 0x18,
  0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x18, 0x18, 0x19, 0x18, 0x18, 0x1B, 0x19, 0x18, 0x1B, 0x19, 0x18,
  0x1A, 0x19, 0x18, 0x1A, 0x19, 0x18, 0x19, 0x18, 0x00, 0x00, 0x18, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1A, 0x19, 0x18, 0x1A, 0x1B, 0x18,
  0x18, 0x1B, 0x18, 0x18, 0x1A, 0x1B, 0x18, 0x1A, 0x1B, 0x18, 0x1B, 0x18,
  0x19, 0x18, 0x19, 0x19, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1A, 0x00, 0x18, 0x1A, 0x1B,
  0x18, 0x1A, 0x18, 0x18, 0x1A, 0x1B, 0x18, 0x18, 0x1A, 0x1B, 0x18, 0x1B,
  0x18, 0x1A, 0x1B, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x19, 0x18, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1A,
  0x19, 0x18, 0x1A, 0x1B, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x1A, 0x18,
  0x1A, 0x1B, 0x18, 0x1B, 0x18, 0x1A, 0x18, 0x1A, 0x1B, 0x18, 0x1A, 0x18,
  0x1B, 0x18, 0x19, 0x18, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x18, 0x18, 0x1A, 0x19, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x18,
  0x1A, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A,
  0x1A, 0x18, 0x1A, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x19, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1A, 0x1B, 0x18, 0x1A, 0x18,
  0x18, 0x1A, 0x1C, 0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x1A,
  0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18,
  0x1B, 0x18, 0x1B, 0x18, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1A,
  0x1B, 0x18, 0x1A, 0x1C, 0x18, 0x1A, 0x1C, 0x18, 0x1A, 0x1C, 0x18, 0x1A,
  0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A,
  0x1A, 0x18, 0x18, 0x1A, 0x1B, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x19, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1C, 0x18, 0x18, 0x1B, 0x18, 0x1A, 0x1C, 0x18, 0x1A, 0x1C, 0x18,
  0x1A, 0x1C, 0x18, 0x1A, 0x1C, 0x1A, 0x1C, 0x1A, 0x1C, 0x1A, 0x18, 0x1A,
  0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x18, 0x1B, 0x18,
  0x1B, 0x18, 0x1B, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1C,
  0x18, 0x1A, 0x1C, 0x18, 0x1A, 0x1C, 0x18, 0x1A, 0x1C, 0x1A, 0x1C, 0x1A,
  0x1C, 0x1A, 0x1C, 0x1A, 0x1C, 0x1A, 0x18, 0x1A, 0x1A, 0x1C, 0x18, 0x1A,
  0x18, 0x18, 0x1A, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x19, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
  0x1A, 0x18, 0x1A, 0x1C, 0x18, 0x1A, 0x1C, 0x18, 0x1A, 0x1C, 0x18, 0x18,
  0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x18,
  0x1A, 0x1C, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x1A, 0x18,
  0x1B, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1C, 0x18, 0x1A, 0x1A, 0x18, 0x1C, 0x18, 0x1A, 0x1C, 0x1C,
  0x18, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x1A, 0x1C, 0x1A, 0x18, 0x1A,
  0x18, 0x1A, 0x1A, 0x1B, 0x18, 0x1A, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x18, 0x1A, 0x18, 0x1C,
  0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x18, 0x1C, 0x1C,
  0x1C, 0x1A, 0x1C, 0x1A, 0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x19,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x18, 0x1A, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x18, 0x18, 0x1C, 0x18, 0x1C, 0x1A, 0x1C, 0x1A, 0x1A, 0x18,
  0x1A, 0x18, 0x1B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x1C, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x1C, 0x18,
  0x1C, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1B, 0x18, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1B, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B,
  0x1B, 0x1B, 0x18, 0x18, 0x1C, 0x18, 0x1C, 0x1C, 0x1A, 0x1A, 0x18, 0x1B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1B,
  0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x1C, 0x1C, 0x1A,
  0x1C, 0x18, 0x1B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x18, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B,
  0x1B, 0x18, 0x1C, 0x1C, 0x1A, 0x1A, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x1B, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x18, 0x1C, 0x18, 0x1C, 0x1B, 0x1B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1B, 0x19, 0x1B,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x18, 0x1C,
  0x1C, 0x1A, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14,
  0x11, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19,
  0x1B, 0x1B, 0x1B, 0x18, 0x1C, 0x1C, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x10, 0x14, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x1C, 0x1A, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x11, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x11, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x10, 0x10, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
  0x10, 0x14, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x00, 0x00, 0x10, 0x14, 0x11, 0x11,
  0x10, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x10, 0x10, 0x14, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x18, 0x1D, 0x1D, 0x1D, 0x10, 0x11, 0x11, 0x11, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x1D, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1D, 0x1D, 0x1D, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x11,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1A, 0x1D, 0x1D, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1D, 0x1D, 0x11, 0x11,
  0x11, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x10, 0x1D, 0x1D, 0x01, 0x10, 0x10, 0x10, 0x11, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A,
  0x11, 0x11, 0x10, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x1D, 0x7B, 0x7B, 0x7B, 0x01, 0x10, 0x10, 0x11,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1A, 0x1A, 0x0A, 0x10, 0x11, 0x11, 0x10, 0x10, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7B, 0x01, 0x7B, 0x7B,
  0x1D, 0x10, 0x10, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x0A, 0x00, 0x00, 0x10, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
  0x1D, 0x7B, 0x7B, 0x7B, 0x1D, 0x10, 0x14, 0x11, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x11, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x10, 0x10, 0x1D, 0x1D, 0x1D, 0x10, 0x14, 0x14, 0x11,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1A, 0x18, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x14, 0x14, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x01, 0x01, 0x01, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1A, 0x18, 0x1C, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x14, 0x14, 0x11, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x01, 0x19, 0x01, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x18, 0x1C, 0x1B, 0x0A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x01, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x1B, 0x1C, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x18,
  0x1C, 0x1C, 0x18, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x11, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x1C, 0x18, 0x18, 0x1A,
  0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1A, 0x18, 0x1C, 0x1A, 0x1A, 0x19, 0x1C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x1C, 0x18,
  0x18, 0x18, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x18, 0x1C, 0x1C, 0x1C, 0x18, 0x18,
  0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x19, 0x19, 0x1B, 0x1B, 0x1B,
  0x1C, 0x18, 0x18, 0x18, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x18, 0x1C,
  0x18, 0x1A, 0x1A, 0x1B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D,
  0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1C, 0x18, 0x18, 0x18, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A,
  0x1A, 0x18, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x1B, 0x19, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x14, 0x1D, 0x1D, 0x1D,
  0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x19, 0x19,
  0x1B, 0x1B, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1B, 0x1B,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1C, 0x18, 0x1A, 0x1A, 0x1A, 0x1A,
  0x18, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x14, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B,
  0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1C, 0x1C, 0x1C,
  0x1C, 0x18, 0x18, 0x18, 0x1B, 0x1B, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x14,
  0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x18, 0x18,
  0x1C, 0x1C, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x18, 0x1A, 0x1A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x14, 0x1D, 0x1D, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x18, 0x18, 0x1C, 0x1C, 0x18, 0x18, 0x1A, 0x18, 0x18, 0x18, 0x1B,
  0x1B, 0x1B, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x18,
  0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x1C, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1C, 0x1C, 0x18, 0x18,
  0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x18, 0x1A, 0x1A, 0x1B, 0x1B, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1A, 0x18, 0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x1C, 0x1A, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
  0x1C, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1A,
  0x1A, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
  0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
  0x1C, 0x1C, 0x1A, 0x1A, 0x1C, 0x1C, 0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x18,
  0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A,
  0x1A, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1A, 0x1A,
  0x18, 0x1A, 0x1C, 0x1A, 0x1A, 0x1A, 0x1C, 0x1C, 0x1A, 0x1A, 0x1A, 0x18,
  0x18, 0x1A, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x19, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1A, 0x1C, 0x1C, 0x1A, 0x1A, 0x1A,
  0x1C, 0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x1A, 0x1B, 0x1B, 0x1B, 0x19, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A,
  0x1A, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1A,
  0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1A, 0x1A, 0x1A, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1B, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B,
  0x1A, 0x1A, 0x1B, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1B, 0x1B, 0x1B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1A, 0x1A, 0x1B, 0x1B, 0x19, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1C, 0x1B, 0x1B, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask2LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0xED,
  0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x03, 0x7F, 0xFF,
  0xFF, 0xC0, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x02, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x1F, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFE, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7E, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x1F, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x03, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x01, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x3F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0xF8,
  0x07, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x01, 0xFF, 0xF8, 0x00,
  0x00, 0x00, 0x00, 0x1E, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F,
  0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite2LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1B,
  0x18, 0x18, 0x19, 0x18, 0x1A, 0x19, 0x1B, 0x18, 0x19, 0x00, 0x18, 0x00,
  0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x18, 0x19, 0x18, 0x18, 0x1B, 0x19, 0x18, 0x1B, 0x19, 0x18, 0x1A,
  0x19, 0x18, 0x1A, 0x19, 0x19, 0x18, 0x19, 0x18, 0x1B, 0x1B, 0x18, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x1A, 0x19, 0x18, 0x1A, 0x1B, 0x18, 0x18,
  0x1B, 0x18, 0x18, 0x1A, 0x1B, 0x18, 0x1A, 0x1B, 0x1B, 0x18, 0x1B, 0x18,
  0x19, 0x18, 0x19, 0x19, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x18, 0x1A, 0x1B, 0x18,
  0x1A, 0x18, 0x18, 0x1A, 0x1B, 0x18, 0x18, 0x1A, 0x1B, 0x18, 0x1B, 0x18,
  0x18, 0x1A, 0x1B, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x19, 0x18, 0x19, 0x18,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1A, 0x19,
  0x18, 0x1A, 0x1B, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A,
  0x1B, 0x18, 0x1B, 0x18, 0x18, 0x1A, 0x18, 0x1A, 0x1B, 0x18, 0x1A, 0x18,
  0x1B, 0x18, 0x19, 0x18, 0x19, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x18, 0x1A, 0x19, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x18, 0x1A,
  0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x1A,
  0x1A, 0x18, 0x1A, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x19, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1A, 0x1B, 0x18, 0x1A, 0x18, 0x18,
  0x1A, 0x1C, 0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18,
  0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18,
  0x1B, 0x18, 0x1B, 0x18, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1A, 0x1B,
  0x18, 0x1A, 0x1C, 0x18, 0x1A, 0x1C, 0x18, 0x1A, 0x1C, 0x18, 0x1A, 0x18,
  0x1A, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A,
  0x1A, 0x18, 0x18, 0x1A, 0x1B, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x19, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1C, 0x18, 0x18, 0x1B, 0x18, 0x1A, 0x1C, 0x18, 0x1A, 0x1C, 0x18, 0x1A,
  0x1C, 0x18, 0x1A, 0x1C, 0x1A, 0x1C, 0x1A, 0x1C, 0x1C, 0x1A, 0x18, 0x1A,
  0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x18, 0x1B, 0x18,
  0x1B, 0x18, 0x1B, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1C, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1C, 0x18,
  0x1A, 0x1C, 0x18, 0x1A, 0x18, 0x1C, 0x18, 0x1A, 0x1C, 0x1A, 0x1C, 0x1A,
  0x1C, 0x1A, 0x1C, 0x1A, 0x1C, 0x1A, 0x18, 0x1A, 0x1A, 0x1C, 0x18, 0x1A,
  0x18, 0x18, 0x1A, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x19, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1A,
  0x18, 0x1A, 0x1C, 0x18, 0x18, 0x1A, 0x1C, 0x18, 0x1A, 0x1C, 0x18, 0x18,
  0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x18,
  0x1A, 0x1C, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x1A, 0x18,
  0x1B, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1C, 0x18, 0x18, 0x1A, 0x1A, 0x18, 0x1C, 0x18, 0x1A, 0x1C, 0x1C,
  0x18, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x1A, 0x1C, 0x1A, 0x18, 0x1A,
  0x18, 0x1A, 0x1A, 0x1B, 0x18, 0x1A, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x18, 0x1A, 0x18, 0x1C,
  0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x18, 0x1C, 0x1C,
  0x1C, 0x1A, 0x1C, 0x1A, 0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x19,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C,
  0x18, 0x1A, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x18, 0x18, 0x1C, 0x18, 0x1C, 0x1A, 0x1C, 0x1A, 0x1A, 0x18,
  0x1A, 0x18, 0x1B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x1C, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x1C, 0x18,
  0x1C, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1B, 0x18, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1B, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B,
  0x1B, 0x1B, 0x18, 0x18, 0x1C, 0x18, 0x1C, 0x1C, 0x1A, 0x1A, 0x18, 0x1B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1B,
  0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x1C, 0x1C, 0x1A,
  0x1C, 0x18, 0x1B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x18, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B,
  0x1B, 0x18, 0x1C, 0x1C, 0x1A, 0x1A, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x1B, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x18, 0x1C, 0x18, 0x1C, 0x1B, 0x1B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x1B, 0x19, 0x1B,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x18, 0x1C,
  0x1C, 0x1A, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14,
  0x11, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19,
  0x1B, 0x1B, 0x1B, 0x18, 0x1C, 0x1C, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x11, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x10, 0x14, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x1C, 0x1A, 0x00,
  0x00, 0x00, 0x10, 0x11, 0x11, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x11, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x10, 0x11, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
  0x10, 0x14, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x00, 0x00, 0x10, 0x14, 0x11, 0x10,
  0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x10, 0x10, 0x14, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x11, 0x11,
  0x11, 0x11, 0x10, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x18, 0x1D, 0x1D, 0x1D, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x1D, 0x10, 0x10, 0x10,
  0x10, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1D, 0x1D, 0x1D, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x11,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1A, 0x1D, 0x1D, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x01, 0x01, 0x01, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1D, 0x1D, 0x11, 0x11,
  0x11, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x10, 0x1D, 0x1D, 0x01, 0x10, 0x10, 0x10, 0x11, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x01,
  0x19, 0x19, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A,
  0x11, 0x11, 0x10, 0x10, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x1D, 0x7B, 0x7B, 0x7B, 0x01, 0x10, 0x10, 0x11,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x01, 0x01, 0x19, 0x19, 0x1B, 0x1B, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1A, 0x1A, 0x0A, 0x10, 0x11, 0x11, 0x10, 0x10, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7B, 0x01, 0x7B, 0x7B,
  0x1D, 0x10, 0x10, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x01, 0x01, 0x19, 0x19, 0x19, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x0A, 0x00, 0x00, 0x10, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
  0x1D, 0x7B, 0x7B, 0x7B, 0x1D, 0x10, 0x14, 0x11, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x01, 0x01, 0x19, 0x19, 0x19, 0x19,
  0x18, 0x18, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x11, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x10, 0x10, 0x1D, 0x1D, 0x1D, 0x10, 0x14, 0x14, 0x11,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x01, 0x19, 0x19,
  0x19, 0x19, 0x1B, 0x1C, 0x18, 0x18, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1A, 0x18, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x14, 0x14, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x01, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1C, 0x18, 0x18, 0x1A, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1A, 0x18, 0x1C, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x14, 0x14, 0x11, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1C, 0x18, 0x18,
  0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x18, 0x1C, 0x1B, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x14, 0x14, 0x14, 0x14, 0x14, 0x11, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x01, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x1B, 0x1C, 0x18, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x18,
  0x1C, 0x1C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x10, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x11, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x1B, 0x18, 0x18, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1A, 0x18, 0x1C, 0x1A, 0x1A, 0x19, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x18, 0x18, 0x1A, 0x1A, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x18, 0x1C, 0x1C, 0x1C, 0x18, 0x18,
  0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x1D, 0x1D, 0x1D,
  0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x18, 0x1A,
  0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x18, 0x1C,
  0x18, 0x1A, 0x1A, 0x1B, 0x1B, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x10, 0x14, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D,
  0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1A,
  0x18, 0x18, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A,
  0x1A, 0x18, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x1A, 0x18, 0x1A, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x14,
  0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x19, 0x19,
  0x19, 0x19, 0x1C, 0x1C, 0x1C, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1C, 0x18, 0x1A, 0x1A, 0x18, 0x18,
  0x1B, 0x1B, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B,
  0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1C, 0x1C, 0x1C,
  0x1C, 0x1A, 0x1A, 0x1B, 0x18, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x14,
  0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x18, 0x18,
  0x1C, 0x1C, 0x1A, 0x1A, 0x18, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x19, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x14, 0x1D, 0x1D, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x18, 0x18, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x18,
  0x18, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x1C, 0x1A, 0x1A, 0x18,
  0x18, 0x18, 0x1A, 0x1A, 0x1B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x1C, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1C, 0x1A, 0x18, 0x18,
  0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x19, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x18, 0x18, 0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x1C, 0x1A, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
  0x1C, 0x1C, 0x1C, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B,
  0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
  0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
  0x1C, 0x1C, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x1B,
  0x1A, 0x1A, 0x1A, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
  0x1A, 0x1A, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1A, 0x1A,
  0x18, 0x1A, 0x1C, 0x1A, 0x1A, 0x1A, 0x1C, 0x1C, 0x1C, 0x18, 0x1A, 0x1A,
  0x1A, 0x18, 0x1A, 0x1B, 0x1B, 0x1B, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1A, 0x1A, 0x1A, 0x1A, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1A, 0x1C, 0x1C, 0x1A, 0x1A, 0x1A,
  0x1B, 0x1B, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A,
  0x1A, 0x1A, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A,
  0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1B, 0x19,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1C, 0x1B, 0x1B, 0x1B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1B, 0x1C, 0x1A, 0x1A, 0x1A, 0x1B,
  0x1B, 0x19, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1B,
  0x1B, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x10, 0x1C, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask2LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFA,
  0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x02, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x03, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x02,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x07, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x3E, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3E,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFE, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7E, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x1E, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0E,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x07, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x03, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x01,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x7C,
  0x07, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x01, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x7F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x03,
  0xC0, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite2RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
  0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00,
  0x18, 0x00, 0x19, 0x18, 0x00, 0x19, 0x1A, 0x18, 0x19, 0x18, 0x18, 0x00,
  0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
  0x18, 0x19, 0x18, 0x19, 0x1A, 0x18, 0x19, 0x1A, 0x18, 0x19, 0x1B, 0x18,
  0x19, 0x1B, 0x18, 0x18, 0x19, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
  0x19, 0x19, 0x18, 0x19, 0x18, 0x1B, 0x18, 0x1B, 0x1A, 0x18, 0x1B, 0x1A,
  0x18, 0x18, 0x1B, 0x18, 0x18, 0x1B, 0x1A, 0x18, 0x19, 0x1A, 0x18, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x18, 0x19, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x1B, 0x1A, 0x18,
  0x1B, 0x18, 0x1B, 0x1A, 0x18, 0x18, 0x1B, 0x1A, 0x18, 0x18, 0x1A, 0x18,
  0x1B, 0x1A, 0x18, 0x00, 0x1A, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x19, 0x18, 0x19, 0x18, 0x1B, 0x18, 0x1A, 0x18, 0x1B,
  0x1A, 0x18, 0x1A, 0x18, 0x1B, 0x18, 0x1B, 0x1A, 0x18, 0x1A, 0x18, 0x1A,
  0x18, 0x18, 0x1A, 0x18, 0x1B, 0x1A, 0x18, 0x19, 0x1A, 0x18, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x1B,
  0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18,
  0x18, 0x1A, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x19,
  0x1A, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x18, 0x1B, 0x18, 0x1B,
  0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18,
  0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x1C, 0x1A, 0x18,
  0x18, 0x1A, 0x18, 0x1B, 0x1A, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x18, 0x1B,
  0x18, 0x1B, 0x18, 0x1B, 0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x18, 0x1A, 0x18,
  0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1C, 0x1A,
  0x18, 0x1C, 0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1B, 0x1A, 0x18, 0x18, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x18, 0x1B, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x1A, 0x1A, 0x18, 0x18, 0x1A,
  0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1C, 0x1A, 0x1C, 0x1A, 0x1C,
  0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1B,
  0x18, 0x18, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x19, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x1A, 0x18, 0x18,
  0x1A, 0x18, 0x1C, 0x1A, 0x1A, 0x18, 0x1A, 0x1C, 0x1A, 0x1C, 0x1A, 0x1C,
  0x1A, 0x1C, 0x1A, 0x1C, 0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1C, 0x1A, 0x18,
  0x1C, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1B, 0x18, 0x1A, 0x18, 0x1A,
  0x18, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1C, 0x1C, 0x1C,
  0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x1C, 0x1A,
  0x18, 0x1C, 0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1A, 0x18, 0x18, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1A, 0x18,
  0x1B, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1C, 0x1A, 0x18, 0x1C, 0x1C,
  0x1C, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1C,
  0x1C, 0x1C, 0x1C, 0x18, 0x1C, 0x1C, 0x1A, 0x18, 0x1C, 0x18, 0x1A, 0x1A,
  0x18, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x19, 0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x1A, 0x1C, 0x1A, 0x1C,
  0x1C, 0x1C, 0x18, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
  0x1C, 0x18, 0x1A, 0x18, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1B, 0x1B, 0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x1C,
  0x1A, 0x1C, 0x18, 0x1C, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B,
  0x18, 0x18, 0x18, 0x18, 0x1C, 0x1C, 0x1A, 0x18, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1B, 0x1A, 0x18,
  0x1A, 0x18, 0x1A, 0x1C, 0x18, 0x1C, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x1C, 0x18,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1B, 0x18, 0x1A, 0x1A, 0x1C, 0x1C, 0x18, 0x1C, 0x18, 0x18, 0x1B, 0x1B,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x1B, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1B, 0x1B, 0x18, 0x1C, 0x1A, 0x1C, 0x1C, 0x18,
  0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1A, 0x1A,
  0x1C, 0x1C, 0x18, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x1B, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1B, 0x1B, 0x1C, 0x18, 0x1C, 0x18, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x18, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1A, 0x1C, 0x1C, 0x18, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x19, 0x1B, 0x11,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1C, 0x1C,
  0x18, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x19,
  0x1B, 0x1B, 0x1B, 0x11, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x11, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x1A, 0x1C, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x14, 0x10, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x11,
  0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x10,
  0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x11, 0x10, 0x11, 0x11, 0x14, 0x10, 0x00, 0x00, 0x18, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x11, 0x14, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x18, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x14, 0x10, 0x10, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11,
  0x11, 0x10, 0x1D, 0x1D, 0x1D, 0x18, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1D, 0x18, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1D, 0x1D, 0x1D,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x1D, 0x1D, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x14, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x11, 0x11, 0x11, 0x1D, 0x1D, 0x1A, 0x1A, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x10, 0x10, 0x11, 0x11,
  0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x10, 0x10, 0x10, 0x01, 0x1D, 0x1D, 0x10,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
  0x10, 0x11, 0x11, 0x10, 0x0A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x10, 0x10, 0x01,
  0x7B, 0x7B, 0x7B, 0x1D, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, 0x0A, 0x1A, 0x1A,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x11, 0x10, 0x10, 0x1D, 0x7B, 0x7B, 0x01, 0x7B, 0x10, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x11, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x14, 0x10, 0x1D, 0x7B, 0x7B, 0x7B, 0x1D,
  0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x18, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x19,
  0x19, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x14, 0x14, 0x10,
  0x1D, 0x1D, 0x1D, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1C, 0x18,
  0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x01, 0x01,
  0x01, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x11, 0x14, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x1B, 0x1C, 0x18, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x01, 0x19, 0x01, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x11, 0x14, 0x14, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1C, 0x18, 0x1C, 0x1C, 0x18, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A,
  0x18, 0x18, 0x1C, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x01, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x19, 0x1A, 0x1A, 0x1C,
  0x18, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x18, 0x18, 0x1C, 0x1B, 0x1B, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19,
  0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x18, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x18, 0x18,
  0x18, 0x1C, 0x1B, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1B, 0x1B, 0x1A, 0x1A, 0x18, 0x1C, 0x18, 0x1A, 0x1A,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1A, 0x1A, 0x18, 0x18, 0x18, 0x1C, 0x1B, 0x1B, 0x1B, 0x19,
  0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x1D, 0x1D,
  0x1D, 0x1D, 0x1D, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1B, 0x18, 0x18, 0x18, 0x1C,
  0x1C, 0x1C, 0x18, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x18, 0x18,
  0x18, 0x1C, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B,
  0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D,
  0x1D, 0x1D, 0x1D, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x18,
  0x1A, 0x1A, 0x1A, 0x1A, 0x18, 0x1C, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x1B, 0x1B,
  0x19, 0x19, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D,
  0x1D, 0x1D, 0x1D, 0x14, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x19, 0x1B, 0x1B, 0x18, 0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x1C, 0x18,
  0x18, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D,
  0x1D, 0x1D, 0x1D, 0x1D, 0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x18, 0x1B, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1C, 0x1C, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D,
  0x1D, 0x1D, 0x1D, 0x1D, 0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1B, 0x1B,
  0x1B, 0x18, 0x18, 0x18, 0x1A, 0x18, 0x18, 0x1C, 0x1C, 0x18, 0x18, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1D, 0x1D, 0x14, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1A, 0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x1C, 0x1C, 0x1C,
  0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1B, 0x1A, 0x1A, 0x18, 0x18,
  0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1C, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1A,
  0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1C,
  0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x18, 0x1A, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x1A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x1A, 0x1A,
  0x1A, 0x18, 0x1C, 0x1C, 0x1A, 0x1A, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
  0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1A, 0x1A, 0x1A,
  0x1B, 0x1A, 0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1C, 0x1C, 0x1A, 0x1A,
  0x1A, 0x1C, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x19, 0x1B, 0x1B, 0x1B, 0x1A, 0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x1C,
  0x1A, 0x1A, 0x1A, 0x1C, 0x1C, 0x1A, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B,
  0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x1A, 0x1A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x19, 0x1B, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1B, 0x1B, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1A, 0x1A,
  0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x19, 0x1B, 0x1B, 0x1A, 0x1A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1B, 0x1B, 0x1B, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x19, 0x1B, 0x1B, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask2RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x12, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
  0xB7, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xFF, 0xFE, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF,
  0xFF, 0xFE, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x40, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0xF8, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x7F, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x7E, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xF8, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0xC0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x80, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xE0,
  0x1F, 0x80, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0x80, 0x3E, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0xFE, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00,
  0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite2RB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00,
  0x00, 0x18, 0x00, 0x19, 0x18, 0x1B, 0x19, 0x1A, 0x18, 0x19, 0x18, 0x18,
  0x1B, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1B, 0x1B,
  0x18, 0x19, 0x18, 0x19, 0x19, 0x1A, 0x18, 0x19, 0x1A, 0x18, 0x19, 0x1B,
  0x18, 0x19, 0x1B, 0x18, 0x18, 0x19, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
  0x19, 0x19, 0x18, 0x19, 0x18, 0x1B, 0x18, 0x1B, 0x1B, 0x1A, 0x18, 0x1B,
  0x1A, 0x18, 0x18, 0x1B, 0x18, 0x18, 0x1B, 0x1A, 0x18, 0x19, 0x1A, 0x18,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x18, 0x19, 0x18, 0x19, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x1B, 0x1A, 0x18,
  0x18, 0x1B, 0x18, 0x1B, 0x1A, 0x18, 0x18, 0x1B, 0x1A, 0x18, 0x18, 0x1A,
  0x18, 0x1B, 0x1A, 0x18, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x18, 0x19, 0x18, 0x19, 0x18, 0x1B, 0x18, 0x1A, 0x18, 0x1B,
  0x1A, 0x18, 0x1A, 0x18, 0x18, 0x1B, 0x18, 0x1B, 0x1A, 0x18, 0x1A, 0x18,
  0x1A, 0x18, 0x18, 0x1A, 0x18, 0x1B, 0x1A, 0x18, 0x19, 0x1A, 0x18, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x1B,
  0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x1A,
  0x18, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18,
  0x19, 0x1A, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x18, 0x1B, 0x18, 0x1B,
  0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18,
  0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x1C, 0x1A,
  0x18, 0x18, 0x1A, 0x18, 0x1B, 0x1A, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x18, 0x1B,
  0x18, 0x1B, 0x18, 0x1B, 0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x18, 0x1A, 0x18,
  0x1A, 0x18, 0x1A, 0x18, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1C,
  0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1B, 0x1A, 0x18, 0x18,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x18, 0x1B, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x1A, 0x1A, 0x18, 0x18, 0x1A,
  0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1C, 0x1C, 0x1A, 0x1C, 0x1A,
  0x1C, 0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1C, 0x1A, 0x18,
  0x1B, 0x18, 0x18, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x19, 0x18, 0x1B, 0x18, 0x1B, 0x18, 0x1A, 0x18, 0x18,
  0x1A, 0x18, 0x1C, 0x1A, 0x1A, 0x18, 0x1A, 0x1C, 0x1A, 0x1C, 0x1A, 0x1C,
  0x1A, 0x1C, 0x1A, 0x1C, 0x1A, 0x18, 0x1C, 0x18, 0x1A, 0x18, 0x1C, 0x1A,
  0x18, 0x1C, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1C, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1B, 0x18, 0x1A, 0x18, 0x1A,
  0x18, 0x18, 0x1A, 0x18, 0x1A, 0x18, 0x1C, 0x1A, 0x18, 0x1C, 0x1C, 0x1C,
  0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x1C, 0x1A,
  0x18, 0x1C, 0x1A, 0x18, 0x18, 0x1C, 0x1A, 0x18, 0x1A, 0x18, 0x18, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1A, 0x18,
  0x1B, 0x1A, 0x1A, 0x18, 0x1A, 0x18, 0x1A, 0x1C, 0x1A, 0x18, 0x1C, 0x1C,
  0x1C, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1C,
  0x1C, 0x1C, 0x1C, 0x18, 0x1C, 0x1C, 0x1A, 0x18, 0x1C, 0x18, 0x1A, 0x1A,
  0x18, 0x18, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x19, 0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x1A, 0x1C, 0x1A, 0x1C,
  0x1C, 0x1C, 0x18, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
  0x1C, 0x18, 0x1A, 0x18, 0x1C, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1B, 0x1B, 0x18, 0x1A, 0x18, 0x1A, 0x1A, 0x1C,
  0x1A, 0x1C, 0x18, 0x1C, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B,
  0x18, 0x18, 0x18, 0x18, 0x1C, 0x1C, 0x1A, 0x18, 0x1C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1B, 0x1A, 0x18,
  0x1A, 0x18, 0x1A, 0x1C, 0x18, 0x1C, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x1C, 0x18,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1B, 0x18, 0x1A, 0x1A, 0x1C, 0x1C, 0x18, 0x1C, 0x18, 0x18, 0x1B, 0x1B,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x1B, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1B, 0x1B, 0x18, 0x1C, 0x1A, 0x1C, 0x1C, 0x18,
  0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1A, 0x1A,
  0x1C, 0x1C, 0x18, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x1B, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1B, 0x1B, 0x1C, 0x18, 0x1C, 0x18, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x18, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1A, 0x1C, 0x1C, 0x18, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x19, 0x1B, 0x11,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x14, 0x14, 0x14, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1C, 0x1C,
  0x18, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x19,
  0x1B, 0x1B, 0x1B, 0x11, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x11, 0x11, 0x10, 0x00, 0x00,
  0x00, 0x1A, 0x1C, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x19,
  0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x14, 0x10, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x10,
  0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B,
  0x19, 0x1B, 0x19, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x10,
  0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x10, 0x10, 0x11, 0x14, 0x10, 0x00, 0x00, 0x18, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x11, 0x14, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x10, 0x11, 0x11,
  0x11, 0x11, 0x18, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x14, 0x10, 0x10, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x1D, 0x1D, 0x1D, 0x18, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x11, 0x10, 0x10, 0x10, 0x10, 0x1D, 0x18, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x1D, 0x1D, 0x1D,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x1D, 0x1D, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x14, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x11, 0x11, 0x11, 0x1D, 0x1D, 0x1A, 0x1A, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x01, 0x01, 0x01, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x10, 0x10, 0x11, 0x11,
  0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x19, 0x19,
  0x01, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x10, 0x10, 0x10, 0x01, 0x1D, 0x1D, 0x10,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
  0x10, 0x11, 0x11, 0x10, 0x0A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A,
  0x1A, 0x1B, 0x1B, 0x19, 0x19, 0x01, 0x01, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x10, 0x10, 0x01,
  0x7B, 0x7B, 0x7B, 0x1D, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, 0x0A, 0x1A, 0x1A,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x19, 0x19, 0x19, 0x01,
  0x01, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x11, 0x10, 0x10, 0x1D, 0x7B, 0x7B, 0x01, 0x7B, 0x10, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x11, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x18, 0x18,
  0x19, 0x19, 0x19, 0x19, 0x01, 0x01, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x14, 0x10, 0x1D, 0x7B, 0x7B, 0x7B, 0x1D,
  0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x18, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1A, 0x18, 0x18, 0x1C, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x01, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x14, 0x14, 0x10,
  0x1D, 0x1D, 0x1D, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1C, 0x18,
  0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x18, 0x18, 0x1C, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x01, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x11, 0x14, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1B, 0x1C, 0x18, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A,
  0x18, 0x18, 0x1C, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x11, 0x14, 0x14, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1C, 0x1C, 0x18, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x18, 0x1C, 0x1B, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x01, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1A, 0x1A, 0x1C,
  0x18, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x18, 0x18,
  0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x11, 0x11, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19,
  0x18, 0x18, 0x1C, 0x1C, 0x1C, 0x18, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1A, 0x1A, 0x18, 0x18, 0x1B, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19,
  0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x19, 0x1B, 0x1B, 0x1A, 0x1A, 0x18, 0x1C, 0x18, 0x1A, 0x1A,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x18, 0x1B, 0x1B,
  0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x1D, 0x1D,
  0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x18, 0x1A, 0x18, 0x18, 0x1C,
  0x1C, 0x1C, 0x18, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1A, 0x1A, 0x18, 0x18, 0x1A, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B,
  0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x14,
  0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1B, 0x1B,
  0x18, 0x18, 0x1A, 0x1A, 0x18, 0x1C, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1C, 0x1C, 0x1C, 0x19, 0x19,
  0x19, 0x19, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D,
  0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1A, 0x1A, 0x18, 0x1B, 0x1A, 0x1A, 0x1C, 0x1C, 0x1C, 0x1C, 0x18,
  0x18, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D,
  0x1D, 0x1D, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x18,
  0x1A, 0x1A, 0x1C, 0x1C, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D,
  0x1D, 0x1D, 0x1D, 0x1D, 0x14, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x18,
  0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x18, 0x1C, 0x1C, 0x18, 0x18, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1D, 0x1D, 0x14, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1B, 0x1B, 0x1A, 0x1A, 0x18, 0x18, 0x18, 0x1A, 0x1A, 0x1C,
  0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x18, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1A, 0x1A, 0x18, 0x18, 0x1A,
  0x1A, 0x1A, 0x18, 0x18, 0x18, 0x18, 0x1A, 0x1C, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1C, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19,
  0x1B, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x1A, 0x1A, 0x1A, 0x1C, 0x1C, 0x1C,
  0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x18, 0x1A, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x18,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x19, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1A, 0x18,
  0x18, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
  0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1B, 0x1B,
  0x1B, 0x1A, 0x18, 0x1A, 0x1A, 0x1A, 0x18, 0x1C, 0x1C, 0x1C, 0x1A, 0x1A,
  0x1A, 0x1C, 0x1A, 0x18, 0x1A, 0x1A, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x18, 0x1A, 0x1A, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x18, 0x18, 0x1B, 0x1B,
  0x1A, 0x1A, 0x1A, 0x1C, 0x1C, 0x1A, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1A, 0x1A, 0x1A, 0x1A, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1B, 0x1A, 0x1A,
  0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x18, 0x18, 0x1A, 0x1A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1A, 0x1A, 0x1A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x18, 0x19, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x1C, 0x1B, 0x1B, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1B, 0x1B, 0x1C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x1C, 0x10,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1B,
  0x1B, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask2RB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
  0x5F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFE, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xC0, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x40, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
  0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0xE0, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x7C, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0x7C, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x7F, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x7E, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x78, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x70, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0xE0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xC0, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x80, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xE0,
  0x3E, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x78, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xFE, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x03,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite3LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x0C, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x00,
  0x00, 0x00, 0x10, 0x10, 0x1E, 0x1E, 0x1B, 0x1E, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x1F, 0x1F, 0x1F, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x0C, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x10,
  0x00, 0x1A, 0x10, 0x10, 0x1A, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x20, 0x1F, 0x20, 0x1F, 0x20, 0x1F, 0x20, 0x20, 0x1F, 0x1F, 0x1F,
  0x1F, 0x1A, 0x10, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x0C, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1E, 0x10, 0x00, 0x1B, 0x7B, 0x1A, 0x7B, 0x10, 0x10, 0x10, 0x10,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1A, 0x10, 0x1B,
  0x1B, 0x1B, 0x0C, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1A, 0x10, 0x00, 0x00, 0x1B, 0x1E, 0x10, 0x10,
  0x1F, 0x11, 0x21, 0x10, 0x10, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x7B, 0x20, 0x20,
  0x1F, 0x1F, 0x1F, 0x1F, 0x1E, 0x0C, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x1A,
  0x1A, 0x10, 0x01, 0x1B, 0x1A, 0x1A, 0x1A, 0x10, 0x1E, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x20, 0x10, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x20, 0x7B, 0x20, 0x20, 0x7B, 0x20, 0x1F, 0x1F, 0x1E, 0x1B, 0x0C,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A,
  0x11, 0x00, 0x1A, 0x7B, 0x22, 0x1E, 0x23, 0x1A, 0x11, 0x1A, 0x11, 0x1A,
  0x11, 0x1E, 0x10, 0x1A, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x20,
  0x1F, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x7B, 0x20,
  0x1F, 0x1F, 0x1A, 0x1B, 0x1B, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x1A, 0x1E, 0x1A, 0x7B, 0x22, 0x1E, 0x23, 0x1A, 0x23,
  0x1A, 0x11, 0x1A, 0x24, 0x1A, 0x11, 0x1A, 0x19, 0x1A, 0x10, 0x1A, 0x1B,
  0x1E, 0x10, 0x1E, 0x1A, 0x10, 0x10, 0x10, 0x1F, 0x20, 0x7B, 0x20, 0x7B,
  0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20, 0x1F, 0x1A, 0x1B, 0x0C, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x10, 0x1E, 0x1A, 0x22, 0x1E,
  0x23, 0x1A, 0x1E, 0x1A, 0x11, 0x1B, 0x11, 0x1B, 0x11, 0x1A, 0x11, 0x1B,
  0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E,
  0x10, 0x20, 0x20, 0x20, 0x7B, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x1F,
  0x1A, 0x1B, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7B, 0x1E,
  0x1A, 0x22, 0x1E, 0x23, 0x1A, 0x23, 0x1B, 0x11, 0x1B, 0x23, 0x1B, 0x11,
  0x1B, 0x19, 0x1A, 0x11, 0x1A, 0x19, 0x1A, 0x10, 0x1A, 0x1B, 0x1E, 0x10,
  0x1E, 0x1A, 0x1E, 0x10, 0x1E, 0x10, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x1F, 0x1A, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x11, 0x1E, 0x1A, 0x22, 0x1E, 0x23, 0x1A, 0x1E, 0x1B, 0x1E, 0x1B,
  0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x11, 0x1B, 0x11, 0x1B, 0x10, 0x1B,
  0x10, 0x1A, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x10,
  0x20, 0x20, 0x7B, 0x20, 0x7B, 0x7B, 0x20, 0x7B, 0x20, 0x1E, 0x1B, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x1E, 0x1A, 0x10, 0x11, 0x1E, 0x1A, 0x23,
  0x1B, 0x1E, 0x1B, 0x23, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19,
  0x1B, 0x11, 0x1B, 0x19, 0x1B, 0x10, 0x1E, 0x1B, 0x1E, 0x10, 0x1E, 0x1A,
  0x1E, 0x10, 0x1E, 0x10, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20,
  0x20, 0x20, 0x1A, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1A, 0x10, 0x12,
  0x11, 0x1A, 0x24, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B,
  0x1E, 0x1B, 0x1E, 0x1B, 0x11, 0x1B, 0x11, 0x1B, 0x10, 0x1A, 0x10, 0x1A,
  0x10, 0x1A, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x11, 0x10, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x20, 0x11, 0x1B, 0x1B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x10, 0x20, 0x10, 0x1E, 0x23, 0x1B, 0x1E, 0x1B, 0x23, 0x1B, 0x1E,
  0x1B, 0x23, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x11,
  0x1A, 0x1B, 0x1A, 0x10, 0x1A, 0x1B, 0x1A, 0x10, 0x1E, 0x1A, 0x1E, 0x10,
  0x11, 0x10, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x1F, 0x1B, 0x0C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x7B, 0x10, 0x1E, 0x1B, 0x24, 0x1B,
  0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B,
  0x1E, 0x1B, 0x11, 0x1B, 0x11, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A,
  0x10, 0x1E, 0x10, 0x1E, 0x10, 0x11, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x1F, 0x1B, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x20, 0x10,
  0x1E, 0x24, 0x1B, 0x23, 0x1B, 0x24, 0x1B, 0x23, 0x1B, 0x24, 0x1B, 0x19,
  0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x11, 0x1B, 0x19, 0x1B, 0x11, 0x1A, 0x1B,
  0x1A, 0x10, 0x1A, 0x1B, 0x1A, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1F, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x20, 0x1F, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x12, 0x7B, 0x10, 0x1E, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x24, 0x1B,
  0x24, 0x1B, 0x24, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B,
  0x11, 0x1A, 0x11, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1E, 0x10, 0x1E,
  0x10, 0x11, 0x10, 0x1F, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x1F, 0x1B, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x7B, 0x20, 0x10, 0x1E, 0x19, 0x1B, 0x24,
  0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x1E,
  0x1B, 0x19, 0x1B, 0x11, 0x1B, 0x19, 0x1A, 0x11, 0x1A, 0x19, 0x1A, 0x10,
  0x1A, 0x1B, 0x1E, 0x10, 0x1A, 0x10, 0x11, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x1F, 0x1A, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x7B, 0x7B, 0x10,
  0x1E, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B,
  0x24, 0x1B, 0x24, 0x1B, 0x1E, 0x1B, 0x1E, 0x1A, 0x1E, 0x1B, 0x11, 0x1A,
  0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1F,
  0x20, 0x7B, 0x20, 0x1F, 0x1F, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11,
  0x1A, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x20, 0x7B, 0x20, 0x10, 0x1E, 0x1B, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19,
  0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19,
  0x1B, 0x11, 0x1B, 0x19, 0x1A, 0x10, 0x1A, 0x1B, 0x1A, 0x10, 0x1E, 0x1A,
  0x1E, 0x10, 0x11, 0x20, 0x7B, 0x20, 0x1F, 0x1F, 0x11, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1A, 0x0C, 0x0C, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x12, 0x7B, 0x7B, 0x7B, 0x10, 0x1E, 0x1B, 0x1B, 0x1B,
  0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B,
  0x1E, 0x1B, 0x1E, 0x1B, 0x11, 0x1B, 0x11, 0x1B, 0x11, 0x1A, 0x10, 0x1A,
  0x10, 0x1A, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x20, 0x1F, 0x1F, 0x20, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x0C, 0x1A, 0x1B, 0x0C, 0x1A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x7B, 0x7B, 0x20, 0x10,
  0x1E, 0x1B, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24,
  0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x11,
  0x1A, 0x1B, 0x1A, 0x10, 0x1A, 0x1B, 0x1A, 0x10, 0x1E, 0x1A, 0x10, 0x1F,
  0x1F, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x0C, 0x1A, 0x1A,
  0x19, 0x1B, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7B,
  0x7B, 0x7B, 0x7B, 0x10, 0x1E, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x24, 0x1B,
  0x1B, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B,
  0x1E, 0x1B, 0x11, 0x1B, 0x11, 0x1A, 0x11, 0x1A, 0x10, 0x1A, 0x10, 0x1E,
  0x10, 0x1E, 0x10, 0x1F, 0x1F, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A,
  0x19, 0x1A, 0x1A, 0x1B, 0x1B, 0x19, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x10, 0x10, 0x20, 0x22, 0x22, 0x20, 0x10, 0x1E, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19,
  0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x11, 0x1A, 0x1B,
  0x1A, 0x10, 0x1B, 0x1A, 0x1E, 0x10, 0x11, 0x1F, 0x20, 0x20, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x19, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x19, 0x19, 0x1A,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x1A, 0x12, 0x22, 0x20, 0x7B, 0x22, 0x11,
  0x1E, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E, 0x1B,
  0x11, 0x1A, 0x11, 0x1A, 0x10, 0x1A, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x20,
  0x1F, 0x10, 0x10, 0x10, 0x20, 0x20, 0x19, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1B, 0x1B, 0x19, 0x1A, 0x00, 0x00, 0x00, 0x10, 0x1A, 0x11, 0x22, 0x20,
  0x7B, 0x20, 0x7B, 0x22, 0x11, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24,
  0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x1B, 0x1A, 0x11, 0x1A, 0x1B, 0x1A, 0x10,
  0x1E, 0x1A, 0x11, 0x1F, 0x20, 0x1F, 0x7B, 0x1F, 0x1F, 0x10, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x19, 0x19, 0x1A, 0x00, 0x00, 0x00, 0x11,
  0x1A, 0x11, 0x20, 0x7B, 0x1E, 0x24, 0x20, 0x7B, 0x22, 0x1E, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x11, 0x1B,
  0x11, 0x1A, 0x10, 0x1A, 0x10, 0x1E, 0x10, 0x10, 0x20, 0x7B, 0x20, 0x7B,
  0x10, 0x20, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x19, 0x19, 0x1A,
  0x00, 0x00, 0x10, 0x1A, 0x1B, 0x11, 0x7B, 0x1E, 0x7B, 0x7B, 0x1E, 0x20,
  0x11, 0x1E, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x23, 0x23, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B,
  0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x10, 0x1B, 0x1A, 0x1E, 0x10, 0x11, 0x20,
  0x20, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x19, 0x1A, 0x00, 0x00, 0x1A, 0x1B, 0x1B, 0x11, 0x20, 0x1E,
  0x7B, 0x7B, 0x1E, 0x7B, 0x11, 0x1E, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x23,
  0x23, 0x19, 0x1B, 0x19, 0x19, 0x23, 0x23, 0x23, 0x1B, 0x1B, 0x24, 0x1B,
  0x1E, 0x1B, 0x24, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x11, 0x1A, 0x10, 0x1A,
  0x10, 0x11, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x10, 0x20, 0x1A, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x19, 0x19, 0x1A, 0x00, 0x10, 0x1B, 0x1B,
  0x1B, 0x11, 0x7B, 0x20, 0x1E, 0x1E, 0x7B, 0x20, 0x11, 0x1A, 0x1B, 0x1B,
  0x1B, 0x1B, 0x24, 0x1E, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x23, 0x23,
  0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x11,
  0x1B, 0x1B, 0x1A, 0x10, 0x1E, 0x1A, 0x10, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x20, 0x10, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1B, 0x23, 0x1E, 0x11, 0x10, 0x20, 0x20, 0x20, 0x20, 0x7B,
  0x11, 0x1E, 0x1A, 0x1B, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x19, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x23, 0x23, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B,
  0x1E, 0x1B, 0x1E, 0x1B, 0x11, 0x1B, 0x10, 0x1A, 0x10, 0x11, 0x20, 0x1F,
  0x20, 0x10, 0x10, 0x10, 0x20, 0x20, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B,
  0x19, 0x19, 0x1A, 0x1A, 0x23, 0x23, 0x23, 0x1A, 0x1A, 0x11, 0x7B, 0x20,
  0x22, 0x22, 0x7B, 0x20, 0x10, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1E, 0x1B,
  0x1B, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x23, 0x1A, 0x1B, 0x1B,
  0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x11, 0x1A, 0x1B,
  0x1E, 0x10, 0x11, 0x20, 0x1F, 0x10, 0x7B, 0x7B, 0x12, 0x10, 0x1A, 0x1B,
  0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x1A, 0x00, 0x1B, 0x1B, 0x24,
  0x11, 0x22, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x10, 0x1E, 0x1A, 0x1B,
  0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x23,
  0x23, 0x1A, 0x1B, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E, 0x1B,
  0x11, 0x1B, 0x11, 0x1A, 0x10, 0x11, 0x10, 0x20, 0x20, 0x1F, 0x10, 0x10,
  0x00, 0x00, 0x20, 0x1A, 0x1B, 0x19, 0x1A, 0x1B, 0x1B, 0x19, 0x19, 0x00,
  0x00, 0x00, 0x1A, 0x1A, 0x22, 0x22, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x10, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x19, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x23, 0x11, 0x1A, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1E,
  0x1B, 0x1B, 0x1B, 0x1E, 0x1B, 0x1A, 0x1B, 0x10, 0x1E, 0x11, 0x10, 0x10,
  0x20, 0x20, 0x20, 0x1F, 0x10, 0x00, 0x00, 0x00, 0x1A, 0x1B, 0x19, 0x1B,
  0x1B, 0x1B, 0x19, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x10, 0x10, 0x7B,
  0x20, 0x7B, 0x20, 0x7B, 0x10, 0x22, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x23, 0x23, 0x11, 0x1A, 0x24, 0x1B,
  0x1B, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1A, 0x1E,
  0x11, 0x10, 0x11, 0x20, 0x1F, 0x7B, 0x20, 0x20, 0x1F, 0x10, 0x00, 0x00,
  0x00, 0x1A, 0x1B, 0x19, 0x1B, 0x19, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x20, 0x10, 0x10, 0x10, 0x7B, 0x20, 0x7B, 0x20, 0x10, 0x11, 0x1A, 0x1A,
  0x1B, 0x1A, 0x11, 0x11, 0x11, 0x23, 0x23, 0x23, 0x1B, 0x19, 0x23, 0x11,
  0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B,
  0x1B, 0x1A, 0x1E, 0x1E, 0x11, 0x11, 0x10, 0x10, 0x20, 0x20, 0x7B, 0x20,
  0x20, 0x1F, 0x20, 0x00, 0x00, 0x00, 0x1A, 0x1B, 0x19, 0x19, 0x1A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7B, 0x20, 0x7B,
  0x20, 0x11, 0x1E, 0x1A, 0x1A, 0x1B, 0x1A, 0x1A, 0x11, 0x19, 0x19, 0x23,
  0x23, 0x23, 0x11, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B,
  0x24, 0x1B, 0x24, 0x1B, 0x1A, 0x1A, 0x1A, 0x11, 0x1E, 0x10, 0x10, 0x20,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x1F, 0x00, 0x00, 0x00, 0x1A,
  0x1B, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x11, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1A, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x24,
  0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x1E, 0x1E,
  0x11, 0x11, 0x10, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x20, 0x7B, 0x1F, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x1A,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B,
  0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1A, 0x1E, 0x11, 0x11, 0x10, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x20,
  0x7B, 0x20, 0x20, 0x1F, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x20,
  0x7B, 0x20, 0x10, 0x1E, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1E, 0x11, 0x1E, 0x11, 0x11, 0x10, 0x20,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x1F, 0x20, 0x1B, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0x20, 0x7B, 0x20, 0x22, 0x1A, 0x1A, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x11, 0x1E, 0x11,
  0x11, 0x10, 0x10, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x1F,
  0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x20, 0x20,
  0x22, 0x1E, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1E,
  0x11, 0x1E, 0x11, 0x11, 0x10, 0x10, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x20, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0x20, 0x20, 0x22, 0x1E, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1E, 0x11, 0x1E, 0x11, 0x1E, 0x10, 0x10, 0x10, 0x20, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x7B, 0x20, 0x20, 0x1A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x20, 0x22, 0x22,
  0x1E, 0x1E, 0x1E, 0x1E, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1E, 0x1E, 0x1E, 0x1E, 0x11, 0x1E, 0x11, 0x11, 0x10, 0x10,
  0x10, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20, 0x20,
  0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1F, 0x1F, 0x22, 0x22, 0x22, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
  0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x11, 0x1E, 0x11, 0x11, 0x11,
  0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x20, 0x20, 0x20, 0x1A, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x1F, 0x22, 0x22,
  0x11, 0x22, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x10, 0x10, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x20, 0x20, 0x1F, 0x11, 0x1A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x12, 0x12, 0x12, 0x1F, 0x1F, 0x1F, 0x1F, 0x10, 0x10, 0x00, 0x00, 0x11,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x10, 0x7B, 0x11, 0x10, 0x22, 0x20, 0x1F,
  0x20, 0x1F, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x1F, 0x1F, 0x1A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1F, 0x11, 0x1F, 0x11, 0x1F, 0x11, 0x1F, 0x11,
  0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x1A, 0x10,
  0x11, 0x1A, 0x00, 0x00, 0x1F, 0x1F, 0x1F, 0x20, 0x20, 0x20, 0x20, 0x10,
  0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x11, 0x11,
  0x11, 0x0C, 0x11, 0x0C, 0x0C, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x1F, 0x1F,
  0x1F, 0x20, 0x10, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x11, 0x1A, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x11, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1A, 0x00, 0x00, 0x11, 0x1A,
  0x1A, 0x10, 0x00, 0x00, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x0C, 0x1A, 0x0C, 0x0C,
  0x0C, 0x1A, 0x1B, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1A, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x0C, 0x0C, 0x0C, 0x1A, 0x1A, 0x1A, 0x0C, 0x11, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1A, 0x1A,
  0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask3LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x23, 0xFF,
  0xFF, 0xFC, 0x00, 0x00, 0x00, 0x03, 0x7F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
  0x00, 0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x0C, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1C, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x3C, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7E,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFE, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xC1, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC7, 0xFF,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xFE,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x7E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x3E,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1C, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x1F, 0xF9,
  0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x0F, 0xFC, 0x0F, 0xCF, 0xFC, 0x00,
  0x00, 0x00, 0x0F, 0xFE, 0x07, 0xE3, 0xF0, 0x00, 0x00, 0x00, 0x07, 0xFF,
  0x03, 0x3C, 0xE0, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x80, 0x86, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xC0, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite3LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1E,
  0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1B, 0x1B,
  0x1E, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1E, 0x1B,
  0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x10, 0x10, 0x10, 0x1F, 0x1F, 0x1F, 0x1F,
  0x1F, 0x1F, 0x1F, 0x1E, 0x1E, 0x1B, 0x1B, 0x1B, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x1A, 0x00, 0x00, 0x10, 0x1B,
  0x1E, 0x1B, 0x1E, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x1F, 0x1F, 0x1F, 0x1F, 0x1E,
  0x1E, 0x1B, 0x1B, 0x0C, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x1B, 0x11,
  0x00, 0x1E, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x1E, 0x1A, 0x1B, 0x1B, 0x0C, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E,
  0x11, 0x00, 0x1B, 0x00, 0x1A, 0x10, 0x10, 0x1F, 0x11, 0x21, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x1E,
  0x1A, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x1B, 0x1E, 0x10, 0x01, 0x1B, 0x1A,
  0x1A, 0x1A, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x10,
  0x10, 0x10, 0x20, 0x1F, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x20, 0x1E, 0x1A, 0x1B, 0x0C, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x11, 0x00, 0x1E, 0x1A, 0x22,
  0x1E, 0x23, 0x1A, 0x11, 0x1A, 0x11, 0x1A, 0x11, 0x1E, 0x10, 0x1A, 0x10,
  0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x10, 0x10, 0x1F, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x1E, 0x1A, 0x1B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1F, 0x1F, 0x11,
  0x1B, 0x1A, 0x22, 0x1E, 0x23, 0x1A, 0x23, 0x1A, 0x11, 0x1A, 0x24, 0x1A,
  0x11, 0x1A, 0x19, 0x1A, 0x10, 0x1A, 0x1B, 0x1E, 0x10, 0x1E, 0x1A, 0x1E,
  0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x20, 0x1E, 0x1B, 0x0C, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x11, 0x00, 0x11, 0x1E, 0x1A, 0x22, 0x1E, 0x23, 0x1A, 0x1E, 0x1A, 0x11,
  0x1B, 0x11, 0x1B, 0x11, 0x1A, 0x11, 0x1B, 0x10, 0x1A, 0x10, 0x1A, 0x10,
  0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x10, 0x20, 0x20, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x1A, 0x1B, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x1E, 0x1A, 0x22, 0x1E, 0x23, 0x1A,
  0x23, 0x1B, 0x11, 0x1B, 0x23, 0x1B, 0x11, 0x1B, 0x19, 0x1A, 0x11, 0x1A,
  0x19, 0x1A, 0x10, 0x1A, 0x1B, 0x1E, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1E,
  0x10, 0x10, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x1E,
  0x1B, 0x0C, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x1E, 0x1A, 0x22,
  0x1E, 0x23, 0x1A, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E,
  0x1B, 0x11, 0x1B, 0x11, 0x1B, 0x10, 0x1B, 0x10, 0x1A, 0x10, 0x1E, 0x10,
  0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x10, 0x20, 0x20, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x20, 0x20, 0x1A, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A,
  0x1E, 0x1A, 0x10, 0x11, 0x1E, 0x1A, 0x23, 0x1B, 0x1E, 0x1B, 0x23, 0x1B,
  0x1E, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x11, 0x1B, 0x19, 0x1B,
  0x10, 0x1E, 0x1B, 0x1E, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1E, 0x10, 0x1F,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x11, 0x1B, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1A, 0x1A, 0x10, 0x12, 0x11, 0x1A, 0x24, 0x1B, 0x1E,
  0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x11,
  0x1B, 0x11, 0x1B, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1E, 0x10,
  0x1E, 0x10, 0x11, 0x10, 0x1F, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x1F, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x10, 0x20, 0x10, 0x1E,
  0x23, 0x1B, 0x1E, 0x1B, 0x23, 0x1B, 0x1E, 0x1B, 0x23, 0x1B, 0x1E, 0x1B,
  0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x11, 0x1A, 0x1B, 0x1A, 0x10, 0x1A,
  0x1B, 0x1A, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x11, 0x10, 0x1F, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x20, 0x1F, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x10, 0x7B, 0x10, 0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24,
  0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x11, 0x1B, 0x11,
  0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1E, 0x10, 0x1E, 0x10,
  0x11, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x1F, 0x1B, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x12, 0x20, 0x10, 0x1E, 0x24, 0x1B, 0x23, 0x1B,
  0x24, 0x1B, 0x23, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B,
  0x11, 0x1B, 0x19, 0x1B, 0x11, 0x1A, 0x1B, 0x1A, 0x10, 0x1A, 0x1B, 0x1A,
  0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1F, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20,
  0x1F, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x7B, 0x10, 0x1E,
  0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E,
  0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x11, 0x1A, 0x11, 0x1A, 0x10,
  0x1A, 0x10, 0x1A, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x11, 0x10, 0x1F, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x1F, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x7B, 0x20, 0x10, 0x1E, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B,
  0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x11, 0x1B,
  0x19, 0x1A, 0x11, 0x1A, 0x19, 0x1A, 0x10, 0x1A, 0x1B, 0x1E, 0x10, 0x1A,
  0x10, 0x11, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x1F, 0x1A, 0x1F, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x12, 0x7B, 0x7B, 0x10, 0x1E, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E,
  0x1B, 0x1E, 0x1A, 0x1E, 0x1B, 0x11, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10,
  0x1A, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1F, 0x20, 0x7B, 0x20, 0x1F, 0x1F,
  0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1A, 0x11, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x7B, 0x20, 0x10, 0x1E,
  0x1B, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B,
  0x24, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x11, 0x1B, 0x19, 0x1A,
  0x10, 0x1A, 0x1B, 0x1A, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x11, 0x20, 0x7B,
  0x20, 0x1F, 0x1F, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x1B,
  0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x7B,
  0x7B, 0x7B, 0x10, 0x1E, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24,
  0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x11,
  0x1B, 0x11, 0x1B, 0x11, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1E, 0x10,
  0x1E, 0x10, 0x1F, 0x20, 0x1F, 0x1F, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1A, 0x1A, 0x1A, 0x19, 0x1B, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x20, 0x7B, 0x7B, 0x20, 0x10, 0x1E, 0x1B, 0x1B, 0x24, 0x1B,
  0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B,
  0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x11, 0x1A, 0x1B, 0x1A, 0x10, 0x1A,
  0x1B, 0x1A, 0x10, 0x1E, 0x1A, 0x10, 0x20, 0x1F, 0x1F, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1A, 0x19, 0x1A, 0x1B, 0x1B, 0x19, 0x1B, 0x1A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7B, 0x7B, 0x7B, 0x7B, 0x10, 0x1E,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x24,
  0x1B, 0x24, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x11, 0x1B, 0x11,
  0x1A, 0x11, 0x1A, 0x10, 0x1A, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1F, 0x1F,
  0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x19, 0x1A, 0x1B, 0x1B, 0x1B,
  0x19, 0x19, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x20, 0x22,
  0x22, 0x20, 0x10, 0x1E, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B,
  0x1E, 0x1B, 0x19, 0x1B, 0x11, 0x1A, 0x1B, 0x1A, 0x10, 0x1B, 0x1A, 0x1E,
  0x10, 0x11, 0x1F, 0x20, 0x20, 0x00, 0x00, 0x00, 0x10, 0x10, 0x19, 0x1A,
  0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x1A, 0x12, 0x22, 0x20, 0x7B, 0x22, 0x11, 0x1E, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x24,
  0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E, 0x1B, 0x11, 0x1A, 0x11, 0x1A, 0x10,
  0x1A, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x20, 0x1F, 0x10, 0x10, 0x10, 0x20,
  0x20, 0x19, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x19, 0x19, 0x1A, 0x11,
  0x00, 0x00, 0x10, 0x1A, 0x11, 0x22, 0x20, 0x7B, 0x20, 0x7B, 0x22, 0x11,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x23, 0x23, 0x23,
  0x23, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x1E, 0x1B,
  0x1B, 0x1A, 0x11, 0x1A, 0x1B, 0x1A, 0x10, 0x1E, 0x1A, 0x11, 0x1F, 0x20,
  0x1F, 0x7B, 0x1F, 0x1F, 0x10, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B,
  0x1B, 0x19, 0x1B, 0x1A, 0x00, 0x00, 0x11, 0x1A, 0x11, 0x20, 0x7B, 0x1E,
  0x24, 0x20, 0x7B, 0x22, 0x1E, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x24,
  0x24, 0x19, 0x19, 0x19, 0x23, 0x23, 0x1A, 0x24, 0x1B, 0x24, 0x1B, 0x24,
  0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x11, 0x1B, 0x11, 0x1A, 0x10, 0x1A, 0x10,
  0x1E, 0x10, 0x10, 0x20, 0x7B, 0x20, 0x7B, 0x10, 0x20, 0x1A, 0x1A, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1B, 0x19, 0x19, 0x1A, 0x1A, 0x00, 0x10, 0x1A, 0x1B,
  0x11, 0x7B, 0x1E, 0x7B, 0x7B, 0x1E, 0x20, 0x11, 0x1E, 0x1B, 0x1B, 0x1B,
  0x1B, 0x23, 0x23, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x23, 0x23, 0x1A,
  0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x1B,
  0x10, 0x1B, 0x1A, 0x1E, 0x10, 0x11, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B,
  0x10, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x1A,
  0x00, 0x1A, 0x1B, 0x1B, 0x11, 0x20, 0x1E, 0x7B, 0x7B, 0x1E, 0x7B, 0x11,
  0x1E, 0x1A, 0x1B, 0x1B, 0x24, 0x1E, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x19,
  0x19, 0x19, 0x23, 0x1A, 0x1A, 0x24, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x1E,
  0x1B, 0x1E, 0x1B, 0x11, 0x1A, 0x10, 0x1A, 0x10, 0x11, 0x20, 0x20, 0x20,
  0x7B, 0x20, 0x7B, 0x10, 0x20, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B,
  0x19, 0x19, 0x1A, 0x1A, 0x10, 0x1B, 0x1B, 0x1B, 0x11, 0x7B, 0x20, 0x1E,
  0x1E, 0x7B, 0x20, 0x11, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x23, 0x11, 0x1A, 0x1B, 0x24, 0x1B,
  0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x11, 0x1B, 0x1B, 0x1A, 0x10, 0x1E,
  0x1A, 0x10, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x10, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x1A, 0x24, 0x23, 0x23, 0x1E,
  0x11, 0x10, 0x20, 0x20, 0x20, 0x20, 0x7B, 0x11, 0x1E, 0x1A, 0x1B, 0x1B,
  0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x19, 0x23, 0x11,
  0x1A, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x11,
  0x1B, 0x10, 0x1A, 0x10, 0x11, 0x20, 0x1F, 0x20, 0x10, 0x10, 0x10, 0x20,
  0x20, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x19, 0x19, 0x1A, 0x1A,
  0x00, 0x00, 0x1A, 0x1A, 0x11, 0x7B, 0x20, 0x22, 0x22, 0x7B, 0x20, 0x10,
  0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x19, 0x19, 0x19, 0x19,
  0x1B, 0x23, 0x23, 0x11, 0x1A, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B,
  0x1E, 0x1B, 0x1B, 0x1B, 0x11, 0x1A, 0x1B, 0x1E, 0x10, 0x11, 0x20, 0x1F,
  0x10, 0x7B, 0x7B, 0x12, 0x10, 0x1A, 0x1B, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B,
  0x1B, 0x19, 0x1B, 0x1A, 0x1B, 0x1B, 0x24, 0x11, 0x22, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x7B, 0x10, 0x1E, 0x1A, 0x1B, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x23, 0x11, 0x1A, 0x1A, 0x1B, 0x1B, 0x24,
  0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E, 0x1B, 0x11, 0x1B, 0x11, 0x1A, 0x10,
  0x11, 0x10, 0x20, 0x20, 0x1F, 0x10, 0x10, 0x00, 0x00, 0x20, 0x1A, 0x1B,
  0x19, 0x1A, 0x1B, 0x1B, 0x19, 0x19, 0x1A, 0x1A, 0x00, 0x1A, 0x1A, 0x22,
  0x22, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x10, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1B, 0x1A, 0x1B, 0x1B, 0x23, 0x23, 0x23, 0x23, 0x23, 0x11, 0x1A, 0x1A,
  0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x1E, 0x1B,
  0x1A, 0x1B, 0x10, 0x1E, 0x11, 0x10, 0x10, 0x20, 0x20, 0x20, 0x1F, 0x10,
  0x00, 0x00, 0x11, 0x1A, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x00,
  0x00, 0x00, 0x20, 0x22, 0x10, 0x10, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x10,
  0x22, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x11, 0x11, 0x11, 0x19, 0x19, 0x23,
  0x11, 0x1A, 0x1A, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x24,
  0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1A, 0x1E, 0x11, 0x10, 0x11, 0x20, 0x1F,
  0x7B, 0x20, 0x20, 0x1F, 0x10, 0x00, 0x00, 0x11, 0x1A, 0x1B, 0x19, 0x1B,
  0x19, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x10, 0x10, 0x7B,
  0x20, 0x7B, 0x20, 0x10, 0x11, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A,
  0x1A, 0x11, 0x11, 0x11, 0x1A, 0x1A, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B,
  0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1A, 0x1E, 0x1E, 0x11,
  0x11, 0x10, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x20, 0x1F, 0x20, 0x00, 0x00,
  0x11, 0x1A, 0x1B, 0x19, 0x19, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x10, 0x7B, 0x20, 0x7B, 0x20, 0x11, 0x1E, 0x1A, 0x1A,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x24,
  0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1A,
  0x1A, 0x1A, 0x11, 0x1E, 0x10, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x20, 0x10, 0x00, 0x00, 0x00, 0x11, 0x1A, 0x1B, 0x1A, 0x1A, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x20, 0x7B, 0x20, 0x20,
  0x10, 0x11, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x1E, 0x1E, 0x11, 0x11, 0x10, 0x10, 0x20,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x1F, 0x00, 0x00, 0x00, 0x11, 0x1A,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B,
  0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1E, 0x11, 0x11,
  0x10, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x1F, 0x11, 0x1A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x20, 0x7B, 0x20, 0x10, 0x1E, 0x1A,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A,
  0x1E, 0x11, 0x1E, 0x11, 0x11, 0x10, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x20, 0x1F, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x20,
  0x7B, 0x20, 0x22, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x11, 0x1E, 0x11, 0x11, 0x10, 0x10, 0x20, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x1F, 0x20, 0x1B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0x1F, 0x20, 0x20, 0x22, 0x1E, 0x1A, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1E, 0x11, 0x1E, 0x11, 0x11, 0x10,
  0x10, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x1F, 0x1B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x20, 0x20,
  0x22, 0x1E, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1E, 0x11, 0x1E,
  0x11, 0x1E, 0x10, 0x10, 0x10, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x20, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0x1F, 0x20, 0x22, 0x22, 0x1E, 0x1E, 0x1E, 0x1E, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1E, 0x1E, 0x1E,
  0x1E, 0x11, 0x1E, 0x11, 0x11, 0x10, 0x10, 0x10, 0x20, 0x20, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x1B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x22, 0x22,
  0x22, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
  0x1E, 0x1E, 0x11, 0x1E, 0x11, 0x11, 0x11, 0x10, 0x10, 0x10, 0x10, 0x20,
  0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20, 0x1B, 0x1A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0x1F, 0x1F, 0x22, 0x22, 0x11, 0x22, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x10,
  0x10, 0x20, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20,
  0x20, 0x1A, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x1F, 0x1F,
  0x1F, 0x1F, 0x10, 0x10, 0x10, 0x10, 0x00, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x10, 0x7B, 0x11, 0x10, 0x20, 0x20, 0x1F, 0x20, 0x20, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x20, 0x1F, 0x11, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F,
  0x11, 0x1F, 0x11, 0x1F, 0x11, 0x1F, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x11, 0x22, 0x00, 0x00, 0x1F,
  0x1F, 0x20, 0x20, 0x20, 0x20, 0x1F, 0x1F, 0x1A, 0x1A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x10, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x1A, 0x00, 0x1A,
  0x1A, 0x22, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x1F, 0x10, 0x10, 0x1A, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x1A, 0x11,
  0x1A, 0x11, 0x1A, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1A, 0x1A, 0x00, 0x1A, 0x1A, 0x10, 0x10, 0x00, 0x00, 0x00, 0x1F,
  0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x0C, 0x11, 0x1A, 0x11, 0x0C, 0x11, 0x1A, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x00, 0x00, 0x1A, 0x1A,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x0C, 0x11,
  0x1B, 0x11, 0x1B, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A,
  0x1A, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x1A, 0x1A, 0x1A, 0x1A, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1A,
  0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask3LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x87, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x05, 0x3F, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x00, 0x0B, 0x7F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x1A, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x13, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0xBF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x38,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7C, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0xFC, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFE,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x8F, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE7, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xFE,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0xFC, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7C,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x38, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x00, 0x00, 0x3F, 0xFD, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0x7F, 0x9F, 0xF8, 0x00, 0x00, 0x00, 0x1F, 0xF8, 0x1D, 0xC7, 0xF0, 0x00,
  0x00, 0x00, 0x0F, 0xFC, 0x06, 0xF1, 0xC0, 0x00, 0x00, 0x00, 0x03, 0xFE,
  0x03, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0x88, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite3RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0C, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0C,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1F, 0x1F, 0x1F, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x1E, 0x1B, 0x1E, 0x1E, 0x10, 0x10, 0x00, 0x00,
  0x00, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0C,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x10, 0x1A, 0x1F, 0x1F, 0x1F, 0x1F, 0x20,
  0x20, 0x1F, 0x20, 0x1F, 0x20, 0x1F, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x1A, 0x10, 0x10, 0x1A, 0x00, 0x10, 0x1A, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x0C, 0x1B, 0x1B, 0x1B, 0x10, 0x1A, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
  0x1F, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x7B, 0x1A, 0x7B, 0x1B,
  0x00, 0x10, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0C, 0x1E, 0x1F, 0x1F, 0x1F, 0x1F,
  0x20, 0x20, 0x7B, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x10, 0x10, 0x21, 0x11, 0x1F,
  0x10, 0x10, 0x1E, 0x1B, 0x00, 0x00, 0x10, 0x1A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0C, 0x1B, 0x1E, 0x1F,
  0x1F, 0x20, 0x7B, 0x20, 0x20, 0x7B, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x10, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1E,
  0x10, 0x1A, 0x1A, 0x1A, 0x1B, 0x01, 0x10, 0x1A, 0x1A, 0x00, 0x00, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1B,
  0x1B, 0x1A, 0x1F, 0x1F, 0x20, 0x7B, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x7B,
  0x20, 0x20, 0x20, 0x1F, 0x20, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10,
  0x1A, 0x10, 0x1E, 0x11, 0x1A, 0x11, 0x1A, 0x11, 0x1A, 0x23, 0x1E, 0x22,
  0x7B, 0x1A, 0x00, 0x11, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0x1B, 0x1A, 0x1F, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B,
  0x7B, 0x20, 0x7B, 0x20, 0x1F, 0x10, 0x10, 0x10, 0x1A, 0x1E, 0x10, 0x1E,
  0x1B, 0x1A, 0x10, 0x1A, 0x19, 0x1A, 0x11, 0x1A, 0x24, 0x1A, 0x11, 0x1A,
  0x23, 0x1A, 0x23, 0x1E, 0x22, 0x7B, 0x1A, 0x1E, 0x1A, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1B, 0x1A, 0x1F, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x7B, 0x7B, 0x20, 0x20, 0x20, 0x10, 0x1E, 0x10, 0x1E, 0x10,
  0x1E, 0x10, 0x1E, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1B, 0x11, 0x1A, 0x11,
  0x1B, 0x11, 0x1B, 0x11, 0x1A, 0x1E, 0x1A, 0x23, 0x1E, 0x22, 0x1A, 0x1E,
  0x10, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1A, 0x1F,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x10, 0x1E,
  0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1E, 0x1B, 0x1A, 0x10, 0x1A, 0x19, 0x1A,
  0x11, 0x1A, 0x19, 0x1B, 0x11, 0x1B, 0x23, 0x1B, 0x11, 0x1B, 0x23, 0x1A,
  0x23, 0x1E, 0x22, 0x1A, 0x1E, 0x7B, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x1B, 0x1E, 0x20, 0x7B, 0x20, 0x7B, 0x7B, 0x20, 0x7B, 0x20, 0x20,
  0x10, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1A, 0x10,
  0x1B, 0x10, 0x1B, 0x11, 0x1B, 0x11, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E,
  0x1B, 0x1E, 0x1B, 0x1E, 0x1A, 0x23, 0x1E, 0x22, 0x1A, 0x1E, 0x11, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0C, 0x1A, 0x20, 0x20, 0x20, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x20, 0x10, 0x10, 0x1E, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1E,
  0x1B, 0x1E, 0x10, 0x1B, 0x19, 0x1B, 0x11, 0x1B, 0x19, 0x1B, 0x1E, 0x1B,
  0x19, 0x1B, 0x1E, 0x1B, 0x23, 0x1B, 0x1E, 0x1B, 0x23, 0x1A, 0x1E, 0x11,
  0x10, 0x1A, 0x1E, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1B, 0x11, 0x20,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x10, 0x11, 0x10, 0x1E, 0x10,
  0x1E, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1B, 0x11, 0x1B, 0x11,
  0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E,
  0x1B, 0x24, 0x1A, 0x11, 0x12, 0x10, 0x1A, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0x1B, 0x1F, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x10, 0x11,
  0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1A, 0x1B, 0x1A, 0x10, 0x1A, 0x1B, 0x1A,
  0x11, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x23, 0x1B,
  0x1E, 0x1B, 0x23, 0x1B, 0x1E, 0x1B, 0x23, 0x1E, 0x10, 0x20, 0x10, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x1B, 0x1F, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x11, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1A, 0x10, 0x1A, 0x10,
  0x1A, 0x10, 0x1A, 0x11, 0x1B, 0x11, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E,
  0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E,
  0x10, 0x7B, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1F, 0x20,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x1F, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1A,
  0x1B, 0x1A, 0x10, 0x1A, 0x1B, 0x1A, 0x11, 0x1B, 0x19, 0x1B, 0x11, 0x1B,
  0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x23, 0x1B, 0x24, 0x1B,
  0x23, 0x1B, 0x24, 0x1E, 0x10, 0x20, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1B, 0x1F, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x1F, 0x10, 0x11, 0x10,
  0x1E, 0x10, 0x1E, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x11, 0x1A, 0x11,
  0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x24,
  0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1E, 0x10, 0x7B, 0x12, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1A, 0x1F, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x11, 0x10, 0x1A, 0x10, 0x1E, 0x1B, 0x1A, 0x10, 0x1A, 0x19, 0x1A,
  0x11, 0x1A, 0x19, 0x1B, 0x11, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B,
  0x1E, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1E,
  0x10, 0x20, 0x7B, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x1A, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1F,
  0x1F, 0x20, 0x7B, 0x20, 0x1F, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1A, 0x10,
  0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x11, 0x1B, 0x1E, 0x1A, 0x1E, 0x1B, 0x1E,
  0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1E, 0x10, 0x7B, 0x7B, 0x12, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x0C, 0x0C, 0x1A, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x1F, 0x1F, 0x20, 0x7B, 0x20, 0x11, 0x10, 0x1E,
  0x1A, 0x1E, 0x10, 0x1A, 0x1B, 0x1A, 0x10, 0x1A, 0x19, 0x1B, 0x11, 0x1B,
  0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B,
  0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x1B, 0x1E, 0x10, 0x20, 0x7B, 0x20,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x0C, 0x1B,
  0x1A, 0x0C, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x20, 0x1F, 0x1F,
  0x20, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x11,
  0x1B, 0x11, 0x1B, 0x11, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x24,
  0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1E,
  0x10, 0x7B, 0x7B, 0x7B, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1A, 0x1B, 0x19, 0x1A, 0x1A, 0x0C, 0x1A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x20, 0x1F, 0x1F, 0x10, 0x1A, 0x1E, 0x10, 0x1A, 0x1B, 0x1A,
  0x10, 0x1A, 0x1B, 0x1A, 0x11, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B,
  0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B,
  0x24, 0x1B, 0x1B, 0x1E, 0x10, 0x20, 0x7B, 0x7B, 0x20, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x19, 0x1B, 0x1B, 0x1A, 0x1A, 0x19,
  0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x1F, 0x1F, 0x10, 0x1E, 0x10,
  0x1E, 0x10, 0x1A, 0x10, 0x1A, 0x11, 0x1A, 0x11, 0x1B, 0x11, 0x1B, 0x1E,
  0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1B,
  0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1E, 0x10, 0x7B, 0x7B, 0x7B,
  0x7B, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x19, 0x19, 0x1B,
  0x1B, 0x1B, 0x1A, 0x1A, 0x19, 0x10, 0x10, 0x00, 0x00, 0x00, 0x20, 0x20,
  0x1F, 0x11, 0x10, 0x1E, 0x1A, 0x1B, 0x10, 0x1A, 0x1B, 0x1A, 0x11, 0x1B,
  0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B,
  0x19, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1E,
  0x10, 0x20, 0x22, 0x22, 0x20, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x1A, 0x19, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x19, 0x20, 0x20,
  0x10, 0x10, 0x10, 0x1F, 0x20, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1A, 0x10,
  0x1A, 0x11, 0x1A, 0x11, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24,
  0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1E, 0x11, 0x22, 0x7B, 0x20, 0x22, 0x12, 0x1A, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x1A, 0x19, 0x19, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A,
  0x1A, 0x1A, 0x10, 0x1F, 0x1F, 0x7B, 0x1F, 0x20, 0x1F, 0x11, 0x1A, 0x1E,
  0x10, 0x1A, 0x1B, 0x1A, 0x11, 0x1A, 0x1B, 0x1B, 0x1E, 0x1B, 0x19, 0x1B,
  0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x22, 0x7B, 0x20, 0x7B,
  0x20, 0x22, 0x11, 0x1A, 0x10, 0x00, 0x00, 0x00, 0x1A, 0x19, 0x19, 0x1B,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x20, 0x10, 0x7B, 0x20, 0x7B, 0x20,
  0x10, 0x10, 0x1E, 0x10, 0x1A, 0x10, 0x1A, 0x11, 0x1B, 0x11, 0x1B, 0x1E,
  0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1E, 0x22,
  0x7B, 0x20, 0x24, 0x1E, 0x7B, 0x20, 0x11, 0x1A, 0x11, 0x00, 0x00, 0x00,
  0x1A, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x10, 0x20,
  0x20, 0x7B, 0x20, 0x20, 0x20, 0x11, 0x10, 0x1E, 0x1A, 0x1B, 0x10, 0x1B,
  0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B,
  0x1B, 0x1B, 0x23, 0x23, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1E, 0x11, 0x20, 0x1E, 0x7B, 0x7B, 0x1E, 0x7B, 0x11, 0x1B,
  0x1A, 0x10, 0x00, 0x00, 0x1A, 0x19, 0x19, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1A, 0x20, 0x10, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20, 0x11, 0x10,
  0x1A, 0x10, 0x1A, 0x11, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x1E,
  0x1B, 0x24, 0x1B, 0x1B, 0x23, 0x23, 0x23, 0x19, 0x19, 0x1B, 0x19, 0x23,
  0x23, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1E, 0x11, 0x7B, 0x1E, 0x7B, 0x7B,
  0x1E, 0x20, 0x11, 0x1B, 0x1B, 0x1A, 0x00, 0x00, 0x1A, 0x1A, 0x19, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x10, 0x1A, 0x1E, 0x10, 0x1A, 0x1B, 0x1B, 0x11, 0x1B, 0x1B, 0x1B,
  0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x23, 0x23, 0x19, 0x19,
  0x19, 0x19, 0x19, 0x1B, 0x1E, 0x24, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x11,
  0x20, 0x7B, 0x1E, 0x1E, 0x20, 0x7B, 0x11, 0x1B, 0x1B, 0x1B, 0x10, 0x00,
  0x1A, 0x1A, 0x19, 0x19, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x20, 0x20,
  0x10, 0x10, 0x10, 0x20, 0x1F, 0x20, 0x11, 0x10, 0x1A, 0x10, 0x1B, 0x11,
  0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x23,
  0x23, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B,
  0x1B, 0x1A, 0x1E, 0x11, 0x7B, 0x20, 0x20, 0x20, 0x20, 0x10, 0x11, 0x1E,
  0x23, 0x1B, 0x1A, 0x1A, 0x1A, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B,
  0x1B, 0x1A, 0x10, 0x12, 0x7B, 0x7B, 0x10, 0x1F, 0x20, 0x11, 0x10, 0x1E,
  0x1B, 0x1A, 0x11, 0x1B, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x24, 0x1B,
  0x1B, 0x1B, 0x1A, 0x23, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B,
  0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x10, 0x20, 0x7B, 0x22, 0x22,
  0x20, 0x7B, 0x11, 0x1A, 0x1A, 0x23, 0x23, 0x23, 0x00, 0x19, 0x19, 0x1B,
  0x1B, 0x1A, 0x19, 0x1B, 0x1A, 0x20, 0x00, 0x00, 0x10, 0x10, 0x1F, 0x20,
  0x20, 0x10, 0x11, 0x10, 0x1A, 0x11, 0x1B, 0x11, 0x1B, 0x1E, 0x1B, 0x24,
  0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1B, 0x1A, 0x23, 0x23, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x1A, 0x1E, 0x10,
  0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x22, 0x11, 0x24, 0x1B, 0x1B, 0x00,
  0x00, 0x19, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x1A, 0x00, 0x00, 0x00, 0x10,
  0x1F, 0x20, 0x20, 0x20, 0x10, 0x10, 0x11, 0x1E, 0x10, 0x1B, 0x1A, 0x1B,
  0x1E, 0x1B, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1A, 0x11,
  0x23, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B,
  0x1A, 0x1B, 0x1A, 0x10, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x22, 0x22,
  0x1A, 0x1A, 0x00, 0x00, 0x00, 0x1A, 0x19, 0x1B, 0x19, 0x1B, 0x1A, 0x00,
  0x00, 0x00, 0x10, 0x1F, 0x20, 0x20, 0x7B, 0x1F, 0x20, 0x11, 0x10, 0x11,
  0x1E, 0x1A, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1B,
  0x1B, 0x24, 0x1A, 0x11, 0x23, 0x23, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x22, 0x10, 0x7B, 0x20, 0x7B, 0x20,
  0x7B, 0x10, 0x10, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x19, 0x19,
  0x1B, 0x1A, 0x00, 0x00, 0x00, 0x20, 0x1F, 0x20, 0x20, 0x7B, 0x20, 0x20,
  0x10, 0x10, 0x11, 0x11, 0x1E, 0x1E, 0x1A, 0x1B, 0x1B, 0x1B, 0x24, 0x1B,
  0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x11, 0x23, 0x19, 0x1B,
  0x23, 0x23, 0x23, 0x11, 0x11, 0x11, 0x1A, 0x1B, 0x1A, 0x1A, 0x11, 0x10,
  0x20, 0x7B, 0x20, 0x7B, 0x10, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1A, 0x1B, 0x1A, 0x00, 0x00, 0x00, 0x1F, 0x10, 0x20, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x10, 0x1E, 0x11, 0x1A, 0x1A, 0x1A,
  0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1A,
  0x1A, 0x11, 0x23, 0x23, 0x23, 0x19, 0x19, 0x11, 0x1A, 0x1A, 0x1B, 0x1A,
  0x1A, 0x1E, 0x11, 0x20, 0x7B, 0x20, 0x7B, 0x10, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1F, 0x7B, 0x20, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x10, 0x11, 0x11,
  0x1E, 0x1E, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x24, 0x1B, 0x1B, 0x1B,
  0x24, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1A,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x11, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x1F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1A, 0x1F, 0x20, 0x20, 0x7B, 0x20, 0x20, 0x7B, 0x20,
  0x20, 0x10, 0x10, 0x11, 0x11, 0x1E, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B,
  0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x10, 0x20, 0x20,
  0x7B, 0x20, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x20, 0x1F, 0x7B, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x11, 0x11, 0x1E, 0x11, 0x1E, 0x1A,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A,
  0x1E, 0x10, 0x20, 0x7B, 0x20, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A,
  0x1F, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x10, 0x10, 0x11,
  0x11, 0x1E, 0x11, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1A, 0x1A, 0x22, 0x20, 0x7B, 0x20, 0x1F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1A, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x20, 0x20, 0x10, 0x10, 0x11, 0x11, 0x1E, 0x11, 0x1E, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1E, 0x22, 0x20, 0x20, 0x1F, 0x1F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x20, 0x20, 0x7B, 0x7B,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x10, 0x10, 0x1E, 0x11, 0x1E,
  0x11, 0x1E, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1E, 0x22, 0x20,
  0x20, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B,
  0x20, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x10,
  0x10, 0x10, 0x11, 0x11, 0x1E, 0x11, 0x1E, 0x1E, 0x1E, 0x1E, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1E, 0x1E, 0x1E, 0x1E,
  0x22, 0x22, 0x20, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1B, 0x1A, 0x20, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x1E,
  0x11, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
  0x1E, 0x1E, 0x22, 0x22, 0x22, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x11, 0x1F, 0x20,
  0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x10,
  0x10, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x22, 0x11, 0x22, 0x22, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1A, 0x1F, 0x1F, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x1F, 0x20,
  0x1F, 0x20, 0x22, 0x10, 0x11, 0x7B, 0x10, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x11, 0x00, 0x00, 0x10, 0x10, 0x1F, 0x1F, 0x1F, 0x1F, 0x12, 0x12, 0x12,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x10, 0x20, 0x20, 0x20,
  0x20, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x1A, 0x11, 0x10, 0x1A, 0x1A, 0x1A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x11, 0x1F, 0x11, 0x1F,
  0x11, 0x1F, 0x11, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1A, 0x10, 0x20, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x0C,
  0x0C, 0x11, 0x0C, 0x11, 0x11, 0x11, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x10, 0x1A,
  0x1A, 0x11, 0x00, 0x00, 0x1A, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x11, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x11, 0x1A, 0x11, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x11, 0x1B, 0x1A, 0x0C, 0x0C, 0x0C, 0x1A, 0x0C,
  0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0C, 0x1A, 0x1A, 0x1A,
  0x0C, 0x0C, 0x0C, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A,
  0x1A, 0x1A, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask3RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF,
  0xFF, 0xC4, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFE, 0xC0, 0x00,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0x00, 0x00, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0x30, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x90, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0x00, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x38, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x3C, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x7E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x7F, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x7F, 0x83, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x7F, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7E, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x7C, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF,
  0x9F, 0xF8, 0x00, 0x00, 0x00, 0x3F, 0xF3, 0xF0, 0x3F, 0xF0, 0x00, 0x00,
  0x00, 0x0F, 0xC7, 0xE0, 0x7F, 0xF0, 0x00, 0x00, 0x00, 0x07, 0x3C, 0xC0,
  0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x61, 0x01, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x06, 0x03, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite3RB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1E, 0x1B, 0x1B, 0x1B, 0x1E,
  0x1B, 0x1E, 0x1B, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1B, 0x1B, 0x1B, 0x1E,
  0x1E, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x10, 0x10, 0x10, 0x1E,
  0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x10, 0x00, 0x00, 0x00, 0x00, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0C, 0x1B, 0x1B, 0x1E,
  0x1E, 0x1F, 0x1F, 0x1F, 0x1F, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1E, 0x1B, 0x1E,
  0x1B, 0x10, 0x00, 0x00, 0x1A, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0C, 0x1B,
  0x1B, 0x1A, 0x1E, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1E, 0x00, 0x11, 0x1B, 0x00, 0x1A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1B, 0x1A, 0x1E, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x21, 0x11, 0x1F, 0x10, 0x10, 0x1A,
  0x00, 0x1B, 0x00, 0x11, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x0C, 0x1B, 0x1A, 0x1E, 0x20, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20, 0x1F, 0x20, 0x10, 0x10,
  0x10, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1A, 0x1A,
  0x1A, 0x1B, 0x01, 0x10, 0x1E, 0x1B, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1A, 0x1E, 0x20,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x1F, 0x10, 0x10,
  0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1A, 0x10, 0x1E,
  0x11, 0x1A, 0x11, 0x1A, 0x11, 0x1A, 0x23, 0x1E, 0x22, 0x1A, 0x1E, 0x00,
  0x11, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0C,
  0x1B, 0x1E, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20,
  0x10, 0x10, 0x10, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1E, 0x1B, 0x1A, 0x10,
  0x1A, 0x19, 0x1A, 0x11, 0x1A, 0x24, 0x1A, 0x11, 0x1A, 0x23, 0x1A, 0x23,
  0x1E, 0x22, 0x1A, 0x1B, 0x11, 0x1F, 0x1F, 0x1A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1B, 0x1A, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x20, 0x20, 0x10, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E,
  0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1B, 0x11, 0x1A, 0x11, 0x1B, 0x11, 0x1B,
  0x11, 0x1A, 0x1E, 0x1A, 0x23, 0x1E, 0x22, 0x1A, 0x1E, 0x11, 0x00, 0x11,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0C, 0x1B, 0x1E, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20, 0x10, 0x10, 0x1E, 0x10, 0x1E, 0x1A,
  0x1E, 0x10, 0x1E, 0x1B, 0x1A, 0x10, 0x1A, 0x19, 0x1A, 0x11, 0x1A, 0x19,
  0x1B, 0x11, 0x1B, 0x23, 0x1B, 0x11, 0x1B, 0x23, 0x1A, 0x23, 0x1E, 0x22,
  0x1A, 0x1E, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1A,
  0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20, 0x10, 0x10, 0x1E,
  0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1A, 0x10, 0x1B, 0x10, 0x1B,
  0x11, 0x1B, 0x11, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B,
  0x1E, 0x1A, 0x23, 0x1E, 0x22, 0x1A, 0x1E, 0x1A, 0x1A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1B, 0x11, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x1F, 0x10, 0x1E, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1E, 0x1B, 0x1E, 0x10,
  0x1B, 0x19, 0x1B, 0x11, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x1E,
  0x1B, 0x23, 0x1B, 0x1E, 0x1B, 0x23, 0x1A, 0x1E, 0x11, 0x10, 0x1A, 0x1E,
  0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1F, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x1F, 0x10, 0x11, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1A,
  0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1B, 0x11, 0x1B, 0x11, 0x1B, 0x1E, 0x1B,
  0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x24, 0x1A,
  0x11, 0x12, 0x10, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1F,
  0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x1F, 0x10, 0x11, 0x10, 0x1E, 0x1A,
  0x1E, 0x10, 0x1A, 0x1B, 0x1A, 0x10, 0x1A, 0x1B, 0x1A, 0x11, 0x1B, 0x19,
  0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x23, 0x1B, 0x1E, 0x1B, 0x23,
  0x1B, 0x1E, 0x1B, 0x23, 0x1E, 0x10, 0x20, 0x10, 0x1A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1B, 0x1F, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x11,
  0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A,
  0x11, 0x1B, 0x11, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B,
  0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1E, 0x10, 0x7B, 0x10,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1F, 0x20, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x1F, 0x10, 0x1E, 0x1A, 0x1E, 0x10, 0x1A, 0x1B, 0x1A, 0x10,
  0x1A, 0x1B, 0x1A, 0x11, 0x1B, 0x19, 0x1B, 0x11, 0x1B, 0x19, 0x1B, 0x1E,
  0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x23, 0x1B, 0x24, 0x1B, 0x23, 0x1B, 0x24,
  0x1E, 0x10, 0x20, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1F,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x1F, 0x10, 0x11, 0x10, 0x1E, 0x10, 0x1E,
  0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x11, 0x1A, 0x11, 0x1B, 0x1E, 0x1B,
  0x1E, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B,
  0x24, 0x1B, 0x1B, 0x1B, 0x1E, 0x10, 0x7B, 0x12, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0x1A, 0x1F, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x11, 0x10,
  0x1A, 0x10, 0x1E, 0x1B, 0x1A, 0x10, 0x1A, 0x19, 0x1A, 0x11, 0x1A, 0x19,
  0x1B, 0x11, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19,
  0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1E, 0x10, 0x20, 0x7B,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11,
  0x1A, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1F, 0x1F, 0x20, 0x7B,
  0x20, 0x1F, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A,
  0x10, 0x1A, 0x11, 0x1B, 0x1E, 0x1A, 0x1E, 0x1B, 0x1E, 0x1B, 0x24, 0x1B,
  0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1E, 0x10, 0x7B, 0x7B, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1A, 0x1A, 0x1B, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x11, 0x1F, 0x1F, 0x20, 0x7B, 0x20, 0x11, 0x10, 0x1E, 0x1A, 0x1E, 0x10,
  0x1A, 0x1B, 0x1A, 0x10, 0x1A, 0x19, 0x1B, 0x11, 0x1B, 0x19, 0x1B, 0x1E,
  0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24,
  0x1B, 0x19, 0x1B, 0x1B, 0x1E, 0x10, 0x20, 0x7B, 0x20, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1B, 0x19, 0x1A, 0x1A, 0x1A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x1F, 0x1F, 0x20, 0x1F, 0x10, 0x1E,
  0x10, 0x1E, 0x10, 0x1A, 0x10, 0x1A, 0x10, 0x1A, 0x11, 0x1B, 0x11, 0x1B,
  0x11, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B,
  0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1E, 0x10, 0x7B, 0x7B,
  0x7B, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1B, 0x19,
  0x1B, 0x1B, 0x1A, 0x19, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x1F,
  0x1F, 0x20, 0x10, 0x1A, 0x1E, 0x10, 0x1A, 0x1B, 0x1A, 0x10, 0x1A, 0x1B,
  0x1A, 0x11, 0x1B, 0x19, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19,
  0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x1B,
  0x1E, 0x10, 0x20, 0x7B, 0x7B, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1A, 0x19, 0x19, 0x1B, 0x1B, 0x1B, 0x1A, 0x19, 0x1A, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x20, 0x1F, 0x1F, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1A,
  0x10, 0x1A, 0x11, 0x1A, 0x11, 0x1B, 0x11, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B,
  0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1E, 0x10, 0x7B, 0x7B, 0x7B, 0x7B, 0x10, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A,
  0x1A, 0x19, 0x10, 0x10, 0x00, 0x00, 0x00, 0x20, 0x20, 0x1F, 0x11, 0x10,
  0x1E, 0x1A, 0x1B, 0x10, 0x1A, 0x1B, 0x1A, 0x11, 0x1B, 0x19, 0x1B, 0x1E,
  0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19, 0x1B, 0x24,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1E, 0x10, 0x20, 0x22,
  0x22, 0x20, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x11, 0x1A, 0x19, 0x19,
  0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x19, 0x20, 0x20, 0x10, 0x10, 0x10,
  0x1F, 0x20, 0x10, 0x1E, 0x10, 0x1E, 0x10, 0x1A, 0x10, 0x1A, 0x11, 0x1A,
  0x11, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1E, 0x11, 0x22, 0x7B, 0x20, 0x22, 0x12, 0x1A, 0x10, 0x00, 0x00, 0x00,
  0x1A, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x10,
  0x1F, 0x1F, 0x7B, 0x1F, 0x20, 0x1F, 0x11, 0x1A, 0x1E, 0x10, 0x1A, 0x1B,
  0x1A, 0x11, 0x1A, 0x1B, 0x1B, 0x1E, 0x1B, 0x19, 0x1B, 0x24, 0x1B, 0x19,
  0x1B, 0x24, 0x1B, 0x23, 0x23, 0x23, 0x23, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x11, 0x22, 0x7B, 0x20, 0x7B, 0x20, 0x22, 0x11,
  0x1A, 0x10, 0x00, 0x00, 0x1A, 0x1A, 0x19, 0x19, 0x1B, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1A, 0x1A, 0x20, 0x10, 0x7B, 0x20, 0x7B, 0x20, 0x10, 0x10, 0x1E,
  0x10, 0x1A, 0x10, 0x1A, 0x11, 0x1B, 0x11, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B,
  0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1A, 0x23, 0x23, 0x19, 0x19, 0x19, 0x24,
  0x24, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1E, 0x22, 0x7B, 0x20, 0x24,
  0x1E, 0x7B, 0x20, 0x11, 0x1A, 0x11, 0x00, 0x00, 0x1A, 0x1B, 0x19, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x1A, 0x10, 0x7B, 0x20, 0x7B, 0x20,
  0x20, 0x20, 0x11, 0x10, 0x1E, 0x1A, 0x1B, 0x10, 0x1B, 0x1B, 0x1B, 0x1E,
  0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1A, 0x23, 0x23, 0x1B,
  0x1B, 0x19, 0x19, 0x19, 0x19, 0x23, 0x23, 0x1B, 0x1B, 0x1B, 0x1B, 0x1E,
  0x11, 0x20, 0x1E, 0x7B, 0x7B, 0x1E, 0x7B, 0x11, 0x1B, 0x1A, 0x10, 0x00,
  0x1A, 0x1A, 0x19, 0x19, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1A, 0x20,
  0x10, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20, 0x11, 0x10, 0x1A, 0x10, 0x1A,
  0x11, 0x1B, 0x1E, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x1E, 0x1B, 0x24, 0x1A,
  0x1A, 0x23, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x1B, 0x19, 0x1B, 0x1E, 0x24,
  0x1B, 0x1B, 0x1A, 0x1E, 0x11, 0x7B, 0x1E, 0x7B, 0x7B, 0x1E, 0x20, 0x11,
  0x1B, 0x1B, 0x1A, 0x00, 0x1A, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x10, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x10, 0x1A,
  0x1E, 0x10, 0x1A, 0x1B, 0x1B, 0x11, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B,
  0x1B, 0x24, 0x1B, 0x1A, 0x11, 0x23, 0x1B, 0x1B, 0x19, 0x19, 0x19, 0x19,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x11, 0x20, 0x7B, 0x1E,
  0x1E, 0x20, 0x7B, 0x11, 0x1B, 0x1B, 0x1B, 0x10, 0x1A, 0x1A, 0x19, 0x19,
  0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x20, 0x20, 0x10, 0x10, 0x10,
  0x20, 0x1F, 0x20, 0x11, 0x10, 0x1A, 0x10, 0x1B, 0x11, 0x1B, 0x1E, 0x1B,
  0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x24, 0x1A, 0x11, 0x23, 0x19, 0x19,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x1A, 0x1E,
  0x11, 0x7B, 0x20, 0x20, 0x20, 0x20, 0x10, 0x11, 0x1E, 0x23, 0x23, 0x24,
  0x1A, 0x1B, 0x19, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1B, 0x1A, 0x10,
  0x12, 0x7B, 0x7B, 0x10, 0x1F, 0x20, 0x11, 0x10, 0x1E, 0x1B, 0x1A, 0x11,
  0x1B, 0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1A,
  0x11, 0x23, 0x23, 0x1B, 0x19, 0x19, 0x19, 0x19, 0x1B, 0x1B, 0x1E, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1A, 0x10, 0x20, 0x7B, 0x22, 0x22, 0x20, 0x7B, 0x11,
  0x1A, 0x1A, 0x00, 0x00, 0x1A, 0x1A, 0x19, 0x19, 0x1B, 0x1B, 0x1A, 0x19,
  0x1B, 0x1A, 0x20, 0x00, 0x00, 0x10, 0x10, 0x1F, 0x20, 0x20, 0x10, 0x11,
  0x10, 0x1A, 0x11, 0x1B, 0x11, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B,
  0x24, 0x1B, 0x1B, 0x1A, 0x1A, 0x11, 0x23, 0x19, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x1A, 0x1E, 0x10, 0x7B, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x22, 0x11, 0x24, 0x1B, 0x1B, 0x00, 0x1B, 0x19, 0x1B,
  0x1B, 0x1B, 0x19, 0x1B, 0x1A, 0x11, 0x00, 0x00, 0x10, 0x1F, 0x20, 0x20,
  0x20, 0x10, 0x10, 0x11, 0x1E, 0x10, 0x1B, 0x1A, 0x1B, 0x1E, 0x1B, 0x1B,
  0x1B, 0x1E, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1A, 0x1A, 0x11, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x1B, 0x1B, 0x1A, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A,
  0x10, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x22, 0x22, 0x1A, 0x1A, 0x00,
  0x00, 0x1A, 0x1A, 0x19, 0x1B, 0x19, 0x1B, 0x1A, 0x11, 0x00, 0x00, 0x10,
  0x1F, 0x20, 0x20, 0x7B, 0x1F, 0x20, 0x11, 0x10, 0x11, 0x1E, 0x1A, 0x1B,
  0x1E, 0x1B, 0x1E, 0x1B, 0x24, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B,
  0x1B, 0x1A, 0x1A, 0x11, 0x23, 0x19, 0x19, 0x11, 0x11, 0x11, 0x1A, 0x1B,
  0x1B, 0x1B, 0x1A, 0x22, 0x10, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x10, 0x10,
  0x22, 0x20, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x19, 0x19, 0x1B, 0x1A, 0x11,
  0x00, 0x00, 0x20, 0x1F, 0x20, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x10, 0x11,
  0x11, 0x1E, 0x1E, 0x1A, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24,
  0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1A, 0x1A, 0x11, 0x11, 0x11, 0x1A,
  0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x11, 0x10, 0x20, 0x7B, 0x20,
  0x7B, 0x10, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x1A,
  0x1B, 0x1A, 0x11, 0x00, 0x00, 0x00, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x20, 0x10, 0x10, 0x1E, 0x11, 0x1A, 0x1A, 0x1A, 0x1B, 0x24, 0x1B,
  0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1E, 0x11,
  0x20, 0x7B, 0x20, 0x7B, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x1A, 0x11, 0x00, 0x00, 0x00, 0x1F, 0x20, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x10, 0x11, 0x11, 0x1E, 0x1E, 0x1A,
  0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B,
  0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A,
  0x1B, 0x1A, 0x11, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x1F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1A, 0x11, 0x1F, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x10,
  0x11, 0x11, 0x1E, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x24, 0x1B,
  0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x24, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x10, 0x20, 0x20, 0x7B, 0x20, 0x1F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1A, 0x1F, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20,
  0x20, 0x20, 0x10, 0x11, 0x11, 0x1E, 0x11, 0x1E, 0x1A, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A, 0x1E, 0x10, 0x20,
  0x7B, 0x20, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x20, 0x1F, 0x7B,
  0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x10, 0x10, 0x11, 0x11, 0x1E, 0x11,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1A,
  0x1A, 0x22, 0x20, 0x7B, 0x20, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1B, 0x1F, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x10,
  0x10, 0x11, 0x11, 0x1E, 0x11, 0x1E, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A,
  0x1B, 0x1A, 0x1A, 0x1E, 0x22, 0x20, 0x20, 0x1F, 0x1F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1B, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B,
  0x20, 0x7B, 0x20, 0x10, 0x10, 0x10, 0x1E, 0x11, 0x1E, 0x11, 0x1E, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B, 0x1A, 0x1B,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1E, 0x22, 0x20, 0x20, 0x1F, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x10, 0x20, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20, 0x10, 0x10, 0x10, 0x11,
  0x11, 0x1E, 0x11, 0x1E, 0x1E, 0x1E, 0x1E, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
  0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1E, 0x1E, 0x1E, 0x1E, 0x22, 0x22, 0x20,
  0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1A, 0x1B, 0x20, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20,
  0x20, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x1E, 0x11, 0x1E, 0x1E,
  0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x22,
  0x22, 0x22, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1A, 0x20, 0x20, 0x20, 0x7B, 0x20,
  0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20, 0x20, 0x10, 0x10, 0x10, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x22,
  0x11, 0x22, 0x22, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x11,
  0x1F, 0x20, 0x20, 0x7B, 0x20, 0x7B, 0x20, 0x20, 0x20, 0x1F, 0x20, 0x20,
  0x10, 0x11, 0x7B, 0x10, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x00, 0x10, 0x10,
  0x10, 0x10, 0x1F, 0x1F, 0x1F, 0x1F, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1A, 0x1A, 0x1F, 0x1F, 0x20, 0x20, 0x20, 0x20, 0x1F,
  0x1F, 0x00, 0x00, 0x22, 0x11, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x1F, 0x11, 0x1F, 0x11, 0x1F, 0x11,
  0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x1A, 0x10, 0x10,
  0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x22, 0x1A, 0x1A, 0x00, 0x1A, 0x1A,
  0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x11, 0x11,
  0x11, 0x11, 0x11, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x10, 0x10, 0x1A, 0x1A,
  0x00, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11,
  0x11, 0x1A, 0x11, 0x1A, 0x11, 0x1A, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x1A, 0x1A, 0x00, 0x00, 0x1A, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x1A, 0x11, 0x0C, 0x11, 0x1A, 0x11, 0x0C, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x1A, 0x1A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x1B, 0x11, 0x1B, 0x11, 0x0C, 0x10, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x1A, 0x1A, 0x1A, 0x1A,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A,
  0x1A, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask3RB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFC, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xE1, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFC, 0xA0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFE, 0xD0, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x58, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xC8, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFD, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x1C, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x3E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x3F, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x7F, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x7F, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xF1, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xE7, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x7F, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x3E, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x1C, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xBF, 0xFC, 0x00, 0x00, 0x00, 0x1F, 0xF9, 0xFE,
  0x0F, 0xF8, 0x00, 0x00, 0x00, 0x0F, 0xE3, 0xB8, 0x1F, 0xF8, 0x00, 0x00,
  0x00, 0x03, 0x8F, 0x60, 0x3F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xC0,
  0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x11, 0x80, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite4LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x25,
  0x25, 0x25, 0x00, 0x25, 0x25, 0x25, 0x25, 0x00, 0x25, 0x25, 0x25, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x26, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x25, 0x25,
  0x00, 0x25, 0x27, 0x27, 0x27, 0x25, 0x25, 0x27, 0x27, 0x27, 0x00, 0x25,
  0x27, 0x27, 0x00, 0x25, 0x25, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x26, 0x26, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00,
  0x25, 0x27, 0x27, 0x27, 0x25, 0x27, 0x27, 0x27, 0x27, 0x00, 0x27, 0x27,
  0x27, 0x27, 0x00, 0x27, 0x27, 0x27, 0x00, 0x25, 0x27, 0x00, 0x25, 0x25,
  0x00, 0x00, 0x00, 0x00, 0x29, 0x28, 0x2A, 0x2A, 0x2A, 0x28, 0x28, 0x28,
  0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x25, 0x25, 0x27, 0x27, 0x27, 0x27, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x29, 0x29, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x27,
  0x27, 0x00, 0x27, 0x27, 0x27, 0x2B, 0x2B, 0x29, 0x2A, 0x2A, 0x2A, 0x2A,
  0x29, 0x29, 0x28, 0x28, 0x28, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x25, 0x27, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x29, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2A,
  0x2A, 0x29, 0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x29, 0x28, 0x28, 0x26, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x29, 0x29, 0x29, 0x2B,
  0x2B, 0x2B, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x29, 0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x29,
  0x28, 0x28, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x28,
  0x28, 0x28, 0x2A, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x2C,
  0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29,
  0x29, 0x29, 0x2A, 0x2D, 0x29, 0x28, 0x28, 0x26, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x28, 0x28, 0x1B, 0x1B, 0x1B, 0x1B, 0x28, 0x29, 0x2D, 0x2D, 0x2D, 0x28,
  0x28, 0x28, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29,
  0x2D, 0x2D, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29,
  0x29, 0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x28, 0x28, 0x26,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x28, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x29,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x28, 0x29, 0x28, 0x2A, 0x2A,
  0x2A, 0x2C, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x29, 0x29, 0x29,
  0x29, 0x29, 0x28, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x29, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x28, 0x28, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x29, 0x29,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x26, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x7B, 0x7B, 0x1B, 0x1B, 0x28, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2A, 0x2C, 0x2C,
  0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x29, 0x28, 0x26,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2B, 0x28, 0x1B, 0x1B, 0x1B, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x28,
  0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29,
  0x28, 0x2D, 0x2D, 0x2A, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x29, 0x29, 0x2D,
  0x2D, 0x28, 0x28, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2B, 0x28, 0x1B, 0x1B, 0x1B, 0x1B, 0x7B, 0x7B, 0x7B,
  0x7B, 0x7B, 0x1B, 0x28, 0x28, 0x28, 0x28, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E,
  0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x29, 0x28,
  0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x2C, 0x2C, 0x2C, 0x29,
  0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x28, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x28, 0x2D, 0x2D, 0x2D, 0x2E, 0x2D,
  0x2E, 0x2D, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2D, 0x2E, 0x2D,
  0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x29,
  0x29, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x28, 0x26, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x28, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x2E, 0x2D, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2C, 0x2C, 0x29, 0x29, 0x29, 0x2D,
  0x2D, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x28, 0x7B, 0x7B, 0x1B, 0x1B, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B,
  0x1B, 0x28, 0x28, 0x28, 0x28, 0x1B, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x29, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x2D, 0x2D,
  0x2D, 0x2D, 0x29, 0x29, 0x26, 0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2B, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x1B, 0x7B, 0x7B, 0x7B, 0x1B, 0x1B,
  0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x28, 0x28, 0x28, 0x2F, 0x1B, 0x2F, 0x2D,
  0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x28, 0x29, 0x28,
  0x29, 0x28, 0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x00, 0x00, 0x2B, 0x2B,
  0x2C, 0x2C, 0x2C, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x7B, 0x7B,
  0x7B, 0x7B, 0x7B, 0x1B, 0x7B, 0x7B, 0x7B, 0x1B, 0x28, 0x28, 0x28, 0x2F,
  0x1B, 0x2F, 0x1B, 0x2F, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2C, 0x2C, 0x00, 0x00,
  0x2B, 0x2B, 0x2C, 0x2C, 0x28, 0x28, 0x1B, 0x2C, 0x00, 0x00, 0x00, 0x00,
  0x2B, 0x1B, 0x7B, 0x2F, 0x2F, 0x7B, 0x7B, 0x1B, 0x7B, 0x7B, 0x7B, 0x1B,
  0x28, 0x2D, 0x2F, 0x2F, 0x1B, 0x2F, 0x1B, 0x2F, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x29,
  0x2C, 0x2C, 0x2C, 0x2B, 0x2C, 0x2C, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B,
  0x00, 0x00, 0x00, 0x2B, 0x28, 0x7B, 0x2F, 0x7B, 0x7B, 0x2F, 0x7B, 0x1B,
  0x7B, 0x7B, 0x7B, 0x1B, 0x2D, 0x28, 0x2F, 0x1B, 0x2F, 0x1B, 0x2F, 0x1B,
  0x2F, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2E, 0x2E, 0x2D,
  0x2E, 0x2D, 0x2E, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x1B, 0x2C, 0x00, 0x00, 0x00, 0x2F, 0x1B, 0x7B, 0x2F, 0x7B,
  0x7B, 0x2F, 0x7B, 0x1B, 0x7B, 0x7B, 0x1B, 0x28, 0x28, 0x2F, 0x1B, 0x2F,
  0x1B, 0x2F, 0x1B, 0x2F, 0x1B, 0x2D, 0x2D, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2C, 0x2C,
  0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x00, 0x00, 0x00, 0x2F,
  0x2F, 0x7B, 0x7B, 0x2F, 0x2F, 0x7B, 0x7B, 0x1B, 0x7B, 0x7B, 0x1B, 0x28,
  0x28, 0x2F, 0x2F, 0x1B, 0x2F, 0x2F, 0x1B, 0x2F, 0x1B, 0x2F, 0x2D, 0x2E,
  0x2D, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2C, 0x2C, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x1B, 0x2C,
  0x00, 0x00, 0x2F, 0x2F, 0x2F, 0x2F, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B,
  0x7B, 0x7B, 0x1B, 0x2D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x1B, 0x2F, 0x1B,
  0x2F, 0x1B, 0x2C, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x29, 0x29, 0x29, 0x29,
  0x29, 0x29, 0x29, 0x2B, 0x00, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x7B, 0x7B, 0x7B, 0x1B, 0x7B, 0x1B, 0x28, 0x28, 0x2F, 0x2B, 0x2B, 0x2F,
  0x2F, 0x2F, 0x1B, 0x2F, 0x1B, 0x2F, 0x2B, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2C, 0x2C,
  0x29, 0x28, 0x28, 0x28, 0x28, 0x28, 0x1B, 0x2C, 0x00, 0x00, 0x00, 0x2F,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x7B, 0x7B, 0x1B, 0x7B, 0x1B, 0x28, 0x2D,
  0x2F, 0x2B, 0x2B, 0x2B, 0x2F, 0x2F, 0x2F, 0x1B, 0x2F, 0x1B, 0x2B, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x29, 0x28,
  0x29, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x2C, 0x2C,
  0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B,
  0x2F, 0x2F, 0x00, 0x00, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x7B, 0x7B,
  0x1B, 0x1B, 0x28, 0x28, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2F, 0x1B, 0x2F,
  0x1B, 0x2C, 0x2C, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29,
  0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2B, 0x2C, 0x2C, 0x2C, 0x29, 0x28, 0x28,
  0x28, 0x28, 0x1B, 0x2C, 0x00, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x2F, 0x2F, 0x7B, 0x7B, 0x7B, 0x1B, 0x28, 0x2F, 0x2B, 0x2B, 0x2B, 0x2B,
  0x2B, 0x2F, 0x2F, 0x1B, 0x2B, 0x2C, 0x2C, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x29, 0x29, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2C, 0x00, 0x00, 0x2B,
  0x2C, 0x2C, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2B, 0x00, 0x28, 0x1B, 0x2F,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x7B, 0x7B, 0x1B, 0x28, 0x2B,
  0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2F, 0x2F, 0x2B, 0x2B, 0x2B, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x29, 0x29, 0x29, 0x29, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2C,
  0x2C, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2C, 0x2C, 0x28, 0x28, 0x28, 0x2C,
  0x00, 0x00, 0x29, 0x1B, 0x1B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x28,
  0x28, 0x2D, 0x2D, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2C, 0x2C, 0x2C, 0x2B,
  0x2B, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x29, 0x28, 0x29, 0x29, 0x29, 0x29, 0x29, 0x28, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2A, 0x2C, 0x2C, 0x2C, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2B,
  0x2C, 0x2C, 0x2C, 0x2B, 0x00, 0x00, 0x00, 0x2B, 0x29, 0x1B, 0x1B, 0x1B,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x29, 0x29, 0x29, 0x29, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x29, 0x29, 0x29, 0x29, 0x29, 0x28, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2A, 0x29, 0x2C, 0x2C, 0x2A, 0x2A, 0x2C, 0x2E, 0x2E, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2B, 0x29, 0x29, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x29, 0x29, 0x29,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2A, 0x28, 0x29, 0x29, 0x2C, 0x2A, 0x2A, 0x2A, 0x2C, 0x2E,
  0x2A, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2C, 0x2C, 0x28, 0x28, 0x28, 0x28,
  0x1B, 0x1B, 0x29, 0x29, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x28, 0x29, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2C, 0x2D, 0x2E, 0x2A, 0x2E, 0x2A, 0x2E, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2C,
  0x2C, 0x28, 0x28, 0x28, 0x28, 0x29, 0x1B, 0x1B, 0x29, 0x29, 0x29, 0x28,
  0x29, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2D, 0x26, 0x2D, 0x2E, 0x2E, 0x2A, 0x2E,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2C, 0x2C, 0x28, 0x28, 0x28, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29,
  0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2C, 0x2C, 0x2D, 0x26, 0x2D, 0x2D,
  0x26, 0x2A, 0x26, 0x2A, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2B, 0x2C,
  0x2C, 0x2C, 0x28, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x28,
  0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2C, 0x2E, 0x2D, 0x2D, 0x2E,
  0x26, 0x2D, 0x2D, 0x26, 0x2D, 0x2D, 0x26, 0x2A, 0x2E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x28, 0x2C, 0x2C, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2C, 0x2C, 0x2E, 0x2A,
  0x2D, 0x2E, 0x26, 0x26, 0x2D, 0x2D, 0x26, 0x2D, 0x2D, 0x26, 0x2D, 0x2E,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2B, 0x2B,
  0x28, 0x28, 0x2C, 0x2B, 0x2C, 0x2B, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2C, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2E, 0x26, 0x26, 0x2D, 0x2D, 0x2D, 0x26, 0x2D, 0x2D,
  0x26, 0x2D, 0x2D, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2B, 0x28, 0x28, 0x2C, 0x2C, 0x2B, 0x2B, 0x2B, 0x2C,
  0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C,
  0x2A, 0x2A, 0x2E, 0x2E, 0x2E, 0x2E, 0x26, 0x26, 0x2A, 0x2A, 0x2A, 0x26,
  0x26, 0x2D, 0x2D, 0x26, 0x2D, 0x2D, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x28, 0x28, 0x2C,
  0x2C, 0x2B, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x26, 0x26, 0x26, 0x2D, 0x2D, 0x26, 0x26, 0x2D, 0x2D, 0x2E, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2C, 0x28, 0x28, 0x2C, 0x2C, 0x2B, 0x2B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x26, 0x2A, 0x2A, 0x2A, 0x26, 0x26, 0x2D, 0x2D, 0x2E,
  0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x28, 0x28, 0x2C, 0x2C, 0x2B,
  0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0x2E, 0x2E, 0x2E, 0x2A, 0x2A, 0x2E, 0x2E, 0x2E, 0x2A,
  0x2A, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x28, 0x28, 0x28, 0x2C, 0x2C, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2A, 0x2A, 0x2A, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask4LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3D, 0xEE, 0x00, 0x0C, 0x00,
  0x00, 0x00, 0x07, 0x7F, 0xDD, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x2F, 0xFB,
  0xDD, 0xB0, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xBF, 0xFF, 0xC0,
  0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8E,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF9, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x7F,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0xFE, 0x00,
  0x3F, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x07, 0xFF, 0xF8, 0x00,
  0x00, 0x00, 0x3F, 0x80, 0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x0F, 0xC0,
  0x01, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite4LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x25,
  0x25, 0x25, 0x00, 0x25, 0x25, 0x25, 0x25, 0x00, 0x25, 0x25, 0x25, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x25, 0x25,
  0x00, 0x25, 0x27, 0x27, 0x27, 0x25, 0x25, 0x27, 0x27, 0x27, 0x00, 0x25,
  0x27, 0x27, 0x00, 0x25, 0x25, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x26, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00,
  0x25, 0x27, 0x27, 0x27, 0x00, 0x27, 0x27, 0x27, 0x27, 0x00, 0x27, 0x27,
  0x27, 0x27, 0x00, 0x27, 0x27, 0x27, 0x00, 0x25, 0x27, 0x00, 0x25, 0x25,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x26, 0x26, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x25, 0x27, 0x25, 0x27, 0x27, 0x27, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x29, 0x29, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x27,
  0x27, 0x00, 0x27, 0x27, 0x27, 0x2B, 0x2B, 0x29, 0x28, 0x2A, 0x2A, 0x2A,
  0x28, 0x28, 0x28, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x25, 0x27, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x29, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x29, 0x2A,
  0x2A, 0x2A, 0x2A, 0x29, 0x29, 0x28, 0x28, 0x28, 0x26, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x29, 0x29, 0x2B,
  0x2B, 0x2B, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x29, 0x28,
  0x28, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x28,
  0x28, 0x28, 0x2A, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x2C,
  0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x29, 0x29, 0x28, 0x28, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x28, 0x28, 0x1B, 0x1B, 0x1B, 0x1B, 0x28, 0x29, 0x2D, 0x2D, 0x2D, 0x28,
  0x28, 0x28, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29,
  0x2D, 0x2D, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x29, 0x29, 0x29, 0x2A, 0x2D, 0x29, 0x28, 0x28, 0x26, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x28, 0x28, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x29,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x28, 0x29, 0x28, 0x2A, 0x2A,
  0x2A, 0x2C, 0x2C, 0x29, 0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29,
  0x28, 0x28, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x29, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x28, 0x28, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29,
  0x29, 0x29, 0x29, 0x29, 0x29, 0x28, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x1B,
  0x1B, 0x1B, 0x1B, 0x7B, 0x7B, 0x1B, 0x1B, 0x28, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2A, 0x2C, 0x2C,
  0x2C, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x26, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x28, 0x1B, 0x1B, 0x1B, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x28,
  0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29,
  0x28, 0x2D, 0x2D, 0x2A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x29,
  0x29, 0x28, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x1B, 0x1B, 0x1B, 0x7B, 0x7B, 0x7B,
  0x7B, 0x7B, 0x1B, 0x28, 0x28, 0x28, 0x28, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E,
  0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x29, 0x28,
  0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x2C, 0x2C, 0x2C, 0x29,
  0x29, 0x29, 0x2D, 0x2D, 0x28, 0x28, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x1B, 0x1B, 0x1B,
  0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x28, 0x2D, 0x2D, 0x2D, 0x2E, 0x2D,
  0x2E, 0x2D, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2D, 0x2E, 0x2D,
  0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x29,
  0x29, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x26, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28,
  0x1B, 0x1B, 0x1B, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x2E, 0x2D, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2C, 0x2C, 0x29, 0x29, 0x29, 0x2D,
  0x2D, 0x26, 0x00, 0x00, 0x00, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x28, 0x7B, 0x7B, 0x1B, 0x1B, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B,
  0x1B, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x29, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x2D, 0x2D,
  0x2D, 0x2D, 0x29, 0x29, 0x26, 0x00, 0x00, 0x2B, 0x2B, 0x2C, 0x2B, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x7B, 0x7B, 0x7B, 0x1B, 0x1B,
  0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x28, 0x29, 0x28,
  0x29, 0x28, 0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x00, 0x00, 0x2B, 0x2C,
  0x2C, 0x1B, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x7B, 0x7B,
  0x7B, 0x7B, 0x7B, 0x1B, 0x7B, 0x7B, 0x7B, 0x1B, 0x28, 0x28, 0x28, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2C, 0x2C, 0x00, 0x00,
  0x2B, 0x2B, 0x2C, 0x28, 0x28, 0x29, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1B, 0x7B, 0x2F, 0x2F, 0x7B, 0x7B, 0x1B, 0x7B, 0x7B, 0x7B, 0x1B,
  0x28, 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x29,
  0x2C, 0x2C, 0x2C, 0x2B, 0x2C, 0x2C, 0x29, 0x29, 0x29, 0x1B, 0x2C, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x28, 0x7B, 0x2F, 0x7B, 0x7B, 0x2F, 0x7B, 0x1B,
  0x7B, 0x7B, 0x7B, 0x1B, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2F, 0x2F,
  0x2F, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2E, 0x2E, 0x2D,
  0x2E, 0x2D, 0x2E, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x29, 0x28, 0x28,
  0x28, 0x29, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x1B, 0x7B, 0x2F, 0x7B,
  0x7B, 0x2F, 0x7B, 0x1B, 0x7B, 0x7B, 0x1B, 0x28, 0x28, 0x28, 0x28, 0x2F,
  0x2F, 0x2F, 0x1B, 0x1B, 0x1B, 0x1B, 0x2D, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2C, 0x2C,
  0x29, 0x29, 0x29, 0x29, 0x29, 0x1B, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x2F,
  0x2F, 0x7B, 0x7B, 0x2F, 0x2F, 0x7B, 0x7B, 0x1B, 0x7B, 0x7B, 0x1B, 0x28,
  0x28, 0x28, 0x2F, 0x2F, 0x2F, 0x1B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2E,
  0x2D, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2C, 0x2C, 0x28, 0x28, 0x28, 0x28, 0x28, 0x1B, 0x2C, 0x00,
  0x00, 0x00, 0x2F, 0x2F, 0x2F, 0x2F, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B,
  0x7B, 0x7B, 0x1B, 0x28, 0x28, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x1B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x2F, 0x2C, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x29, 0x29, 0x29, 0x29,
  0x29, 0x29, 0x2B, 0x00, 0x00, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x7B, 0x7B, 0x7B, 0x1B, 0x7B, 0x1B, 0x28, 0x28, 0x2F, 0x2F, 0x2F, 0x2F,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2B, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2C, 0x2C,
  0x29, 0x28, 0x29, 0x29, 0x29, 0x1B, 0x2C, 0x00, 0x01, 0x2F, 0x2F, 0x2F,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x7B, 0x7B, 0x1B, 0x7B, 0x1B, 0x28, 0x28,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x2F,
  0x2B, 0x2B, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x29, 0x28,
  0x29, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x2C, 0x2C,
  0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x29, 0x28, 0x28, 0x28, 0x29, 0x2B, 0x00,
  0x00, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x7B, 0x7B,
  0x1B, 0x1B, 0x28, 0x2F, 0x2B, 0x2B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2C, 0x2C, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29,
  0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x00, 0x2C, 0x2C, 0x2C, 0x28, 0x29, 0x29,
  0x29, 0x1B, 0x2C, 0x00, 0x00, 0x28, 0x1B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x2F, 0x2F, 0x7B, 0x7B, 0x7B, 0x1B, 0x28, 0x2F, 0x2B, 0x2B, 0x2B, 0x2F,
  0x2F, 0x2F, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x2F, 0x2C, 0x2C, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x29, 0x29, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2C, 0x00, 0x00, 0x2B,
  0x2C, 0x2C, 0x2C, 0x28, 0x28, 0x29, 0x2B, 0x00, 0x00, 0x00, 0x29, 0x1B,
  0x1B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x7B, 0x7B, 0x1B, 0x28, 0x2F,
  0x2B, 0x2B, 0x2B, 0x2B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2C,
  0x2B, 0x2B, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x29, 0x29, 0x29, 0x29, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2C,
  0x2C, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2C, 0x2C, 0x28, 0x2C, 0x00,
  0x00, 0x00, 0x00, 0x2B, 0x29, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x28,
  0x28, 0x2D, 0x2D, 0x7B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2F, 0x2F, 0x2F, 0x1B,
  0x1B, 0x2F, 0x2B, 0x2B, 0x2B, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x29, 0x28, 0x29, 0x29, 0x29, 0x29, 0x29, 0x28, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2A, 0x2C, 0x2C, 0x2C, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B,
  0x2B, 0x2C, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x29, 0x1B, 0x1B,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2D, 0x2D, 0x7B, 0x2B, 0x2B, 0x2B, 0x2B,
  0x2F, 0x2F, 0x1B, 0x2F, 0x2C, 0x2B, 0x2B, 0x2C, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x29, 0x29, 0x29, 0x29, 0x29, 0x28, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2A, 0x29, 0x2C, 0x2C, 0x2A, 0x2A, 0x2C, 0x2E, 0x2E, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2B, 0x29, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x29, 0x29, 0x29,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2F, 0x2F, 0x2D, 0x29, 0x29, 0x28, 0x29, 0x29,
  0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2A, 0x28, 0x29, 0x29, 0x2C, 0x2A, 0x2A, 0x2A, 0x2C, 0x26,
  0x2A, 0x2E, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2C, 0x2C, 0x28, 0x28, 0x28, 0x28,
  0x1B, 0x1B, 0x29, 0x29, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x28, 0x29, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2C, 0x2D, 0x26, 0x2A, 0x2E, 0x2E, 0x2A, 0x2E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2C,
  0x2C, 0x28, 0x28, 0x28, 0x28, 0x29, 0x1B, 0x1B, 0x29, 0x29, 0x29, 0x28,
  0x29, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2D, 0x2E, 0x2D, 0x26, 0x2E, 0x26, 0x2A,
  0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2C, 0x2C, 0x28, 0x28, 0x28, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29,
  0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2C, 0x2C, 0x2D, 0x2E, 0x2D, 0x2D,
  0x2D, 0x26, 0x2A, 0x26, 0x2A, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2B, 0x2C,
  0x2C, 0x2C, 0x28, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x28,
  0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2C, 0x2E, 0x2D, 0x2D, 0x2E,
  0x2E, 0x26, 0x2D, 0x2D, 0x26, 0x2D, 0x2D, 0x26, 0x2A, 0x2E, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x28, 0x2C, 0x2C, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2C, 0x2C, 0x2E, 0x2A,
  0x2D, 0x2E, 0x2E, 0x26, 0x26, 0x2D, 0x2D, 0x26, 0x2D, 0x2D, 0x26, 0x2D,
  0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2B, 0x2B,
  0x28, 0x28, 0x2B, 0x2B, 0x2C, 0x2B, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2C, 0x2C,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2E, 0x26, 0x26, 0x2D, 0x2D, 0x2D, 0x26, 0x2D,
  0x2D, 0x26, 0x2D, 0x2D, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2B, 0x28, 0x28, 0x2C, 0x2B, 0x2B, 0x2B, 0x2B, 0x2C,
  0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C,
  0x2C, 0x2A, 0x2A, 0x2E, 0x2E, 0x2E, 0x2E, 0x26, 0x26, 0x2A, 0x2A, 0x2A,
  0x26, 0x26, 0x2D, 0x2D, 0x26, 0x2D, 0x2D, 0x2E, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x2C, 0x2C,
  0x2B, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2E, 0x2E, 0x2E, 0x2E, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x26, 0x26, 0x26, 0x2D, 0x2D, 0x26, 0x26, 0x2D, 0x2D, 0x2E, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2C, 0x28, 0x28, 0x2C, 0x2C, 0x2B, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x26, 0x2A, 0x2A, 0x2A, 0x26, 0x26, 0x2D, 0x2D,
  0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x2C, 0x2C, 0x2B, 0x2B, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2E, 0x2E, 0x2E, 0x2E, 0x2A, 0x2A, 0x2E, 0x2E, 0x2E,
  0x2A, 0x2A, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x28,
  0x28, 0x2C, 0x2C, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2A, 0x2A, 0x2A, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask4LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3D, 0xEE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x07, 0x7F, 0xDD, 0xC0, 0x18, 0x00, 0x00, 0x00, 0x2F, 0x7B,
  0xDD, 0xB0, 0x7E, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xBF, 0xFF, 0x00,
  0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC4, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9E,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3E, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0xFE, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF9, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x7E,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x1E, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x04, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFC, 0x00,
  0x0F, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x03, 0xFF, 0xFC, 0x00,
  0x00, 0x00, 0x7E, 0x00, 0x01, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x3F, 0x00,
  0x00, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite4RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x26, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x25, 0x25,
  0x00, 0x25, 0x25, 0x25, 0x25, 0x00, 0x25, 0x25, 0x25, 0x25, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x26, 0x28, 0x28,
  0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x25,
  0x25, 0x00, 0x27, 0x27, 0x25, 0x00, 0x27, 0x27, 0x27, 0x25, 0x25, 0x27,
  0x27, 0x27, 0x25, 0x00, 0x25, 0x25, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26,
  0x28, 0x28, 0x28, 0x2A, 0x2A, 0x2A, 0x28, 0x29, 0x00, 0x00, 0x00, 0x00,
  0x25, 0x25, 0x00, 0x27, 0x25, 0x00, 0x27, 0x27, 0x27, 0x00, 0x27, 0x27,
  0x27, 0x27, 0x00, 0x27, 0x27, 0x27, 0x27, 0x25, 0x27, 0x27, 0x27, 0x25,
  0x00, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x26, 0x28, 0x28, 0x28, 0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2A,
  0x29, 0x2B, 0x2B, 0x27, 0x27, 0x27, 0x00, 0x27, 0x27, 0x2B, 0x2B, 0x2B,
  0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x29, 0x27, 0x27, 0x27, 0x27, 0x25, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x28, 0x28, 0x29, 0x2A, 0x2A, 0x2A,
  0x29, 0x29, 0x29, 0x2A, 0x2A, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
  0x2B, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x27, 0x25,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x28, 0x28,
  0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x29, 0x29, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2B, 0x2B, 0x2B,
  0x2B, 0x29, 0x29, 0x29, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x26, 0x28, 0x28, 0x29, 0x2D, 0x2A, 0x29, 0x29, 0x29, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x29, 0x28, 0x29,
  0x28, 0x29, 0x28, 0x29, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2B, 0x2A, 0x28, 0x28, 0x28, 0x29, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x26, 0x28, 0x28, 0x29, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2D, 0x2D, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28,
  0x29, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x29, 0x28, 0x1B, 0x1B,
  0x1B, 0x1B, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x28, 0x29, 0x29,
  0x29, 0x29, 0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2A,
  0x2A, 0x2A, 0x28, 0x29, 0x28, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x29, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x28, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x26, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x29, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x28, 0x28, 0x29, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x26, 0x28, 0x29, 0x29, 0x29, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2C, 0x2C, 0x2C, 0x2A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x1B, 0x1B, 0x7B,
  0x7B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x28, 0x28, 0x2D,
  0x2D, 0x29, 0x29, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2A, 0x2D, 0x2D, 0x28,
  0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D,
  0x28, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x1B, 0x1B, 0x1B, 0x28, 0x2B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x26, 0x28, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x2C, 0x2C, 0x2C,
  0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x2E, 0x2D,
  0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D,
  0x2E, 0x28, 0x28, 0x28, 0x28, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B,
  0x1B, 0x1B, 0x1B, 0x28, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x28, 0x29, 0x29, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2C, 0x29, 0x29, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2E,
  0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2D, 0x2D, 0x28, 0x1B, 0x7B,
  0x7B, 0x7B, 0x7B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x28, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x2D,
  0x2D, 0x29, 0x29, 0x29, 0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2E, 0x2D, 0x2E, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x28, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x1B, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2B,
  0x00, 0x00, 0x00, 0x26, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x2D,
  0x2D, 0x2D, 0x2D, 0x28, 0x29, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x1B, 0x28, 0x28, 0x28, 0x28, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B,
  0x1B, 0x1B, 0x1B, 0x7B, 0x7B, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2B, 0x2C, 0x2C, 0x2C, 0x2B, 0x2B, 0x00, 0x00, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2C, 0x2C, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2F, 0x1B, 0x2F, 0x28, 0x28, 0x28, 0x1B,
  0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x1B, 0x7B, 0x7B, 0x7B, 0x1B, 0x2B, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2C, 0x1B, 0x28, 0x28, 0x2C, 0x2C, 0x2B, 0x2B,
  0x00, 0x00, 0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2F, 0x1B, 0x2F, 0x1B,
  0x2F, 0x28, 0x28, 0x28, 0x1B, 0x7B, 0x7B, 0x7B, 0x1B, 0x7B, 0x7B, 0x7B,
  0x7B, 0x7B, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x29, 0x29, 0x29,
  0x29, 0x29, 0x2C, 0x2C, 0x2B, 0x2C, 0x2C, 0x2C, 0x29, 0x29, 0x28, 0x29,
  0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x2F, 0x1B, 0x2F, 0x1B, 0x2F, 0x2F, 0x2D, 0x28, 0x1B, 0x7B, 0x7B, 0x7B,
  0x1B, 0x7B, 0x7B, 0x2F, 0x2F, 0x7B, 0x1B, 0x2B, 0x00, 0x00, 0x00, 0x00,
  0x2C, 0x1B, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C,
  0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x2D, 0x2F, 0x1B, 0x2F, 0x1B, 0x2F, 0x1B, 0x2F, 0x28, 0x2D,
  0x1B, 0x7B, 0x7B, 0x7B, 0x1B, 0x7B, 0x2F, 0x7B, 0x7B, 0x2F, 0x7B, 0x28,
  0x2B, 0x00, 0x00, 0x00, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2D, 0x2D, 0x1B, 0x2F, 0x1B, 0x2F, 0x1B,
  0x2F, 0x1B, 0x2F, 0x28, 0x28, 0x1B, 0x7B, 0x7B, 0x1B, 0x7B, 0x2F, 0x7B,
  0x7B, 0x2F, 0x7B, 0x1B, 0x2F, 0x00, 0x00, 0x00, 0x2C, 0x1B, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2F, 0x1B,
  0x2F, 0x1B, 0x2F, 0x2F, 0x1B, 0x2F, 0x2F, 0x28, 0x28, 0x1B, 0x7B, 0x7B,
  0x1B, 0x7B, 0x7B, 0x2F, 0x2F, 0x7B, 0x7B, 0x2F, 0x2F, 0x00, 0x00, 0x00,
  0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2C, 0x2C, 0x2C, 0x2C,
  0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x2C, 0x1B, 0x2F, 0x1B, 0x2F, 0x1B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x2D, 0x1B, 0x7B, 0x7B, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x2F, 0x2F,
  0x2F, 0x2F, 0x00, 0x00, 0x2C, 0x1B, 0x28, 0x28, 0x28, 0x28, 0x28, 0x29,
  0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2B, 0x2F, 0x1B, 0x2F, 0x1B, 0x2F, 0x2F,
  0x2F, 0x2B, 0x2B, 0x2F, 0x28, 0x28, 0x1B, 0x7B, 0x1B, 0x7B, 0x7B, 0x7B,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x00, 0x2B, 0x29, 0x29, 0x29,
  0x29, 0x29, 0x29, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x29, 0x29,
  0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x29, 0x28, 0x29, 0x28, 0x28,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2B, 0x1B, 0x2F,
  0x1B, 0x2F, 0x2F, 0x2F, 0x2B, 0x2B, 0x2B, 0x2F, 0x2D, 0x28, 0x1B, 0x7B,
  0x1B, 0x7B, 0x7B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x00, 0x00, 0x00,
  0x2C, 0x1B, 0x28, 0x28, 0x28, 0x28, 0x29, 0x2C, 0x2C, 0x2C, 0x2B, 0x2D,
  0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x2C, 0x2C, 0x1B, 0x2F, 0x1B, 0x2F, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
  0x28, 0x28, 0x1B, 0x1B, 0x7B, 0x7B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x00, 0x00, 0x2F, 0x2F, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2C, 0x2C,
  0x2B, 0x00, 0x00, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x29, 0x29,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x2C, 0x2C, 0x2B, 0x1B, 0x2F, 0x2F, 0x2B,
  0x2B, 0x2B, 0x2B, 0x2B, 0x2F, 0x28, 0x1B, 0x7B, 0x7B, 0x7B, 0x2F, 0x2F,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x00, 0x2C, 0x28, 0x28, 0x28,
  0x2C, 0x2C, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x2C, 0x2D, 0x2D, 0x2D,
  0x2D, 0x28, 0x29, 0x29, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2B, 0x2B,
  0x2B, 0x2F, 0x2F, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x28, 0x1B, 0x7B,
  0x7B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x1B, 0x28, 0x00,
  0x2B, 0x2C, 0x2C, 0x2C, 0x2B, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C,
  0x2C, 0x2C, 0x2C, 0x2A, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x29, 0x29, 0x29,
  0x29, 0x29, 0x28, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2B, 0x2B, 0x2C, 0x2C, 0x2C, 0x2B, 0x2B, 0x2B, 0x2B,
  0x2B, 0x2D, 0x2D, 0x28, 0x28, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x1B,
  0x1B, 0x29, 0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0x2E, 0x2C, 0x2A, 0x2A, 0x2C, 0x2C, 0x29, 0x2A, 0x2D,
  0x2D, 0x2D, 0x2D, 0x28, 0x29, 0x29, 0x29, 0x29, 0x29, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x29, 0x29, 0x29, 0x29,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x1B, 0x1B, 0x1B, 0x29, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2E, 0x2A, 0x2E, 0x2C, 0x2A, 0x2A,
  0x2A, 0x2C, 0x29, 0x29, 0x28, 0x2A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29,
  0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x29, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x29, 0x29, 0x2B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2A, 0x2E, 0x2A,
  0x2E, 0x2D, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x28, 0x29, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29,
  0x29, 0x29, 0x1B, 0x1B, 0x28, 0x28, 0x28, 0x28, 0x2C, 0x2C, 0x2B, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2E, 0x2A, 0x2E, 0x2E, 0x2D, 0x26, 0x2D, 0x2C, 0x2C, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x29,
  0x28, 0x29, 0x29, 0x29, 0x1B, 0x1B, 0x29, 0x28, 0x28, 0x28, 0x28, 0x2C,
  0x2C, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2E, 0x2A, 0x26, 0x2A, 0x26, 0x2D, 0x2D, 0x26, 0x2D,
  0x2C, 0x2C, 0x2C, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x28,
  0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28,
  0x29, 0x28, 0x29, 0x28, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x28, 0x28,
  0x28, 0x2C, 0x2C, 0x2B, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2A, 0x26, 0x2D, 0x2D,
  0x26, 0x2D, 0x2D, 0x26, 0x2E, 0x2D, 0x2D, 0x2E, 0x2C, 0x2C, 0x2C, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29,
  0x28, 0x29, 0x28, 0x29, 0x28, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2C, 0x28, 0x2C, 0x2C, 0x2C, 0x2B, 0x2B, 0x2B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2E, 0x2D, 0x26, 0x2D, 0x2D, 0x26, 0x2D, 0x2D, 0x26, 0x26, 0x2E, 0x2D,
  0x2A, 0x2E, 0x2C, 0x2C, 0x2C, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2C, 0x2C, 0x28, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2E, 0x2D, 0x2D, 0x26, 0x2D, 0x2D, 0x26, 0x2D,
  0x2D, 0x2D, 0x26, 0x26, 0x2E, 0x2A, 0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2C,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2C, 0x2B, 0x2C, 0x2B, 0x2C, 0x28, 0x28, 0x2B, 0x2B, 0x2B, 0x2B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2D, 0x2D,
  0x26, 0x2D, 0x2D, 0x26, 0x26, 0x2A, 0x2A, 0x2A, 0x26, 0x26, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2A, 0x2A, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C,
  0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2B, 0x2B, 0x2B, 0x2C, 0x2C, 0x28, 0x28,
  0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0x2D, 0x2D, 0x26, 0x26, 0x2D, 0x2D, 0x26, 0x26, 0x26,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2C,
  0x2C, 0x28, 0x28, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2E, 0x2D, 0x2D, 0x26,
  0x26, 0x2A, 0x2A, 0x2A, 0x26, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2B, 0x2B, 0x2C, 0x2C, 0x28, 0x28, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2E, 0x2E, 0x2A, 0x2A, 0x2E, 0x2E, 0x2E, 0x2A, 0x2A, 0x2E, 0x2E,
  0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2C, 0x2C, 0x28, 0x28, 0x2C, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2E, 0x2A, 0x2A, 0x2A,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2C, 0x2C, 0x28, 0x28, 0x28,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask4RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x77, 0xBC, 0x00, 0x00, 0x00,
  0x00, 0xFC, 0x03, 0xBB, 0xFE, 0xE0, 0x00, 0x00, 0x01, 0xFF, 0x0D, 0xBB,
  0xDF, 0xF4, 0x00, 0x00, 0x03, 0xFF, 0xFD, 0xFF, 0xFF, 0xFE, 0x00, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x71, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xFF, 0x9F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0xFC, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x70, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xFF, 0xFC,
  0x00, 0x7F, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xE0, 0x00, 0xFE, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xC0, 0x01, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x80,
  0x03, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite4RB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x25, 0x25,
  0x00, 0x25, 0x25, 0x25, 0x25, 0x00, 0x25, 0x25, 0x25, 0x25, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26,
  0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x25,
  0x25, 0x00, 0x27, 0x27, 0x25, 0x00, 0x27, 0x27, 0x27, 0x25, 0x25, 0x27,
  0x27, 0x27, 0x25, 0x00, 0x25, 0x25, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x26, 0x26, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x25, 0x25, 0x00, 0x27, 0x25, 0x00, 0x27, 0x27, 0x27, 0x00, 0x27, 0x27,
  0x27, 0x27, 0x00, 0x27, 0x27, 0x27, 0x27, 0x00, 0x27, 0x27, 0x27, 0x25,
  0x00, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x26, 0x28, 0x28, 0x28, 0x2A, 0x2A, 0x2A, 0x28,
  0x29, 0x2B, 0x2B, 0x27, 0x27, 0x27, 0x00, 0x27, 0x27, 0x2B, 0x2B, 0x2B,
  0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x29, 0x27, 0x27, 0x27, 0x25, 0x27, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x28, 0x28, 0x28, 0x29,
  0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
  0x2B, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x27, 0x25,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x28,
  0x28, 0x29, 0x2A, 0x2A, 0x2A, 0x29, 0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2B, 0x2B, 0x2B,
  0x2B, 0x29, 0x29, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x26, 0x28, 0x28, 0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x29, 0x29, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x29, 0x28, 0x29,
  0x28, 0x29, 0x28, 0x29, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2B, 0x2A, 0x28, 0x28, 0x28, 0x29, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x28, 0x28, 0x29, 0x2D, 0x2A, 0x29,
  0x29, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2D, 0x2D, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28,
  0x29, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x29, 0x28, 0x1B, 0x1B,
  0x1B, 0x1B, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x28, 0x28,
  0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x29, 0x29, 0x2C, 0x2C, 0x2A,
  0x2A, 0x2A, 0x28, 0x29, 0x28, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x29, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x28, 0x28, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x26, 0x28, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x28, 0x28, 0x29, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x29, 0x29, 0x2C, 0x2C, 0x2C, 0x2A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x1B, 0x1B, 0x7B,
  0x7B, 0x1B, 0x1B, 0x1B, 0x1B, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x28, 0x29,
  0x29, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2A, 0x2D, 0x2D, 0x28,
  0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D,
  0x28, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x1B, 0x1B, 0x1B, 0x28, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x26, 0x28, 0x28, 0x2D, 0x2D, 0x29, 0x29, 0x29, 0x2C, 0x2C, 0x2C,
  0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x2E, 0x2D,
  0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D,
  0x2E, 0x28, 0x28, 0x28, 0x28, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B,
  0x1B, 0x1B, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x29, 0x29, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2C, 0x29, 0x29, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2E,
  0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2D, 0x2D, 0x2D, 0x28, 0x1B, 0x7B,
  0x7B, 0x7B, 0x7B, 0x1B, 0x1B, 0x1B, 0x1B, 0x28, 0x28, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x00, 0x00, 0x00, 0x26, 0x2D,
  0x2D, 0x29, 0x29, 0x29, 0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2E, 0x2D, 0x2E, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2C, 0x2B,
  0x2B, 0x00, 0x00, 0x26, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x2D,
  0x2D, 0x2D, 0x2D, 0x28, 0x29, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B,
  0x1B, 0x1B, 0x1B, 0x7B, 0x7B, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2C, 0x1B, 0x2C, 0x2C, 0x2B, 0x00, 0x00, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2C, 0x2C, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2D, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x1B,
  0x7B, 0x7B, 0x7B, 0x7B, 0x1B, 0x1B, 0x7B, 0x7B, 0x7B, 0x28, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x29, 0x28, 0x28, 0x2C, 0x2B, 0x2B,
  0x00, 0x00, 0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x28, 0x28, 0x28, 0x1B, 0x7B, 0x7B, 0x7B, 0x1B, 0x7B, 0x7B, 0x7B,
  0x7B, 0x7B, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x1B, 0x29,
  0x29, 0x29, 0x2C, 0x2C, 0x2B, 0x2C, 0x2C, 0x2C, 0x29, 0x29, 0x28, 0x29,
  0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x2D, 0x2D, 0x2D, 0x28, 0x1B, 0x7B, 0x7B, 0x7B,
  0x1B, 0x7B, 0x7B, 0x2F, 0x2F, 0x7B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2B, 0x29, 0x28, 0x28, 0x28, 0x29, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C,
  0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x2F, 0x2F, 0x2F, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2D,
  0x1B, 0x7B, 0x7B, 0x7B, 0x1B, 0x7B, 0x2F, 0x7B, 0x7B, 0x2F, 0x7B, 0x28,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x1B, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2E, 0x2D, 0x2E, 0x2E,
  0x2E, 0x2E, 0x2D, 0x2E, 0x2D, 0x2D, 0x1B, 0x1B, 0x1B, 0x1B, 0x2F, 0x2F,
  0x2F, 0x28, 0x28, 0x28, 0x28, 0x1B, 0x7B, 0x7B, 0x1B, 0x7B, 0x2F, 0x7B,
  0x7B, 0x2F, 0x7B, 0x1B, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x1B, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2D, 0x2E, 0x2F, 0x2F, 0x2F,
  0x2F, 0x2F, 0x1B, 0x2F, 0x2F, 0x2F, 0x28, 0x28, 0x28, 0x1B, 0x7B, 0x7B,
  0x1B, 0x7B, 0x7B, 0x2F, 0x2F, 0x7B, 0x7B, 0x2F, 0x2F, 0x00, 0x00, 0x00,
  0x00, 0x2B, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x2C, 0x2C, 0x2C, 0x2C,
  0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2C,
  0x2F, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x28,
  0x28, 0x1B, 0x7B, 0x7B, 0x1B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x2F, 0x2F,
  0x2F, 0x2F, 0x00, 0x00, 0x00, 0x2C, 0x1B, 0x29, 0x29, 0x29, 0x28, 0x29,
  0x2C, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x2F, 0x2F, 0x2F, 0x2F, 0x28, 0x28, 0x1B, 0x7B, 0x1B, 0x7B, 0x7B, 0x7B,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x00, 0x00, 0x2B, 0x29, 0x28,
  0x28, 0x28, 0x29, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x29, 0x29,
  0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28, 0x28, 0x29, 0x28, 0x29, 0x28, 0x28,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2B, 0x2B, 0x2F, 0x1B, 0x1B, 0x1B,
  0x1B, 0x1B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x28, 0x28, 0x1B, 0x7B,
  0x1B, 0x7B, 0x7B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x00,
  0x00, 0x2C, 0x1B, 0x29, 0x29, 0x29, 0x28, 0x2C, 0x2C, 0x2C, 0x00, 0x2D,
  0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2C, 0x2C,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2B, 0x2B,
  0x2F, 0x28, 0x1B, 0x1B, 0x7B, 0x7B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x2F, 0x2F, 0x2F, 0x00, 0x00, 0x2B, 0x29, 0x28, 0x28, 0x2C, 0x2C, 0x2C,
  0x2B, 0x00, 0x00, 0x2C, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x29, 0x29,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x2C, 0x2C, 0x2F, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x2F, 0x2F,
  0x2F, 0x2B, 0x2B, 0x2B, 0x2F, 0x28, 0x1B, 0x7B, 0x7B, 0x7B, 0x2F, 0x2F,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x1B, 0x28, 0x00, 0x00, 0x2C, 0x28, 0x2C,
  0x2C, 0x2B, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x2C, 0x2D, 0x2D, 0x2D,
  0x2D, 0x28, 0x29, 0x29, 0x29, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2B, 0x2B, 0x2C, 0x2F, 0x2F, 0x2F,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2B, 0x2B, 0x2B, 0x2B, 0x2F, 0x28, 0x1B, 0x7B,
  0x7B, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x1B, 0x1B, 0x29, 0x00, 0x00,
  0x00, 0x2B, 0x2C, 0x2B, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C,
  0x2C, 0x2C, 0x2C, 0x2A, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x29, 0x29, 0x29,
  0x29, 0x29, 0x28, 0x29, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2B,
  0x2B, 0x2B, 0x2F, 0x1B, 0x1B, 0x2F, 0x2F, 0x2F, 0x2B, 0x2B, 0x2B, 0x2B,
  0x7B, 0x2D, 0x2D, 0x28, 0x28, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x29,
  0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0x2E, 0x2C, 0x2A, 0x2A, 0x2C, 0x2C, 0x29, 0x2A, 0x2D,
  0x2D, 0x2D, 0x2D, 0x28, 0x29, 0x29, 0x29, 0x29, 0x29, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x2C, 0x2B, 0x2B, 0x2C, 0x2F, 0x1B, 0x2F, 0x2F,
  0x2B, 0x2B, 0x2B, 0x2B, 0x7B, 0x2D, 0x2D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x1B, 0x1B, 0x29, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2E, 0x2E, 0x2E, 0x2A, 0x26, 0x2C, 0x2A, 0x2A,
  0x2A, 0x2C, 0x29, 0x29, 0x28, 0x2A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29,
  0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x28, 0x29,
  0x29, 0x2D, 0x2F, 0x2F, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29, 0x29, 0x1B,
  0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x29, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2A, 0x2E, 0x2E, 0x2A,
  0x26, 0x2D, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x28, 0x29, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x29, 0x29,
  0x29, 0x29, 0x1B, 0x1B, 0x28, 0x28, 0x28, 0x28, 0x2C, 0x2C, 0x2B, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E,
  0x2A, 0x26, 0x2E, 0x26, 0x2D, 0x2E, 0x2D, 0x2C, 0x2C, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x2D, 0x2D, 0x2D,
  0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x28, 0x29,
  0x28, 0x29, 0x29, 0x29, 0x1B, 0x1B, 0x29, 0x28, 0x28, 0x28, 0x28, 0x2C,
  0x2C, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0x2A, 0x26, 0x2A, 0x26, 0x2D, 0x2D, 0x2D, 0x2E, 0x2D,
  0x2C, 0x2C, 0x2C, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x28,
  0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28,
  0x29, 0x28, 0x29, 0x28, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x28, 0x28,
  0x28, 0x2C, 0x2C, 0x2B, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2A, 0x26, 0x2D, 0x2D, 0x26,
  0x2D, 0x2D, 0x26, 0x2E, 0x2E, 0x2D, 0x2D, 0x2E, 0x2C, 0x2C, 0x2C, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x29, 0x28, 0x29, 0x28, 0x29, 0x28, 0x29,
  0x28, 0x29, 0x28, 0x29, 0x28, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2C, 0x28, 0x2C, 0x2C, 0x2C, 0x2B, 0x2B, 0x2B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E,
  0x2D, 0x26, 0x2D, 0x2D, 0x26, 0x2D, 0x2D, 0x26, 0x26, 0x2E, 0x2E, 0x2D,
  0x2A, 0x2E, 0x2C, 0x2C, 0x2C, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2A, 0x2C, 0x2C, 0x28, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2E, 0x2D, 0x2D, 0x26, 0x2D, 0x2D, 0x26, 0x2D, 0x2D,
  0x2D, 0x26, 0x26, 0x2E, 0x2A, 0x2A, 0x2A, 0x2A, 0x2C, 0x2C, 0x2C, 0x2C,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x2A, 0x2C, 0x2B, 0x2C, 0x2B, 0x2B, 0x28, 0x28, 0x2B, 0x2B, 0x2B, 0x2B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2D, 0x2D, 0x26,
  0x2D, 0x2D, 0x26, 0x26, 0x2A, 0x2A, 0x2A, 0x26, 0x26, 0x2E, 0x2E, 0x2E,
  0x2E, 0x2A, 0x2A, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C,
  0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2B, 0x2B, 0x2B, 0x2B, 0x2C, 0x28, 0x28,
  0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2E, 0x2D, 0x2D, 0x26, 0x26, 0x2D, 0x2D, 0x26, 0x26, 0x26, 0x2A,
  0x2A, 0x2A, 0x2A, 0x2A, 0x2E, 0x2E, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2B,
  0x2C, 0x2C, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2E, 0x2D, 0x2D, 0x26, 0x26,
  0x2A, 0x2A, 0x2A, 0x26, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2B, 0x2B, 0x2C, 0x2C, 0x28, 0x28, 0x2C, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2E, 0x2E, 0x2A, 0x2A, 0x2E, 0x2E, 0x2E, 0x2A, 0x2A, 0x2E, 0x2E, 0x2E,
  0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2B, 0x2C, 0x2C, 0x28, 0x28, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x2E, 0x2A, 0x2A, 0x2A, 0x2E,
  0x2E, 0x2E, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0x2C, 0x2C, 0x28,
  0x28, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask4RB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0xBC, 0x00, 0x00, 0x00,
  0x00, 0x18, 0x03, 0xBB, 0xFE, 0xE0, 0x00, 0x00, 0x00, 0x7E, 0x0D, 0xBB,
  0xDE, 0xF4, 0x00, 0x00, 0x00, 0xFF, 0xFD, 0xFF, 0xFF, 0xFE, 0x00, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x23, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x79, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x7C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x7F, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x7F, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0x9F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0x7E, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0x78, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x20, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0x00, 0x3F, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x7F, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x80, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x00,
  0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite5LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
  0x30, 0x30, 0x12, 0x12, 0x0A, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x30, 0x12, 0x0A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x12, 0x10, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x0A, 0x0A, 0x12, 0x30, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x12, 0x12, 0x10, 0x0B, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x30, 0x0A, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x0B, 0x10, 0x0A, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x31, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10,
  0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x12, 0x10, 0x10, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x31, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10,
  0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x12, 0x10, 0x10, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x0B, 0x0A,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x0A, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x10, 0x0B, 0x0B, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x0A, 0x12, 0x12,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x12, 0x10, 0x10, 0x0B, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x0B, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x0B, 0x11, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0B, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x12,
  0x10, 0x0B, 0x11, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x0B, 0x0B, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x0A,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0B, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0C, 0x0B, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0B, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x31, 0x11, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x10, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x31, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x0B, 0x0A, 0x12,
  0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x13, 0x12, 0x12, 0x12, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x31, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x11, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x31, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x0C, 0x0B, 0x10, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x13, 0x12,
  0x12, 0x12, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x10, 0x13,
  0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x12, 0x10, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x0A, 0x12,
  0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0B, 0x0B, 0x31, 0x10, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x31, 0x10, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x31, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x0B, 0x0B, 0x31, 0x31, 0x31, 0x10, 0x0A, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x31,
  0x31, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x31, 0x31, 0x0C, 0x31,
  0x11, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x12, 0x12, 0x31, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x12, 0x12, 0x10, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0B, 0x31,
  0x31, 0x0C, 0x0C, 0x31, 0x11, 0x13, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x31, 0x31, 0x10, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12,
  0x12, 0x12, 0x12, 0x0B, 0x10, 0x12, 0x12, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x10, 0x0B, 0x31, 0x31, 0x31, 0x0C, 0x0C, 0x11, 0x11, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31,
  0x0C, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x31, 0x10, 0x12, 0x12, 0x0A,
  0x00, 0x00, 0x00, 0x0A, 0x12, 0x10, 0x0B, 0x31, 0x31, 0x0C, 0x0C, 0x0C,
  0x31, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x12,
  0x31, 0x31, 0x0A, 0x31, 0x0C, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x31,
  0x10, 0x12, 0x12, 0x12, 0x0A, 0x00, 0x0A, 0x12, 0x10, 0x10, 0x0B, 0x31,
  0x31, 0x31, 0x0C, 0x0C, 0x11, 0x11, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x13, 0x10, 0x10, 0x13, 0x31, 0x0C, 0x10, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12,
  0x12, 0x12, 0x12, 0x0C, 0x10, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12,
  0x10, 0x0B, 0x0B, 0x31, 0x31, 0x0C, 0x0C, 0x0C, 0x31, 0x11, 0x13, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0C, 0x7B, 0x7B, 0x0C, 0x31,
  0x0C, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0C, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x0B, 0x31, 0x31, 0x31, 0x0C, 0x0C,
  0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x10, 0x24,
  0x7B, 0x7B, 0x24, 0x31, 0x0C, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0C,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0B, 0x0B, 0x31,
  0x31, 0x0C, 0x0C, 0x0C, 0x31, 0x11, 0x13, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x11, 0x11, 0x10, 0x7B, 0x31, 0x31, 0x7B, 0x31, 0x31, 0x10, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12,
  0x12, 0x12, 0x12, 0x0C, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x10, 0x0B, 0x31, 0x31, 0x31, 0x0C, 0x0C, 0x11, 0x11, 0x13, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x11, 0x10, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x31,
  0x31, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0C, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x0A, 0x0A, 0x12, 0x10, 0x0B, 0x31, 0x31, 0x0C, 0x0C, 0x0C,
  0x31, 0x11, 0x10, 0x00, 0x00, 0x00, 0x31, 0x11, 0x11, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x0A, 0x31, 0x31, 0x12, 0x12, 0x12, 0x10, 0x1E, 0x24, 0x24,
  0x15, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0C,
  0x10, 0x12, 0x12, 0x12, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x10, 0x0B, 0x31,
  0x31, 0x31, 0x0C, 0x0C, 0x11, 0x11, 0x0A, 0x00, 0x00, 0x31, 0x15, 0x15,
  0x11, 0x10, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x31, 0x31, 0x12, 0x12, 0x15,
  0x24, 0x31, 0x31, 0x15, 0x31, 0x24, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12,
  0x12, 0x12, 0x12, 0x0C, 0x10, 0x12, 0x12, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x0B, 0x31, 0x31, 0x0C, 0x0C, 0x31, 0x11, 0x13, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x31, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x31,
  0x31, 0x12, 0x15, 0x10, 0x1E, 0x31, 0x1E, 0x1E, 0x24, 0x24, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x31, 0x10, 0x12, 0x12, 0x0A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x31, 0x31, 0x0C, 0x11,
  0x11, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x13, 0x10, 0x12,
  0x12, 0x12, 0x0A, 0x31, 0x31, 0x1E, 0x10, 0x10, 0x15, 0x31, 0x31, 0x1E,
  0x31, 0x15, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x31,
  0x10, 0x12, 0x12, 0x12, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B,
  0x0B, 0x31, 0x31, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x31,
  0x31, 0x31, 0x10, 0x10, 0x12, 0x12, 0x12, 0x24, 0x1E, 0x10, 0x10, 0x11,
  0x10, 0x15, 0x31, 0x1E, 0x24, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12,
  0x12, 0x12, 0x12, 0x0B, 0x10, 0x12, 0x12, 0x12, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x31, 0x10, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x31, 0x10, 0x12, 0x12, 0x24, 0x31,
  0x11, 0x10, 0x12, 0x12, 0x12, 0x31, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x10, 0x12, 0x12, 0x12,
  0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x10, 0x13,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0B,
  0x10, 0x12, 0x31, 0x11, 0x11, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x10, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x10, 0x12, 0x31, 0x31, 0x0B, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x31, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x12, 0x31,
  0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x31, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x12, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B,
  0x31, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x0B, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x0B, 0x31, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x31, 0x0B, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x31, 0x0B, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x31, 0x0B, 0x10, 0x0A, 0x00, 0x12,
  0x12, 0x12, 0x0B, 0x31, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x31, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x31,
  0x10, 0x10, 0x12, 0x00, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x10, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x10,
  0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x13, 0x31, 0x10, 0x10, 0x12, 0x00, 0x00, 0x12, 0x12,
  0x0B, 0x31, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x11, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x12, 0x12, 0x12, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x10, 0x10, 0x10,
  0x12, 0x12, 0x00, 0x00, 0x12, 0x12, 0x31, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x31, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x12, 0x12, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12,
  0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x10, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x11, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x31, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
  0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x12, 0x10, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x0A, 0x10, 0x0A, 0x0A, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x10, 0x10, 0x10, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask5LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x7F, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x03, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x30,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x78, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0xF8, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xFC,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xFC, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x87, 0xFE, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFE,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFE, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xBF, 0xFE, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x8F, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFC,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFC, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x81, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0xF8,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x70, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xC0, 0x30, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x07, 0xDF, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x01, 0xF3, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0xFC, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x7E, 0x7F, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x00, 0x3E, 0x1F, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x0F, 0x07,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x07, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite5LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x30, 0x12, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x12, 0x10, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x0A, 0x0A, 0x12, 0x30, 0x0A, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x12, 0x12, 0x10, 0x0B, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x30, 0x0A, 0x12, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x12, 0x12, 0x10, 0x0B, 0x10, 0x0A, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x0A, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x31, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10,
  0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x12, 0x10, 0x10, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x31, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10,
  0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x12, 0x10, 0x10, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x0B, 0x0A,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x0A, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x10, 0x0B, 0x0B, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x0A, 0x12, 0x12,
  0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x12, 0x10, 0x10, 0x0B, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x0B, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x0B, 0x11, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0B, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x12,
  0x10, 0x0B, 0x11, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x0B, 0x0B, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x0A,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0B, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0C, 0x0B, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0B, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x31, 0x11, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x10, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x31, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x0B, 0x0A, 0x12,
  0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x13, 0x12, 0x12, 0x12, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x31, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x11, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x31, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x0C, 0x0B, 0x10, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x13, 0x12,
  0x12, 0x12, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x10,
  0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x12, 0x10, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x0A, 0x12,
  0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0B, 0x0B, 0x0B, 0x31, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10, 0x31, 0x10, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x31, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x00,
  0x00, 0x00, 0x00, 0x0B, 0x0B, 0x31, 0x31, 0x31, 0x31, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x31,
  0x31, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x31, 0x31, 0x31, 0x0C,
  0x31, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x12, 0x12, 0x31, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x12, 0x12, 0x10, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0B, 0x31,
  0x31, 0x0C, 0x0C, 0x0C, 0x31, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x31, 0x31, 0x10, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12,
  0x12, 0x12, 0x12, 0x0B, 0x10, 0x12, 0x12, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x10, 0x0B, 0x31, 0x31, 0x31, 0x31, 0x0C, 0x0C, 0x11, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31,
  0x0C, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x31, 0x10, 0x12, 0x12, 0x0A,
  0x00, 0x00, 0x00, 0x0A, 0x12, 0x10, 0x0B, 0x31, 0x31, 0x0C, 0x0C, 0x0C,
  0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x12,
  0x31, 0x31, 0x0A, 0x31, 0x0C, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x31,
  0x10, 0x12, 0x12, 0x12, 0x0A, 0x00, 0x0A, 0x12, 0x10, 0x10, 0x0B, 0x31,
  0x31, 0x31, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x13, 0x10, 0x10, 0x13, 0x31, 0x0C, 0x10, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12,
  0x12, 0x12, 0x12, 0x0C, 0x10, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12,
  0x10, 0x0B, 0x0B, 0x31, 0x31, 0x0C, 0x31, 0x31, 0x0C, 0x0C, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x0C, 0x7B, 0x7B, 0x0C, 0x31,
  0x0C, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0C, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x0B, 0x31, 0x31, 0x31, 0x0C, 0x0C,
  0x0C, 0x0C, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x10, 0x24,
  0x7B, 0x7B, 0x24, 0x31, 0x0C, 0x10, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0C,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0B, 0x0B, 0x31,
  0x31, 0x0C, 0x31, 0x31, 0x0C, 0x0C, 0x11, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x11, 0x11, 0x10, 0x7B, 0x31, 0x31, 0x7B, 0x31, 0x31, 0x10, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12,
  0x12, 0x12, 0x12, 0x0C, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x10, 0x0B, 0x31, 0x31, 0x31, 0x0C, 0x0C, 0x0C, 0x0C, 0x31, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x11, 0x10, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x31,
  0x31, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0C, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x0A, 0x0A, 0x12, 0x10, 0x0B, 0x31, 0x31, 0x0C, 0x31, 0x31,
  0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x31, 0x11, 0x11, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x0A, 0x31, 0x31, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0C,
  0x10, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x00, 0x00, 0x0A, 0x10, 0x0B, 0x31,
  0x31, 0x31, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x31, 0x15, 0x15,
  0x11, 0x10, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x31, 0x31, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12,
  0x12, 0x12, 0x12, 0x0C, 0x10, 0x12, 0x12, 0x0A, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x0B, 0x31, 0x31, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x11, 0x31, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x31,
  0x31, 0x12, 0x12, 0x12, 0x10, 0x1E, 0x24, 0x24, 0x15, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x31, 0x10, 0x12, 0x12, 0x0A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x31, 0x31, 0x0C, 0x0C,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x31, 0x31, 0x13, 0x10, 0x12,
  0x12, 0x12, 0x0A, 0x31, 0x31, 0x1E, 0x12, 0x15, 0x24, 0x31, 0x31, 0x15,
  0x31, 0x24, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x31,
  0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0B, 0x31, 0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31,
  0x31, 0x31, 0x10, 0x10, 0x12, 0x12, 0x12, 0x24, 0x1E, 0x10, 0x10, 0x11,
  0x10, 0x15, 0x31, 0x1E, 0x24, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12,
  0x12, 0x12, 0x12, 0x0B, 0x10, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x31, 0x31, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x31, 0x10, 0x12, 0x12, 0x24, 0x31,
  0x11, 0x10, 0x12, 0x12, 0x12, 0x31, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x10, 0x12, 0x12, 0x12,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x0B,
  0x10, 0x12, 0x31, 0x11, 0x11, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x10, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x10, 0x12, 0x31, 0x31, 0x0B, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x31, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x12, 0x31,
  0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x31, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x12, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B,
  0x31, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x0B, 0x10, 0x0A,
  0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x0B, 0x31, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x31, 0x31, 0x0B, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x13, 0x31, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x0A, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x13, 0x31, 0x10, 0x10, 0x12, 0x00, 0x00,
  0x12, 0x12, 0x0B, 0x31, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x31, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x31, 0x10,
  0x10, 0x10, 0x12, 0x12, 0x00, 0x12, 0x12, 0x0B, 0x31, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x10, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x10,
  0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x31, 0x10, 0x10, 0x10, 0x12, 0x12, 0x00, 0x12, 0x12,
  0x0B, 0x31, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x11, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x12, 0x12, 0x12, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x10, 0x10,
  0x10, 0x12, 0x00, 0x12, 0x12, 0x12, 0x31, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x12, 0x31, 0x11, 0x11, 0x10, 0x12, 0x00, 0x00, 0x12, 0x12, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x31, 0x31, 0x31, 0x10, 0x12,
  0x00, 0x00, 0x00, 0x0A, 0x11, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x12, 0x31, 0x31, 0x31, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
  0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x12, 0x10, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x10,
  0x00, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask5LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x7F, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x03, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x30,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x78, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0xF8, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xF8,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xFC, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x87, 0xFC, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFC,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFC, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xBF, 0xFC, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xCF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xF8,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x00, 0xF0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x70,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x0F, 0xCF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x07, 0xF7, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x03, 0xFB, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0xFD, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x7E, 0x7F, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x3F, 0x1F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x0F, 0x87,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xC0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x77, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite5RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0A,
  0x12, 0x12, 0x30, 0x30, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x12, 0x30, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x30, 0x12, 0x0A, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x30, 0x12, 0x12, 0x12, 0x0A,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x0B,
  0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x0A, 0x10, 0x0B, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x10,
  0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x0B, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x10, 0x10, 0x12,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0A, 0x12,
  0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0B, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x10, 0x10, 0x12, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31,
  0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x0B, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x0B, 0x31, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x10, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x0A, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x0A, 0x0B, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x0A, 0x0A,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x0B, 0x10, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x0B, 0x10,
  0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x10, 0x0B, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x11, 0x0B, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x0B, 0x0B, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x11, 0x0B, 0x10, 0x12, 0x10, 0x12, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x0B, 0x0C,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0B, 0x31, 0x10,
  0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x10, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x11, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12,
  0x13, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x0B,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x11, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x10,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x13, 0x10, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x10, 0x12, 0x12, 0x12, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12,
  0x12, 0x10, 0x0B, 0x0C, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x31, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x10, 0x31, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x10, 0x31, 0x0B, 0x0B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12,
  0x12, 0x0A, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31, 0x10, 0x12, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x10,
  0x31, 0x31, 0x31, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31,
  0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x13, 0x11, 0x31, 0x0C, 0x31, 0x31, 0x0B, 0x0B, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x10, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x10, 0x31, 0x31, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x13, 0x11, 0x31, 0x0C, 0x0C, 0x31,
  0x31, 0x0B, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x10, 0x10, 0x12, 0x12,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31, 0x31, 0x12, 0x12, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11,
  0x0C, 0x0C, 0x31, 0x31, 0x31, 0x0B, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x12, 0x12, 0x10, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31,
  0x31, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x11, 0x31, 0x0C, 0x0C, 0x0C, 0x31, 0x31, 0x0B, 0x10, 0x12,
  0x0A, 0x00, 0x00, 0x00, 0x0A, 0x12, 0x12, 0x10, 0x31, 0x12, 0x12, 0x12,
  0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x10, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x11, 0x11, 0x0C, 0x0C, 0x31, 0x31,
  0x31, 0x0B, 0x10, 0x10, 0x12, 0x0A, 0x00, 0x0A, 0x12, 0x12, 0x12, 0x10,
  0x31, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x0C, 0x31, 0x0A, 0x31, 0x31,
  0x12, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x11, 0x31,
  0x0C, 0x0C, 0x0C, 0x31, 0x31, 0x0B, 0x0B, 0x10, 0x12, 0x12, 0x0A, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x0C, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x0C,
  0x31, 0x13, 0x10, 0x10, 0x13, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x11, 0x11, 0x0C, 0x0C, 0x31, 0x31, 0x31, 0x0B, 0x10, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0C, 0x12, 0x12, 0x12,
  0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x10, 0x0C, 0x31, 0x0C, 0x7B, 0x7B, 0x0C, 0x11, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x11, 0x31, 0x0C, 0x0C, 0x0C, 0x31,
  0x31, 0x0B, 0x0B, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x0C, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x0C, 0x31, 0x24, 0x7B, 0x7B,
  0x24, 0x10, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x11, 0x11,
  0x0C, 0x0C, 0x31, 0x31, 0x31, 0x0B, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x0C, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31,
  0x31, 0x7B, 0x31, 0x31, 0x7B, 0x10, 0x11, 0x11, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x11, 0x31, 0x0C, 0x0C, 0x0C, 0x31, 0x31, 0x0B, 0x10, 0x12,
  0x0A, 0x0A, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0C, 0x12, 0x12, 0x12,
  0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x31, 0x31, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x10, 0x11,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x11, 0x11, 0x0C, 0x0C, 0x31, 0x31,
  0x31, 0x0B, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x12, 0x12, 0x12, 0x10,
  0x0C, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x15,
  0x24, 0x24, 0x1E, 0x10, 0x12, 0x12, 0x12, 0x31, 0x31, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x11, 0x11, 0x31, 0x00, 0x00, 0x00, 0x00, 0x13, 0x11,
  0x31, 0x0C, 0x0C, 0x31, 0x31, 0x0B, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x12, 0x12, 0x10, 0x0C, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x24, 0x31, 0x15, 0x31, 0x31, 0x24, 0x15, 0x12, 0x12, 0x31,
  0x31, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x10, 0x11, 0x15, 0x15, 0x31, 0x00,
  0x00, 0x00, 0x0A, 0x11, 0x11, 0x0C, 0x31, 0x31, 0x0B, 0x0B, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x12, 0x12, 0x10, 0x31, 0x12, 0x12, 0x12,
  0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x24, 0x24, 0x1E, 0x1E, 0x31, 0x1E,
  0x10, 0x15, 0x12, 0x31, 0x31, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31,
  0x31, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x31, 0x31, 0x0B,
  0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x12, 0x12, 0x12, 0x10,
  0x31, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x15, 0x31,
  0x1E, 0x31, 0x31, 0x15, 0x10, 0x10, 0x1E, 0x31, 0x31, 0x0A, 0x12, 0x12,
  0x12, 0x10, 0x13, 0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A,
  0x10, 0x31, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A,
  0x12, 0x12, 0x12, 0x10, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x24, 0x1E, 0x31, 0x15, 0x10, 0x11, 0x10, 0x10, 0x1E,
  0x24, 0x12, 0x12, 0x12, 0x10, 0x10, 0x31, 0x31, 0x31, 0x14, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x13, 0x10, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x10, 0x0B, 0x12, 0x12, 0x12,
  0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x31, 0x31, 0x12,
  0x12, 0x12, 0x10, 0x11, 0x31, 0x24, 0x12, 0x12, 0x10, 0x31, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0B, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x10,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x11, 0x11, 0x31, 0x12, 0x10,
  0x0B, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x31, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B,
  0x31, 0x31, 0x12, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x31, 0x0B, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x0B, 0x31, 0x12, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x31,
  0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x12, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x31, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x10,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x11, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0B, 0x0A,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x0A, 0x0B, 0x31, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x31, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0B, 0x12, 0x12,
  0x12, 0x00, 0x0A, 0x10, 0x0B, 0x31, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x10, 0x12, 0x12, 0x12,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0B, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x31, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x31,
  0x0B, 0x12, 0x12, 0x12, 0x00, 0x12, 0x10, 0x10, 0x31, 0x13, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A,
  0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x10, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x31, 0x0B, 0x12, 0x12, 0x00, 0x00, 0x12, 0x10, 0x10, 0x31,
  0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x31, 0x12, 0x12, 0x00, 0x00, 0x12, 0x12,
  0x10, 0x10, 0x10, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x12, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x31, 0x12, 0x12, 0x00,
  0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x11,
  0x0A, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x31, 0x31, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12,
  0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x11, 0x11, 0x31,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10,
  0x12, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A, 0x0A, 0x10, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0A, 0x0A,
  0x0A, 0x0A, 0x0A, 0x0A, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask5RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF,
  0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0x0C, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x1E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x1F, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0x3F, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x3F, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x7F, 0xE1, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x7F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x7F, 0xFD, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x7F, 0xF1, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x3F, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0x81, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x1F, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0x0E, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x0C, 0x03, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFB, 0xE0, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xF7, 0xC0, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xCF, 0x80, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0x3F, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFE, 0x7E, 0x00, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xF8, 0x7C, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xE0, 0xF0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite5RB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x12, 0x30, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x12, 0x0A, 0x30, 0x12, 0x0A, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0A, 0x30, 0x12, 0x12, 0x12, 0x0A,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x0B,
  0x10, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0A, 0x0A, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x0A, 0x10, 0x0B, 0x10, 0x12, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x10,
  0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x0B, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x10, 0x10, 0x12,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0A, 0x12,
  0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0B, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x10, 0x10, 0x12, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31,
  0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x0B, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x0B, 0x31, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x10, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x0A, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x0A, 0x0B, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x12, 0x12, 0x0A, 0x0A,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x0B, 0x10, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x0B, 0x10,
  0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x10, 0x0B, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x11, 0x0B, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x0B, 0x0B, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x0A, 0x11, 0x0B, 0x10, 0x12, 0x10, 0x12, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x0A, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x0B, 0x0C,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0B, 0x31, 0x10,
  0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x10, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x0A, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x11, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12,
  0x13, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x0A, 0x0B, 0x0B,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x11, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x10,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x13, 0x10, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x10, 0x12, 0x12, 0x12, 0x13, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x12,
  0x12, 0x10, 0x0B, 0x0C, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x31, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x10, 0x31, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x31, 0x0B, 0x0B, 0x0B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12,
  0x12, 0x0A, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31, 0x10, 0x12, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31,
  0x31, 0x31, 0x31, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31,
  0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x11, 0x31, 0x0C, 0x31, 0x31, 0x31, 0x0B, 0x0B, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x10, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x10, 0x31, 0x31, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x31, 0x0C, 0x0C, 0x0C, 0x31,
  0x31, 0x0B, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x10, 0x10, 0x12, 0x12,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31, 0x31, 0x12, 0x12, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0C,
  0x0C, 0x31, 0x31, 0x31, 0x31, 0x0B, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0x12, 0x12, 0x10, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31,
  0x31, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x31, 0x31, 0x0B, 0x10, 0x12,
  0x0A, 0x00, 0x00, 0x00, 0x0A, 0x12, 0x12, 0x10, 0x31, 0x12, 0x12, 0x12,
  0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x10, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x31, 0x31,
  0x31, 0x0B, 0x10, 0x10, 0x12, 0x0A, 0x00, 0x0A, 0x12, 0x12, 0x12, 0x10,
  0x31, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x0C, 0x31, 0x0A, 0x31, 0x31,
  0x12, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0C, 0x0C,
  0x31, 0x31, 0x0C, 0x31, 0x31, 0x0B, 0x0B, 0x10, 0x12, 0x12, 0x0A, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x0C, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x0C,
  0x31, 0x13, 0x10, 0x10, 0x13, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x31, 0x0C, 0x0C, 0x0C, 0x0C, 0x31, 0x31, 0x31, 0x0B, 0x10, 0x10,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0C, 0x12, 0x12, 0x12,
  0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x10, 0x0C, 0x31, 0x0C, 0x7B, 0x7B, 0x0C, 0x11, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0C, 0x0C, 0x31, 0x31, 0x0C, 0x31,
  0x31, 0x0B, 0x0B, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x0C, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x0C, 0x31, 0x24, 0x7B, 0x7B,
  0x24, 0x10, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x0C, 0x0C,
  0x0C, 0x0C, 0x31, 0x31, 0x31, 0x0B, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x0C, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x10, 0x31,
  0x31, 0x7B, 0x31, 0x31, 0x7B, 0x10, 0x11, 0x11, 0x12, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0x0C, 0x31, 0x31, 0x0C, 0x31, 0x31, 0x0B, 0x10, 0x12,
  0x0A, 0x0A, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0C, 0x12, 0x12, 0x12,
  0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10,
  0x12, 0x12, 0x12, 0x31, 0x31, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x10, 0x11,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x31, 0x31,
  0x31, 0x0B, 0x10, 0x0A, 0x00, 0x00, 0x12, 0x0A, 0x12, 0x12, 0x12, 0x10,
  0x0C, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x31, 0x31, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x11, 0x11, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C,
  0x0C, 0x0C, 0x0C, 0x31, 0x31, 0x0B, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x0A, 0x12, 0x12, 0x10, 0x0C, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x31, 0x0C, 0x31, 0x10, 0x12, 0x12, 0x12, 0x31,
  0x31, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x10, 0x11, 0x15, 0x15, 0x31, 0x00,
  0x00, 0x00, 0x00, 0x11, 0x0C, 0x0C, 0x31, 0x31, 0x0B, 0x0B, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0x12, 0x12, 0x10, 0x31, 0x12, 0x12, 0x12,
  0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x15, 0x24, 0x24, 0x1E, 0x10,
  0x12, 0x12, 0x12, 0x31, 0x31, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31,
  0x31, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x31, 0x0B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x10,
  0x31, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x24, 0x31,
  0x15, 0x31, 0x31, 0x24, 0x15, 0x12, 0x1E, 0x31, 0x31, 0x0A, 0x12, 0x12,
  0x12, 0x10, 0x13, 0x31, 0x31, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x31, 0x31, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x12, 0x12, 0x12, 0x10, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x24, 0x1E, 0x31, 0x15, 0x10, 0x11, 0x10, 0x10, 0x1E,
  0x24, 0x12, 0x12, 0x12, 0x10, 0x10, 0x31, 0x31, 0x31, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x10, 0x0B, 0x12, 0x12, 0x12,
  0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x31, 0x31, 0x12,
  0x12, 0x12, 0x10, 0x11, 0x31, 0x24, 0x12, 0x12, 0x10, 0x31, 0x11, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x10,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x11, 0x11, 0x31, 0x12, 0x10,
  0x0B, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x31, 0x31, 0x31, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B,
  0x31, 0x31, 0x12, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10, 0x12, 0x12, 0x12,
  0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0C, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x31, 0x0B, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x0B, 0x31, 0x12, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x13, 0x0C, 0x31, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x31, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x31,
  0x0B, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x12, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0B, 0x31, 0x31,
  0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x31, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x10, 0x0B, 0x10,
  0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x0A, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x11, 0x31, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x31, 0x0B, 0x0A,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x10, 0x10, 0x31, 0x13, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x0B, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x31, 0x31, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x31, 0x0B, 0x12, 0x12,
  0x00, 0x00, 0x12, 0x10, 0x10, 0x31, 0x13, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x10, 0x12, 0x12, 0x12,
  0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0B, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x10, 0x31, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x31,
  0x0B, 0x12, 0x12, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10, 0x31, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A,
  0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x11, 0x10, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x31, 0x0B, 0x12, 0x12, 0x00, 0x12, 0x12, 0x10, 0x10, 0x10,
  0x31, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x31, 0x12, 0x12, 0x12, 0x00, 0x12, 0x10,
  0x10, 0x10, 0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x31, 0x12, 0x12, 0x00,
  0x00, 0x12, 0x10, 0x11, 0x11, 0x31, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12,
  0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x11,
  0x0A, 0x00, 0x00, 0x00, 0x12, 0x10, 0x31, 0x31, 0x31, 0x12, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10,
  0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x12, 0x12, 0x12,
  0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x31, 0x31, 0x31, 0x12,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12,
  0x12, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x10, 0x10,
  0x12, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x12, 0x10, 0x0A, 0x12, 0x12, 0x12, 0x12, 0x12,
  0x12, 0x10, 0x10, 0x00, 0x10, 0x10, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x12, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask5RB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0x80, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0x0C, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x1E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x1F, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0x00, 0x1F, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0x3F, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x3F, 0xE1, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x3F, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x3F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x3F, 0xFD, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xF3, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0x1F, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFC, 0x0E, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xF3, 0xF0, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xEF, 0xE0, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xDF, 0xC0, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xBF, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFE, 0x7E, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xF8, 0xFC, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF,
  0xE1, 0xF0, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xEE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite6LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 0x32, 0x00,
  0x00, 0x34, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x33, 0x00,
  0x00, 0x32, 0x35, 0x00, 0x31, 0x36, 0x34, 0x32, 0x32, 0x36, 0x34, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32,
  0x00, 0x00, 0x33, 0x00, 0x32, 0x36, 0x00, 0x00, 0x31, 0x34, 0x36, 0x33,
  0x36, 0x36, 0x31, 0x32, 0x37, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x32, 0x00, 0x32, 0x36, 0x33, 0x36, 0x36, 0x00, 0x31,
  0x31, 0x36, 0x33, 0x36, 0x36, 0x31, 0x36, 0x36, 0x34, 0x36, 0x37, 0x37,
  0x37, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x32, 0x36, 0x33,
  0x36, 0x33, 0x31, 0x31, 0x36, 0x32, 0x33, 0x36, 0x31, 0x31, 0x31, 0x36,
  0x21, 0x31, 0x36, 0x33, 0x36, 0x31, 0x37, 0x36, 0x37, 0x36, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x36,
  0x00, 0x36, 0x36, 0x33, 0x36, 0x31, 0x31, 0x36, 0x32, 0x33, 0x36, 0x31,
  0x31, 0x36, 0x36, 0x21, 0x33, 0x36, 0x33, 0x36, 0x36, 0x36, 0x33, 0x21,
  0x36, 0x36, 0x37, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x32, 0x00, 0x36, 0x33, 0x36, 0x33, 0x36, 0x31, 0x31, 0x36, 0x32,
  0x33, 0x31, 0x31, 0x36, 0x36, 0x31, 0x33, 0x36, 0x36, 0x33, 0x21, 0x36,
  0x36, 0x33, 0x21, 0x36, 0x36, 0x36, 0x33, 0x21, 0x37, 0x37, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x36, 0x33, 0x36, 0x33, 0x36,
  0x31, 0x36, 0x32, 0x33, 0x31, 0x31, 0x36, 0x36, 0x31, 0x33, 0x36, 0x36,
  0x33, 0x21, 0x36, 0x36, 0x33, 0x21, 0x36, 0x36, 0x36, 0x33, 0x21, 0x21,
  0x36, 0x36, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x36, 0x33, 0x36,
  0x33, 0x36, 0x33, 0x34, 0x31, 0x34, 0x33, 0x31, 0x31, 0x36, 0x36, 0x31,
  0x33, 0x31, 0x36, 0x21, 0x36, 0x36, 0x36, 0x33, 0x21, 0x36, 0x36, 0x33,
  0x21, 0x21, 0x21, 0x36, 0x36, 0x33, 0x36, 0x37, 0x37, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32,
  0x00, 0x36, 0x33, 0x36, 0x33, 0x34, 0x33, 0x34, 0x31, 0x34, 0x31, 0x31,
  0x0B, 0x34, 0x31, 0x31, 0x31, 0x36, 0x31, 0x31, 0x36, 0x31, 0x33, 0x31,
  0x36, 0x37, 0x33, 0x21, 0x21, 0x37, 0x36, 0x33, 0x21, 0x21, 0x36, 0x37,
  0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x32, 0x00, 0x36, 0x33, 0x34, 0x33, 0x34, 0x0B, 0x34,
  0x34, 0x37, 0x37, 0x31, 0x37, 0x34, 0x31, 0x37, 0x31, 0x37, 0x31, 0x36,
  0x36, 0x37, 0x37, 0x31, 0x37, 0x31, 0x31, 0x31, 0x37, 0x36, 0x33, 0x21,
  0x21, 0x21, 0x37, 0x36, 0x33, 0x33, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x33, 0x36, 0x33, 0x34,
  0x0B, 0x0B, 0x0B, 0x7B, 0x34, 0x0B, 0x0B, 0x0B, 0x34, 0x34, 0x0B, 0x0B,
  0x0B, 0x34, 0x34, 0x37, 0x37, 0x0B, 0x36, 0x37, 0x36, 0x37, 0x31, 0x36,
  0x36, 0x33, 0x21, 0x21, 0x21, 0x36, 0x33, 0x21, 0x21, 0x36, 0x34, 0x32,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34,
  0x36, 0x38, 0x38, 0x0B, 0x32, 0x34, 0x38, 0x35, 0x0B, 0x32, 0x34, 0x34,
  0x38, 0x0B, 0x0B, 0x0B, 0x34, 0x34, 0x33, 0x0B, 0x32, 0x0B, 0x34, 0x34,
  0x34, 0x31, 0x37, 0x36, 0x37, 0x21, 0x21, 0x21, 0x36, 0x33, 0x21, 0x21,
  0x33, 0x36, 0x21, 0x39, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x32, 0x38, 0x38, 0x0B, 0x32, 0x32, 0x38, 0x34, 0x0B, 0x0B,
  0x32, 0x34, 0x38, 0x38, 0x0B, 0x0B, 0x34, 0x38, 0x0B, 0x0B, 0x32, 0x32,
  0x34, 0x34, 0x34, 0x0B, 0x37, 0x37, 0x32, 0x32, 0x34, 0x36, 0x21, 0x36,
  0x33, 0x21, 0x21, 0x33, 0x37, 0x36, 0x36, 0x21, 0x34, 0x32, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x38, 0x38, 0x0B, 0x32, 0x32, 0x38,
  0x34, 0x0B, 0x0B, 0x32, 0x34, 0x34, 0x0B, 0x0B, 0x0B, 0x34, 0x38, 0x0B,
  0x32, 0x32, 0x34, 0x38, 0x38, 0x0B, 0x0B, 0x0B, 0x0B, 0x32, 0x34, 0x34,
  0x34, 0x37, 0x36, 0x37, 0x21, 0x21, 0x36, 0x21, 0x21, 0x37, 0x34, 0x36,
  0x21, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x38, 0x38, 0x0B,
  0x32, 0x32, 0x38, 0x34, 0x0B, 0x32, 0x34, 0x38, 0x38, 0x0B, 0x0B, 0x34,
  0x38, 0x38, 0x33, 0x32, 0x38, 0x34, 0x38, 0x0B, 0x0B, 0x0B, 0x32, 0x32,
  0x37, 0x34, 0x0B, 0x37, 0x37, 0x32, 0x32, 0x34, 0x21, 0x36, 0x21, 0x21,
  0x37, 0x36, 0x21, 0x34, 0x21, 0x35, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x34, 0x38, 0x32, 0x32, 0x34, 0x38, 0x0B, 0x32, 0x34, 0x34, 0x38, 0x0B,
  0x0B, 0x0B, 0x34, 0x38, 0x0B, 0x32, 0x32, 0x34, 0x34, 0x0B, 0x33, 0x0B,
  0x32, 0x32, 0x37, 0x38, 0x0B, 0x0B, 0x0B, 0x0B, 0x34, 0x34, 0x34, 0x36,
  0x36, 0x37, 0x21, 0x37, 0x36, 0x21, 0x37, 0x34, 0x21, 0x34, 0x32, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x34, 0x34, 0x32, 0x32, 0x38, 0x38, 0x32, 0x39, 0x34,
  0x38, 0x38, 0x0B, 0x33, 0x0B, 0x38, 0x34, 0x0B, 0x33, 0x34, 0x38, 0x38,
  0x0B, 0x0B, 0x32, 0x32, 0x37, 0x38, 0x0B, 0x0B, 0x0B, 0x0B, 0x38, 0x37,
  0x34, 0x0B, 0x32, 0x37, 0x36, 0x37, 0x37, 0x37, 0x21, 0x37, 0x21, 0x21,
  0x34, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x38, 0x34, 0x32, 0x34, 0x38,
  0x32, 0x39, 0x38, 0x34, 0x32, 0x0B, 0x33, 0x0B, 0x38, 0x38, 0x0B, 0x33,
  0x34, 0x34, 0x0B, 0x0B, 0x33, 0x33, 0x37, 0x34, 0x38, 0x0B, 0x0B, 0x33,
  0x34, 0x37, 0x37, 0x0B, 0x32, 0x32, 0x0B, 0x0B, 0x34, 0x36, 0x37, 0x21,
  0x37, 0x21, 0x21, 0x37, 0x21, 0x21, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x38,
  0x34, 0x34, 0x38, 0x32, 0x39, 0x34, 0x34, 0x32, 0x0B, 0x33, 0x0B, 0x34,
  0x0B, 0x0B, 0x33, 0x38, 0x38, 0x0B, 0x33, 0x33, 0x33, 0x34, 0x38, 0x0B,
  0x0B, 0x33, 0x0B, 0x38, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x38, 0x37, 0x0B,
  0x0B, 0x34, 0x36, 0x37, 0x21, 0x37, 0x37, 0x21, 0x36, 0x37, 0x34, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x34, 0x34, 0x34, 0x3A, 0x38, 0x32, 0x39, 0x34, 0x36, 0x32, 0x39,
  0x33, 0x0B, 0x34, 0x0B, 0x0B, 0x33, 0x38, 0x38, 0x0B, 0x33, 0x33, 0x0B,
  0x38, 0x38, 0x0B, 0x0B, 0x33, 0x0B, 0x38, 0x34, 0x0B, 0x0B, 0x37, 0x38,
  0x38, 0x0B, 0x0B, 0x0B, 0x37, 0x0B, 0x34, 0x37, 0x37, 0x37, 0x21, 0x37,
  0x37, 0x34, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x34, 0x38, 0x38, 0x34, 0x3A, 0x33, 0x32, 0x34,
  0x36, 0x32, 0x39, 0x39, 0x33, 0x34, 0x0B, 0x33, 0x33, 0x38, 0x38, 0x0B,
  0x33, 0x39, 0x0B, 0x34, 0x38, 0x0B, 0x33, 0x33, 0x38, 0x38, 0x0B, 0x0B,
  0x0B, 0x37, 0x34, 0x33, 0x0B, 0x34, 0x34, 0x37, 0x36, 0x34, 0x36, 0x34,
  0x37, 0x34, 0x37, 0x34, 0x34, 0x21, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x38, 0x38, 0x38, 0x34,
  0x3A, 0x3A, 0x39, 0x34, 0x33, 0x39, 0x39, 0x33, 0x34, 0x33, 0x33, 0x39,
  0x34, 0x38, 0x0B, 0x39, 0x33, 0x34, 0x38, 0x38, 0x33, 0x33, 0x0B, 0x38,
  0x34, 0x0B, 0x0B, 0x33, 0x38, 0x34, 0x0B, 0x0B, 0x38, 0x34, 0x32, 0x32,
  0x32, 0x36, 0x34, 0x36, 0x34, 0x37, 0x34, 0x36, 0x21, 0x36, 0x00, 0x00,
  0x34, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34,
  0x38, 0x32, 0x3A, 0x34, 0x34, 0x34, 0x34, 0x39, 0x39, 0x3B, 0x33, 0x0B,
  0x33, 0x39, 0x39, 0x34, 0x38, 0x0B, 0x39, 0x39, 0x38, 0x38, 0x0B, 0x33,
  0x39, 0x0B, 0x38, 0x34, 0x39, 0x33, 0x33, 0x38, 0x34, 0x0B, 0x33, 0x38,
  0x34, 0x0B, 0x39, 0x36, 0x36, 0x32, 0x37, 0x34, 0x34, 0x34, 0x36, 0x21,
  0x36, 0x00, 0x00, 0x34, 0x36, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x36, 0x38, 0x38, 0x38, 0x32, 0x0B, 0x34, 0x35, 0x34, 0x3B,
  0x3B, 0x33, 0x0B, 0x33, 0x3B, 0x3B, 0x34, 0x38, 0x0B, 0x39, 0x3B, 0x38,
  0x38, 0x0B, 0x39, 0x3B, 0x0B, 0x38, 0x34, 0x39, 0x33, 0x0B, 0x38, 0x32,
  0x0B, 0x33, 0x34, 0x0B, 0x0B, 0x3B, 0x36, 0x34, 0x36, 0x36, 0x32, 0x37,
  0x36, 0x34, 0x21, 0x34, 0x00, 0x00, 0x34, 0x36, 0x34, 0x34, 0x37, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x36, 0x39, 0x39, 0x34, 0x34, 0x0B,
  0x35, 0x35, 0x35, 0x36, 0x33, 0x33, 0x39, 0x3B, 0x3B, 0x34, 0x38, 0x0B,
  0x39, 0x3B, 0x38, 0x38, 0x33, 0x39, 0x3B, 0x34, 0x34, 0x39, 0x3B, 0x33,
  0x34, 0x38, 0x32, 0x33, 0x33, 0x35, 0x38, 0x0B, 0x33, 0x3B, 0x34, 0x7B,
  0x34, 0x36, 0x37, 0x0B, 0x34, 0x34, 0x34, 0x00, 0x00, 0x34, 0x36, 0x34,
  0x34, 0x37, 0x37, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x39, 0x7B,
  0x7B, 0x3B, 0x36, 0x0B, 0x39, 0x0B, 0x0B, 0x35, 0x33, 0x39, 0x3B, 0x3B,
  0x34, 0x38, 0x33, 0x39, 0x3B, 0x34, 0x34, 0x33, 0x39, 0x3B, 0x34, 0x34,
  0x39, 0x3B, 0x0B, 0x34, 0x34, 0x32, 0x33, 0x0B, 0x0B, 0x38, 0x0B, 0x39,
  0x3B, 0x36, 0x7B, 0x7B, 0x7B, 0x34, 0x37, 0x0B, 0x37, 0x38, 0x38, 0x00,
  0x34, 0x36, 0x34, 0x34, 0x37, 0x37, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00,
  0x34, 0x34, 0x36, 0x7B, 0x7B, 0x39, 0x34, 0x36, 0x0B, 0x39, 0x39, 0x0B,
  0x32, 0x3B, 0x39, 0x34, 0x38, 0x33, 0x3B, 0x3B, 0x34, 0x34, 0x39, 0x3B,
  0x3B, 0x0B, 0x34, 0x34, 0x34, 0x39, 0x3B, 0x33, 0x34, 0x34, 0x0B, 0x34,
  0x38, 0x0B, 0x39, 0x33, 0x3B, 0x34, 0x7B, 0x7B, 0x7B, 0x34, 0x36, 0x32,
  0x34, 0x38, 0x38, 0x37, 0x21, 0x36, 0x34, 0x37, 0x34, 0x34, 0x34, 0x37,
  0x00, 0x00, 0x00, 0x0B, 0x36, 0x34, 0x34, 0x36, 0x39, 0x34, 0x39, 0x36,
  0x39, 0x0B, 0x39, 0x0B, 0x32, 0x33, 0x36, 0x34, 0x33, 0x39, 0x3B, 0x34,
  0x34, 0x34, 0x34, 0x34, 0x3B, 0x3B, 0x39, 0x0B, 0x34, 0x34, 0x34, 0x39,
  0x3B, 0x33, 0x38, 0x38, 0x0B, 0x3B, 0x33, 0x39, 0x3B, 0x34, 0x7B, 0x7B,
  0x7B, 0x34, 0x37, 0x32, 0x0B, 0x34, 0x34, 0x37, 0x21, 0x34, 0x37, 0x34,
  0x37, 0x37, 0x37, 0x34, 0x00, 0x0B, 0x31, 0x31, 0x36, 0x34, 0x34, 0x38,
  0x34, 0x39, 0x39, 0x36, 0x3B, 0x39, 0x39, 0x0B, 0x0B, 0x33, 0x34, 0x33,
  0x39, 0x39, 0x39, 0x39, 0x39, 0x36, 0x34, 0x34, 0x38, 0x3B, 0x3B, 0x3B,
  0x39, 0x0B, 0x38, 0x38, 0x39, 0x3B, 0x33, 0x34, 0x3B, 0x39, 0x39, 0x39,
  0x3B, 0x34, 0x7B, 0x7B, 0x7B, 0x34, 0x36, 0x33, 0x0B, 0x39, 0x37, 0x21,
  0x21, 0x37, 0x37, 0x37, 0x37, 0x34, 0x34, 0x34, 0x31, 0x31, 0x31, 0x31,
  0x31, 0x36, 0x34, 0x38, 0x38, 0x36, 0x39, 0x36, 0x3B, 0x39, 0x39, 0x39,
  0x0B, 0x32, 0x34, 0x34, 0x34, 0x36, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x39,
  0x38, 0x38, 0x38, 0x39, 0x39, 0x39, 0x0B, 0x34, 0x38, 0x34, 0x3B, 0x33,
  0x38, 0x34, 0x34, 0x0B, 0x3B, 0x34, 0x7B, 0x7B, 0x34, 0x36, 0x37, 0x32,
  0x0B, 0x37, 0x21, 0x21, 0x37, 0x37, 0x37, 0x34, 0x34, 0x34, 0x34, 0x34,
  0x39, 0x39, 0x39, 0x33, 0x31, 0x31, 0x36, 0x34, 0x38, 0x36, 0x39, 0x36,
  0x3B, 0x3B, 0x39, 0x39, 0x0B, 0x32, 0x39, 0x39, 0x36, 0x34, 0x34, 0x34,
  0x34, 0x3B, 0x3B, 0x3B, 0x39, 0x39, 0x38, 0x38, 0x36, 0x0B, 0x39, 0x39,
  0x0B, 0x7B, 0x7B, 0x0B, 0x0B, 0x33, 0x38, 0x34, 0x3B, 0x36, 0x34, 0x34,
  0x36, 0x3B, 0x0B, 0x33, 0x34, 0x21, 0x21, 0x37, 0x37, 0x37, 0x34, 0x34,
  0x34, 0x34, 0x34, 0x34, 0x00, 0x34, 0x36, 0x39, 0x39, 0x31, 0x31, 0x36,
  0x38, 0x34, 0x39, 0x39, 0x3B, 0x3B, 0x39, 0x39, 0x39, 0x32, 0x3B, 0x3B,
  0x3B, 0x39, 0x39, 0x34, 0x34, 0x34, 0x39, 0x3B, 0x33, 0x39, 0x33, 0x39,
  0x38, 0x36, 0x0B, 0x39, 0x33, 0x33, 0x34, 0x7B, 0x0B, 0x0B, 0x33, 0x38,
  0x0B, 0x3B, 0x36, 0x34, 0x3B, 0x0B, 0x34, 0x33, 0x0B, 0x37, 0x21, 0x21,
  0x37, 0x37, 0x37, 0x34, 0x34, 0x34, 0x34, 0x34, 0x00, 0x0B, 0x34, 0x36,
  0x36, 0x39, 0x39, 0x36, 0x38, 0x38, 0x39, 0x39, 0x3B, 0x3B, 0x3B, 0x39,
  0x39, 0x32, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x39, 0x34, 0x38, 0x38,
  0x39, 0x39, 0x33, 0x33, 0x39, 0x38, 0x36, 0x0B, 0x33, 0x33, 0x33, 0x0B,
  0x34, 0x36, 0x0B, 0x33, 0x38, 0x0B, 0x3B, 0x3B, 0x32, 0x36, 0x36, 0x34,
  0x0B, 0x32, 0x37, 0x21, 0x21, 0x37, 0x34, 0x37, 0x37, 0x34, 0x34, 0x34,
  0x0B, 0x34, 0x36, 0x34, 0x39, 0x39, 0x36, 0x33, 0x38, 0x38, 0x39, 0x39,
  0x3B, 0x3B, 0x3B, 0x39, 0x33, 0x32, 0x39, 0x39, 0x36, 0x36, 0x36, 0x3B,
  0x3B, 0x39, 0x36, 0x34, 0x38, 0x33, 0x33, 0x33, 0x33, 0x33, 0x38, 0x36,
  0x0B, 0x0B, 0x33, 0x33, 0x33, 0x34, 0x36, 0x0B, 0x33, 0x38, 0x34, 0x34,
  0x38, 0x38, 0x38, 0x32, 0x34, 0x37, 0x37, 0x32, 0x21, 0x37, 0x37, 0x34,
  0x37, 0x37, 0x34, 0x34, 0x00, 0x00, 0x00, 0x36, 0x36, 0x39, 0x33, 0x33,
  0x38, 0x34, 0x39, 0x39, 0x3B, 0x3B, 0x3B, 0x39, 0x33, 0x35, 0x3B, 0x39,
  0x39, 0x39, 0x36, 0x36, 0x3B, 0x3B, 0x3B, 0x33, 0x34, 0x38, 0x38, 0x0B,
  0x0B, 0x33, 0x33, 0x38, 0x38, 0x0B, 0x0B, 0x33, 0x33, 0x33, 0x34, 0x36,
  0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x34, 0x35, 0x34, 0x32, 0x34, 0x34, 0x37,
  0x32, 0x34, 0x37, 0x37, 0x34, 0x34, 0x37, 0x37, 0x00, 0x00, 0x00, 0x00,
  0x36, 0x36, 0x39, 0x36, 0x38, 0x39, 0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x39,
  0x33, 0x35, 0x3B, 0x3B, 0x3B, 0x39, 0x39, 0x36, 0x36, 0x36, 0x39, 0x33,
  0x33, 0x36, 0x34, 0x38, 0x34, 0x0B, 0x33, 0x33, 0x33, 0x38, 0x34, 0x0B,
  0x0B, 0x0B, 0x33, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x35, 0x34, 0x32,
  0x34, 0x00, 0x00, 0x34, 0x36, 0x32, 0x34, 0x37, 0x37, 0x34, 0x34, 0x34,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x36, 0x36, 0x3B, 0x3B, 0x39,
  0x3B, 0x3B, 0x39, 0x39, 0x32, 0x35, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x39,
  0x39, 0x34, 0x34, 0x36, 0x33, 0x33, 0x33, 0x36, 0x38, 0x38, 0x0B, 0x0B,
  0x33, 0x33, 0x38, 0x38, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x36,
  0x36, 0x31, 0x35, 0x34, 0x31, 0x34, 0x00, 0x00, 0x34, 0x34, 0x36, 0x34,
  0x37, 0x37, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36,
  0x3B, 0x34, 0x36, 0x3B, 0x3B, 0x39, 0x39, 0x33, 0x32, 0x35, 0x3B, 0x3B,
  0x3B, 0x3B, 0x3B, 0x39, 0x39, 0x39, 0x36, 0x34, 0x34, 0x0B, 0x0B, 0x33,
  0x33, 0x38, 0x38, 0x34, 0x0B, 0x33, 0x33, 0x33, 0x36, 0x36, 0x36, 0x36,
  0x36, 0x34, 0x34, 0x34, 0x31, 0x34, 0x34, 0x34, 0x34, 0x36, 0x34, 0x00,
  0x00, 0x00, 0x34, 0x36, 0x34, 0x34, 0x37, 0x37, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3B, 0x39, 0x3B, 0x34, 0x39, 0x39, 0x39, 0x33, 0x32,
  0x35, 0x35, 0x33, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x37, 0x39, 0x39, 0x39,
  0x34, 0x34, 0x34, 0x0B, 0x33, 0x33, 0x36, 0x38, 0x38, 0x0B, 0x0B, 0x0B,
  0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x31, 0x34, 0x31, 0x34, 0x31,
  0x37, 0x34, 0x37, 0x34, 0x00, 0x00, 0x00, 0x34, 0x36, 0x34, 0x34, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x0E, 0x35, 0x39,
  0x39, 0x33, 0x33, 0x39, 0x32, 0x35, 0x35, 0x33, 0x3B, 0x3B, 0x3B, 0x3B,
  0x3B, 0x37, 0x37, 0x39, 0x39, 0x39, 0x34, 0x34, 0x0B, 0x0B, 0x33, 0x33,
  0x0B, 0x38, 0x38, 0x38, 0x34, 0x34, 0x34, 0x34, 0x34, 0x31, 0x34, 0x0B,
  0x31, 0x34, 0x31, 0x34, 0x36, 0x37, 0x34, 0x37, 0x34, 0x00, 0x00, 0x00,
  0x34, 0x36, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x35, 0x33, 0x39, 0x33, 0x0B, 0x39, 0x3B, 0x39, 0x32, 0x35, 0x32,
  0x33, 0x39, 0x3B, 0x39, 0x3B, 0x3B, 0x37, 0x37, 0x37, 0x39, 0x33, 0x34,
  0x34, 0x34, 0x34, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x31, 0x0B,
  0x31, 0x0B, 0x31, 0x34, 0x0B, 0x31, 0x34, 0x34, 0x37, 0x34, 0x36, 0x34,
  0x37, 0x34, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x0B, 0x0B, 0x39, 0x3B, 0x3B,
  0x3B, 0x39, 0x33, 0x33, 0x33, 0x33, 0x39, 0x39, 0x36, 0x3B, 0x3B, 0x3B,
  0x36, 0x34, 0x34, 0x33, 0x39, 0x33, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38,
  0x38, 0x31, 0x36, 0x34, 0x31, 0x34, 0x36, 0x0B, 0x31, 0x34, 0x34, 0x37,
  0x36, 0x37, 0x34, 0x37, 0x34, 0x37, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32,
  0x0B, 0x0B, 0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x33, 0x33, 0x33, 0x39,
  0x39, 0x36, 0x36, 0x3B, 0x3B, 0x3B, 0x34, 0x34, 0x34, 0x34, 0x33, 0x0B,
  0x33, 0x33, 0x0B, 0x31, 0x31, 0x0B, 0x31, 0x31, 0x31, 0x36, 0x34, 0x31,
  0x31, 0x34, 0x37, 0x21, 0x21, 0x36, 0x37, 0x34, 0x36, 0x34, 0x37, 0x34,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x32, 0x0B, 0x35, 0x39, 0x3B, 0x3B, 0x3B, 0x3B,
  0x3B, 0x3B, 0x39, 0x3B, 0x39, 0x39, 0x36, 0x36, 0x36, 0x39, 0x39, 0x39,
  0x39, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x36,
  0x34, 0x0B, 0x31, 0x0B, 0x34, 0x34, 0x37, 0x21, 0x36, 0x21, 0x36, 0x37,
  0x34, 0x37, 0x34, 0x37, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x35, 0x35,
  0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x3B, 0x39, 0x39, 0x39,
  0x0E, 0x36, 0x36, 0x36, 0x39, 0x39, 0x33, 0x39, 0x33, 0x33, 0x33, 0x33,
  0x0B, 0x33, 0x0B, 0x31, 0x0B, 0x31, 0x0B, 0x34, 0x34, 0x37, 0x21, 0x21,
  0x21, 0x36, 0x37, 0x34, 0x37, 0x34, 0x32, 0x34, 0x34, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x34, 0x35, 0x35, 0x35, 0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B,
  0x39, 0x3B, 0x39, 0x3B, 0x39, 0x0E, 0x39, 0x0E, 0x36, 0x36, 0x36, 0x36,
  0x0E, 0x0E, 0x33, 0x0B, 0x37, 0x0B, 0x37, 0x37, 0x31, 0x37, 0x34, 0x34,
  0x37, 0x21, 0x21, 0x21, 0x36, 0x21, 0x36, 0x37, 0x36, 0x36, 0x34, 0x37,
  0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x35, 0x36, 0x0E,
  0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x3B, 0x39, 0x3B, 0x39, 0x0E, 0x39,
  0x0E, 0x39, 0x36, 0x0E, 0x36, 0x36, 0x36, 0x37, 0x0B, 0x37, 0x34, 0x31,
  0x37, 0x34, 0x34, 0x37, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x37, 0x37,
  0x34, 0x32, 0x37, 0x36, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x34, 0x36, 0x36, 0x0E, 0x39, 0x39, 0x39, 0x0E, 0x39, 0x0E,
  0x39, 0x0E, 0x39, 0x0E, 0x0E, 0x0E, 0x0E, 0x36, 0x36, 0x31, 0x36, 0x31,
  0x31, 0x34, 0x36, 0x34, 0x34, 0x37, 0x37, 0x21, 0x21, 0x21, 0x21, 0x21,
  0x36, 0x37, 0x37, 0x34, 0x32, 0x36, 0x36, 0x34, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x36, 0x36, 0x0E,
  0x0E, 0x0E, 0x0E, 0x0E, 0x36, 0x0E, 0x36, 0x0E, 0x36, 0x0E, 0x36, 0x36,
  0x0E, 0x36, 0x34, 0x34, 0x34, 0x34, 0x37, 0x34, 0x37, 0x36, 0x21, 0x21,
  0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x34, 0x32, 0x36, 0x37, 0x34, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x34, 0x37, 0x37, 0x36, 0x34, 0x36, 0x34, 0x36, 0x34, 0x36, 0x34,
  0x36, 0x34, 0x36, 0x34, 0x36, 0x34, 0x34, 0x36, 0x34, 0x34, 0x34, 0x37,
  0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x32, 0x32, 0x36,
  0x31, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x39, 0x37, 0x33, 0x37, 0x0B,
  0x0B, 0x34, 0x34, 0x34, 0x00, 0x00, 0x00, 0x36, 0x34, 0x36, 0x36, 0x34,
  0x36, 0x37, 0x34, 0x37, 0x34, 0x21, 0x37, 0x21, 0x31, 0x21, 0x31, 0x36,
  0x31, 0x34, 0x36, 0x31, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39,
  0x33, 0x33, 0x31, 0x33, 0x0B, 0x0B, 0x37, 0x34, 0x00, 0x00, 0x00, 0x00,
  0x36, 0x34, 0x39, 0x33, 0x36, 0x36, 0x36, 0x34, 0x37, 0x36, 0x21, 0x31,
  0x36, 0x31, 0x21, 0x21, 0x34, 0x31, 0x31, 0x34, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x39, 0x31, 0x33, 0x31, 0x33, 0x0B, 0x0B, 0x37,
  0x34, 0x00, 0x00, 0x00, 0x00, 0x36, 0x34, 0x39, 0x33, 0x33, 0x36, 0x36,
  0x34, 0x31, 0x36, 0x31, 0x31, 0x36, 0x36, 0x36, 0x31, 0x31, 0x34, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x0E, 0x33,
  0x31, 0x33, 0x35, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x34,
  0x39, 0x39, 0x33, 0x33, 0x36, 0x34, 0x31, 0x36, 0x31, 0x31, 0x31, 0x31,
  0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x31, 0x31, 0x33, 0x31, 0x33, 0x31, 0x0B, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x36, 0x34, 0x31, 0x39, 0x39, 0x33, 0x39, 0x34, 0x36,
  0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x33, 0x31, 0x33,
  0x31, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x34, 0x31, 0x31,
  0x39, 0x33, 0x31, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x31, 0x31, 0x33, 0x31, 0x33, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x36, 0x00, 0x00, 0x31, 0x31, 0x33, 0x31, 0x34, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x31, 0x0B, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x34, 0x34, 0x31,
  0x31, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33,
  0x31, 0x31, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34,
  0x00, 0x00, 0x00, 0x34, 0x34, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x31, 0x33, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x0B, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask6LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x26, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x6F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xCF,
  0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0xDF, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x17, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x57, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
  0x00, 0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x01, 0x7F, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x01, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0x01, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x9E, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3E,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x3F, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1E,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8E, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC4, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x07, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x03, 0xFF, 0x1F, 0xFF, 0xFF, 0x80,
  0x00, 0x00, 0x01, 0xFF, 0x0F, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x87, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x83, 0xFF, 0xF8, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0x81, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x1F,
  0xC0, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xC0, 0x4F, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x03, 0xC0, 0x27, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x01,
  0xE0, 0x11, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00,
};

const uint8_t sprite6LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x00,
  0x32, 0x00, 0x00, 0x32, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x32,
  0x00, 0x00, 0x32, 0x32, 0x32, 0x32, 0x32, 0x36, 0x32, 0x32, 0x32, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x32, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32, 0x32, 0x35, 0x32, 0x31, 0x36,
  0x36, 0x32, 0x32, 0x21, 0x32, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32, 0x36, 0x33, 0x32, 0x36,
  0x32, 0x32, 0x31, 0x35, 0x36, 0x33, 0x36, 0x36, 0x31, 0x31, 0x37, 0x37,
  0x32, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x32, 0x32,
  0x36, 0x33, 0x36, 0x36, 0x32, 0x31, 0x31, 0x36, 0x33, 0x36, 0x36, 0x31,
  0x31, 0x36, 0x31, 0x21, 0x36, 0x21, 0x21, 0x37, 0x37, 0x32, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x32,
  0x36, 0x36, 0x36, 0x36, 0x36, 0x33, 0x36, 0x33, 0x31, 0x31, 0x36, 0x32,
  0x33, 0x36, 0x31, 0x31, 0x36, 0x31, 0x21, 0x36, 0x21, 0x21, 0x21, 0x36,
  0x31, 0x37, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x32, 0x00, 0x32, 0x36, 0x33, 0x36, 0x33, 0x36, 0x31, 0x36, 0x31,
  0x36, 0x32, 0x33, 0x36, 0x31, 0x31, 0x36, 0x36, 0x21, 0x21, 0x36, 0x21,
  0x21, 0x21, 0x36, 0x31, 0x21, 0x21, 0x37, 0x37, 0x32, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x32, 0x36, 0x33, 0x36, 0x33,
  0x36, 0x31, 0x36, 0x36, 0x32, 0x33, 0x31, 0x31, 0x36, 0x36, 0x31, 0x31,
  0x36, 0x36, 0x21, 0x21, 0x36, 0x36, 0x21, 0x21, 0x36, 0x39, 0x21, 0x21,
  0x21, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x32, 0x36, 0x32,
  0x36, 0x33, 0x36, 0x33, 0x34, 0x31, 0x34, 0x33, 0x33, 0x31, 0x31, 0x36,
  0x36, 0x31, 0x21, 0x36, 0x36, 0x21, 0x21, 0x36, 0x36, 0x21, 0x21, 0x36,
  0x36, 0x36, 0x21, 0x21, 0x21, 0x37, 0x37, 0x32, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x32,
  0x36, 0x32, 0x36, 0x33, 0x36, 0x33, 0x34, 0x33, 0x34, 0x31, 0x34, 0x31,
  0x31, 0x31, 0x36, 0x36, 0x31, 0x21, 0x31, 0x36, 0x21, 0x36, 0x36, 0x21,
  0x21, 0x21, 0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x36, 0x36, 0x34, 0x37,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x32, 0x36, 0x32, 0x36, 0x33, 0x33, 0x34, 0x0B, 0x34,
  0x34, 0x37, 0x37, 0x31, 0x31, 0x0B, 0x34, 0x31, 0x31, 0x31, 0x36, 0x31,
  0x31, 0x36, 0x31, 0x31, 0x31, 0x36, 0x37, 0x21, 0x21, 0x21, 0x37, 0x36,
  0x21, 0x21, 0x21, 0x39, 0x37, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x33, 0x36, 0x33, 0x34,
  0x0B, 0x0B, 0x0B, 0x7B, 0x34, 0x0B, 0x0B, 0x0B, 0x34, 0x34, 0x0B, 0x0B,
  0x0B, 0x31, 0x37, 0x31, 0x36, 0x36, 0x37, 0x36, 0x34, 0x37, 0x31, 0x31,
  0x31, 0x37, 0x36, 0x21, 0x21, 0x21, 0x21, 0x37, 0x36, 0x33, 0x36, 0x32,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34,
  0x36, 0x38, 0x38, 0x0B, 0x32, 0x34, 0x38, 0x35, 0x0B, 0x32, 0x34, 0x34,
  0x38, 0x0B, 0x0B, 0x0B, 0x34, 0x34, 0x33, 0x0B, 0x37, 0x37, 0x34, 0x36,
  0x37, 0x36, 0x37, 0x31, 0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x36, 0x21,
  0x21, 0x21, 0x36, 0x34, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x32, 0x38, 0x38, 0x0B, 0x32, 0x32, 0x38, 0x34, 0x0B, 0x0B,
  0x32, 0x34, 0x38, 0x38, 0x0B, 0x0B, 0x34, 0x38, 0x0B, 0x0B, 0x32, 0x32,
  0x34, 0x34, 0x34, 0x0B, 0x37, 0x34, 0x31, 0x37, 0x36, 0x21, 0x21, 0x21,
  0x21, 0x36, 0x21, 0x21, 0x21, 0x21, 0x36, 0x21, 0x39, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x38, 0x38, 0x0B, 0x32, 0x32, 0x38,
  0x34, 0x0B, 0x0B, 0x32, 0x34, 0x34, 0x0B, 0x0B, 0x0B, 0x34, 0x38, 0x0B,
  0x32, 0x32, 0x34, 0x38, 0x38, 0x0B, 0x0B, 0x0B, 0x0B, 0x32, 0x34, 0x34,
  0x34, 0x34, 0x36, 0x21, 0x36, 0x21, 0x21, 0x21, 0x36, 0x37, 0x36, 0x21,
  0x34, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x38, 0x38, 0x0B,
  0x32, 0x32, 0x38, 0x34, 0x0B, 0x32, 0x34, 0x38, 0x38, 0x0B, 0x0B, 0x34,
  0x38, 0x38, 0x33, 0x32, 0x38, 0x34, 0x38, 0x0B, 0x0B, 0x0B, 0x32, 0x32,
  0x37, 0x34, 0x0B, 0x37, 0x37, 0x32, 0x36, 0x21, 0x21, 0x21, 0x36, 0x21,
  0x21, 0x21, 0x34, 0x36, 0x21, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x34, 0x38, 0x32, 0x32, 0x34, 0x38, 0x0B, 0x32, 0x34, 0x34, 0x38, 0x0B,
  0x0B, 0x0B, 0x34, 0x38, 0x0B, 0x32, 0x32, 0x34, 0x34, 0x0B, 0x33, 0x0B,
  0x32, 0x32, 0x37, 0x38, 0x0B, 0x0B, 0x0B, 0x0B, 0x34, 0x34, 0x32, 0x34,
  0x21, 0x36, 0x21, 0x21, 0x21, 0x36, 0x21, 0x34, 0x21, 0x35, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x34, 0x34, 0x32, 0x32, 0x38, 0x38, 0x32, 0x39, 0x34,
  0x38, 0x38, 0x0B, 0x33, 0x0B, 0x38, 0x34, 0x0B, 0x33, 0x34, 0x38, 0x38,
  0x0B, 0x0B, 0x32, 0x32, 0x37, 0x38, 0x0B, 0x0B, 0x0B, 0x0B, 0x38, 0x37,
  0x34, 0x0B, 0x32, 0x36, 0x36, 0x37, 0x21, 0x21, 0x36, 0x21, 0x37, 0x34,
  0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x38, 0x34, 0x32, 0x34, 0x38,
  0x32, 0x39, 0x38, 0x34, 0x32, 0x0B, 0x33, 0x0B, 0x38, 0x38, 0x0B, 0x33,
  0x34, 0x34, 0x0B, 0x0B, 0x33, 0x33, 0x37, 0x34, 0x38, 0x0B, 0x0B, 0x33,
  0x34, 0x37, 0x37, 0x0B, 0x32, 0x32, 0x0B, 0x0B, 0x36, 0x37, 0x37, 0x37,
  0x21, 0x37, 0x21, 0x21, 0x34, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x38,
  0x34, 0x34, 0x38, 0x32, 0x39, 0x34, 0x34, 0x32, 0x0B, 0x33, 0x0B, 0x34,
  0x0B, 0x0B, 0x33, 0x38, 0x38, 0x0B, 0x33, 0x33, 0x33, 0x34, 0x38, 0x0B,
  0x0B, 0x33, 0x0B, 0x38, 0x37, 0x0B, 0x0B, 0x0B, 0x0B, 0x38, 0x37, 0x0B,
  0x34, 0x36, 0x37, 0x37, 0x37, 0x37, 0x21, 0x37, 0x34, 0x34, 0x38, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x34, 0x34, 0x34, 0x3A, 0x38, 0x32, 0x39, 0x34, 0x36, 0x32, 0x39,
  0x33, 0x0B, 0x34, 0x0B, 0x0B, 0x33, 0x38, 0x38, 0x0B, 0x33, 0x33, 0x0B,
  0x38, 0x38, 0x0B, 0x0B, 0x33, 0x0B, 0x38, 0x34, 0x0B, 0x0B, 0x37, 0x38,
  0x38, 0x0B, 0x0B, 0x0B, 0x37, 0x34, 0x36, 0x37, 0x37, 0x37, 0x37, 0x37,
  0x36, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x34, 0x38, 0x38, 0x34, 0x3A, 0x33, 0x32, 0x34,
  0x36, 0x32, 0x39, 0x39, 0x33, 0x34, 0x0B, 0x33, 0x33, 0x38, 0x38, 0x0B,
  0x33, 0x39, 0x0B, 0x34, 0x38, 0x0B, 0x33, 0x33, 0x38, 0x38, 0x0B, 0x0B,
  0x0B, 0x37, 0x34, 0x33, 0x0B, 0x34, 0x34, 0x37, 0x36, 0x37, 0x34, 0x34,
  0x37, 0x34, 0x37, 0x37, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x38, 0x38, 0x38, 0x34,
  0x3A, 0x3A, 0x39, 0x34, 0x33, 0x39, 0x39, 0x33, 0x34, 0x33, 0x33, 0x39,
  0x34, 0x38, 0x0B, 0x39, 0x33, 0x34, 0x38, 0x38, 0x33, 0x33, 0x0B, 0x38,
  0x34, 0x0B, 0x0B, 0x33, 0x38, 0x34, 0x0B, 0x0B, 0x38, 0x34, 0x32, 0x32,
  0x32, 0x36, 0x37, 0x34, 0x34, 0x37, 0x34, 0x36, 0x34, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34,
  0x38, 0x32, 0x3A, 0x34, 0x34, 0x34, 0x34, 0x39, 0x39, 0x3B, 0x33, 0x0B,
  0x33, 0x39, 0x39, 0x34, 0x38, 0x0B, 0x39, 0x39, 0x38, 0x38, 0x0B, 0x33,
  0x39, 0x0B, 0x38, 0x34, 0x39, 0x33, 0x33, 0x38, 0x34, 0x0B, 0x33, 0x38,
  0x34, 0x0B, 0x39, 0x36, 0x36, 0x32, 0x37, 0x37, 0x34, 0x36, 0x21, 0x34,
  0x34, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x36, 0x38, 0x38, 0x38, 0x32, 0x0B, 0x34, 0x35, 0x34, 0x3B,
  0x3B, 0x33, 0x0B, 0x33, 0x3B, 0x3B, 0x34, 0x38, 0x0B, 0x39, 0x3B, 0x38,
  0x38, 0x0B, 0x39, 0x3B, 0x0B, 0x38, 0x34, 0x39, 0x33, 0x0B, 0x38, 0x32,
  0x0B, 0x33, 0x34, 0x0B, 0x0B, 0x3B, 0x36, 0x34, 0x36, 0x36, 0x32, 0x37,
  0x34, 0x21, 0x34, 0x34, 0x00, 0x00, 0x00, 0x36, 0x34, 0x34, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x36, 0x39, 0x39, 0x34, 0x34, 0x0B,
  0x35, 0x35, 0x35, 0x36, 0x33, 0x33, 0x39, 0x3B, 0x3B, 0x34, 0x38, 0x0B,
  0x39, 0x3B, 0x38, 0x38, 0x33, 0x39, 0x3B, 0x34, 0x34, 0x39, 0x3B, 0x33,
  0x34, 0x38, 0x32, 0x33, 0x33, 0x35, 0x38, 0x0B, 0x33, 0x3B, 0x34, 0x7B,
  0x34, 0x36, 0x37, 0x0B, 0x34, 0x34, 0x34, 0x00, 0x00, 0x00, 0x36, 0x34,
  0x34, 0x37, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x39, 0x7B,
  0x7B, 0x3B, 0x36, 0x0B, 0x39, 0x0B, 0x0B, 0x35, 0x33, 0x39, 0x3B, 0x3B,
  0x34, 0x38, 0x33, 0x39, 0x3B, 0x34, 0x34, 0x33, 0x39, 0x3B, 0x34, 0x34,
  0x39, 0x3B, 0x0B, 0x34, 0x34, 0x32, 0x33, 0x0B, 0x0B, 0x38, 0x0B, 0x39,
  0x3B, 0x36, 0x7B, 0x7B, 0x7B, 0x34, 0x37, 0x0B, 0x37, 0x34, 0x00, 0x00,
  0x34, 0x36, 0x34, 0x34, 0x37, 0x37, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00,
  0x34, 0x34, 0x36, 0x7B, 0x7B, 0x39, 0x34, 0x36, 0x0B, 0x39, 0x39, 0x0B,
  0x32, 0x3B, 0x39, 0x34, 0x38, 0x33, 0x3B, 0x3B, 0x34, 0x34, 0x39, 0x3B,
  0x3B, 0x0B, 0x34, 0x34, 0x34, 0x39, 0x3B, 0x33, 0x34, 0x34, 0x0B, 0x34,
  0x38, 0x0B, 0x39, 0x33, 0x3B, 0x34, 0x7B, 0x7B, 0x7B, 0x34, 0x36, 0x32,
  0x34, 0x00, 0x00, 0x37, 0x21, 0x36, 0x34, 0x37, 0x34, 0x34, 0x34, 0x37,
  0x00, 0x00, 0x00, 0x0B, 0x36, 0x34, 0x34, 0x36, 0x39, 0x34, 0x39, 0x36,
  0x39, 0x0B, 0x39, 0x0B, 0x32, 0x33, 0x36, 0x34, 0x33, 0x39, 0x3B, 0x34,
  0x34, 0x34, 0x34, 0x34, 0x3B, 0x3B, 0x39, 0x0B, 0x34, 0x34, 0x34, 0x39,
  0x3B, 0x33, 0x38, 0x38, 0x0B, 0x3B, 0x33, 0x39, 0x3B, 0x34, 0x7B, 0x7B,
  0x7B, 0x34, 0x37, 0x32, 0x0B, 0x34, 0x34, 0x37, 0x21, 0x34, 0x37, 0x34,
  0x37, 0x37, 0x37, 0x34, 0x00, 0x00, 0x31, 0x31, 0x36, 0x34, 0x34, 0x38,
  0x34, 0x39, 0x39, 0x36, 0x3B, 0x39, 0x39, 0x0B, 0x0B, 0x33, 0x34, 0x33,
  0x39, 0x39, 0x39, 0x39, 0x39, 0x36, 0x34, 0x34, 0x38, 0x3B, 0x3B, 0x3B,
  0x39, 0x0B, 0x38, 0x38, 0x39, 0x3B, 0x33, 0x34, 0x3B, 0x39, 0x39, 0x39,
  0x3B, 0x34, 0x7B, 0x7B, 0x7B, 0x34, 0x36, 0x33, 0x0B, 0x39, 0x37, 0x21,
  0x21, 0x37, 0x37, 0x37, 0x37, 0x34, 0x34, 0x34, 0x31, 0x31, 0x31, 0x31,
  0x31, 0x36, 0x34, 0x38, 0x38, 0x36, 0x39, 0x36, 0x3B, 0x39, 0x39, 0x39,
  0x0B, 0x32, 0x34, 0x34, 0x34, 0x36, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x39,
  0x38, 0x38, 0x38, 0x39, 0x39, 0x39, 0x0B, 0x34, 0x38, 0x34, 0x3B, 0x33,
  0x38, 0x34, 0x34, 0x0B, 0x3B, 0x34, 0x7B, 0x7B, 0x34, 0x36, 0x37, 0x32,
  0x0B, 0x37, 0x21, 0x21, 0x37, 0x37, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34,
  0x39, 0x39, 0x33, 0x33, 0x31, 0x31, 0x36, 0x34, 0x38, 0x36, 0x39, 0x36,
  0x3B, 0x3B, 0x39, 0x39, 0x0B, 0x32, 0x39, 0x39, 0x36, 0x34, 0x34, 0x34,
  0x34, 0x3B, 0x3B, 0x3B, 0x39, 0x39, 0x38, 0x38, 0x36, 0x0B, 0x39, 0x39,
  0x0B, 0x7B, 0x7B, 0x0B, 0x0B, 0x33, 0x38, 0x34, 0x3B, 0x36, 0x34, 0x34,
  0x36, 0x3B, 0x0B, 0x33, 0x34, 0x21, 0x21, 0x21, 0x37, 0x34, 0x34, 0x34,
  0x34, 0x34, 0x34, 0x34, 0x38, 0x33, 0x39, 0x39, 0x39, 0x31, 0x31, 0x36,
  0x38, 0x34, 0x39, 0x39, 0x3B, 0x3B, 0x39, 0x39, 0x39, 0x32, 0x3B, 0x3B,
  0x3B, 0x39, 0x39, 0x34, 0x34, 0x34, 0x39, 0x3B, 0x33, 0x39, 0x33, 0x39,
  0x38, 0x36, 0x0B, 0x39, 0x33, 0x33, 0x34, 0x7B, 0x0B, 0x0B, 0x33, 0x38,
  0x0B, 0x3B, 0x36, 0x34, 0x3B, 0x0B, 0x34, 0x33, 0x0B, 0x32, 0x37, 0x21,
  0x21, 0x37, 0x34, 0x37, 0x34, 0x34, 0x34, 0x34, 0x00, 0x0B, 0x0B, 0x33,
  0x39, 0x39, 0x39, 0x36, 0x38, 0x38, 0x39, 0x39, 0x3B, 0x3B, 0x3B, 0x39,
  0x39, 0x32, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x39, 0x34, 0x38, 0x38,
  0x39, 0x39, 0x33, 0x33, 0x39, 0x38, 0x36, 0x0B, 0x33, 0x33, 0x33, 0x0B,
  0x34, 0x36, 0x0B, 0x33, 0x38, 0x0B, 0x3B, 0x3B, 0x32, 0x36, 0x36, 0x34,
  0x34, 0x37, 0x37, 0x32, 0x21, 0x37, 0x37, 0x34, 0x37, 0x37, 0x34, 0x34,
  0x00, 0x00, 0x36, 0x36, 0x39, 0x3B, 0x36, 0x33, 0x38, 0x38, 0x39, 0x39,
  0x3B, 0x3B, 0x3B, 0x39, 0x33, 0x32, 0x39, 0x39, 0x36, 0x36, 0x36, 0x3B,
  0x3B, 0x39, 0x36, 0x34, 0x38, 0x33, 0x33, 0x33, 0x33, 0x33, 0x38, 0x36,
  0x0B, 0x0B, 0x33, 0x33, 0x33, 0x34, 0x36, 0x0B, 0x33, 0x38, 0x34, 0x34,
  0x38, 0x38, 0x38, 0x32, 0x32, 0x34, 0x34, 0x37, 0x32, 0x34, 0x37, 0x37,
  0x34, 0x34, 0x37, 0x37, 0x00, 0x00, 0x00, 0x36, 0x36, 0x39, 0x33, 0x33,
  0x38, 0x34, 0x39, 0x39, 0x3B, 0x3B, 0x3B, 0x39, 0x33, 0x35, 0x3B, 0x39,
  0x39, 0x39, 0x36, 0x36, 0x3B, 0x3B, 0x3B, 0x33, 0x34, 0x38, 0x38, 0x0B,
  0x0B, 0x33, 0x33, 0x38, 0x38, 0x0B, 0x0B, 0x33, 0x33, 0x33, 0x34, 0x36,
  0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x34, 0x35, 0x34, 0x34, 0x34, 0x34, 0x34,
  0x36, 0x32, 0x34, 0x37, 0x37, 0x34, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00,
  0x36, 0x36, 0x39, 0x36, 0x38, 0x39, 0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x39,
  0x33, 0x35, 0x3B, 0x3B, 0x3B, 0x39, 0x39, 0x36, 0x36, 0x36, 0x39, 0x33,
  0x33, 0x36, 0x34, 0x38, 0x34, 0x0B, 0x33, 0x33, 0x33, 0x38, 0x34, 0x0B,
  0x0B, 0x0B, 0x33, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x35, 0x34, 0x32,
  0x31, 0x00, 0x00, 0x34, 0x36, 0x34, 0x36, 0x34, 0x37, 0x37, 0x34, 0x34,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x36, 0x36, 0x3B, 0x3B, 0x39,
  0x3B, 0x3B, 0x39, 0x39, 0x32, 0x35, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x39,
  0x39, 0x34, 0x34, 0x36, 0x33, 0x33, 0x33, 0x36, 0x38, 0x38, 0x0B, 0x0B,
  0x33, 0x33, 0x38, 0x38, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x36,
  0x36, 0x31, 0x35, 0x34, 0x34, 0x36, 0x00, 0x00, 0x34, 0x36, 0x34, 0x36,
  0x34, 0x34, 0x37, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36,
  0x3B, 0x34, 0x36, 0x3B, 0x3B, 0x39, 0x39, 0x33, 0x32, 0x35, 0x3B, 0x3B,
  0x3B, 0x3B, 0x3B, 0x39, 0x39, 0x39, 0x36, 0x34, 0x34, 0x0B, 0x0B, 0x33,
  0x33, 0x38, 0x38, 0x34, 0x0B, 0x33, 0x33, 0x33, 0x36, 0x36, 0x36, 0x36,
  0x36, 0x34, 0x34, 0x34, 0x31, 0x34, 0x34, 0x31, 0x37, 0x34, 0x37, 0x00,
  0x00, 0x34, 0x36, 0x34, 0x36, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3B, 0x39, 0x3B, 0x34, 0x39, 0x39, 0x39, 0x33, 0x32,
  0x35, 0x35, 0x33, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x37, 0x39, 0x39, 0x39,
  0x34, 0x34, 0x34, 0x0B, 0x33, 0x33, 0x36, 0x38, 0x38, 0x0B, 0x0B, 0x0B,
  0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x31, 0x34, 0x31, 0x31, 0x34,
  0x36, 0x37, 0x34, 0x37, 0x00, 0x00, 0x34, 0x36, 0x34, 0x36, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x0E, 0x35, 0x39,
  0x39, 0x33, 0x33, 0x39, 0x32, 0x35, 0x35, 0x33, 0x3B, 0x3B, 0x3B, 0x3B,
  0x3B, 0x37, 0x37, 0x39, 0x39, 0x39, 0x34, 0x34, 0x0B, 0x0B, 0x33, 0x33,
  0x0B, 0x38, 0x38, 0x38, 0x34, 0x34, 0x34, 0x34, 0x34, 0x31, 0x34, 0x0B,
  0x31, 0x34, 0x34, 0x34, 0x37, 0x34, 0x36, 0x34, 0x37, 0x34, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x35, 0x33, 0x39, 0x33, 0x0B, 0x39, 0x3B, 0x39, 0x32, 0x35, 0x32,
  0x33, 0x39, 0x3B, 0x39, 0x3B, 0x3B, 0x37, 0x37, 0x37, 0x39, 0x33, 0x34,
  0x34, 0x34, 0x34, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x31, 0x0B,
  0x31, 0x0B, 0x31, 0x34, 0x0B, 0x34, 0x34, 0x37, 0x36, 0x37, 0x34, 0x37,
  0x34, 0x37, 0x34, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x0B, 0x0B, 0x39, 0x3B, 0x3B,
  0x3B, 0x39, 0x33, 0x33, 0x33, 0x33, 0x39, 0x39, 0x36, 0x3B, 0x3B, 0x3B,
  0x36, 0x34, 0x34, 0x33, 0x39, 0x33, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38,
  0x38, 0x31, 0x36, 0x34, 0x31, 0x34, 0x36, 0x0B, 0x31, 0x34, 0x37, 0x21,
  0x21, 0x36, 0x37, 0x34, 0x36, 0x34, 0x37, 0x34, 0x34, 0x34, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32,
  0x0B, 0x0B, 0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x33, 0x33, 0x33, 0x39,
  0x39, 0x36, 0x36, 0x3B, 0x3B, 0x3B, 0x34, 0x34, 0x34, 0x34, 0x33, 0x0B,
  0x33, 0x33, 0x0B, 0x31, 0x31, 0x0B, 0x31, 0x31, 0x31, 0x36, 0x34, 0x31,
  0x34, 0x34, 0x37, 0x21, 0x36, 0x21, 0x36, 0x37, 0x34, 0x37, 0x34, 0x37,
  0x34, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x32, 0x0B, 0x35, 0x39, 0x3B, 0x3B, 0x3B, 0x3B,
  0x3B, 0x3B, 0x39, 0x3B, 0x39, 0x39, 0x36, 0x36, 0x36, 0x39, 0x39, 0x39,
  0x39, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x36,
  0x34, 0x0B, 0x31, 0x0B, 0x34, 0x37, 0x21, 0x21, 0x21, 0x36, 0x37, 0x34,
  0x37, 0x34, 0x32, 0x34, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x35, 0x35,
  0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x3B, 0x39, 0x39, 0x39,
  0x0E, 0x36, 0x36, 0x36, 0x39, 0x39, 0x33, 0x39, 0x33, 0x33, 0x33, 0x33,
  0x0B, 0x33, 0x0B, 0x31, 0x0B, 0x31, 0x0B, 0x34, 0x37, 0x21, 0x21, 0x21,
  0x36, 0x21, 0x36, 0x37, 0x36, 0x36, 0x34, 0x37, 0x34, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x34, 0x35, 0x35, 0x35, 0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B,
  0x39, 0x3B, 0x39, 0x3B, 0x39, 0x0E, 0x39, 0x0E, 0x36, 0x36, 0x36, 0x36,
  0x0E, 0x0E, 0x33, 0x0B, 0x37, 0x0B, 0x37, 0x37, 0x31, 0x37, 0x34, 0x34,
  0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x37, 0x37, 0x34, 0x32, 0x37, 0x36,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x35, 0x36, 0x0E,
  0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x3B, 0x39, 0x3B, 0x39, 0x0E, 0x39,
  0x0E, 0x39, 0x36, 0x0E, 0x36, 0x36, 0x36, 0x37, 0x0B, 0x37, 0x34, 0x31,
  0x37, 0x34, 0x34, 0x37, 0x21, 0x21, 0x21, 0x21, 0x36, 0x37, 0x37, 0x34,
  0x32, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x34, 0x36, 0x36, 0x0E, 0x39, 0x39, 0x39, 0x0E, 0x39, 0x0E,
  0x39, 0x0E, 0x39, 0x0E, 0x0E, 0x0E, 0x0E, 0x36, 0x36, 0x31, 0x36, 0x31,
  0x31, 0x34, 0x36, 0x34, 0x34, 0x37, 0x37, 0x21, 0x21, 0x21, 0x21, 0x21,
  0x21, 0x36, 0x34, 0x32, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x34, 0x36, 0x36, 0x0E,
  0x0E, 0x0E, 0x0E, 0x0E, 0x36, 0x0E, 0x36, 0x0E, 0x36, 0x0E, 0x36, 0x36,
  0x0E, 0x36, 0x34, 0x34, 0x34, 0x34, 0x37, 0x34, 0x37, 0x36, 0x21, 0x21,
  0x21, 0x21, 0x21, 0x21, 0x36, 0x32, 0x32, 0x36, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x34, 0x33, 0x37, 0x37, 0x36, 0x34, 0x36, 0x34, 0x36, 0x34, 0x36, 0x34,
  0x36, 0x34, 0x36, 0x34, 0x36, 0x34, 0x34, 0x36, 0x34, 0x34, 0x34, 0x37,
  0x36, 0x21, 0x21, 0x21, 0x31, 0x21, 0x31, 0x36, 0x31, 0x34, 0x36, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x33, 0x39, 0x37, 0x33, 0x37, 0x0B,
  0x0B, 0x34, 0x34, 0x34, 0x00, 0x00, 0x34, 0x36, 0x34, 0x36, 0x36, 0x34,
  0x36, 0x37, 0x34, 0x37, 0x34, 0x21, 0x37, 0x21, 0x36, 0x31, 0x21, 0x21,
  0x34, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x39,
  0x33, 0x33, 0x31, 0x33, 0x0B, 0x0B, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x34,
  0x36, 0x34, 0x39, 0x33, 0x36, 0x36, 0x36, 0x34, 0x37, 0x36, 0x21, 0x31,
  0x31, 0x36, 0x36, 0x36, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x31, 0x39, 0x31, 0x33, 0x31, 0x33, 0x0B, 0x0B, 0x0B,
  0x00, 0x00, 0x00, 0x00, 0x34, 0x36, 0x34, 0x39, 0x33, 0x33, 0x36, 0x36,
  0x34, 0x31, 0x36, 0x31, 0x31, 0x31, 0x31, 0x31, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x39, 0x0E, 0x33,
  0x31, 0x33, 0x33, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x34,
  0x39, 0x39, 0x33, 0x33, 0x36, 0x34, 0x31, 0x36, 0x36, 0x36, 0x36, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x31, 0x31, 0x33, 0x31, 0x31, 0x33, 0x31, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x36, 0x34, 0x3B, 0x39, 0x39, 0x33, 0x39, 0x34, 0x36,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x33, 0x33, 0x31,
  0x33, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x34, 0x39, 0x3B,
  0x39, 0x33, 0x39, 0x34, 0x34, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x31, 0x31, 0x33, 0x31, 0x33, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x34, 0x34, 0x31, 0x31, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x31, 0x31, 0x0B, 0x34,
  0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x33, 0x31, 0x31, 0x0B, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x0B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask6LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x89, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x05, 0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x7F,
  0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x01, 0x7F, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x88, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1C,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x3E, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFC, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x7E, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3C,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x3F, 0xFF, 0xFC, 0x00,
  0x00, 0x00, 0x03, 0xFE, 0x1F, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0x0F, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0xFF, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F,
  0xC0, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x3F, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite6RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x34, 0x00, 0x00, 0x32, 0x00, 0x00,
  0x00, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x36, 0x32, 0x32, 0x34, 0x36, 0x31,
  0x00, 0x35, 0x32, 0x00, 0x00, 0x33, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x37, 0x32, 0x31, 0x36, 0x36,
  0x33, 0x36, 0x34, 0x31, 0x00, 0x00, 0x36, 0x32, 0x00, 0x33, 0x00, 0x00,
  0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x37, 0x37, 0x37, 0x36, 0x34,
  0x36, 0x36, 0x31, 0x36, 0x36, 0x33, 0x36, 0x31, 0x31, 0x00, 0x36, 0x36,
  0x33, 0x36, 0x32, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x37, 0x36, 0x37, 0x31, 0x36,
  0x33, 0x36, 0x31, 0x21, 0x36, 0x31, 0x31, 0x31, 0x36, 0x33, 0x32, 0x36,
  0x31, 0x31, 0x33, 0x36, 0x33, 0x36, 0x32, 0x00, 0x36, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x37, 0x36, 0x36,
  0x21, 0x33, 0x36, 0x36, 0x36, 0x33, 0x36, 0x33, 0x21, 0x36, 0x36, 0x31,
  0x31, 0x36, 0x33, 0x32, 0x36, 0x31, 0x31, 0x36, 0x33, 0x36, 0x36, 0x00,
  0x36, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x37,
  0x21, 0x33, 0x36, 0x36, 0x36, 0x21, 0x33, 0x36, 0x36, 0x21, 0x33, 0x36,
  0x36, 0x33, 0x31, 0x36, 0x36, 0x31, 0x31, 0x33, 0x32, 0x36, 0x31, 0x31,
  0x36, 0x33, 0x36, 0x33, 0x36, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x37, 0x36, 0x36, 0x21, 0x21, 0x33, 0x36, 0x36, 0x36, 0x21, 0x33,
  0x36, 0x36, 0x21, 0x33, 0x36, 0x36, 0x33, 0x31, 0x36, 0x36, 0x31, 0x31,
  0x33, 0x32, 0x36, 0x31, 0x36, 0x33, 0x36, 0x33, 0x36, 0x00, 0x32, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x37, 0x37, 0x36, 0x33, 0x36, 0x36, 0x21, 0x21, 0x21,
  0x33, 0x36, 0x36, 0x21, 0x33, 0x36, 0x36, 0x36, 0x21, 0x36, 0x31, 0x33,
  0x31, 0x36, 0x36, 0x31, 0x31, 0x33, 0x34, 0x31, 0x34, 0x33, 0x36, 0x33,
  0x36, 0x33, 0x36, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x37, 0x36, 0x21, 0x21,
  0x33, 0x36, 0x37, 0x21, 0x21, 0x33, 0x37, 0x36, 0x31, 0x33, 0x31, 0x36,
  0x31, 0x31, 0x36, 0x31, 0x31, 0x31, 0x34, 0x0B, 0x31, 0x31, 0x34, 0x31,
  0x34, 0x33, 0x34, 0x33, 0x36, 0x33, 0x36, 0x00, 0x32, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x33, 0x33,
  0x36, 0x37, 0x21, 0x21, 0x21, 0x33, 0x36, 0x37, 0x31, 0x31, 0x31, 0x37,
  0x31, 0x37, 0x37, 0x36, 0x36, 0x31, 0x37, 0x31, 0x37, 0x31, 0x34, 0x37,
  0x31, 0x37, 0x37, 0x34, 0x34, 0x0B, 0x34, 0x33, 0x34, 0x33, 0x36, 0x00,
  0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x32, 0x34, 0x36, 0x21, 0x21, 0x33, 0x36, 0x21, 0x21, 0x21, 0x33, 0x36,
  0x36, 0x31, 0x37, 0x36, 0x37, 0x36, 0x0B, 0x37, 0x37, 0x34, 0x34, 0x0B,
  0x0B, 0x0B, 0x34, 0x34, 0x0B, 0x0B, 0x0B, 0x34, 0x7B, 0x0B, 0x0B, 0x0B,
  0x34, 0x33, 0x36, 0x33, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x32, 0x39, 0x21, 0x36, 0x33, 0x21, 0x21, 0x33, 0x36,
  0x21, 0x21, 0x21, 0x37, 0x36, 0x37, 0x31, 0x34, 0x34, 0x34, 0x0B, 0x32,
  0x0B, 0x33, 0x34, 0x34, 0x0B, 0x0B, 0x0B, 0x38, 0x34, 0x34, 0x32, 0x0B,
  0x35, 0x38, 0x34, 0x32, 0x0B, 0x38, 0x38, 0x36, 0x34, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x34, 0x21, 0x36, 0x36, 0x37,
  0x33, 0x21, 0x21, 0x33, 0x36, 0x21, 0x36, 0x34, 0x32, 0x32, 0x37, 0x37,
  0x0B, 0x34, 0x34, 0x34, 0x32, 0x32, 0x0B, 0x0B, 0x38, 0x34, 0x0B, 0x0B,
  0x38, 0x38, 0x34, 0x32, 0x0B, 0x0B, 0x34, 0x38, 0x32, 0x32, 0x0B, 0x38,
  0x38, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x21,
  0x36, 0x34, 0x37, 0x21, 0x21, 0x36, 0x21, 0x21, 0x37, 0x36, 0x37, 0x34,
  0x34, 0x34, 0x32, 0x0B, 0x0B, 0x0B, 0x0B, 0x38, 0x38, 0x34, 0x32, 0x32,
  0x0B, 0x38, 0x34, 0x0B, 0x0B, 0x0B, 0x34, 0x34, 0x32, 0x0B, 0x0B, 0x34,
  0x38, 0x32, 0x32, 0x0B, 0x38, 0x38, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x32, 0x35, 0x21, 0x34, 0x21, 0x36, 0x37, 0x21, 0x21, 0x36, 0x21,
  0x34, 0x32, 0x32, 0x37, 0x37, 0x0B, 0x34, 0x37, 0x32, 0x32, 0x0B, 0x0B,
  0x0B, 0x38, 0x34, 0x38, 0x32, 0x33, 0x38, 0x38, 0x34, 0x0B, 0x0B, 0x38,
  0x38, 0x34, 0x32, 0x0B, 0x34, 0x38, 0x32, 0x32, 0x0B, 0x38, 0x38, 0x34,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x34, 0x21, 0x34, 0x37, 0x21, 0x36,
  0x37, 0x21, 0x37, 0x36, 0x36, 0x34, 0x34, 0x34, 0x0B, 0x0B, 0x0B, 0x0B,
  0x38, 0x37, 0x32, 0x32, 0x0B, 0x33, 0x0B, 0x34, 0x34, 0x32, 0x32, 0x0B,
  0x38, 0x34, 0x0B, 0x0B, 0x0B, 0x38, 0x34, 0x34, 0x32, 0x0B, 0x38, 0x34,
  0x32, 0x32, 0x38, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x34,
  0x21, 0x21, 0x37, 0x21, 0x37, 0x37, 0x37, 0x36, 0x37, 0x32, 0x0B, 0x34,
  0x37, 0x38, 0x0B, 0x0B, 0x0B, 0x0B, 0x38, 0x37, 0x32, 0x32, 0x0B, 0x0B,
  0x38, 0x38, 0x34, 0x33, 0x0B, 0x34, 0x38, 0x0B, 0x33, 0x0B, 0x38, 0x38,
  0x34, 0x39, 0x32, 0x38, 0x38, 0x32, 0x32, 0x34, 0x34, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x34, 0x21, 0x21, 0x37, 0x21, 0x21, 0x37, 0x21, 0x37, 0x36, 0x34,
  0x0B, 0x0B, 0x32, 0x32, 0x0B, 0x37, 0x37, 0x34, 0x33, 0x0B, 0x0B, 0x38,
  0x34, 0x37, 0x33, 0x33, 0x0B, 0x0B, 0x34, 0x34, 0x33, 0x0B, 0x38, 0x38,
  0x0B, 0x33, 0x0B, 0x32, 0x34, 0x38, 0x39, 0x32, 0x38, 0x34, 0x32, 0x34,
  0x38, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x37, 0x36, 0x21, 0x37, 0x37, 0x21,
  0x37, 0x36, 0x34, 0x0B, 0x0B, 0x37, 0x38, 0x0B, 0x0B, 0x0B, 0x0B, 0x37,
  0x38, 0x0B, 0x33, 0x0B, 0x0B, 0x38, 0x34, 0x33, 0x33, 0x33, 0x0B, 0x38,
  0x38, 0x33, 0x0B, 0x0B, 0x34, 0x0B, 0x33, 0x0B, 0x32, 0x34, 0x34, 0x39,
  0x32, 0x38, 0x34, 0x34, 0x38, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x34, 0x37,
  0x37, 0x21, 0x37, 0x37, 0x37, 0x34, 0x0B, 0x37, 0x0B, 0x0B, 0x0B, 0x38,
  0x38, 0x37, 0x0B, 0x0B, 0x34, 0x38, 0x0B, 0x33, 0x0B, 0x0B, 0x38, 0x38,
  0x0B, 0x33, 0x33, 0x0B, 0x38, 0x38, 0x33, 0x0B, 0x0B, 0x34, 0x0B, 0x33,
  0x39, 0x32, 0x36, 0x34, 0x39, 0x32, 0x38, 0x3A, 0x34, 0x34, 0x34, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x34, 0x21, 0x34, 0x34, 0x37, 0x34, 0x37, 0x34, 0x36, 0x34, 0x36,
  0x37, 0x34, 0x34, 0x0B, 0x33, 0x34, 0x37, 0x0B, 0x0B, 0x0B, 0x38, 0x38,
  0x33, 0x33, 0x0B, 0x38, 0x34, 0x0B, 0x39, 0x33, 0x0B, 0x38, 0x38, 0x33,
  0x33, 0x0B, 0x34, 0x33, 0x39, 0x39, 0x32, 0x36, 0x34, 0x32, 0x33, 0x3A,
  0x34, 0x38, 0x38, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x34, 0x34, 0x00, 0x00, 0x36, 0x21, 0x36, 0x34, 0x37, 0x34,
  0x36, 0x34, 0x36, 0x32, 0x32, 0x32, 0x34, 0x38, 0x0B, 0x0B, 0x34, 0x38,
  0x33, 0x0B, 0x0B, 0x34, 0x38, 0x0B, 0x33, 0x33, 0x38, 0x38, 0x34, 0x33,
  0x39, 0x0B, 0x38, 0x34, 0x39, 0x33, 0x33, 0x34, 0x33, 0x39, 0x39, 0x33,
  0x34, 0x39, 0x3A, 0x3A, 0x34, 0x38, 0x38, 0x38, 0x34, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x34, 0x36, 0x34, 0x00, 0x00, 0x36,
  0x21, 0x36, 0x34, 0x34, 0x34, 0x37, 0x32, 0x36, 0x36, 0x39, 0x0B, 0x34,
  0x38, 0x33, 0x0B, 0x34, 0x38, 0x33, 0x33, 0x39, 0x34, 0x38, 0x0B, 0x39,
  0x33, 0x0B, 0x38, 0x38, 0x39, 0x39, 0x0B, 0x38, 0x34, 0x39, 0x39, 0x33,
  0x0B, 0x33, 0x3B, 0x39, 0x39, 0x34, 0x34, 0x34, 0x34, 0x3A, 0x32, 0x38,
  0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x34, 0x34,
  0x36, 0x34, 0x00, 0x00, 0x34, 0x21, 0x34, 0x36, 0x37, 0x32, 0x36, 0x36,
  0x34, 0x36, 0x3B, 0x0B, 0x0B, 0x34, 0x33, 0x0B, 0x32, 0x38, 0x0B, 0x33,
  0x39, 0x34, 0x38, 0x0B, 0x3B, 0x39, 0x0B, 0x38, 0x38, 0x3B, 0x39, 0x0B,
  0x38, 0x34, 0x3B, 0x3B, 0x33, 0x0B, 0x33, 0x3B, 0x3B, 0x34, 0x35, 0x34,
  0x0B, 0x32, 0x38, 0x38, 0x38, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x37, 0x37, 0x37, 0x34, 0x34, 0x36, 0x34, 0x00, 0x00, 0x34, 0x34, 0x34,
  0x0B, 0x37, 0x36, 0x34, 0x7B, 0x34, 0x3B, 0x33, 0x0B, 0x38, 0x35, 0x33,
  0x33, 0x32, 0x38, 0x34, 0x33, 0x3B, 0x39, 0x34, 0x34, 0x3B, 0x39, 0x33,
  0x38, 0x38, 0x3B, 0x39, 0x0B, 0x38, 0x34, 0x3B, 0x3B, 0x39, 0x33, 0x33,
  0x36, 0x35, 0x35, 0x35, 0x0B, 0x34, 0x34, 0x39, 0x39, 0x36, 0x38, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x34, 0x34, 0x37, 0x37, 0x34, 0x34, 0x36, 0x34,
  0x00, 0x38, 0x38, 0x37, 0x0B, 0x37, 0x34, 0x7B, 0x7B, 0x7B, 0x36, 0x3B,
  0x39, 0x0B, 0x38, 0x0B, 0x0B, 0x33, 0x32, 0x34, 0x34, 0x0B, 0x3B, 0x39,
  0x34, 0x34, 0x3B, 0x39, 0x33, 0x34, 0x34, 0x3B, 0x39, 0x33, 0x38, 0x34,
  0x3B, 0x3B, 0x39, 0x33, 0x35, 0x0B, 0x0B, 0x39, 0x0B, 0x36, 0x3B, 0x7B,
  0x7B, 0x39, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x34, 0x34, 0x34,
  0x37, 0x34, 0x36, 0x21, 0x37, 0x38, 0x38, 0x34, 0x32, 0x36, 0x34, 0x7B,
  0x7B, 0x7B, 0x34, 0x3B, 0x33, 0x39, 0x0B, 0x38, 0x34, 0x0B, 0x34, 0x34,
  0x33, 0x3B, 0x39, 0x34, 0x34, 0x34, 0x0B, 0x3B, 0x3B, 0x39, 0x34, 0x34,
  0x3B, 0x3B, 0x33, 0x38, 0x34, 0x39, 0x3B, 0x32, 0x0B, 0x39, 0x39, 0x0B,
  0x36, 0x34, 0x39, 0x7B, 0x7B, 0x36, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00,
  0x34, 0x37, 0x37, 0x37, 0x34, 0x37, 0x34, 0x21, 0x37, 0x34, 0x34, 0x0B,
  0x32, 0x37, 0x34, 0x7B, 0x7B, 0x7B, 0x34, 0x3B, 0x39, 0x33, 0x3B, 0x0B,
  0x38, 0x38, 0x33, 0x3B, 0x39, 0x34, 0x34, 0x34, 0x0B, 0x39, 0x3B, 0x3B,
  0x34, 0x34, 0x34, 0x34, 0x34, 0x3B, 0x39, 0x33, 0x34, 0x36, 0x33, 0x32,
  0x0B, 0x39, 0x0B, 0x39, 0x36, 0x39, 0x34, 0x39, 0x36, 0x34, 0x34, 0x36,
  0x0B, 0x00, 0x00, 0x00, 0x34, 0x34, 0x34, 0x37, 0x37, 0x37, 0x37, 0x21,
  0x21, 0x37, 0x39, 0x0B, 0x33, 0x36, 0x34, 0x7B, 0x7B, 0x7B, 0x34, 0x3B,
  0x39, 0x39, 0x39, 0x3B, 0x34, 0x33, 0x3B, 0x39, 0x38, 0x38, 0x0B, 0x39,
  0x3B, 0x3B, 0x3B, 0x38, 0x34, 0x34, 0x36, 0x39, 0x39, 0x39, 0x39, 0x39,
  0x33, 0x34, 0x33, 0x0B, 0x0B, 0x39, 0x39, 0x3B, 0x36, 0x39, 0x39, 0x34,
  0x38, 0x34, 0x34, 0x36, 0x31, 0x31, 0x0B, 0x00, 0x34, 0x34, 0x34, 0x34,
  0x34, 0x37, 0x37, 0x37, 0x21, 0x21, 0x37, 0x0B, 0x32, 0x37, 0x36, 0x34,
  0x7B, 0x7B, 0x34, 0x3B, 0x0B, 0x34, 0x34, 0x38, 0x33, 0x3B, 0x34, 0x38,
  0x34, 0x0B, 0x39, 0x39, 0x39, 0x38, 0x38, 0x38, 0x39, 0x39, 0x3B, 0x3B,
  0x3B, 0x3B, 0x36, 0x34, 0x34, 0x34, 0x32, 0x0B, 0x39, 0x39, 0x39, 0x3B,
  0x36, 0x39, 0x36, 0x38, 0x38, 0x34, 0x36, 0x31, 0x31, 0x31, 0x31, 0x31,
  0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x37, 0x37, 0x37, 0x21, 0x21, 0x34,
  0x33, 0x0B, 0x3B, 0x36, 0x34, 0x34, 0x36, 0x3B, 0x34, 0x38, 0x33, 0x0B,
  0x0B, 0x7B, 0x7B, 0x0B, 0x39, 0x39, 0x0B, 0x36, 0x38, 0x38, 0x39, 0x39,
  0x3B, 0x3B, 0x3B, 0x34, 0x34, 0x34, 0x34, 0x36, 0x39, 0x39, 0x32, 0x0B,
  0x39, 0x39, 0x3B, 0x3B, 0x36, 0x39, 0x36, 0x38, 0x34, 0x36, 0x31, 0x31,
  0x33, 0x39, 0x39, 0x39, 0x34, 0x34, 0x34, 0x34, 0x34, 0x37, 0x37, 0x37,
  0x21, 0x21, 0x37, 0x0B, 0x33, 0x34, 0x0B, 0x3B, 0x34, 0x36, 0x3B, 0x0B,
  0x38, 0x33, 0x0B, 0x0B, 0x7B, 0x34, 0x33, 0x33, 0x39, 0x0B, 0x36, 0x38,
  0x39, 0x33, 0x39, 0x33, 0x3B, 0x39, 0x34, 0x34, 0x34, 0x39, 0x39, 0x3B,
  0x3B, 0x3B, 0x32, 0x39, 0x39, 0x39, 0x3B, 0x3B, 0x39, 0x39, 0x34, 0x38,
  0x36, 0x31, 0x31, 0x39, 0x39, 0x36, 0x34, 0x00, 0x34, 0x34, 0x34, 0x37,
  0x37, 0x34, 0x37, 0x21, 0x21, 0x37, 0x32, 0x0B, 0x34, 0x36, 0x36, 0x32,
  0x3B, 0x3B, 0x0B, 0x38, 0x33, 0x0B, 0x36, 0x34, 0x0B, 0x33, 0x33, 0x33,
  0x0B, 0x36, 0x38, 0x39, 0x33, 0x33, 0x39, 0x39, 0x38, 0x38, 0x34, 0x39,
  0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x32, 0x39, 0x39, 0x3B, 0x3B, 0x3B,
  0x39, 0x39, 0x38, 0x38, 0x36, 0x39, 0x39, 0x36, 0x36, 0x34, 0x0B, 0x00,
  0x34, 0x34, 0x37, 0x37, 0x34, 0x37, 0x37, 0x21, 0x32, 0x37, 0x37, 0x34,
  0x32, 0x38, 0x38, 0x38, 0x34, 0x34, 0x38, 0x33, 0x0B, 0x36, 0x34, 0x33,
  0x33, 0x33, 0x0B, 0x0B, 0x36, 0x38, 0x33, 0x33, 0x33, 0x33, 0x33, 0x38,
  0x34, 0x36, 0x39, 0x3B, 0x3B, 0x36, 0x36, 0x36, 0x39, 0x39, 0x32, 0x33,
  0x39, 0x3B, 0x3B, 0x3B, 0x39, 0x39, 0x38, 0x38, 0x33, 0x36, 0x39, 0x39,
  0x34, 0x36, 0x34, 0x0B, 0x37, 0x37, 0x34, 0x34, 0x37, 0x37, 0x34, 0x32,
  0x37, 0x34, 0x34, 0x32, 0x34, 0x35, 0x34, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
  0x36, 0x34, 0x33, 0x33, 0x33, 0x0B, 0x0B, 0x38, 0x38, 0x33, 0x33, 0x0B,
  0x0B, 0x38, 0x38, 0x34, 0x33, 0x3B, 0x3B, 0x3B, 0x36, 0x36, 0x39, 0x39,
  0x39, 0x3B, 0x35, 0x33, 0x39, 0x3B, 0x3B, 0x3B, 0x39, 0x39, 0x34, 0x38,
  0x33, 0x33, 0x39, 0x36, 0x36, 0x00, 0x00, 0x00, 0x34, 0x34, 0x34, 0x37,
  0x37, 0x34, 0x32, 0x36, 0x34, 0x00, 0x00, 0x34, 0x32, 0x34, 0x35, 0x34,
  0x34, 0x34, 0x34, 0x34, 0x34, 0x33, 0x0B, 0x0B, 0x0B, 0x34, 0x38, 0x33,
  0x33, 0x33, 0x0B, 0x34, 0x38, 0x34, 0x36, 0x33, 0x33, 0x39, 0x36, 0x36,
  0x36, 0x39, 0x39, 0x3B, 0x3B, 0x3B, 0x35, 0x33, 0x39, 0x3B, 0x3B, 0x3B,
  0x3B, 0x39, 0x39, 0x38, 0x36, 0x39, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00,
  0x34, 0x34, 0x37, 0x37, 0x34, 0x36, 0x34, 0x34, 0x00, 0x00, 0x34, 0x31,
  0x34, 0x35, 0x31, 0x36, 0x36, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
  0x38, 0x38, 0x33, 0x33, 0x0B, 0x0B, 0x38, 0x38, 0x36, 0x33, 0x33, 0x33,
  0x36, 0x34, 0x34, 0x39, 0x39, 0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x35, 0x32,
  0x39, 0x39, 0x3B, 0x3B, 0x39, 0x3B, 0x3B, 0x36, 0x36, 0x36, 0x36, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x37, 0x37, 0x34, 0x34, 0x36, 0x34, 0x00, 0x00,
  0x00, 0x34, 0x36, 0x34, 0x34, 0x34, 0x34, 0x31, 0x34, 0x34, 0x34, 0x36,
  0x36, 0x36, 0x36, 0x36, 0x33, 0x33, 0x33, 0x0B, 0x34, 0x38, 0x38, 0x33,
  0x33, 0x0B, 0x0B, 0x34, 0x34, 0x36, 0x39, 0x39, 0x39, 0x3B, 0x3B, 0x3B,
  0x3B, 0x3B, 0x35, 0x32, 0x33, 0x39, 0x39, 0x3B, 0x3B, 0x36, 0x34, 0x3B,
  0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x34, 0x36,
  0x34, 0x00, 0x00, 0x00, 0x34, 0x37, 0x34, 0x37, 0x31, 0x34, 0x31, 0x34,
  0x31, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x38,
  0x38, 0x36, 0x33, 0x33, 0x0B, 0x34, 0x34, 0x34, 0x39, 0x39, 0x39, 0x37,
  0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x33, 0x35, 0x35, 0x32, 0x33, 0x39, 0x39,
  0x39, 0x34, 0x3B, 0x39, 0x3B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x34, 0x36, 0x34, 0x00, 0x00, 0x00, 0x34, 0x37, 0x34, 0x37, 0x36,
  0x34, 0x31, 0x34, 0x31, 0x0B, 0x34, 0x31, 0x34, 0x34, 0x34, 0x34, 0x34,
  0x38, 0x38, 0x38, 0x0B, 0x33, 0x33, 0x0B, 0x0B, 0x34, 0x34, 0x39, 0x39,
  0x39, 0x37, 0x37, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x33, 0x35, 0x35, 0x32,
  0x39, 0x33, 0x33, 0x39, 0x39, 0x35, 0x0E, 0x39, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x34, 0x37,
  0x34, 0x36, 0x34, 0x37, 0x34, 0x34, 0x31, 0x0B, 0x34, 0x31, 0x0B, 0x31,
  0x0B, 0x31, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x34, 0x34, 0x34,
  0x34, 0x33, 0x39, 0x37, 0x37, 0x37, 0x3B, 0x3B, 0x39, 0x3B, 0x39, 0x33,
  0x32, 0x35, 0x32, 0x39, 0x3B, 0x39, 0x0B, 0x33, 0x39, 0x33, 0x35, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x34, 0x37, 0x34, 0x37, 0x34, 0x37, 0x36, 0x37, 0x34, 0x34, 0x31,
  0x0B, 0x36, 0x34, 0x31, 0x34, 0x36, 0x31, 0x38, 0x38, 0x34, 0x34, 0x34,
  0x34, 0x34, 0x33, 0x39, 0x33, 0x34, 0x34, 0x36, 0x3B, 0x3B, 0x3B, 0x36,
  0x39, 0x39, 0x33, 0x33, 0x33, 0x33, 0x39, 0x3B, 0x3B, 0x3B, 0x39, 0x0B,
  0x0B, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x34, 0x37, 0x34, 0x36, 0x34, 0x37, 0x36, 0x21,
  0x21, 0x37, 0x34, 0x31, 0x31, 0x34, 0x36, 0x31, 0x31, 0x31, 0x0B, 0x31,
  0x31, 0x0B, 0x33, 0x33, 0x0B, 0x33, 0x34, 0x34, 0x34, 0x34, 0x3B, 0x3B,
  0x3B, 0x36, 0x36, 0x39, 0x39, 0x33, 0x33, 0x33, 0x3B, 0x3B, 0x3B, 0x3B,
  0x3B, 0x39, 0x0B, 0x0B, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x37, 0x34, 0x37, 0x34,
  0x37, 0x36, 0x21, 0x36, 0x21, 0x37, 0x34, 0x34, 0x0B, 0x31, 0x0B, 0x34,
  0x36, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x39,
  0x39, 0x39, 0x39, 0x36, 0x36, 0x36, 0x39, 0x39, 0x3B, 0x39, 0x3B, 0x3B,
  0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x35, 0x0B, 0x32, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34,
  0x34, 0x32, 0x34, 0x37, 0x34, 0x37, 0x36, 0x21, 0x21, 0x21, 0x37, 0x34,
  0x34, 0x0B, 0x31, 0x0B, 0x31, 0x0B, 0x33, 0x0B, 0x33, 0x33, 0x33, 0x33,
  0x39, 0x33, 0x39, 0x39, 0x36, 0x36, 0x36, 0x0E, 0x39, 0x39, 0x39, 0x3B,
  0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x35, 0x35, 0x32, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x34, 0x37, 0x34, 0x36, 0x36, 0x37, 0x36, 0x21, 0x36,
  0x21, 0x21, 0x21, 0x37, 0x34, 0x34, 0x37, 0x31, 0x37, 0x37, 0x0B, 0x37,
  0x0B, 0x33, 0x0E, 0x0E, 0x36, 0x36, 0x36, 0x36, 0x0E, 0x39, 0x0E, 0x39,
  0x3B, 0x39, 0x3B, 0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x35, 0x35,
  0x35, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x36, 0x37, 0x32, 0x34,
  0x37, 0x37, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x37, 0x34, 0x34, 0x37,
  0x31, 0x34, 0x37, 0x0B, 0x37, 0x36, 0x36, 0x36, 0x0E, 0x36, 0x39, 0x0E,
  0x39, 0x0E, 0x39, 0x3B, 0x39, 0x3B, 0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B,
  0x0E, 0x36, 0x35, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x34, 0x36, 0x36, 0x32, 0x34, 0x37, 0x37, 0x36, 0x21, 0x21, 0x21, 0x21,
  0x21, 0x37, 0x37, 0x34, 0x34, 0x36, 0x34, 0x31, 0x31, 0x36, 0x31, 0x36,
  0x36, 0x0E, 0x0E, 0x0E, 0x0E, 0x39, 0x0E, 0x39, 0x0E, 0x39, 0x0E, 0x39,
  0x39, 0x39, 0x0E, 0x36, 0x36, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x37, 0x36, 0x32, 0x34, 0x36, 0x21,
  0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x37, 0x34, 0x37, 0x34, 0x34,
  0x34, 0x34, 0x36, 0x0E, 0x36, 0x36, 0x0E, 0x36, 0x0E, 0x36, 0x0E, 0x36,
  0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x36, 0x36, 0x34, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x31,
  0x36, 0x32, 0x32, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36,
  0x37, 0x34, 0x34, 0x34, 0x36, 0x34, 0x34, 0x36, 0x34, 0x36, 0x34, 0x36,
  0x34, 0x36, 0x34, 0x36, 0x34, 0x36, 0x34, 0x36, 0x37, 0x37, 0x34, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x34, 0x31, 0x36, 0x34, 0x31, 0x36, 0x31, 0x21, 0x31,
  0x21, 0x37, 0x21, 0x34, 0x37, 0x34, 0x37, 0x36, 0x34, 0x36, 0x36, 0x34,
  0x36, 0x00, 0x00, 0x00, 0x34, 0x34, 0x34, 0x0B, 0x0B, 0x37, 0x33, 0x37,
  0x39, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x31, 0x31, 0x34,
  0x21, 0x21, 0x31, 0x36, 0x31, 0x21, 0x36, 0x37, 0x34, 0x36, 0x36, 0x36,
  0x33, 0x39, 0x34, 0x36, 0x00, 0x00, 0x00, 0x00, 0x34, 0x37, 0x0B, 0x0B,
  0x33, 0x31, 0x33, 0x33, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x34, 0x31, 0x31, 0x36, 0x36, 0x36, 0x31, 0x31, 0x36, 0x31, 0x34,
  0x36, 0x36, 0x33, 0x33, 0x39, 0x34, 0x36, 0x00, 0x00, 0x00, 0x00, 0x34,
  0x37, 0x0B, 0x0B, 0x33, 0x31, 0x33, 0x31, 0x39, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x31, 0x31, 0x31, 0x31,
  0x36, 0x31, 0x34, 0x36, 0x33, 0x33, 0x39, 0x39, 0x34, 0x36, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0B, 0x0B, 0x35, 0x33, 0x31, 0x33, 0x0E, 0x39, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x36, 0x36, 0x36, 0x36, 0x34, 0x39, 0x33, 0x39, 0x39, 0x31, 0x34,
  0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x31, 0x33, 0x31, 0x33,
  0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x31, 0x33, 0x39,
  0x31, 0x31, 0x34, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x31,
  0x33, 0x31, 0x33, 0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34,
  0x31, 0x33, 0x31, 0x31, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0x33, 0x31, 0x33, 0x31, 0x31, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x34, 0x31, 0x31, 0x34, 0x34, 0x00, 0x00, 0x34, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x31, 0x31, 0x31, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x34, 0x34, 0x34, 0x00, 0x00, 0x00,
  0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x31, 0x31,
  0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0B, 0x33, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask6RA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xF6, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F,
  0xF3, 0x48, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFB, 0xE8, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xE8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xEA, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFA, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFE, 0x80, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFE, 0x80, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0x80, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x79, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x7C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFC, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x71, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x23, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xE0, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xF8, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xF0, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xE1,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xC1, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0x81, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x01, 0xF2, 0x03, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xE4, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x88, 0x07,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite6RB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x32, 0x32, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x33,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x32, 0x32, 0x36, 0x32, 0x32, 0x32,
  0x32, 0x32, 0x00, 0x00, 0x32, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x32, 0x21, 0x32, 0x32, 0x36,
  0x36, 0x31, 0x32, 0x35, 0x32, 0x32, 0x32, 0x00, 0x32, 0x00, 0x00, 0x32,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x32, 0x37, 0x37, 0x31, 0x31,
  0x36, 0x36, 0x33, 0x36, 0x35, 0x31, 0x32, 0x32, 0x36, 0x32, 0x33, 0x36,
  0x32, 0x32, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x37, 0x37, 0x21, 0x21, 0x36,
  0x21, 0x31, 0x36, 0x31, 0x31, 0x36, 0x36, 0x33, 0x36, 0x31, 0x31, 0x32,
  0x36, 0x36, 0x33, 0x36, 0x32, 0x32, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x37, 0x31,
  0x36, 0x21, 0x21, 0x21, 0x36, 0x21, 0x31, 0x36, 0x31, 0x31, 0x36, 0x33,
  0x32, 0x36, 0x31, 0x31, 0x33, 0x36, 0x33, 0x36, 0x36, 0x36, 0x36, 0x36,
  0x32, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32,
  0x37, 0x37, 0x21, 0x21, 0x31, 0x36, 0x21, 0x21, 0x21, 0x36, 0x21, 0x21,
  0x36, 0x36, 0x31, 0x31, 0x36, 0x33, 0x32, 0x36, 0x31, 0x36, 0x31, 0x36,
  0x33, 0x36, 0x33, 0x36, 0x32, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x32, 0x21, 0x21, 0x21, 0x39, 0x36, 0x21, 0x21, 0x36, 0x36,
  0x21, 0x21, 0x36, 0x36, 0x31, 0x31, 0x36, 0x36, 0x31, 0x31, 0x33, 0x32,
  0x36, 0x36, 0x31, 0x36, 0x33, 0x36, 0x33, 0x36, 0x32, 0x00, 0x32, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x32, 0x37, 0x37, 0x21, 0x21, 0x21, 0x36, 0x36,
  0x36, 0x21, 0x21, 0x36, 0x36, 0x21, 0x21, 0x36, 0x36, 0x21, 0x31, 0x36,
  0x36, 0x31, 0x31, 0x33, 0x33, 0x34, 0x31, 0x34, 0x33, 0x36, 0x33, 0x36,
  0x32, 0x36, 0x32, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x34, 0x36, 0x36,
  0x21, 0x21, 0x21, 0x21, 0x36, 0x36, 0x21, 0x21, 0x21, 0x36, 0x36, 0x21,
  0x36, 0x31, 0x21, 0x31, 0x36, 0x36, 0x31, 0x31, 0x31, 0x34, 0x31, 0x34,
  0x33, 0x34, 0x33, 0x36, 0x33, 0x36, 0x32, 0x36, 0x32, 0x34, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x37,
  0x39, 0x21, 0x21, 0x21, 0x36, 0x37, 0x21, 0x21, 0x21, 0x37, 0x36, 0x31,
  0x31, 0x31, 0x36, 0x31, 0x31, 0x36, 0x31, 0x31, 0x31, 0x34, 0x0B, 0x31,
  0x31, 0x37, 0x37, 0x34, 0x34, 0x0B, 0x34, 0x33, 0x33, 0x36, 0x32, 0x36,
  0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x32, 0x36, 0x33, 0x36, 0x37, 0x21, 0x21, 0x21, 0x21, 0x36, 0x37, 0x31,
  0x31, 0x31, 0x37, 0x34, 0x36, 0x37, 0x36, 0x36, 0x31, 0x37, 0x31, 0x0B,
  0x0B, 0x0B, 0x34, 0x34, 0x0B, 0x0B, 0x0B, 0x34, 0x7B, 0x0B, 0x0B, 0x0B,
  0x34, 0x33, 0x36, 0x33, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x32, 0x34, 0x36, 0x21, 0x21, 0x21, 0x36, 0x21, 0x21,
  0x21, 0x21, 0x36, 0x36, 0x31, 0x37, 0x36, 0x37, 0x36, 0x34, 0x37, 0x37,
  0x0B, 0x33, 0x34, 0x34, 0x0B, 0x0B, 0x0B, 0x38, 0x34, 0x34, 0x32, 0x0B,
  0x35, 0x38, 0x34, 0x32, 0x0B, 0x38, 0x38, 0x36, 0x34, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x21, 0x36, 0x21, 0x21,
  0x21, 0x21, 0x36, 0x21, 0x21, 0x21, 0x21, 0x36, 0x37, 0x31, 0x34, 0x37,
  0x0B, 0x34, 0x34, 0x34, 0x32, 0x32, 0x0B, 0x0B, 0x38, 0x34, 0x0B, 0x0B,
  0x38, 0x38, 0x34, 0x32, 0x0B, 0x0B, 0x34, 0x38, 0x32, 0x32, 0x0B, 0x38,
  0x38, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x34,
  0x21, 0x36, 0x37, 0x36, 0x21, 0x21, 0x21, 0x36, 0x21, 0x36, 0x34, 0x34,
  0x34, 0x34, 0x32, 0x0B, 0x0B, 0x0B, 0x0B, 0x38, 0x38, 0x34, 0x32, 0x32,
  0x0B, 0x38, 0x34, 0x0B, 0x0B, 0x0B, 0x34, 0x34, 0x32, 0x0B, 0x0B, 0x34,
  0x38, 0x32, 0x32, 0x0B, 0x38, 0x38, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x39, 0x21, 0x36, 0x34, 0x21, 0x21, 0x21, 0x36, 0x21, 0x21,
  0x21, 0x36, 0x32, 0x37, 0x37, 0x0B, 0x34, 0x37, 0x32, 0x32, 0x0B, 0x0B,
  0x0B, 0x38, 0x34, 0x38, 0x32, 0x33, 0x38, 0x38, 0x34, 0x0B, 0x0B, 0x38,
  0x38, 0x34, 0x32, 0x0B, 0x34, 0x38, 0x32, 0x32, 0x0B, 0x38, 0x38, 0x34,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x21, 0x34, 0x21, 0x36, 0x21,
  0x21, 0x21, 0x36, 0x21, 0x34, 0x32, 0x34, 0x34, 0x0B, 0x0B, 0x0B, 0x0B,
  0x38, 0x37, 0x32, 0x32, 0x0B, 0x33, 0x0B, 0x34, 0x34, 0x32, 0x32, 0x0B,
  0x38, 0x34, 0x0B, 0x0B, 0x0B, 0x38, 0x34, 0x34, 0x32, 0x0B, 0x38, 0x34,
  0x32, 0x32, 0x38, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21,
  0x34, 0x37, 0x21, 0x36, 0x21, 0x21, 0x37, 0x36, 0x36, 0x32, 0x0B, 0x34,
  0x37, 0x38, 0x0B, 0x0B, 0x0B, 0x0B, 0x38, 0x37, 0x32, 0x32, 0x0B, 0x0B,
  0x38, 0x38, 0x34, 0x33, 0x0B, 0x34, 0x38, 0x0B, 0x33, 0x0B, 0x38, 0x38,
  0x34, 0x39, 0x32, 0x38, 0x38, 0x32, 0x32, 0x34, 0x34, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x21, 0x34, 0x21, 0x21, 0x37, 0x21, 0x37, 0x37, 0x37, 0x36,
  0x0B, 0x0B, 0x32, 0x32, 0x0B, 0x37, 0x37, 0x34, 0x33, 0x0B, 0x0B, 0x38,
  0x34, 0x37, 0x33, 0x33, 0x0B, 0x0B, 0x34, 0x34, 0x33, 0x0B, 0x38, 0x38,
  0x0B, 0x33, 0x0B, 0x32, 0x34, 0x38, 0x39, 0x32, 0x38, 0x34, 0x32, 0x34,
  0x38, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x34, 0x34, 0x37, 0x21, 0x37, 0x37,
  0x37, 0x37, 0x36, 0x34, 0x0B, 0x37, 0x38, 0x0B, 0x0B, 0x0B, 0x0B, 0x37,
  0x38, 0x0B, 0x33, 0x0B, 0x0B, 0x38, 0x34, 0x33, 0x33, 0x33, 0x0B, 0x38,
  0x38, 0x33, 0x0B, 0x0B, 0x34, 0x0B, 0x33, 0x0B, 0x32, 0x34, 0x34, 0x39,
  0x32, 0x38, 0x34, 0x34, 0x38, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x36,
  0x37, 0x37, 0x37, 0x37, 0x37, 0x36, 0x34, 0x37, 0x0B, 0x0B, 0x0B, 0x38,
  0x38, 0x37, 0x0B, 0x0B, 0x34, 0x38, 0x0B, 0x33, 0x0B, 0x0B, 0x38, 0x38,
  0x0B, 0x33, 0x33, 0x0B, 0x38, 0x38, 0x33, 0x0B, 0x0B, 0x34, 0x0B, 0x33,
  0x39, 0x32, 0x36, 0x34, 0x39, 0x32, 0x38, 0x3A, 0x34, 0x34, 0x34, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x37, 0x37, 0x37, 0x34, 0x37, 0x34, 0x34, 0x37, 0x36,
  0x37, 0x34, 0x34, 0x0B, 0x33, 0x34, 0x37, 0x0B, 0x0B, 0x0B, 0x38, 0x38,
  0x33, 0x33, 0x0B, 0x38, 0x34, 0x0B, 0x39, 0x33, 0x0B, 0x38, 0x38, 0x33,
  0x33, 0x0B, 0x34, 0x33, 0x39, 0x39, 0x32, 0x36, 0x34, 0x32, 0x33, 0x3A,
  0x34, 0x38, 0x38, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x36, 0x34, 0x37, 0x34,
  0x34, 0x37, 0x36, 0x32, 0x32, 0x32, 0x34, 0x38, 0x0B, 0x0B, 0x34, 0x38,
  0x33, 0x0B, 0x0B, 0x34, 0x38, 0x0B, 0x33, 0x33, 0x38, 0x38, 0x34, 0x33,
  0x39, 0x0B, 0x38, 0x34, 0x39, 0x33, 0x33, 0x34, 0x33, 0x39, 0x39, 0x33,
  0x34, 0x39, 0x3A, 0x3A, 0x34, 0x38, 0x38, 0x38, 0x34, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x34,
  0x34, 0x21, 0x36, 0x34, 0x37, 0x37, 0x32, 0x36, 0x36, 0x39, 0x0B, 0x34,
  0x38, 0x33, 0x0B, 0x34, 0x38, 0x33, 0x33, 0x39, 0x34, 0x38, 0x0B, 0x39,
  0x33, 0x0B, 0x38, 0x38, 0x39, 0x39, 0x0B, 0x38, 0x34, 0x39, 0x39, 0x33,
  0x0B, 0x33, 0x3B, 0x39, 0x39, 0x34, 0x34, 0x34, 0x34, 0x3A, 0x32, 0x38,
  0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x34,
  0x36, 0x00, 0x00, 0x00, 0x34, 0x34, 0x21, 0x34, 0x37, 0x32, 0x36, 0x36,
  0x34, 0x36, 0x3B, 0x0B, 0x0B, 0x34, 0x33, 0x0B, 0x32, 0x38, 0x0B, 0x33,
  0x39, 0x34, 0x38, 0x0B, 0x3B, 0x39, 0x0B, 0x38, 0x38, 0x3B, 0x39, 0x0B,
  0x38, 0x34, 0x3B, 0x3B, 0x33, 0x0B, 0x33, 0x3B, 0x3B, 0x34, 0x35, 0x34,
  0x0B, 0x32, 0x38, 0x38, 0x38, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x37, 0x37, 0x34, 0x34, 0x36, 0x00, 0x00, 0x00, 0x34, 0x34, 0x34,
  0x0B, 0x37, 0x36, 0x34, 0x7B, 0x34, 0x3B, 0x33, 0x0B, 0x38, 0x35, 0x33,
  0x33, 0x32, 0x38, 0x34, 0x33, 0x3B, 0x39, 0x34, 0x34, 0x3B, 0x39, 0x33,
  0x38, 0x38, 0x3B, 0x39, 0x0B, 0x38, 0x34, 0x3B, 0x3B, 0x39, 0x33, 0x33,
  0x36, 0x35, 0x35, 0x35, 0x0B, 0x34, 0x34, 0x39, 0x39, 0x36, 0x38, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x34, 0x34, 0x37, 0x37, 0x34, 0x34, 0x36, 0x34,
  0x00, 0x00, 0x34, 0x37, 0x0B, 0x37, 0x34, 0x7B, 0x7B, 0x7B, 0x36, 0x3B,
  0x39, 0x0B, 0x38, 0x0B, 0x0B, 0x33, 0x32, 0x34, 0x34, 0x0B, 0x3B, 0x39,
  0x34, 0x34, 0x3B, 0x39, 0x33, 0x34, 0x34, 0x3B, 0x39, 0x33, 0x38, 0x34,
  0x3B, 0x3B, 0x39, 0x33, 0x35, 0x0B, 0x0B, 0x39, 0x0B, 0x36, 0x3B, 0x7B,
  0x7B, 0x39, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x34, 0x34, 0x34,
  0x37, 0x34, 0x36, 0x21, 0x37, 0x00, 0x00, 0x34, 0x32, 0x36, 0x34, 0x7B,
  0x7B, 0x7B, 0x34, 0x3B, 0x33, 0x39, 0x0B, 0x38, 0x34, 0x0B, 0x34, 0x34,
  0x33, 0x3B, 0x39, 0x34, 0x34, 0x34, 0x0B, 0x3B, 0x3B, 0x39, 0x34, 0x34,
  0x3B, 0x3B, 0x33, 0x38, 0x34, 0x39, 0x3B, 0x32, 0x0B, 0x39, 0x39, 0x0B,
  0x36, 0x34, 0x39, 0x7B, 0x7B, 0x36, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00,
  0x34, 0x37, 0x37, 0x37, 0x34, 0x37, 0x34, 0x21, 0x37, 0x34, 0x34, 0x0B,
  0x32, 0x37, 0x34, 0x7B, 0x7B, 0x7B, 0x34, 0x3B, 0x39, 0x33, 0x3B, 0x0B,
  0x38, 0x38, 0x33, 0x3B, 0x39, 0x34, 0x34, 0x34, 0x0B, 0x39, 0x3B, 0x3B,
  0x34, 0x34, 0x34, 0x34, 0x34, 0x3B, 0x39, 0x33, 0x34, 0x36, 0x33, 0x32,
  0x0B, 0x39, 0x0B, 0x39, 0x36, 0x39, 0x34, 0x39, 0x36, 0x34, 0x34, 0x36,
  0x0B, 0x00, 0x00, 0x00, 0x34, 0x34, 0x34, 0x37, 0x37, 0x37, 0x37, 0x21,
  0x21, 0x37, 0x39, 0x0B, 0x33, 0x36, 0x34, 0x7B, 0x7B, 0x7B, 0x34, 0x3B,
  0x39, 0x39, 0x39, 0x3B, 0x34, 0x33, 0x3B, 0x39, 0x38, 0x38, 0x0B, 0x39,
  0x3B, 0x3B, 0x3B, 0x38, 0x34, 0x34, 0x36, 0x39, 0x39, 0x39, 0x39, 0x39,
  0x33, 0x34, 0x33, 0x0B, 0x0B, 0x39, 0x39, 0x3B, 0x36, 0x39, 0x39, 0x34,
  0x38, 0x34, 0x34, 0x36, 0x31, 0x31, 0x00, 0x00, 0x34, 0x34, 0x34, 0x34,
  0x34, 0x34, 0x37, 0x37, 0x21, 0x21, 0x37, 0x0B, 0x32, 0x37, 0x36, 0x34,
  0x7B, 0x7B, 0x34, 0x3B, 0x0B, 0x34, 0x34, 0x38, 0x33, 0x3B, 0x34, 0x38,
  0x34, 0x0B, 0x39, 0x39, 0x39, 0x38, 0x38, 0x38, 0x39, 0x39, 0x3B, 0x3B,
  0x3B, 0x3B, 0x36, 0x34, 0x34, 0x34, 0x32, 0x0B, 0x39, 0x39, 0x39, 0x3B,
  0x36, 0x39, 0x36, 0x38, 0x38, 0x34, 0x36, 0x31, 0x31, 0x31, 0x31, 0x31,
  0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x37, 0x21, 0x21, 0x21, 0x34,
  0x33, 0x0B, 0x3B, 0x36, 0x34, 0x34, 0x36, 0x3B, 0x34, 0x38, 0x33, 0x0B,
  0x0B, 0x7B, 0x7B, 0x0B, 0x39, 0x39, 0x0B, 0x36, 0x38, 0x38, 0x39, 0x39,
  0x3B, 0x3B, 0x3B, 0x34, 0x34, 0x34, 0x34, 0x36, 0x39, 0x39, 0x32, 0x0B,
  0x39, 0x39, 0x3B, 0x3B, 0x36, 0x39, 0x36, 0x38, 0x34, 0x36, 0x31, 0x31,
  0x33, 0x33, 0x39, 0x39, 0x34, 0x34, 0x34, 0x34, 0x37, 0x34, 0x37, 0x21,
  0x21, 0x37, 0x32, 0x0B, 0x33, 0x34, 0x0B, 0x3B, 0x34, 0x36, 0x3B, 0x0B,
  0x38, 0x33, 0x0B, 0x0B, 0x7B, 0x34, 0x33, 0x33, 0x39, 0x0B, 0x36, 0x38,
  0x39, 0x33, 0x39, 0x33, 0x3B, 0x39, 0x34, 0x34, 0x34, 0x39, 0x39, 0x3B,
  0x3B, 0x3B, 0x32, 0x39, 0x39, 0x39, 0x3B, 0x3B, 0x39, 0x39, 0x34, 0x38,
  0x36, 0x31, 0x31, 0x39, 0x39, 0x39, 0x33, 0x38, 0x34, 0x34, 0x37, 0x37,
  0x34, 0x37, 0x37, 0x21, 0x32, 0x37, 0x37, 0x34, 0x34, 0x36, 0x36, 0x32,
  0x3B, 0x3B, 0x0B, 0x38, 0x33, 0x0B, 0x36, 0x34, 0x0B, 0x33, 0x33, 0x33,
  0x0B, 0x36, 0x38, 0x39, 0x33, 0x33, 0x39, 0x39, 0x38, 0x38, 0x34, 0x39,
  0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x32, 0x39, 0x39, 0x3B, 0x3B, 0x3B,
  0x39, 0x39, 0x38, 0x38, 0x36, 0x39, 0x39, 0x39, 0x33, 0x0B, 0x0B, 0x00,
  0x37, 0x37, 0x34, 0x34, 0x37, 0x37, 0x34, 0x32, 0x37, 0x34, 0x34, 0x32,
  0x32, 0x38, 0x38, 0x38, 0x34, 0x34, 0x38, 0x33, 0x0B, 0x36, 0x34, 0x33,
  0x33, 0x33, 0x0B, 0x0B, 0x36, 0x38, 0x33, 0x33, 0x33, 0x33, 0x33, 0x38,
  0x34, 0x36, 0x39, 0x3B, 0x3B, 0x36, 0x36, 0x36, 0x39, 0x39, 0x32, 0x33,
  0x39, 0x3B, 0x3B, 0x3B, 0x39, 0x39, 0x38, 0x38, 0x33, 0x36, 0x3B, 0x39,
  0x36, 0x36, 0x00, 0x00, 0x34, 0x34, 0x34, 0x37, 0x37, 0x34, 0x32, 0x36,
  0x34, 0x34, 0x34, 0x34, 0x34, 0x35, 0x34, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
  0x36, 0x34, 0x33, 0x33, 0x33, 0x0B, 0x0B, 0x38, 0x38, 0x33, 0x33, 0x0B,
  0x0B, 0x38, 0x38, 0x34, 0x33, 0x3B, 0x3B, 0x3B, 0x36, 0x36, 0x39, 0x39,
  0x39, 0x3B, 0x35, 0x33, 0x39, 0x3B, 0x3B, 0x3B, 0x39, 0x39, 0x34, 0x38,
  0x33, 0x33, 0x39, 0x36, 0x36, 0x00, 0x00, 0x00, 0x34, 0x34, 0x37, 0x37,
  0x34, 0x36, 0x34, 0x36, 0x34, 0x00, 0x00, 0x31, 0x32, 0x34, 0x35, 0x34,
  0x34, 0x34, 0x34, 0x34, 0x34, 0x33, 0x0B, 0x0B, 0x0B, 0x34, 0x38, 0x33,
  0x33, 0x33, 0x0B, 0x34, 0x38, 0x34, 0x36, 0x33, 0x33, 0x39, 0x36, 0x36,
  0x36, 0x39, 0x39, 0x3B, 0x3B, 0x3B, 0x35, 0x33, 0x39, 0x3B, 0x3B, 0x3B,
  0x3B, 0x39, 0x39, 0x38, 0x36, 0x39, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00,
  0x37, 0x37, 0x34, 0x34, 0x36, 0x34, 0x36, 0x34, 0x00, 0x00, 0x36, 0x34,
  0x34, 0x35, 0x31, 0x36, 0x36, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
  0x38, 0x38, 0x33, 0x33, 0x0B, 0x0B, 0x38, 0x38, 0x36, 0x33, 0x33, 0x33,
  0x36, 0x34, 0x34, 0x39, 0x39, 0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x35, 0x32,
  0x39, 0x39, 0x3B, 0x3B, 0x39, 0x3B, 0x3B, 0x36, 0x36, 0x36, 0x36, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x34, 0x36, 0x34, 0x36, 0x34, 0x00,
  0x00, 0x37, 0x34, 0x37, 0x31, 0x34, 0x34, 0x31, 0x34, 0x34, 0x34, 0x36,
  0x36, 0x36, 0x36, 0x36, 0x33, 0x33, 0x33, 0x0B, 0x34, 0x38, 0x38, 0x33,
  0x33, 0x0B, 0x0B, 0x34, 0x34, 0x36, 0x39, 0x39, 0x39, 0x3B, 0x3B, 0x3B,
  0x3B, 0x3B, 0x35, 0x32, 0x33, 0x39, 0x39, 0x3B, 0x3B, 0x36, 0x34, 0x3B,
  0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x34,
  0x36, 0x34, 0x00, 0x00, 0x37, 0x34, 0x37, 0x36, 0x34, 0x31, 0x31, 0x34,
  0x31, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x38,
  0x38, 0x36, 0x33, 0x33, 0x0B, 0x34, 0x34, 0x34, 0x39, 0x39, 0x39, 0x37,
  0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x33, 0x35, 0x35, 0x32, 0x33, 0x39, 0x39,
  0x39, 0x34, 0x3B, 0x39, 0x3B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x37, 0x34, 0x36, 0x34, 0x37,
  0x34, 0x34, 0x34, 0x31, 0x0B, 0x34, 0x31, 0x34, 0x34, 0x34, 0x34, 0x34,
  0x38, 0x38, 0x38, 0x0B, 0x33, 0x33, 0x0B, 0x0B, 0x34, 0x34, 0x39, 0x39,
  0x39, 0x37, 0x37, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x33, 0x35, 0x35, 0x32,
  0x39, 0x33, 0x33, 0x39, 0x39, 0x35, 0x0E, 0x39, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x34, 0x34, 0x37, 0x34,
  0x37, 0x34, 0x37, 0x36, 0x37, 0x34, 0x34, 0x0B, 0x34, 0x31, 0x0B, 0x31,
  0x0B, 0x31, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x34, 0x34, 0x34,
  0x34, 0x33, 0x39, 0x37, 0x37, 0x37, 0x3B, 0x3B, 0x39, 0x3B, 0x39, 0x33,
  0x32, 0x35, 0x32, 0x39, 0x3B, 0x39, 0x0B, 0x33, 0x39, 0x33, 0x35, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x34,
  0x34, 0x37, 0x34, 0x36, 0x34, 0x37, 0x36, 0x21, 0x21, 0x37, 0x34, 0x31,
  0x0B, 0x36, 0x34, 0x31, 0x34, 0x36, 0x31, 0x38, 0x38, 0x34, 0x34, 0x34,
  0x34, 0x34, 0x33, 0x39, 0x33, 0x34, 0x34, 0x36, 0x3B, 0x3B, 0x3B, 0x36,
  0x39, 0x39, 0x33, 0x33, 0x33, 0x33, 0x39, 0x3B, 0x3B, 0x3B, 0x39, 0x0B,
  0x0B, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x34, 0x34, 0x37, 0x34, 0x37, 0x34, 0x37, 0x36, 0x21, 0x36,
  0x21, 0x37, 0x34, 0x34, 0x31, 0x34, 0x36, 0x31, 0x31, 0x31, 0x0B, 0x31,
  0x31, 0x0B, 0x33, 0x33, 0x0B, 0x33, 0x34, 0x34, 0x34, 0x34, 0x3B, 0x3B,
  0x3B, 0x36, 0x36, 0x39, 0x39, 0x33, 0x33, 0x33, 0x3B, 0x3B, 0x3B, 0x3B,
  0x3B, 0x39, 0x0B, 0x0B, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x34, 0x34, 0x32, 0x34, 0x37,
  0x34, 0x37, 0x36, 0x21, 0x21, 0x21, 0x37, 0x34, 0x0B, 0x31, 0x0B, 0x34,
  0x36, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x39,
  0x39, 0x39, 0x39, 0x36, 0x36, 0x36, 0x39, 0x39, 0x3B, 0x39, 0x3B, 0x3B,
  0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x35, 0x0B, 0x32, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34,
  0x37, 0x34, 0x36, 0x36, 0x37, 0x36, 0x21, 0x36, 0x21, 0x21, 0x21, 0x37,
  0x34, 0x0B, 0x31, 0x0B, 0x31, 0x0B, 0x33, 0x0B, 0x33, 0x33, 0x33, 0x33,
  0x39, 0x33, 0x39, 0x39, 0x36, 0x36, 0x36, 0x0E, 0x39, 0x39, 0x39, 0x3B,
  0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x35, 0x35, 0x32, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x36, 0x37, 0x32, 0x34, 0x37, 0x37, 0x36, 0x21,
  0x21, 0x21, 0x21, 0x21, 0x34, 0x34, 0x37, 0x31, 0x37, 0x37, 0x0B, 0x37,
  0x0B, 0x33, 0x0E, 0x0E, 0x36, 0x36, 0x36, 0x36, 0x0E, 0x39, 0x0E, 0x39,
  0x3B, 0x39, 0x3B, 0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x39, 0x35, 0x35,
  0x35, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x32,
  0x34, 0x37, 0x37, 0x36, 0x21, 0x21, 0x21, 0x21, 0x37, 0x34, 0x34, 0x37,
  0x31, 0x34, 0x37, 0x0B, 0x37, 0x36, 0x36, 0x36, 0x0E, 0x36, 0x39, 0x0E,
  0x39, 0x0E, 0x39, 0x3B, 0x39, 0x3B, 0x39, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B,
  0x0E, 0x36, 0x35, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x36, 0x32, 0x34, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21,
  0x21, 0x37, 0x37, 0x34, 0x34, 0x36, 0x34, 0x31, 0x31, 0x36, 0x31, 0x36,
  0x36, 0x0E, 0x0E, 0x0E, 0x0E, 0x39, 0x0E, 0x39, 0x0E, 0x39, 0x0E, 0x39,
  0x39, 0x39, 0x0E, 0x36, 0x36, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x32, 0x32, 0x36,
  0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x37, 0x34, 0x37, 0x34, 0x34,
  0x34, 0x34, 0x36, 0x0E, 0x36, 0x36, 0x0E, 0x36, 0x0E, 0x36, 0x0E, 0x36,
  0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x36, 0x36, 0x34, 0x34, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x36, 0x34, 0x31, 0x36, 0x31, 0x21, 0x31, 0x21, 0x21, 0x21, 0x36,
  0x37, 0x34, 0x34, 0x34, 0x36, 0x34, 0x34, 0x36, 0x34, 0x36, 0x34, 0x36,
  0x34, 0x36, 0x34, 0x36, 0x34, 0x36, 0x34, 0x36, 0x37, 0x37, 0x33, 0x34,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x34, 0x21, 0x21, 0x31, 0x36,
  0x21, 0x37, 0x21, 0x34, 0x37, 0x34, 0x37, 0x36, 0x34, 0x36, 0x36, 0x34,
  0x36, 0x34, 0x00, 0x00, 0x34, 0x34, 0x34, 0x0B, 0x0B, 0x37, 0x33, 0x37,
  0x39, 0x33, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31,
  0x36, 0x36, 0x36, 0x31, 0x31, 0x21, 0x36, 0x37, 0x34, 0x36, 0x36, 0x36,
  0x33, 0x39, 0x34, 0x36, 0x34, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x0B, 0x0B,
  0x33, 0x31, 0x33, 0x33, 0x39, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x31, 0x31, 0x31, 0x31, 0x31, 0x36, 0x31, 0x34,
  0x36, 0x36, 0x33, 0x33, 0x39, 0x34, 0x36, 0x34, 0x00, 0x00, 0x00, 0x00,
  0x0B, 0x0B, 0x0B, 0x33, 0x31, 0x33, 0x31, 0x39, 0x31, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x36,
  0x36, 0x31, 0x34, 0x36, 0x33, 0x33, 0x39, 0x39, 0x34, 0x36, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x35, 0x33, 0x33, 0x31, 0x33, 0x0E, 0x39, 0x31,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x36, 0x34, 0x39, 0x33, 0x39, 0x39, 0x3B, 0x34,
  0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x33, 0x31, 0x31, 0x33,
  0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x34, 0x34, 0x34, 0x39, 0x33, 0x39,
  0x3B, 0x39, 0x34, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x33,
  0x31, 0x33, 0x33, 0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33,
  0x33, 0x33, 0x31, 0x31, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0B, 0x33, 0x31, 0x33, 0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x38, 0x34, 0x0B, 0x31, 0x31, 0x31, 0x31, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x0B, 0x31, 0x31, 0x33,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0B, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask6RB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x91, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xFC, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F,
  0xFE, 0x90, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF,
  0xFF, 0xFA, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFA, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFE, 0x80, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x11, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x7C, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0x3F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x7E, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x3F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x07, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFC, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x1F, 0xFF, 0xF8, 0x7F, 0xC0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF0,
  0xFF, 0x80, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xC0, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x81, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x03,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, 0x07, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite7LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x17, 0x17, 0x10, 0x14, 0x14, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x17, 0x14, 0x14, 0x10, 0x17, 0x00, 0x17, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x17, 0x10, 0x16, 0x16, 0x16, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x10, 0x14, 0x16, 0x16, 0x14, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x10, 0x16, 0x16, 0x16, 0x16, 0x16,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x16, 0x16, 0x3C, 0x3C,
  0x3C, 0x3C, 0x16, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x16, 0x3C,
  0x3D, 0x3D, 0x23, 0x3C, 0x16, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x16, 0x3C, 0x3C, 0x3D, 0x3D, 0x23, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x16, 0x3C, 0x3C, 0x3C, 0x3D, 0x23, 0x23, 0x16, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x3C, 0x3C, 0x3D, 0x3D, 0x23, 0x3C,
  0x16, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x16, 0x3C, 0x3D, 0x3D,
  0x23, 0x3E, 0x3C, 0x16, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x3C,
  0x3C, 0x3D, 0x3D, 0x23, 0x3E, 0x3C, 0x16, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x16, 0x3C, 0x3C, 0x3D, 0x3D, 0x23, 0x3E, 0x3C, 0x16, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x16, 0x3C, 0x3D, 0x3D, 0x3D, 0x23, 0x3E, 0x3C,
  0x16, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x3C, 0x3C, 0x3D, 0x3D, 0x3D,
  0x23, 0x3E, 0x3C, 0x16, 0x17, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x16, 0x3C, 0x3C,
  0x3C, 0x3C, 0x3C, 0x23, 0x3E, 0x3C, 0x16, 0x17, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17,
  0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x16, 0x17, 0x0F,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x17, 0x17, 0x17, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x3C, 0x3C, 0x16,
  0x16, 0x17, 0x0F, 0x17, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x7B, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x16, 0x16, 0x16, 0x17, 0x0D, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x7B, 0x17, 0x17, 0x17, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x00,
  0x0D, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x7B, 0x17, 0x17,
  0x10, 0x14, 0x3F, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3F, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x0F, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x17, 0x17, 0x17, 0x10, 0x10, 0x14, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D,
  0x3F, 0x3D, 0x3F, 0x17, 0x17, 0x17, 0x10, 0x17, 0x0D, 0x0F, 0x0F, 0x0F,
  0x0F, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x14, 0x17, 0x17, 0x10, 0x10, 0x10, 0x14, 0x3D, 0x3F,
  0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x17, 0x17, 0x10, 0x17, 0x17,
  0x23, 0x23, 0x23, 0x0D, 0x0D, 0x0F, 0x0F, 0x17, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x17, 0x17, 0x10, 0x10, 0x14,
  0x10, 0x14, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x17,
  0x10, 0x10, 0x10, 0x17, 0x23, 0x0D, 0x0D, 0x0D, 0x0F, 0x0D, 0x40, 0x0F,
  0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x14, 0x17,
  0x10, 0x10, 0x14, 0x10, 0x10, 0x14, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D,
  0x3D, 0x3D, 0x3D, 0x17, 0x10, 0x10, 0x10, 0x17, 0x16, 0x23, 0x23, 0x23,
  0x23, 0x0F, 0x0F, 0x40, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x14, 0x14, 0x14, 0x17, 0x10, 0x14, 0x10, 0x10, 0x17, 0x14, 0x3D, 0x3D,
  0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x3D, 0x17, 0x10, 0x10, 0x10, 0x17,
  0x14, 0x23, 0x23, 0x0D, 0x0D, 0x0D, 0x0D, 0x0F, 0x0F, 0x0F, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x14, 0x14, 0x16, 0x14, 0x17, 0x10, 0x10, 0x14, 0x10,
  0x17, 0x14, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x17,
  0x10, 0x10, 0x10, 0x17, 0x17, 0x16, 0x23, 0x23, 0x23, 0x0F, 0x0F, 0x0D,
  0x40, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x14, 0x16, 0x17, 0x17,
  0x10, 0x14, 0x10, 0x10, 0x17, 0x14, 0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D,
  0x2F, 0x3D, 0x2F, 0x17, 0x10, 0x10, 0x10, 0x10, 0x17, 0x14, 0x01, 0x23,
  0x0D, 0x23, 0x23, 0x0F, 0x0F, 0x40, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x14,
  0x16, 0x16, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x14, 0x3D, 0x2F,
  0x3D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x17, 0x10, 0x14, 0x10, 0x14,
  0x17, 0x17, 0x01, 0x23, 0x23, 0x0D, 0x0D, 0x0D, 0x40, 0x0F, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x0F, 0x17, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x14, 0x14, 0x14, 0x16, 0x3C, 0x17, 0x10, 0x10, 0x14, 0x10, 0x10,
  0x17, 0x14, 0x2F, 0x3D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x17,
  0x14, 0x10, 0x14, 0x10, 0x14, 0x17, 0x16, 0x01, 0x23, 0x23, 0x23, 0x0F,
  0x0F, 0x40, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x40,
  0x40, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x14, 0x16, 0x16, 0x3C, 0x17, 0x10,
  0x14, 0x10, 0x14, 0x10, 0x17, 0x14, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x01,
  0x2F, 0x01, 0x2F, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x14, 0x01,
  0x23, 0x23, 0x0D, 0x0D, 0x0D, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x0D, 0x23, 0x23, 0x0D, 0x40, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x16,
  0x3C, 0x3C, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x14, 0x2F, 0x2F,
  0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x17, 0x14, 0x10, 0x14, 0x10,
  0x14, 0x10, 0x17, 0x16, 0x01, 0x23, 0x23, 0x23, 0x0F, 0x40, 0x0F, 0x17,
  0x00, 0x00, 0x00, 0x17, 0x0D, 0x23, 0x0D, 0x0D, 0x0D, 0x40, 0x40, 0x17,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x14, 0x14, 0x16, 0x16, 0x3C, 0x3C, 0x17, 0x10, 0x10, 0x14, 0x10, 0x10,
  0x17, 0x14, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x14,
  0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x17, 0x14, 0x01, 0x01, 0x23, 0x23,
  0x23, 0x40, 0x0F, 0x17, 0x00, 0x00, 0x17, 0x0D, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x0D, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x14, 0x14, 0x16, 0x16, 0x3C, 0x3C, 0x3C, 0x17, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x17, 0x14, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F,
  0x01, 0x2F, 0x01, 0x16, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x17,
  0x16, 0x01, 0x23, 0x23, 0x23, 0x23, 0x0D, 0x0D, 0x0F, 0x17, 0x0D, 0x3E,
  0x3E, 0x23, 0x0D, 0x0D, 0x0D, 0x40, 0x40, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x14, 0x16, 0x3C, 0x3C,
  0x3C, 0x3C, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x14, 0x2F, 0x01,
  0x2F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x17, 0x14, 0x10, 0x14,
  0x10, 0x14, 0x10, 0x17, 0x14, 0x01, 0x01, 0x23, 0x23, 0x23, 0x23, 0x0D,
  0x0D, 0x0D, 0x3E, 0x3E, 0x23, 0x23, 0x23, 0x23, 0x23, 0x0D, 0x0F, 0x17,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14,
  0x14, 0x14, 0x16, 0x3C, 0x3C, 0x3C, 0x17, 0x10, 0x10, 0x10, 0x14, 0x10,
  0x17, 0x14, 0x01, 0x2F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x16, 0x01, 0x01,
  0x23, 0x23, 0x23, 0x3E, 0x3E, 0x0D, 0x3E, 0x23, 0x3E, 0x23, 0x0D, 0x0D,
  0x0D, 0x40, 0x40, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x17, 0x14, 0x14, 0x16, 0x14, 0x3C, 0x3C, 0x3C, 0x17, 0x10,
  0x10, 0x14, 0x10, 0x14, 0x17, 0x14, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x2F, 0x14, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14,
  0x17, 0x14, 0x01, 0x01, 0x23, 0x23, 0x23, 0x23, 0x3E, 0x3E, 0x3E, 0x3E,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x0D, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x3C, 0x7B, 0x7B, 0x7B, 0x16, 0x14,
  0x3C, 0x3C, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x14, 0x2F, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x17, 0x14, 0x10,
  0x14, 0x10, 0x14, 0x10, 0x17, 0x17, 0x16, 0x01, 0x01, 0x23, 0x23, 0x23,
  0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x23, 0x0D, 0x0D, 0x0D, 0x40, 0x40, 0x0F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x3C, 0x7B, 0x17,
  0x17, 0x7B, 0x7B, 0x16, 0x3C, 0x3C, 0x17, 0x14, 0x10, 0x14, 0x10, 0x14,
  0x17, 0x14, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2F,
  0x01, 0x17, 0x17, 0x14, 0x10, 0x14, 0x10, 0x10, 0x10, 0x17, 0x14, 0x16,
  0x01, 0x01, 0x23, 0x3E, 0x23, 0x3E, 0x3E, 0x3E, 0x23, 0x0D, 0x23, 0x23,
  0x23, 0x0D, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x17, 0x3C, 0x7B, 0x01, 0x17, 0x7B, 0x7B, 0x16, 0x3C, 0x3C, 0x17, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x17, 0x17, 0x14, 0x01, 0x01, 0x01, 0x01, 0x2F,
  0x16, 0x16, 0x14, 0x01, 0x2F, 0x14, 0x17, 0x10, 0x14, 0x10, 0x10, 0x10,
  0x10, 0x17, 0x17, 0x14, 0x16, 0x01, 0x23, 0x23, 0x3E, 0x3E, 0x3E, 0x3E,
  0x3E, 0x23, 0x0D, 0x0D, 0x0D, 0x40, 0x40, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x17, 0x17, 0x3C, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x16,
  0x3C, 0x3C, 0x17, 0x14, 0x14, 0x14, 0x14, 0x14, 0x17, 0x17, 0x14, 0x01,
  0x3C, 0x2F, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x2F, 0x01, 0x16, 0x17, 0x17,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x14, 0x23, 0x23, 0x23,
  0x23, 0x3E, 0x3E, 0x3E, 0x23, 0x0D, 0x23, 0x23, 0x23, 0x0D, 0x0F, 0x17,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x14, 0x14, 0x17, 0x3C, 0x7B,
  0x7B, 0x7B, 0x14, 0x14, 0x3C, 0x3C, 0x14, 0x17, 0x14, 0x14, 0x14, 0x14,
  0x17, 0x17, 0x14, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x16, 0x14, 0x01,
  0x2F, 0x01, 0x14, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17,
  0x17, 0x14, 0x23, 0x23, 0x3E, 0x23, 0x3E, 0x3E, 0x3E, 0x23, 0x23, 0x0D,
  0x0D, 0x40, 0x40, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x14, 0x14,
  0x14, 0x14, 0x17, 0x3C, 0x3C, 0x3C, 0x14, 0x16, 0x3C, 0x2F, 0x14, 0x17,
  0x14, 0x14, 0x14, 0x14, 0x17, 0x17, 0x10, 0x16, 0x3C, 0x3C, 0x3C, 0x3C,
  0x3C, 0x3C, 0x16, 0x2F, 0x01, 0x2F, 0x16, 0x17, 0x17, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14, 0x0D, 0x23, 0x3E, 0x3E, 0x3E,
  0x23, 0x0D, 0x0D, 0x23, 0x23, 0x0D, 0x0F, 0x17, 0x00, 0x00, 0x17, 0x14,
  0x14, 0x16, 0x14, 0x16, 0x14, 0x16, 0x14, 0x14, 0x14, 0x16, 0x16, 0x3C,
  0x3C, 0x2F, 0x14, 0x17, 0x14, 0x14, 0x14, 0x14, 0x14, 0x17, 0x17, 0x14,
  0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x16, 0x14, 0x2F, 0x2F, 0x2F, 0x2F, 0x14,
  0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14,
  0x0D, 0x0D, 0x0D, 0x0D, 0x3E, 0x23, 0x23, 0x0D, 0x0D, 0x40, 0x40, 0x0F,
  0x16, 0x16, 0x16, 0x14, 0x16, 0x14, 0x16, 0x14, 0x16, 0x14, 0x16, 0x16,
  0x16, 0x16, 0x16, 0x3C, 0x2F, 0x2F, 0x16, 0x17, 0x14, 0x14, 0x14, 0x14,
  0x10, 0x17, 0x17, 0x10, 0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x2F,
  0x2F, 0x2F, 0x2F, 0x16, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x17, 0x17, 0x00, 0x00, 0x17, 0x0F, 0x0D, 0x0D, 0x23, 0x23,
  0x23, 0x0D, 0x0F, 0x17, 0x17, 0x17, 0x14, 0x16, 0x3C, 0x3C, 0x16, 0x16,
  0x16, 0x16, 0x16, 0x16, 0x16, 0x3C, 0x16, 0x3C, 0x2F, 0x3D, 0x3F, 0x17,
  0x14, 0x14, 0x14, 0x10, 0x14, 0x17, 0x17, 0x10, 0x14, 0x3C, 0x3C, 0x3C,
  0x16, 0x16, 0x14, 0x2F, 0x2F, 0x2F, 0x2F, 0x01, 0x14, 0x17, 0x17, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00,
  0x17, 0x0F, 0x0D, 0x23, 0x0D, 0x40, 0x40, 0x0F, 0x17, 0x17, 0x17, 0x14,
  0x14, 0x16, 0x3C, 0x3C, 0x16, 0x16, 0x3C, 0x3C, 0x3C, 0x16, 0x3C, 0x3C,
  0x3D, 0x2F, 0x3F, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x17, 0x17,
  0x14, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x2F, 0x2F, 0x2F, 0x01, 0x2F,
  0x16, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x40, 0x40, 0x0F, 0x17,
  0x00, 0x00, 0x14, 0x14, 0x16, 0x14, 0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
  0x16, 0x16, 0x3C, 0x3D, 0x2F, 0x3D, 0x2F, 0x17, 0x17, 0x10, 0x14, 0x10,
  0x14, 0x10, 0x17, 0x17, 0x10, 0x16, 0x3C, 0x3C, 0x16, 0x16, 0x2F, 0x2F,
  0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x14, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x0F, 0x17, 0x17, 0x00, 0x00, 0x00, 0x14, 0x14, 0x16, 0x14, 0x16,
  0x3C, 0x3C, 0x16, 0x16, 0x16, 0x3C, 0x3C, 0x2F, 0x3D, 0x2F, 0x3D, 0x14,
  0x17, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14, 0x3C, 0x3C,
  0x3C, 0x16, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x16, 0x14, 0x17,
  0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x14, 0x16, 0x14, 0x16, 0x16, 0x16, 0x16, 0x3C, 0x3C, 0x2F, 0x3D,
  0x3D, 0x3D, 0x3D, 0x16, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17,
  0x17, 0x10, 0x16, 0x3C, 0x16, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01,
  0x2F, 0x01, 0x16, 0x14, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x14, 0x14, 0x3C, 0x3C,
  0x3C, 0x3C, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3F, 0x17, 0x17, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14, 0x16, 0x2F, 0x2F, 0x01, 0x2F,
  0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x16, 0x14, 0x17, 0x17, 0x17,
  0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x14, 0x14, 0x3C, 0x3C, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3F,
  0x14, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14,
  0x16, 0x2F, 0x2F, 0x01, 0x2F, 0x2F, 0x01, 0x01, 0x2F, 0x01, 0x2F, 0x01,
  0x16, 0x14, 0x17, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10,
  0x14, 0x14, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x16, 0x16, 0x3C, 0x3C, 0x23,
  0x23, 0x3F, 0x3F, 0x3F, 0x16, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x17, 0x14, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x23, 0x01, 0x23, 0x23, 0x23, 0x16, 0x14, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x10, 0x10, 0x14, 0x14, 0x10, 0x10, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x14, 0x16, 0x16, 0x3C, 0x3C, 0x23, 0x23, 0x23, 0x23, 0x14, 0x17, 0x17,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x16, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x3C, 0x3C, 0x14, 0x14,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x10, 0x14, 0x14, 0x10, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x16, 0x16, 0x3C, 0x3C,
  0x3C, 0x16, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x14, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
  0x16, 0x16, 0x16, 0x17, 0x17, 0x17, 0x10, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x10, 0x10, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x14, 0x16, 0x16, 0x16, 0x17, 0x17, 0x17, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x16, 0x16, 0x16, 0x16, 0x16,
  0x16, 0x16, 0x16, 0x16, 0x16, 0x14, 0x14, 0x14, 0x17, 0x17, 0x17, 0x10,
  0x10, 0x10, 0x10, 0x17, 0x17, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x14, 0x14, 0x10, 0x10, 0x14, 0x10, 0x14, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x14, 0x10, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x00, 0x17, 0x00, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x14, 0x14, 0x14,
  0x17, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x17, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask7LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xF4,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF8, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F,
  0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF,
  0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFE, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x03, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x3E,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x7E, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0xFE, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0xFF,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xFF, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x03, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFA, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F,
  0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite7LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x17, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x17, 0x10, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x10, 0x14, 0x16, 0x16, 0x14, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x10, 0x16, 0x16, 0x16, 0x16, 0x16,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x16, 0x16, 0x3C, 0x3C,
  0x3C, 0x3C, 0x16, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x16, 0x3C,
  0x3D, 0x3D, 0x23, 0x3C, 0x16, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x16, 0x3C, 0x3C, 0x3D, 0x3D, 0x23, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x16, 0x3C, 0x3C, 0x3C, 0x3D, 0x23, 0x23, 0x16, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x3C, 0x3C, 0x3D, 0x3D, 0x23, 0x3C,
  0x16, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x10, 0x16, 0x3C, 0x3D, 0x3D,
  0x23, 0x3E, 0x3C, 0x16, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x3C,
  0x3C, 0x3D, 0x3D, 0x23, 0x3E, 0x3C, 0x16, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x16, 0x3C, 0x3C, 0x3D, 0x3D, 0x23, 0x3E, 0x3C, 0x16, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x16, 0x3C, 0x3D, 0x3D, 0x3D, 0x23, 0x3E, 0x3C,
  0x16, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x3C, 0x3C, 0x3D, 0x3D, 0x3D,
  0x23, 0x3E, 0x3C, 0x16, 0x17, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x10, 0x16, 0x3C, 0x3C,
  0x3C, 0x3C, 0x3C, 0x23, 0x3E, 0x3C, 0x16, 0x17, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17,
  0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x16, 0x17, 0x0F,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x17, 0x17, 0x17, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x3C, 0x3C, 0x16,
  0x16, 0x17, 0x0F, 0x17, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x7B, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
  0x3F, 0x16, 0x16, 0x16, 0x17, 0x0D, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x7B, 0x17, 0x17, 0x17, 0x3F, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x00,
  0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x7B, 0x17, 0x17,
  0x10, 0x14, 0x3F, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3F, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x17, 0x17, 0x17, 0x10, 0x10, 0x14, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D,
  0x3F, 0x3D, 0x3F, 0x17, 0x17, 0x17, 0x10, 0x17, 0x0D, 0x0D, 0x0F, 0x0F,
  0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x14, 0x17, 0x17, 0x10, 0x10, 0x10, 0x14, 0x3D, 0x3F,
  0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x17, 0x17, 0x10, 0x17, 0x17,
  0x23, 0x23, 0x23, 0x23, 0x0D, 0x0D, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x17, 0x17, 0x10, 0x10, 0x14,
  0x10, 0x14, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x17,
  0x10, 0x10, 0x10, 0x17, 0x23, 0x23, 0x0D, 0x0D, 0x0D, 0x0F, 0x0D, 0x40,
  0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x14, 0x17,
  0x10, 0x10, 0x14, 0x10, 0x10, 0x14, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D,
  0x3D, 0x3D, 0x3D, 0x17, 0x10, 0x10, 0x10, 0x17, 0x16, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x0F, 0x0F, 0x40, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x14, 0x14, 0x14, 0x17, 0x10, 0x14, 0x10, 0x10, 0x17, 0x14, 0x3D, 0x3D,
  0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x3D, 0x17, 0x10, 0x10, 0x10, 0x17,
  0x14, 0x23, 0x23, 0x23, 0x0D, 0x0D, 0x0D, 0x0D, 0x0F, 0x0F, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x14, 0x14, 0x16, 0x14, 0x17, 0x10, 0x10, 0x14, 0x10,
  0x17, 0x14, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x17,
  0x10, 0x10, 0x10, 0x17, 0x17, 0x16, 0x23, 0x23, 0x23, 0x23, 0x0F, 0x0F,
  0x0D, 0x40, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x14, 0x16, 0x17, 0x17,
  0x10, 0x14, 0x10, 0x10, 0x17, 0x14, 0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D,
  0x2F, 0x3D, 0x2F, 0x17, 0x10, 0x10, 0x10, 0x10, 0x17, 0x14, 0x01, 0x23,
  0x23, 0x0D, 0x23, 0x23, 0x0F, 0x0F, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x14,
  0x16, 0x16, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x14, 0x3D, 0x2F,
  0x3D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x17, 0x10, 0x14, 0x10, 0x14,
  0x17, 0x17, 0x01, 0x23, 0x23, 0x23, 0x0D, 0x0D, 0x0D, 0x40, 0x0F, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x14, 0x14, 0x14, 0x16, 0x3C, 0x17, 0x10, 0x10, 0x14, 0x10, 0x10,
  0x17, 0x14, 0x2F, 0x3D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x17,
  0x14, 0x10, 0x14, 0x10, 0x14, 0x17, 0x16, 0x01, 0x23, 0x23, 0x23, 0x23,
  0x0F, 0x0F, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x40,
  0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x14, 0x16, 0x16, 0x3C, 0x17, 0x10,
  0x14, 0x10, 0x14, 0x10, 0x17, 0x14, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x01,
  0x2F, 0x01, 0x2F, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x14, 0x01,
  0x23, 0x23, 0x23, 0x0D, 0x0D, 0x0D, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x17, 0x0D, 0x23, 0x23, 0x40, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x16,
  0x3C, 0x3C, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x14, 0x2F, 0x2F,
  0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x17, 0x14, 0x10, 0x14, 0x10,
  0x14, 0x10, 0x17, 0x16, 0x01, 0x23, 0x23, 0x23, 0x0F, 0x0F, 0x40, 0x0F,
  0x00, 0x00, 0x00, 0x17, 0x0D, 0x23, 0x0D, 0x0D, 0x40, 0x40, 0x17, 0x17,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x14, 0x14, 0x16, 0x16, 0x3C, 0x3C, 0x17, 0x10, 0x10, 0x14, 0x10, 0x10,
  0x17, 0x14, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x14,
  0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x17, 0x14, 0x01, 0x01, 0x23, 0x23,
  0x23, 0x0D, 0x40, 0x0F, 0x00, 0x00, 0x17, 0x0D, 0x23, 0x23, 0x23, 0x23,
  0x0D, 0x0F, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x14, 0x14, 0x16, 0x16, 0x3C, 0x3C, 0x3C, 0x17, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x17, 0x14, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F,
  0x01, 0x2F, 0x01, 0x16, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x17,
  0x16, 0x01, 0x23, 0x23, 0x23, 0x23, 0x0D, 0x0D, 0x0F, 0x17, 0x0D, 0x3E,
  0x3E, 0x23, 0x0D, 0x0D, 0x40, 0x40, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x14, 0x16, 0x3C, 0x3C,
  0x3C, 0x3C, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x14, 0x2F, 0x01,
  0x2F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x17, 0x14, 0x10, 0x14,
  0x10, 0x14, 0x10, 0x17, 0x14, 0x01, 0x01, 0x23, 0x23, 0x23, 0x23, 0x0D,
  0x0D, 0x0D, 0x3E, 0x3E, 0x23, 0x23, 0x23, 0x23, 0x0D, 0x0F, 0x17, 0x17,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14,
  0x14, 0x14, 0x16, 0x3C, 0x3C, 0x3C, 0x17, 0x10, 0x10, 0x10, 0x14, 0x10,
  0x17, 0x14, 0x01, 0x2F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x16, 0x01, 0x01,
  0x23, 0x23, 0x23, 0x3E, 0x3E, 0x0D, 0x3E, 0x23, 0x3E, 0x23, 0x0D, 0x0D,
  0x40, 0x40, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x17, 0x14, 0x14, 0x16, 0x14, 0x3C, 0x3C, 0x3C, 0x17, 0x10,
  0x10, 0x14, 0x10, 0x14, 0x17, 0x14, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x2F, 0x14, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14,
  0x17, 0x14, 0x01, 0x01, 0x23, 0x23, 0x23, 0x23, 0x3E, 0x3E, 0x3E, 0x3E,
  0x23, 0x23, 0x23, 0x23, 0x0D, 0x0F, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x3C, 0x7B, 0x7B, 0x7B, 0x16, 0x14,
  0x3C, 0x3C, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x14, 0x2F, 0x01,
  0x01, 0x01, 0x16, 0x16, 0x14, 0x01, 0x01, 0x01, 0x16, 0x17, 0x14, 0x10,
  0x14, 0x10, 0x14, 0x10, 0x17, 0x17, 0x16, 0x01, 0x01, 0x23, 0x23, 0x23,
  0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x23, 0x0D, 0x0D, 0x40, 0x40, 0x0F, 0x17,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x3C, 0x7B, 0x17,
  0x17, 0x7B, 0x7B, 0x16, 0x3C, 0x3C, 0x17, 0x14, 0x10, 0x14, 0x10, 0x14,
  0x17, 0x14, 0x16, 0x01, 0x01, 0x3C, 0x3C, 0x3C, 0x16, 0x01, 0x01, 0x2F,
  0x01, 0x17, 0x17, 0x14, 0x10, 0x14, 0x10, 0x10, 0x10, 0x17, 0x14, 0x16,
  0x01, 0x01, 0x23, 0x3E, 0x23, 0x3E, 0x3E, 0x3E, 0x23, 0x0D, 0x23, 0x23,
  0x0D, 0x0F, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x17, 0x3C, 0x7B, 0x01, 0x17, 0x7B, 0x7B, 0x16, 0x3C, 0x3C, 0x17, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x17, 0x17, 0x14, 0x01, 0x01, 0x3C, 0x16, 0x16,
  0x14, 0x2F, 0x2F, 0x01, 0x2F, 0x14, 0x17, 0x10, 0x14, 0x10, 0x10, 0x10,
  0x10, 0x17, 0x17, 0x14, 0x16, 0x01, 0x23, 0x23, 0x3E, 0x3E, 0x3E, 0x3E,
  0x3E, 0x23, 0x0D, 0x0D, 0x40, 0x40, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x17, 0x17, 0x3C, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x16,
  0x3C, 0x3C, 0x17, 0x14, 0x14, 0x14, 0x14, 0x14, 0x17, 0x17, 0x14, 0x01,
  0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x2F, 0x2F, 0x2F, 0x01, 0x16, 0x17, 0x17,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x14, 0x23, 0x23, 0x23,
  0x23, 0x3E, 0x3E, 0x3E, 0x23, 0x0D, 0x23, 0x23, 0x0D, 0x0F, 0x17, 0x17,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x14, 0x14, 0x17, 0x3C, 0x7B,
  0x7B, 0x7B, 0x14, 0x14, 0x3C, 0x3C, 0x14, 0x17, 0x14, 0x14, 0x14, 0x14,
  0x17, 0x17, 0x14, 0x3C, 0x3C, 0x3C, 0x16, 0x16, 0x14, 0x2F, 0x2F, 0x01,
  0x2F, 0x01, 0x14, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17,
  0x17, 0x14, 0x23, 0x23, 0x3E, 0x23, 0x3E, 0x3E, 0x3E, 0x23, 0x23, 0x0D,
  0x40, 0x40, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x14, 0x14,
  0x14, 0x14, 0x17, 0x3C, 0x3C, 0x3C, 0x14, 0x16, 0x3C, 0x2F, 0x14, 0x17,
  0x14, 0x14, 0x14, 0x14, 0x17, 0x17, 0x10, 0x16, 0x3C, 0x3C, 0x3C, 0x3C,
  0x16, 0x2F, 0x2F, 0x2F, 0x01, 0x2F, 0x16, 0x17, 0x17, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14, 0x0D, 0x23, 0x3E, 0x3E, 0x3E,
  0x23, 0x0D, 0x0D, 0x23, 0x0D, 0x0F, 0x17, 0x17, 0x00, 0x00, 0x17, 0x17,
  0x14, 0x16, 0x14, 0x16, 0x14, 0x16, 0x14, 0x14, 0x14, 0x16, 0x16, 0x3C,
  0x3C, 0x2F, 0x14, 0x17, 0x14, 0x14, 0x14, 0x14, 0x14, 0x17, 0x17, 0x14,
  0x3C, 0x3C, 0x16, 0x16, 0x14, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x14,
  0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14,
  0x0D, 0x0D, 0x0D, 0x0D, 0x3E, 0x23, 0x23, 0x0D, 0x40, 0x40, 0x0F, 0x17,
  0x14, 0x16, 0x16, 0x16, 0x16, 0x14, 0x16, 0x14, 0x16, 0x14, 0x16, 0x16,
  0x16, 0x16, 0x16, 0x3C, 0x2F, 0x2F, 0x16, 0x17, 0x14, 0x14, 0x14, 0x14,
  0x10, 0x17, 0x17, 0x10, 0x16, 0x3C, 0x3C, 0x3C, 0x16, 0x2F, 0x2F, 0x2F,
  0x2F, 0x2F, 0x2F, 0x16, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x17, 0x17, 0x00, 0x00, 0x17, 0x0F, 0x0D, 0x0D, 0x23, 0x23,
  0x0D, 0x0F, 0x17, 0x17, 0x7B, 0x7B, 0x14, 0x16, 0x3C, 0x3C, 0x16, 0x16,
  0x16, 0x16, 0x16, 0x16, 0x16, 0x3C, 0x16, 0x3C, 0x2F, 0x3D, 0x3F, 0x17,
  0x14, 0x14, 0x14, 0x10, 0x14, 0x17, 0x17, 0x10, 0x14, 0x3C, 0x16, 0x16,
  0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x01, 0x14, 0x17, 0x17, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00,
  0x17, 0x0F, 0x0D, 0x23, 0x40, 0x40, 0x0F, 0x17, 0x7B, 0x7B, 0x7B, 0x14,
  0x16, 0x14, 0x3C, 0x3C, 0x16, 0x16, 0x3C, 0x3C, 0x3C, 0x16, 0x3C, 0x3C,
  0x3D, 0x2F, 0x3F, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x17, 0x17,
  0x14, 0x3C, 0x3C, 0x16, 0x01, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x01, 0x2F,
  0x16, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x40, 0x0F, 0x17, 0x17,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x16, 0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C,
  0x16, 0x16, 0x3C, 0x3D, 0x2F, 0x3D, 0x2F, 0x17, 0x17, 0x10, 0x14, 0x10,
  0x14, 0x10, 0x17, 0x17, 0x10, 0x16, 0x3C, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x14, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x17,
  0x0F, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x17, 0x17, 0x14, 0x14, 0x16,
  0x3C, 0x3C, 0x16, 0x16, 0x16, 0x3C, 0x3C, 0x2F, 0x3D, 0x2F, 0x3D, 0x14,
  0x17, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14, 0x3C, 0x2F,
  0x2F, 0x2F, 0x2F, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x16, 0x14, 0x17,
  0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x17, 0x14, 0x16, 0x16, 0x16, 0x16, 0x3C, 0x3C, 0x2F, 0x3D,
  0x3D, 0x3D, 0x3D, 0x16, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17,
  0x17, 0x10, 0x16, 0x3C, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01,
  0x2F, 0x01, 0x16, 0x14, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x14, 0x14, 0x3C, 0x3C,
  0x3C, 0x3C, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3F, 0x17, 0x17, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14, 0x16, 0x2F, 0x2F, 0x01, 0x2F,
  0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x16, 0x14, 0x17, 0x17, 0x17,
  0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x17,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x14, 0x14, 0x3C, 0x3C, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3F,
  0x14, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14,
  0x16, 0x2F, 0x2F, 0x01, 0x2F, 0x2F, 0x01, 0x01, 0x2F, 0x01, 0x2F, 0x01,
  0x16, 0x14, 0x17, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10,
  0x14, 0x14, 0x10, 0x10, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x16, 0x16, 0x3C, 0x3C, 0x23,
  0x23, 0x3F, 0x3F, 0x3F, 0x16, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x17, 0x14, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x23, 0x01, 0x23, 0x23, 0x23, 0x16, 0x14, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x10, 0x10, 0x14, 0x14, 0x10, 0x10, 0x14, 0x14, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x14, 0x16, 0x16, 0x3C, 0x3C, 0x23, 0x23, 0x23, 0x23, 0x14, 0x17, 0x17,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x16, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x3C, 0x3C, 0x16, 0x14,
  0x10, 0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x10, 0x14, 0x14, 0x10, 0x10,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x14, 0x16, 0x16, 0x3C, 0x3C,
  0x3C, 0x16, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x14, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x16,
  0x16, 0x16, 0x14, 0x14, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x10, 0x10, 0x14, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x14, 0x16, 0x16, 0x16, 0x17, 0x17, 0x17, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
  0x14, 0x16, 0x14, 0x16, 0x14, 0x14, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x17, 0x17, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x14,
  0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x10, 0x17, 0x17, 0x17, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x14, 0x14, 0x17, 0x10, 0x17, 0x10, 0x17, 0x10, 0x10, 0x17, 0x10, 0x17,
  0x10, 0x17, 0x10, 0x17, 0x10, 0x17, 0x10, 0x17, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17,
  0x17, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x17, 0x10, 0x17, 0x10, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x14, 0x14, 0x14, 0x10,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17, 0x17, 0x14,
  0x10, 0x10, 0x10, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x17, 0x17, 0x17, 0x14, 0x14, 0x14, 0x10, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask7LB[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF8, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F,
  0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF,
  0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFE, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF,
  0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x03, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x38,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x7C, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE1, 0xFE, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0xFF,
  0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xFF, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00,
};

const uint8_t sprite7RA[] = {
  0x00, 0x17, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x14, 0x14, 0x10, 0x17, 0x17, 0x17,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x00,
  0x17, 0x10, 0x14, 0x14, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x16, 0x16, 0x16, 0x10,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x14, 0x16, 0x16, 0x14, 0x10, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x16, 0x16, 0x16,
  0x16, 0x10, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x16, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x3C, 0x23, 0x3D, 0x3D,
  0x3C, 0x16, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x16, 0x16, 0x23, 0x3D, 0x3D, 0x3C, 0x3C, 0x16, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x23, 0x23, 0x3D, 0x3C, 0x3C,
  0x3C, 0x16, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x16,
  0x3C, 0x23, 0x3D, 0x3D, 0x3C, 0x3C, 0x16, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x17, 0x16, 0x3C, 0x3E, 0x23, 0x3D, 0x3D, 0x3C, 0x16,
  0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x16, 0x3C, 0x3E,
  0x23, 0x3D, 0x3D, 0x3C, 0x3C, 0x16, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x16, 0x3C, 0x3E, 0x23, 0x3D, 0x3D, 0x3C, 0x3C, 0x16, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x16, 0x3C, 0x3E, 0x23, 0x3D,
  0x3D, 0x3D, 0x3C, 0x16, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x17,
  0x16, 0x3C, 0x3E, 0x23, 0x3D, 0x3D, 0x3D, 0x3C, 0x3C, 0x16, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x17, 0x16, 0x3C, 0x3E, 0x23, 0x3C, 0x3C, 0x3C,
  0x3C, 0x3C, 0x16, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x17, 0x16, 0x16,
  0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x17, 0x17, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F,
  0x17, 0x0F, 0x17, 0x16, 0x16, 0x3C, 0x3C, 0x16, 0x16, 0x16, 0x16, 0x16,
  0x16, 0x17, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x0D, 0x17, 0x16, 0x16, 0x16, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x7B, 0x17, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0D, 0x00, 0x17, 0x17, 0x17,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17,
  0x17, 0x7B, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x0F, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D,
  0x3F, 0x3F, 0x14, 0x10, 0x17, 0x17, 0x7B, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x0F,
  0x0F, 0x0F, 0x0F, 0x0D, 0x17, 0x10, 0x17, 0x17, 0x17, 0x3F, 0x3D, 0x3F,
  0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x14, 0x10, 0x10, 0x17, 0x17, 0x17,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x17, 0x0F, 0x0F, 0x0D, 0x0D, 0x23, 0x23, 0x23, 0x17, 0x17, 0x10, 0x17,
  0x17, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x14, 0x10,
  0x10, 0x10, 0x17, 0x17, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x17, 0x0F, 0x40, 0x0D, 0x0F, 0x0D, 0x0D, 0x0D, 0x23,
  0x17, 0x10, 0x10, 0x10, 0x17, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D,
  0x3D, 0x3D, 0x14, 0x10, 0x14, 0x10, 0x10, 0x17, 0x17, 0x14, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x40, 0x0F, 0x0F, 0x23,
  0x23, 0x23, 0x23, 0x16, 0x17, 0x10, 0x10, 0x10, 0x17, 0x3D, 0x3D, 0x3D,
  0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x14, 0x10, 0x10, 0x14, 0x10, 0x10,
  0x17, 0x14, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x0F,
  0x0F, 0x0D, 0x0D, 0x0D, 0x0D, 0x23, 0x23, 0x14, 0x17, 0x10, 0x10, 0x10,
  0x17, 0x3D, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x3D, 0x14, 0x17,
  0x10, 0x10, 0x14, 0x10, 0x17, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x0F, 0x40, 0x0D, 0x0F, 0x0F, 0x23, 0x23, 0x23, 0x16, 0x17,
  0x17, 0x10, 0x10, 0x10, 0x17, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D,
  0x2F, 0x3D, 0x14, 0x17, 0x10, 0x14, 0x10, 0x10, 0x17, 0x14, 0x16, 0x14,
  0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x40, 0x0F, 0x0F, 0x23, 0x23, 0x0D,
  0x23, 0x01, 0x14, 0x17, 0x10, 0x10, 0x10, 0x10, 0x17, 0x2F, 0x3D, 0x2F,
  0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x14, 0x17, 0x10, 0x10, 0x14, 0x10,
  0x17, 0x17, 0x16, 0x14, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x0F,
  0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x40,
  0x0D, 0x0D, 0x0D, 0x23, 0x23, 0x01, 0x17, 0x17, 0x14, 0x10, 0x14, 0x10,
  0x17, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x3D, 0x2F, 0x3D, 0x14, 0x17,
  0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x16, 0x16, 0x14, 0x14, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x0F, 0x40, 0x40, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0x40, 0x0F, 0x0F, 0x23, 0x23, 0x23, 0x01, 0x16, 0x17, 0x14,
  0x10, 0x14, 0x10, 0x14, 0x17, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x3D, 0x2F, 0x14, 0x17, 0x10, 0x10, 0x14, 0x10, 0x10, 0x17, 0x3C, 0x16,
  0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x40, 0x0D, 0x23, 0x23, 0x0D, 0x17,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x0D, 0x0D, 0x0D, 0x23, 0x23,
  0x01, 0x14, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x2F, 0x01, 0x2F,
  0x01, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x14, 0x17, 0x10, 0x14, 0x10, 0x14,
  0x10, 0x17, 0x3C, 0x16, 0x16, 0x14, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x40, 0x40, 0x0D,
  0x0D, 0x0D, 0x23, 0x0D, 0x17, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x40, 0x0F,
  0x23, 0x23, 0x23, 0x01, 0x16, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14,
  0x17, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x2F, 0x14, 0x17,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x3C, 0x3C, 0x16, 0x14, 0x14, 0x14,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x0F, 0x0D, 0x23, 0x23, 0x23, 0x23, 0x23, 0x0D, 0x17, 0x00, 0x00,
  0x17, 0x0F, 0x40, 0x23, 0x23, 0x23, 0x01, 0x01, 0x14, 0x17, 0x14, 0x10,
  0x14, 0x10, 0x14, 0x10, 0x14, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F,
  0x01, 0x2F, 0x14, 0x17, 0x10, 0x10, 0x14, 0x10, 0x10, 0x17, 0x3C, 0x3C,
  0x16, 0x16, 0x14, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x40, 0x40, 0x0D, 0x0D, 0x0D, 0x23, 0x3E,
  0x3E, 0x0D, 0x17, 0x0F, 0x0D, 0x0D, 0x23, 0x23, 0x23, 0x23, 0x01, 0x16,
  0x17, 0x14, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x16, 0x01, 0x2F, 0x01,
  0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x14, 0x17, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x17, 0x3C, 0x3C, 0x3C, 0x16, 0x16, 0x14, 0x14, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x0D, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x3E, 0x3E, 0x0D, 0x0D, 0x0D, 0x23, 0x23, 0x23,
  0x23, 0x01, 0x01, 0x14, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x17,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2F, 0x01, 0x2F, 0x14, 0x17,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x14,
  0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x40, 0x40, 0x0D, 0x0D, 0x0D, 0x23, 0x3E, 0x23, 0x3E, 0x0D, 0x3E,
  0x3E, 0x23, 0x23, 0x23, 0x01, 0x01, 0x16, 0x17, 0x10, 0x14, 0x10, 0x14,
  0x10, 0x14, 0x10, 0x17, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x2F, 0x01, 0x14, 0x17, 0x10, 0x14, 0x10, 0x10, 0x10, 0x17, 0x3C, 0x3C,
  0x3C, 0x16, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x0D, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x3E, 0x3E, 0x3E, 0x3E, 0x23, 0x23, 0x23, 0x23, 0x01, 0x01, 0x14, 0x17,
  0x14, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x14, 0x2F, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x17, 0x14, 0x10, 0x14, 0x10,
  0x10, 0x17, 0x3C, 0x3C, 0x3C, 0x14, 0x16, 0x14, 0x14, 0x17, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x40, 0x40, 0x0D,
  0x0D, 0x0D, 0x23, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x23, 0x23, 0x23, 0x01,
  0x01, 0x16, 0x17, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x17, 0x16,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2F, 0x14, 0x17,
  0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x3C, 0x3C, 0x14, 0x16, 0x7B, 0x7B,
  0x7B, 0x3C, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x0F, 0x0D, 0x23, 0x23, 0x23, 0x0D, 0x23, 0x3E, 0x3E, 0x3E, 0x23,
  0x3E, 0x23, 0x01, 0x01, 0x16, 0x14, 0x17, 0x10, 0x10, 0x10, 0x14, 0x10,
  0x14, 0x17, 0x17, 0x01, 0x2F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x16, 0x14, 0x17, 0x14, 0x10, 0x14, 0x10, 0x14, 0x17, 0x3C, 0x3C,
  0x16, 0x7B, 0x7B, 0x17, 0x17, 0x7B, 0x3C, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x40, 0x40, 0x0D, 0x0D, 0x0D, 0x23, 0x3E,
  0x3E, 0x3E, 0x3E, 0x3E, 0x23, 0x23, 0x01, 0x16, 0x14, 0x17, 0x17, 0x10,
  0x10, 0x10, 0x10, 0x14, 0x10, 0x17, 0x14, 0x2F, 0x01, 0x14, 0x16, 0x16,
  0x2F, 0x01, 0x01, 0x01, 0x01, 0x14, 0x17, 0x17, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x17, 0x3C, 0x3C, 0x16, 0x7B, 0x7B, 0x17, 0x01, 0x7B, 0x3C, 0x17,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x0D, 0x23,
  0x23, 0x23, 0x0D, 0x23, 0x3E, 0x3E, 0x3E, 0x23, 0x23, 0x23, 0x23, 0x14,
  0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x16, 0x01,
  0x2F, 0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x2F, 0x3C, 0x01, 0x14, 0x17, 0x17,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x17, 0x3C, 0x3C, 0x16, 0x7B, 0x7B, 0x7B,
  0x7B, 0x7B, 0x3C, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x40, 0x40, 0x0D, 0x0D, 0x23, 0x23, 0x3E, 0x3E, 0x3E, 0x23, 0x3E,
  0x23, 0x23, 0x14, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x17, 0x14, 0x01, 0x2F, 0x01, 0x14, 0x16, 0x16, 0x3C, 0x3C, 0x3C, 0x3C,
  0x3C, 0x14, 0x17, 0x17, 0x14, 0x14, 0x14, 0x14, 0x17, 0x14, 0x3C, 0x3C,
  0x14, 0x14, 0x7B, 0x7B, 0x7B, 0x3C, 0x17, 0x14, 0x14, 0x17, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x0D, 0x23, 0x23, 0x0D, 0x0D, 0x23,
  0x3E, 0x3E, 0x3E, 0x23, 0x0D, 0x14, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x17, 0x17, 0x16, 0x2F, 0x01, 0x2F, 0x16, 0x3C, 0x3C,
  0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x10, 0x17, 0x17, 0x14, 0x14, 0x14, 0x14,
  0x17, 0x14, 0x2F, 0x3C, 0x16, 0x14, 0x3C, 0x3C, 0x3C, 0x17, 0x14, 0x14,
  0x14, 0x14, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x40, 0x40, 0x0D,
  0x0D, 0x23, 0x23, 0x3E, 0x0D, 0x0D, 0x0D, 0x0D, 0x14, 0x17, 0x17, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x14, 0x2F, 0x2F, 0x2F,
  0x2F, 0x14, 0x16, 0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x14, 0x17, 0x17, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x17, 0x14, 0x2F, 0x3C, 0x3C, 0x16, 0x16, 0x14,
  0x14, 0x14, 0x16, 0x14, 0x16, 0x14, 0x16, 0x14, 0x14, 0x17, 0x00, 0x00,
  0x17, 0x0F, 0x0D, 0x23, 0x23, 0x23, 0x0D, 0x0D, 0x0F, 0x17, 0x00, 0x00,
  0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17,
  0x16, 0x2F, 0x2F, 0x2F, 0x2F, 0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x16,
  0x10, 0x17, 0x17, 0x10, 0x14, 0x14, 0x14, 0x14, 0x17, 0x16, 0x2F, 0x2F,
  0x3C, 0x16, 0x16, 0x16, 0x16, 0x16, 0x14, 0x16, 0x14, 0x16, 0x14, 0x16,
  0x14, 0x16, 0x16, 0x16, 0x0F, 0x40, 0x40, 0x0D, 0x23, 0x0D, 0x0F, 0x17,
  0x00, 0x00, 0x00, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x17, 0x17, 0x14, 0x01, 0x2F, 0x2F, 0x2F, 0x2F, 0x14, 0x16, 0x16,
  0x3C, 0x3C, 0x3C, 0x14, 0x10, 0x17, 0x17, 0x14, 0x10, 0x14, 0x14, 0x14,
  0x17, 0x3F, 0x3D, 0x2F, 0x3C, 0x16, 0x3C, 0x16, 0x16, 0x16, 0x16, 0x16,
  0x16, 0x16, 0x3C, 0x3C, 0x16, 0x14, 0x17, 0x17, 0x17, 0x0F, 0x40, 0x40,
  0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x16, 0x2F, 0x01, 0x2F, 0x2F,
  0x2F, 0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x14, 0x17, 0x17, 0x14, 0x10,
  0x14, 0x10, 0x14, 0x10, 0x17, 0x3F, 0x2F, 0x3D, 0x3C, 0x3C, 0x16, 0x3C,
  0x3C, 0x3C, 0x16, 0x16, 0x3C, 0x3C, 0x16, 0x14, 0x14, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x14, 0x2F,
  0x01, 0x2F, 0x01, 0x2F, 0x2F, 0x2F, 0x16, 0x16, 0x3C, 0x3C, 0x16, 0x10,
  0x17, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x17, 0x2F, 0x3D, 0x2F,
  0x3D, 0x3C, 0x16, 0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x14, 0x16,
  0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17,
  0x17, 0x14, 0x16, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x16, 0x3C,
  0x3C, 0x3C, 0x14, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x17,
  0x14, 0x3D, 0x2F, 0x3D, 0x2F, 0x3C, 0x3C, 0x16, 0x16, 0x16, 0x3C, 0x3C,
  0x16, 0x14, 0x16, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x17, 0x17, 0x17, 0x14, 0x16, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F,
  0x01, 0x2F, 0x01, 0x16, 0x3C, 0x16, 0x10, 0x17, 0x17, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x17, 0x16, 0x3D, 0x3D, 0x3D, 0x3D, 0x2F, 0x3C, 0x3C,
  0x16, 0x16, 0x16, 0x16, 0x14, 0x16, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17, 0x14, 0x16, 0x01, 0x2F, 0x01,
  0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x2F, 0x16, 0x14, 0x17, 0x17,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x3F, 0x3D, 0x3D, 0x3D,
  0x3D, 0x3D, 0x3C, 0x3C, 0x3C, 0x3C, 0x14, 0x14, 0x14, 0x17, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x14, 0x14,
  0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17, 0x14, 0x16,
  0x01, 0x2F, 0x01, 0x2F, 0x01, 0x01, 0x2F, 0x2F, 0x01, 0x2F, 0x2F, 0x16,
  0x14, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14,
  0x3F, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3C, 0x3C, 0x14, 0x14, 0x17,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x14, 0x10, 0x10, 0x14, 0x14, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x14, 0x16, 0x23, 0x23, 0x23, 0x01, 0x23, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x16, 0x14, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x17, 0x17, 0x17, 0x16, 0x3F, 0x3F, 0x3F, 0x23, 0x23, 0x3C, 0x3C, 0x16,
  0x16, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x14, 0x14, 0x10, 0x10, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x14, 0x14, 0x3C, 0x3C, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x16, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14, 0x23, 0x23, 0x23, 0x23, 0x3C,
  0x3C, 0x16, 0x16, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x10, 0x10,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x17, 0x17, 0x17, 0x16, 0x16, 0x16,
  0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x14, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x16, 0x3C,
  0x3C, 0x3C, 0x16, 0x16, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17,
  0x14, 0x14, 0x14, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
  0x16, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17,
  0x17, 0x16, 0x16, 0x16, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x14, 0x10, 0x14, 0x10, 0x10, 0x14, 0x14, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x00, 0x17, 0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x14,
  0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x14, 0x17, 0x14, 0x14, 0x14, 0x10, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x10,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask7RA[] = {
  0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFE, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF,
  0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x7F, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF,
  0xFF, 0xF8, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xC0, 0x00, 0x7C, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x7E, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x7F, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x01, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xC0, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x5F, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite7RB[] = {
  0x00, 0x17, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x17, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x10, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16, 0x10,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x14, 0x16, 0x16, 0x14, 0x10, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x16, 0x16, 0x16,
  0x16, 0x10, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x16, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x3C, 0x23, 0x3D, 0x3D,
  0x3C, 0x16, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x16, 0x16, 0x23, 0x3D, 0x3D, 0x3C, 0x3C, 0x16, 0x17, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x16, 0x23, 0x23, 0x3D, 0x3C, 0x3C,
  0x3C, 0x16, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x16,
  0x3C, 0x23, 0x3D, 0x3D, 0x3C, 0x3C, 0x16, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x17, 0x16, 0x3C, 0x3E, 0x23, 0x3D, 0x3D, 0x3C, 0x16,
  0x10, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x16, 0x3C, 0x3E,
  0x23, 0x3D, 0x3D, 0x3C, 0x3C, 0x16, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x16, 0x3C, 0x3E, 0x23, 0x3D, 0x3D, 0x3C, 0x3C, 0x16, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x16, 0x3C, 0x3E, 0x23, 0x3D,
  0x3D, 0x3D, 0x3C, 0x16, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x17,
  0x16, 0x3C, 0x3E, 0x23, 0x3D, 0x3D, 0x3D, 0x3C, 0x3C, 0x16, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x17, 0x16, 0x3C, 0x3E, 0x23, 0x3C, 0x3C, 0x3C,
  0x3C, 0x3C, 0x16, 0x10, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x17, 0x16, 0x16,
  0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x17, 0x17, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F,
  0x17, 0x0F, 0x17, 0x16, 0x16, 0x3C, 0x3C, 0x16, 0x16, 0x16, 0x16, 0x16,
  0x16, 0x17, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x0D, 0x17, 0x16, 0x16, 0x16, 0x3F,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17, 0x17, 0x7B, 0x17, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x17, 0x17, 0x17,
  0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x17, 0x17,
  0x17, 0x7B, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x3F, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D,
  0x3F, 0x3F, 0x14, 0x10, 0x17, 0x17, 0x7B, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F,
  0x0F, 0x0F, 0x0D, 0x0D, 0x17, 0x10, 0x17, 0x17, 0x17, 0x3F, 0x3D, 0x3F,
  0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x14, 0x10, 0x10, 0x17, 0x17, 0x17,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x0F, 0x0D, 0x0D, 0x23, 0x23, 0x23, 0x23, 0x17, 0x17, 0x10, 0x17,
  0x17, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x3F, 0x3D, 0x14, 0x10,
  0x10, 0x10, 0x17, 0x17, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x40, 0x0D, 0x0F, 0x0D, 0x0D, 0x0D, 0x23, 0x23,
  0x17, 0x10, 0x10, 0x10, 0x17, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D,
  0x3D, 0x3D, 0x14, 0x10, 0x14, 0x10, 0x10, 0x17, 0x17, 0x14, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x40, 0x0F, 0x0F, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x16, 0x17, 0x10, 0x10, 0x10, 0x17, 0x3D, 0x3D, 0x3D,
  0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x14, 0x10, 0x10, 0x14, 0x10, 0x10,
  0x17, 0x14, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F,
  0x0D, 0x0D, 0x0D, 0x0D, 0x23, 0x23, 0x23, 0x14, 0x17, 0x10, 0x10, 0x10,
  0x17, 0x3D, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x3D, 0x14, 0x17,
  0x10, 0x10, 0x14, 0x10, 0x17, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0x40, 0x0D, 0x0F, 0x0F, 0x23, 0x23, 0x23, 0x23, 0x16, 0x17,
  0x17, 0x10, 0x10, 0x10, 0x17, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x3D,
  0x2F, 0x3D, 0x14, 0x17, 0x10, 0x14, 0x10, 0x10, 0x17, 0x14, 0x16, 0x14,
  0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x0F, 0x0F, 0x23, 0x23, 0x0D, 0x23,
  0x23, 0x01, 0x14, 0x17, 0x10, 0x10, 0x10, 0x10, 0x17, 0x2F, 0x3D, 0x2F,
  0x3D, 0x2F, 0x3D, 0x2F, 0x3D, 0x2F, 0x14, 0x17, 0x10, 0x10, 0x14, 0x10,
  0x17, 0x17, 0x16, 0x14, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x40, 0x0D,
  0x0D, 0x0D, 0x23, 0x23, 0x23, 0x01, 0x17, 0x17, 0x14, 0x10, 0x14, 0x10,
  0x17, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x3D, 0x2F, 0x3D, 0x14, 0x17,
  0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x16, 0x16, 0x14, 0x14, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0x0F, 0x40, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x40, 0x0F, 0x0F, 0x23, 0x23, 0x23, 0x23, 0x01, 0x16, 0x17, 0x14,
  0x10, 0x14, 0x10, 0x14, 0x17, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x3D, 0x2F, 0x14, 0x17, 0x10, 0x10, 0x14, 0x10, 0x10, 0x17, 0x3C, 0x16,
  0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x40, 0x23, 0x23, 0x0D, 0x17,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0D, 0x0D, 0x0D, 0x23, 0x23, 0x23,
  0x01, 0x14, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x2F, 0x01, 0x2F,
  0x01, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x14, 0x17, 0x10, 0x14, 0x10, 0x14,
  0x10, 0x17, 0x3C, 0x16, 0x16, 0x14, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x40, 0x40,
  0x0D, 0x0D, 0x23, 0x0D, 0x17, 0x00, 0x00, 0x00, 0x0F, 0x40, 0x0F, 0x0F,
  0x23, 0x23, 0x23, 0x01, 0x16, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14,
  0x17, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x2F, 0x14, 0x17,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x3C, 0x3C, 0x16, 0x14, 0x14, 0x14,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x17, 0x0F, 0x0D, 0x23, 0x23, 0x23, 0x23, 0x0D, 0x17, 0x00, 0x00,
  0x0F, 0x40, 0x0D, 0x23, 0x23, 0x23, 0x01, 0x01, 0x14, 0x17, 0x14, 0x10,
  0x14, 0x10, 0x14, 0x10, 0x14, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F,
  0x01, 0x2F, 0x14, 0x17, 0x10, 0x10, 0x14, 0x10, 0x10, 0x17, 0x3C, 0x3C,
  0x16, 0x16, 0x14, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x40, 0x40, 0x0D, 0x0D, 0x23, 0x3E,
  0x3E, 0x0D, 0x17, 0x0F, 0x0D, 0x0D, 0x23, 0x23, 0x23, 0x23, 0x01, 0x16,
  0x17, 0x14, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x16, 0x01, 0x2F, 0x01,
  0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x14, 0x17, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x17, 0x3C, 0x3C, 0x3C, 0x16, 0x16, 0x14, 0x14, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x0F, 0x0D,
  0x23, 0x23, 0x23, 0x23, 0x3E, 0x3E, 0x0D, 0x0D, 0x0D, 0x23, 0x23, 0x23,
  0x23, 0x01, 0x01, 0x14, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x17,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2F, 0x01, 0x2F, 0x14, 0x17,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x14,
  0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x0F, 0x40, 0x40, 0x0D, 0x0D, 0x23, 0x3E, 0x23, 0x3E, 0x0D, 0x3E,
  0x3E, 0x23, 0x23, 0x23, 0x01, 0x01, 0x16, 0x17, 0x10, 0x14, 0x10, 0x14,
  0x10, 0x14, 0x10, 0x17, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x2F, 0x01, 0x14, 0x17, 0x10, 0x14, 0x10, 0x10, 0x10, 0x17, 0x3C, 0x3C,
  0x3C, 0x16, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x0F, 0x0D, 0x23, 0x23, 0x23, 0x23,
  0x3E, 0x3E, 0x3E, 0x3E, 0x23, 0x23, 0x23, 0x23, 0x01, 0x01, 0x14, 0x17,
  0x14, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x14, 0x2F, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x17, 0x14, 0x10, 0x14, 0x10,
  0x10, 0x17, 0x3C, 0x3C, 0x3C, 0x14, 0x16, 0x14, 0x14, 0x17, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x40, 0x40,
  0x0D, 0x0D, 0x23, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x23, 0x23, 0x23, 0x01,
  0x01, 0x16, 0x17, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x17, 0x16,
  0x01, 0x01, 0x01, 0x14, 0x16, 0x16, 0x01, 0x01, 0x01, 0x2F, 0x14, 0x17,
  0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x3C, 0x3C, 0x14, 0x16, 0x7B, 0x7B,
  0x7B, 0x3C, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x17, 0x0F, 0x0D, 0x23, 0x23, 0x0D, 0x23, 0x3E, 0x3E, 0x3E, 0x23,
  0x3E, 0x23, 0x01, 0x01, 0x16, 0x14, 0x17, 0x10, 0x10, 0x10, 0x14, 0x10,
  0x14, 0x17, 0x17, 0x01, 0x2F, 0x01, 0x01, 0x16, 0x3C, 0x3C, 0x3C, 0x01,
  0x01, 0x16, 0x14, 0x17, 0x14, 0x10, 0x14, 0x10, 0x14, 0x17, 0x3C, 0x3C,
  0x16, 0x7B, 0x7B, 0x17, 0x17, 0x7B, 0x3C, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x40, 0x40, 0x0D, 0x0D, 0x23, 0x3E,
  0x3E, 0x3E, 0x3E, 0x3E, 0x23, 0x23, 0x01, 0x16, 0x14, 0x17, 0x17, 0x10,
  0x10, 0x10, 0x10, 0x14, 0x10, 0x17, 0x14, 0x2F, 0x01, 0x2F, 0x2F, 0x14,
  0x16, 0x16, 0x3C, 0x01, 0x01, 0x14, 0x17, 0x17, 0x14, 0x14, 0x14, 0x14,
  0x14, 0x17, 0x3C, 0x3C, 0x16, 0x7B, 0x7B, 0x17, 0x01, 0x7B, 0x3C, 0x17,
  0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x0F, 0x0D,
  0x23, 0x23, 0x0D, 0x23, 0x3E, 0x3E, 0x3E, 0x23, 0x23, 0x23, 0x23, 0x14,
  0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x16, 0x01,
  0x2F, 0x2F, 0x2F, 0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x01, 0x14, 0x17, 0x17,
  0x14, 0x14, 0x14, 0x14, 0x14, 0x17, 0x3C, 0x3C, 0x16, 0x7B, 0x7B, 0x7B,
  0x7B, 0x7B, 0x3C, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x17, 0x0F, 0x40, 0x40, 0x0D, 0x23, 0x23, 0x3E, 0x3E, 0x3E, 0x23, 0x3E,
  0x23, 0x23, 0x14, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x17, 0x14, 0x01, 0x2F, 0x01, 0x2F, 0x2F, 0x14, 0x16, 0x16, 0x3C, 0x3C,
  0x3C, 0x14, 0x17, 0x17, 0x14, 0x14, 0x14, 0x14, 0x17, 0x14, 0x3C, 0x3C,
  0x14, 0x14, 0x7B, 0x7B, 0x7B, 0x3C, 0x17, 0x14, 0x14, 0x17, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x0F, 0x0D, 0x23, 0x0D, 0x0D, 0x23,
  0x3E, 0x3E, 0x3E, 0x23, 0x0D, 0x14, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x17, 0x17, 0x16, 0x2F, 0x01, 0x2F, 0x2F, 0x2F, 0x16,
  0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x10, 0x17, 0x17, 0x14, 0x14, 0x14, 0x14,
  0x17, 0x14, 0x2F, 0x3C, 0x16, 0x14, 0x3C, 0x3C, 0x3C, 0x17, 0x14, 0x14,
  0x14, 0x14, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x17, 0x0F, 0x40, 0x40,
  0x0D, 0x23, 0x23, 0x3E, 0x0D, 0x0D, 0x0D, 0x0D, 0x14, 0x17, 0x17, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x14, 0x2F, 0x2F, 0x2F,
  0x2F, 0x2F, 0x2F, 0x14, 0x16, 0x16, 0x3C, 0x3C, 0x14, 0x17, 0x17, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x17, 0x14, 0x2F, 0x3C, 0x3C, 0x16, 0x16, 0x14,
  0x14, 0x14, 0x16, 0x14, 0x16, 0x14, 0x16, 0x14, 0x17, 0x17, 0x00, 0x00,
  0x17, 0x17, 0x0F, 0x0D, 0x23, 0x23, 0x0D, 0x0D, 0x0F, 0x17, 0x00, 0x00,
  0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17,
  0x16, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x16, 0x3C, 0x3C, 0x3C, 0x16,
  0x10, 0x17, 0x17, 0x10, 0x14, 0x14, 0x14, 0x14, 0x17, 0x16, 0x2F, 0x2F,
  0x3C, 0x16, 0x16, 0x16, 0x16, 0x16, 0x14, 0x16, 0x14, 0x16, 0x14, 0x16,
  0x16, 0x16, 0x16, 0x14, 0x17, 0x0F, 0x40, 0x40, 0x23, 0x0D, 0x0F, 0x17,
  0x00, 0x00, 0x00, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x17, 0x17, 0x14, 0x01, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x16, 0x16, 0x3C, 0x14, 0x10, 0x17, 0x17, 0x14, 0x10, 0x14, 0x14, 0x14,
  0x17, 0x3F, 0x3D, 0x2F, 0x3C, 0x16, 0x3C, 0x16, 0x16, 0x16, 0x16, 0x16,
  0x16, 0x16, 0x3C, 0x3C, 0x16, 0x14, 0x00, 0x00, 0x17, 0x17, 0x0F, 0x40,
  0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x16, 0x2F, 0x01, 0x2F, 0x2F,
  0x2F, 0x2F, 0x2F, 0x01, 0x16, 0x3C, 0x3C, 0x14, 0x17, 0x17, 0x14, 0x10,
  0x14, 0x10, 0x14, 0x10, 0x17, 0x3F, 0x2F, 0x3D, 0x3C, 0x3C, 0x16, 0x3C,
  0x3C, 0x3C, 0x16, 0x16, 0x3C, 0x3C, 0x14, 0x16, 0x14, 0x00, 0x00, 0x00,
  0x17, 0x17, 0x17, 0x0F, 0x17, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x14, 0x2F,
  0x01, 0x2F, 0x01, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x3C, 0x16, 0x10,
  0x17, 0x17, 0x10, 0x14, 0x10, 0x14, 0x10, 0x17, 0x17, 0x2F, 0x3D, 0x2F,
  0x3D, 0x3C, 0x16, 0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x16, 0x16, 0x14,
  0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17,
  0x17, 0x14, 0x16, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x2F, 0x2F, 0x2F,
  0x2F, 0x3C, 0x14, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x17,
  0x14, 0x3D, 0x2F, 0x3D, 0x2F, 0x3C, 0x3C, 0x16, 0x16, 0x16, 0x3C, 0x3C,
  0x16, 0x14, 0x14, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x17, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x17, 0x17, 0x17, 0x14, 0x16, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F,
  0x01, 0x2F, 0x01, 0x2F, 0x3C, 0x16, 0x10, 0x17, 0x17, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x17, 0x16, 0x3D, 0x3D, 0x3D, 0x3D, 0x2F, 0x3C, 0x3C,
  0x16, 0x16, 0x16, 0x16, 0x14, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17, 0x14, 0x16, 0x01, 0x2F, 0x01,
  0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x01, 0x2F, 0x2F, 0x16, 0x14, 0x17, 0x17,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x3F, 0x3D, 0x3D, 0x3D,
  0x3D, 0x3D, 0x3C, 0x3C, 0x3C, 0x3C, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x10, 0x10, 0x14, 0x14,
  0x10, 0x10, 0x14, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17, 0x14, 0x16,
  0x01, 0x2F, 0x01, 0x2F, 0x01, 0x01, 0x2F, 0x2F, 0x01, 0x2F, 0x2F, 0x16,
  0x14, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14,
  0x3F, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3C, 0x3C, 0x14, 0x14, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x14, 0x14, 0x10, 0x10, 0x14, 0x14, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17,
  0x17, 0x14, 0x16, 0x23, 0x23, 0x23, 0x01, 0x23, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x16, 0x14, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x17, 0x17, 0x17, 0x16, 0x3F, 0x3F, 0x3F, 0x23, 0x23, 0x3C, 0x3C, 0x16,
  0x16, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x17, 0x10, 0x10, 0x14, 0x14, 0x10, 0x10, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x10, 0x14, 0x16, 0x3C, 0x3C, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x16, 0x14, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x14, 0x23, 0x23, 0x23, 0x23, 0x3C,
  0x3C, 0x16, 0x16, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x14, 0x10, 0x10,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x10, 0x10, 0x14, 0x14, 0x16, 0x16,
  0x16, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x14, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x16, 0x3C,
  0x3C, 0x3C, 0x16, 0x16, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x10, 0x10, 0x17, 0x17, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
  0x10, 0x14, 0x14, 0x14, 0x16, 0x14, 0x16, 0x14, 0x16, 0x16, 0x16, 0x16,
  0x16, 0x16, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17,
  0x17, 0x16, 0x16, 0x16, 0x14, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x17, 0x17, 0x17, 0x10, 0x17, 0x10,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x14, 0x10, 0x14, 0x10, 0x14, 0x10,
  0x14, 0x10, 0x14, 0x10, 0x14, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x10,
  0x10, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x17, 0x17, 0x10, 0x17, 0x10, 0x17, 0x10, 0x17, 0x10,
  0x17, 0x10, 0x17, 0x10, 0x10, 0x17, 0x10, 0x17, 0x10, 0x17, 0x14, 0x14,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x10, 0x17, 0x10,
  0x17, 0x10, 0x10, 0x10, 0x14, 0x10, 0x10, 0x17, 0x17, 0x17, 0x17, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x17, 0x10, 0x14, 0x14, 0x14, 0x10, 0x17, 0x17, 0x17,
  0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x10, 0x10, 0x10,
  0x14, 0x17, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
  0x10, 0x14, 0x14, 0x14, 0x17, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

const uint8_t mask7RB[] = {
  0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFE, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF,
  0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7F, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF,
  0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x07, 0xFF, 0xFF,
  0xFF, 0xFF, 0xC0, 0x00, 0x1C, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
  0x3E, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x7F, 0x87, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF0, 0x00, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00,
  0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFC, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x1F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xC0, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F,
  0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00,
};

const uint8_t sprite8LA[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x41, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x41, 0x43, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x42, 0x43, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x18, 0x18, 0x18,
  0x42, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x41, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x18,
  0x18, 0x18, 0x41, 0x42, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x41,
  0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x43, 0x42, 0x41, 0x18, 0x28, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x28, 0x18, 0x18, 0x18, 0x42, 0x42, 0x43, 0x00, 0x00, 0x00, 0x00,
  0x28, 0x41, 0x41, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41,
  0x41, 0x18, 0x18, 0x28, 0x00, 0x43, 0x42, 0x42, 0x18, 0x18, 0x18, 0x28,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x41, 0x42, 0x42, 0x00, 0x00,
  0x28, 0x28, 0x18, 0x18, 0x41, 0x41, 0x42, 0x43, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0x42, 0x41, 0x41, 0x18, 0x18, 0x28, 0x28, 0x28,
  0x42, 0x41, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x18, 0x41, 0x41, 0x41,
  0x42, 0x28, 0x28, 0x28, 0x18, 0x18, 0x41, 0x41, 0x42, 0x42, 0x43, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x42, 0x42, 0x41,
  0x18, 0x18, 0x18, 0x18, 0x28, 0x41, 0x41, 0x41, 0x18, 0x41, 0x28, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
  0x41, 0x41, 0x41, 0x42, 0x28, 0x18, 0x18, 0x18, 0x18, 0x41, 0x42, 0x42,
  0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x43, 0x42, 0x42, 0x41, 0x41, 0x41, 0x18, 0x18, 0x41, 0x41,
  0x41, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x41, 0x18, 0x41, 0x41, 0x41, 0x41, 0x18, 0x18, 0x41, 0x41, 0x41,
  0x42, 0x42, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x42, 0x41, 0x41,
  0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x18, 0x41, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x42, 0x18, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
  0x41, 0x41, 0x41, 0x42, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x18,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x43, 0x42, 0x42, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
  0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x18, 0x41, 0x41,
  0x41, 0x41, 0x41, 0x41, 0x42, 0x42, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x42, 0x00,
  0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x42, 0x41, 0x41, 0x41,
  0x41, 0x41, 0x41, 0x41, 0x41, 0x18, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x42, 0x41, 0x42, 0x41, 0x41, 0x41, 0x42, 0x42, 0x43, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x7B, 0x00,
  0x00, 0x00, 0x7B, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x43, 0x42, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x18, 0x42,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x41, 0x42, 0x41, 0x42, 0x43, 0x43,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42,
  0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x42, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x41, 0x41, 0x41, 0x41,
  0x41, 0x41, 0x18, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x41, 0x42, 0x41,
  0x42, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x42, 0x00, 0x42, 0x00, 0x00,
  0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43,
  0x42, 0x42, 0x41, 0x41, 0x41, 0x41, 0x41, 0x42, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x43, 0x42, 0x42, 0x42, 0x43, 0x43, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x42,
  0x00, 0x42, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x43, 0x43, 0x42, 0x41, 0x41, 0x41, 0x41, 0x42,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x28, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x43, 0x43, 0x43, 0x41, 0x41, 0x41,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x00, 0x42, 0x00, 0x42, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x42,
  0x41, 0x41, 0x41, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00,
  0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7B, 0x7B,
  0x42, 0x42, 0x41, 0x41, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42,
  0x42, 0x42, 0x42, 0x00, 0x41, 0x00, 0x42, 0x00, 0x00, 0x00, 0x42, 0x00,
  0x41, 0x00, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x42, 0x43, 0x43, 0x42, 0x42, 0x42, 0x43, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x41, 0x42, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x43, 0x42, 0x41, 0x42, 0x41, 0x41, 0x41, 0x00, 0x00,
  0x00, 0x00, 0x42, 0x43, 0x7B, 0x7B, 0x43, 0x18, 0x18, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x18, 0x18, 0x43, 0x7B, 0x7B, 0x43, 0x42, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x41, 0x42, 0x42, 0x7B, 0x43, 0x43, 0x43, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x42, 0x41, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x42, 0x41, 0x42,
  0x41, 0x42, 0x43, 0x00, 0x00, 0x00, 0x42, 0x43, 0x7B, 0x7B, 0x43, 0x18,
  0x18, 0x18, 0x18, 0x28, 0x28, 0x28, 0x18, 0x18, 0x18, 0x43, 0x7B, 0x7B,
  0x43, 0x42, 0x00, 0x00, 0x00, 0x00, 0x42, 0x41, 0x41, 0x41, 0x42, 0x42,
  0x7B, 0x7B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00,
  0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x43, 0x42, 0x42, 0x42, 0x43, 0x7B, 0x41, 0x18, 0x42, 0x18, 0x43,
  0x7B, 0x43, 0x42, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
  0x18, 0x42, 0x43, 0x7B, 0x43, 0x18, 0x42, 0x18, 0x41, 0x00, 0x43, 0x42,
  0x42, 0x42, 0x42, 0x43, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x42, 0x43, 0x7B, 0x43, 0x41,
  0x18, 0x28, 0x42, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x41, 0x18,
  0x18, 0x41, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x42, 0x28, 0x18,
  0x41, 0x43, 0x7B, 0x43, 0x42, 0x42, 0x43, 0x43, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x18, 0x41, 0x42, 0x7B, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43,
  0x7B, 0x43, 0x41, 0x41, 0x18, 0x18, 0x41, 0x42, 0x42, 0x42, 0x42, 0x18,
  0x18, 0x41, 0x18, 0x41, 0x41, 0x18, 0x41, 0x18, 0x18, 0x42, 0x42, 0x42,
  0x42, 0x41, 0x18, 0x18, 0x41, 0x41, 0x43, 0x7B, 0x43, 0x43, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x41, 0x42, 0x7B, 0x43, 0x00, 0x00,
  0x00, 0x00, 0x7B, 0x42, 0x41, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x43, 0x42, 0x28, 0x41, 0x41, 0x18, 0x28, 0x28,
  0x42, 0x41, 0x18, 0x18, 0x41, 0x18, 0x41, 0x41, 0x41, 0x41, 0x18, 0x41,
  0x18, 0x18, 0x41, 0x42, 0x28, 0x28, 0x18, 0x41, 0x41, 0x28, 0x42, 0x43,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x28, 0x41, 0x42, 0x42, 0x7B,
  0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x7B, 0x42, 0x41, 0x41, 0x41,
  0x28, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x42, 0x41, 0x41,
  0x18, 0x41, 0x18, 0x18, 0x28, 0x42, 0x42, 0x41, 0x41, 0x41, 0x42, 0x41,
