
#ifndef FIX_FFT_H
#define	FIX_FFT_H

#ifdef __cplusplus
extern "C" {
#endif

#define fixed long
#define FIX_MPY(DEST,A,B)       DEST = ((long long)(A) * (long long)(B))>>31
#define N_WAVE          4096    /* dimension of Sinewave[] */
#define LOG2_N_WAVE     12      /* log2(N_WAVE) */

extern const fixed Sinewave[N_WAVE];     /* placed at end of this file for clarity */
extern const fixed flattop_window[N_WAVE/2+1];     /* placed at end of this file for clarity */
extern const fixed TriWave[N_WAVE];
extern const fixed SquareWave[N_WAVE];
extern const fixed SawWave[N_WAVE];
extern const fixed WhiteWave[N_WAVE];

int fix_fft (fixed fr[], fixed fi[], int m, int inverse);
void window_hann (fixed fr[], int n);
void window2_hann (fixed fr[], fixed im[], int n);
void window2_flattop (fixed fr[], fixed im[], int n);
void fix_loud (fixed loud[], fixed fr[], fixed fi[], int n, int scale_shift);
int iscale (int value, int numer, int denom);
fixed fix_dot (fixed * hpa, fixed * pb, int n);
void fft_real_result_convolve(fixed* re, fixed* im, int n);

#ifdef __cplusplus
}
#endif
#endif	/* FIX_FFT_H */
