#ifndef AUDIO_C //AUDIO_C
#define AUDIO_C //AUDIO_C

#include "audio.h"

unsigned int sliceA,chanA,pinA;
unsigned int freqdiv=11;  //11=>44100ish
volatile const int16_t* nowData;
volatile const int16_t* nextData;
volatile unsigned int nowSize, nextSize, nowPtr;
unsigned int audioState=0;
unsigned int pwmf=0;

unsigned int audioSetRate(unsigned int s){ //returns actual rate, gives c 500kHz/SYSCLKDIV PWM with 133MHz sysclk
  pwmf= clock_get_hz(clk_sys)/(256*SYSCLKDIV);
  if(s>0){
    freqdiv=(pwmf+(s/2))/s; //+s/2 gets us nearest rounding
  }
  if(freqdiv<1){freqdiv=1;}
  return pwmf/freqdiv;
}

unsigned int audioSamples(){  //number of samples left to play
  unsigned int r=0;
  if(nextData && nextSize){   //if data in second
    r=nextSize;
  }
  if(nowData && nowSize){   //continue if valid    
    return nowSize-nowPtr+r;
  }
  return 0; //nothing to play if current buffer is empty
}

unsigned int audioSpace(){ //is there space to Queue?
  if(nextData && nextSize){   //if data in second, no room
    return 0;
  }else{
    return 1;
  }
}

unsigned int audioQueue(const int16_t* b, unsigned int s){
  noInterrupts();
  if(audioState==AUDIO_STOPPED){
    if(nowData && nowSize){   //if data in 1st
      if(nextData && nextSize){   //if data in second, no room
        interrupts();
        return 0;
      }else{
         nextData=b;
         nextSize=s;
      }
    }else{
      nowData=b;
      nowSize=s;            
    }
  }else{
    if(nextData && nextSize){   //if data in second, no room
      interrupts();
      return 0;
    }else{
       nextData=b;
       nextSize=s;
    }
  }
  interrupts();
  return s;   //s bytes queued
}

unsigned int audioPlay(unsigned int s){  //takes AUDIO_PLAY_16 or AUDIO_LOOP_16, will resume current state if paused
  if(audioState==AUDIO_STOPPED){
    if(nowData && nowSize){   //continue if valid    
      if(s==AUDIO_PLAY_16){audioState=AUDIO_PLAY_16;}
      if(s==AUDIO_LOOP_16){audioState=AUDIO_LOOP_16;}
    }
  }else if(audioState==AUDIO_PAUSE_16){
    if(s==AUDIO_PLAY_16){audioState=AUDIO_PLAY_16;} //choose resume method
    if(s==AUDIO_LOOP_16){audioState=AUDIO_LOOP_16;}      
  }else if(audioState==AUDIO_LOOP_16){
    if(s==AUDIO_PLAY_16){audioState=AUDIO_PLAY_16;} //elegantly end looping    
  }else if(audioState==AUDIO_PLAY_16){
    if(s==AUDIO_LOOP_16){audioState=AUDIO_LOOP_16;} //elegantly start looping    
  }
  return audioState;  //return resulting state
}

void audioStop(){ //stop and put everything in an empty state
  audioState=AUDIO_STOPPED;  
  nowData=0;
  nowSize=0;
  nowPtr=0;
  nextData=0;
  nextSize=0;
}

unsigned int audioPause(){
  if(audioState==AUDIO_PLAY_16){audioState=AUDIO_PAUSE_16;}
  if(audioState==AUDIO_LOOP_16){audioState=AUDIO_PAUSE_16;}
  return audioState;  //return resulting state  
}

void audioInit(unsigned int p){
  pinA=p;
  //set null
  nowData=0;
  nextData=0;
  audioState=AUDIO_STOPPED;
  freqdiv=11;  //11=>44100ish
  //use C SDK to get access to interrupts
  gpio_set_function(pinA, GPIO_FUNC_PWM);
  sliceA=pwm_gpio_to_slice_num(pinA);
  chanA=pwm_gpio_to_channel(pinA);
  //use these globals to init irq using PWM slice
  pwm_clear_irq(sliceA);
  pwm_set_irq_enabled(sliceA, true);
  irq_set_exclusive_handler(PWM_IRQ_WRAP, audioPWMINT);
  irq_set_enabled(PWM_IRQ_WRAP, true);
  //set up PWM output
  pwm_set_wrap(sliceA, 255);
  pwm_set_clkdiv_int_frac(sliceA,SYSCLKDIV,0); //use highest available freq and divide down in IRQ
  pwm_set_chan_level(sliceA, chanA, 128);   //midpoint
  pwm_set_enabled(sliceA, true);    //PWM running
}

void __no_inline_not_in_flash_func(audioPWMINT)(){
  static unsigned int fcount=0;
  static int16_t residue=0;
  static int curSamp=0;     //keep and update as needed
  int curPWM,curOut;
  pwm_clear_irq(sliceA);  
  curPWM=curSamp+residue;
  residue=(curPWM>>0)&0xFF;
  //curOut=((curSamp>>8)&0xFF)^0x80;  //signed to unsigned
  curOut=((curSamp+32768)>>8)&0x1FF; //signed to unsigned, conserve values above 255
  pwm_set_chan_level(sliceA, chanA,curOut);
  fcount++;
  if(fcount>=freqdiv){
    fcount=0;
    nowPtr++;
    if(nowData){  //valid data
      if((audioState==AUDIO_PLAY_16)||(audioState==AUDIO_LOOP_16)){  //and playing
        curSamp=nowData[nowPtr]; //otherwise spin on previous value
        if(nowPtr>=nowSize){
          if(audioState==AUDIO_PLAY_16){    //single play
            if(nextData && nextSize){   //continue if valid
              nowData=nextData;
              nowSize=nextSize;
              nowPtr=0;       
              nextData=0;
              nextSize=0;            
            }else{
              nowData=0;
              nowSize=0;
              nowPtr=0;
              audioState=AUDIO_STOPPED;
            }
          }else{        //loop
            nowPtr=0;       
          }
        }
      }
    }
  }
}

#endif  //AUDIO_C
