#ifndef AUDIO_H //AUDIO_H
#define AUDIO_H //AUDIO_H

#include "Arduino.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "pico/stdlib.h"
#include <stdio.h>
#include "pico/time.h"
#include "hardware/irq.h"
#include "hardware/pwm.h"
#include "hardware/pll.h"
#include "hardware/clocks.h"
#include "hardware/structs/pll.h"
#include "hardware/structs/clocks.h"
 
//this version designed for mono playback of 16-bit samples
#define AUDIO_STOPPED 0
#define AUDIO_PLAY_16 2
#define AUDIO_PAUSE_16 4
#define AUDIO_LOOP_16 6
#define SYSCLKDIV (2)

extern unsigned int sliceA,chanA;
extern unsigned int freqdiv;
extern volatile const int16_t* nowData;
extern volatile const int16_t* nextData;
extern volatile unsigned int nowSize, nextSize, nowPtr;
extern unsigned int audioState;
extern unsigned int pwmf;

unsigned int audioSetRate(unsigned int s); //returns actual rate
unsigned int audioSamples();  //number of bytes left to play
unsigned int audioSpace(); //is there space to Queue?
unsigned int audioQueue(const int16_t* b, unsigned int s); //add to queue
unsigned int audioPlay(unsigned int s);  //takes AUDIO_PLAY_16, will resume current state if paused
void audioStop(); //stop and put everything in an empty state
unsigned int audioPause();
void audioPWMINT();    //ISR
void audioInit(unsigned int p);      //set everything up using pin p

#ifdef __cplusplus
}
#endif
#endif  //AUDIO_H
