
from gtts import gTTS
import subprocess
##import openai
import speech_recognition as sr
import yt_dlp
from googleapiclient.discovery import build
import RPi.GPIO as GPIO
import time
import os
import signal
from gpiozero import Button
from threading import Thread, Timer
import board
import digitalio
import adafruit_rgb_display.ili9341 as ili9341
from PIL import Image, ImageDraw, ImageFont, ImageOps
from datetime import datetime, timedelta
import re
import calendar
import threading

alarm_timer = None


youtube_api_key = "*********************"

# GPIO setup
LED_PIN = 27  # Use the pin you have connected your LED to
button_pin = 17  # Define the button GPIO pin
GPIO.setmode(GPIO.BCM)
GPIO.setup(LED_PIN, GPIO.OUT)

button = Button(button_pin, bounce_time=0.1)  # Set a debounce time of 0.1 seconds

# TFT Display setup
cs_pin = digitalio.DigitalInOut(board.CE0)  # Chip select
dc_pin = digitalio.DigitalInOut(board.D25)  # Data/command
reset_pin = digitalio.DigitalInOut(board.D24)  # Reset
BAUDRATE = 24000000  # Config for display baudrate (default max is 24mhz)
spi = board.SPI()  # Setup SPI bus using hardware SPI

# Create the display
disp = ili9341.ILI9341(
    spi,
    cs=cs_pin,
    dc=dc_pin,
    rst=reset_pin,
    baudrate=BAUDRATE,
    width=128,
    height=128
)

# Function to update the display
def update_display(text):
    height = disp.width  # Swap height/width to rotate it to landscape
    width = disp.height
    image = Image.new("RGB", (width, height))  # Create blank image for drawing
    draw = ImageDraw.Draw(image)
    draw.rectangle((0, 0, width, height), outline=0, fill=(255, 255, 220))  # Light background
    font = ImageFont.truetype("/usr/share/fonts/truetype/dejavu/DejaVuSans.ttf", 12)  # Load a TTF font

    # Text wrapping
    max_width = width - 12
    lines = []
    words = text.split(' ')
    line = ''
    for word in words:
        # Check the width of the current line plus the next word
        line_width = font.getbbox(line + word)[2] if line else font.getbbox(word)[2]
        if line_width <= max_width:
            line += word + ' '
        else:
            lines.append(line)
            line = word + ' '
    lines.append(line)

    y = 5
    for line in lines:
        draw.text((5, y), line, font=font, fill="#0000FF")  # Blue text
        y += font.getbbox(line)[3] - font.getbbox(line)[1]  # Get the height of the text

    flipped_image = ImageOps.mirror(image)  # Flip the image horizontally to correct the mirror effect
    disp.image(flipped_image)  # Display image

def led_on():
    GPIO.output(LED_PIN, GPIO.HIGH)

def led_off():
    GPIO.output(LED_PIN, GPIO.LOW)

def text_to_speech(text):
    tts = gTTS(text=text, lang="en")
    tts.save("output.mp3")
    subprocess.run(["mpg123", "-q", "output.mp3"], stderr=subprocess.DEVNULL)

def record_audio(file_name, duration=10):
    command = ["arecord", "-D", "plughw:1,0", "-f", "S16_LE", "-r", "16000", "-d", str(duration), file_name]
    subprocess.run(command, stderr=subprocess.DEVNULL)

def speech_to_text(file_name):
    recognizer = sr.Recognizer()
    try:
        with sr.AudioFile(file_name) as source:
            audio_data = recognizer.record(source)
            text = recognizer.recognize_google(audio_data)
            return text.lower()
    except sr.UnknownValueError:
        print("Sorry, could not understand the audio (UnknownValueError).")
        return ""
    except sr.RequestError as e:
        print(f"Could not request results from Google Speech Recognition service; {e}")
        return ""
    except Exception as e:
        print(f"An error occurred during speech recognition: {e}")
        return ""

def get_feedback():
    while True:
        led_on()
        record_audio("feedback.wav", duration=5)
        feedback = speech_to_text("feedback.wav")
        if "yes" in feedback:
            led_off()
            return True
        elif "no" in feedback:
            led_off()
            return False
        else:
            update_display("Say 'yes' or 'no' to confirm...")
            text_to_speech("Please say 'yes' or 'no' to confirm.")
        led_off()

def search_youtube(query):
    youtube = build('youtube', 'v3', developerKey=youtube_api_key)
    search_response = youtube.search().list(
        q=query,
        part='id,snippet',
        maxResults=1
    ).execute()

    if 'items' in search_response and search_response['items']:
        item = search_response['items'][0]
        if item['id']['kind'] == 'youtube#video':
            video_id = item['id']['videoId']
            video_title = item['snippet']['title']
            video_url = f"https://www.youtube.com/watch?v={video_id}"
            return video_url, video_title
    return None, None

def extract_audio_url(youtube_url):
    ydl_opts = {
        'format': 'bestaudio/best',
        'quiet': True,
        'extract_flat': True,
        'skip_download': True
    }
    with yt_dlp.YoutubeDL(ydl_opts) as ydl:
        info = ydl.extract_info(youtube_url, download=False)
        if 'entries' in info:  # Playlist
            video_url = info['entries'][0]['url']
        else:  # Single video
            video_url = info['url']
    return video_url

process = None
alarm_timer = None

def toggle_program():
    global process

    if process is None or process.poll() is not None:  # If no process is running
        led_on()
        while True:
            update_display("Listening...")
            text_to_speech("Please provide the song or video description:")
            update_display("Please provide the song or video description:")
            record_audio("question.wav", duration=10)
            led_off()
            print("Recording complete. Processing question...")
            update_display("Processing Request...")
            spoken_question = speech_to_text("question.wav")
            if spoken_question:
                print(f"Spoken Question: {spoken_question}")
            else:
                update_display("Recognition failed")
                text_to_speech("Failed to recognize the question. Exiting.")
                led_off()
                return

            video_url, video_title = search_youtube(spoken_question)
            if video_url:
                update_display(f"Found: {video_title}")
                text_to_speech(f"Found: {video_title}")
                text_to_speech("Is this the correct video? Say 'yes' or 'no'.")
            else:
                update_display("Not found. Try again.")
                text_to_speech("Could not find any video. Please try again.")
                continue

            if get_feedback():
                break
            else:
                text_to_speech("Let's try again.")
                led_off()

        audio_url = extract_audio_url(video_url)
        update_display("Playing...")
        text_to_speech("Playing the song.")
        process = subprocess.Popen(["mpv", "--no-video", audio_url], preexec_fn=os.setsid)
        led_on()
    else:  # A process is already running
        stop_program()

def stop_program():
    global process
    if process is not None:
        print("Terminating current process...")
        text_to_speech("Stopping the song.")
        update_display("Stopping...")
        os.killpg(os.getpgid(process.pid), signal.SIGTERM)  # Terminate the process group
        process.wait()  # Ensure the process has terminated
        process = None
        led_off()
        update_display("Stopped")

def pause_music():
    global process
    if process is not None and process.poll() is None:
        print("Pausing music...")
        text_to_speech("Pausing the song.")
        update_display("Paused")
        process.send_signal(signal.SIGSTOP)

def resume_music():
    global process
    if process is not None and process.poll() is None:
        print("Resuming music...")
        text_to_speech("Resuming the song.")
        update_display("Playing")
        process.send_signal(signal.SIGCONT)

def set_alarm_time(alarm_time):
    text_to_speech("Alarm time has reached")
    update_display("Alarm time has reached")



def schedule_alarm(alarm_time):
    global alarm_timer
    delay = (alarm_time - datetime.now()).total_seconds()
    if delay > 0:
        alarm_timer = threading.Timer(delay, trigger_alarm)
        alarm_timer.start()
    else:
        print("Alarm time is in the past. Please set a future time.")

def trigger_alarm():
    for _ in range(5):
        text_to_speech("Alarm time has reached")
        update_display("Alarm time has reached")
        led_on()
        time.sleep(1)  # Pause for 1 second between repeats
        led_off()



def parse_date_time(date_str, time_str):
    now = datetime.now()

    # Parse the time
    try:
        time_match = re.match(r'(\d{1,2})(\d{2})', time_str)
        if time_match:
            hour, minute = map(int, time_match.groups())
        else:
            return None
    except ValueError:
        return None

    # Parse the date
    if date_str == "today":
        alarm_date = now.date()
    elif date_str == "tomorrow":
        alarm_date = now.date() + timedelta(days=1)
    else:
        try:
            specific_date = datetime.strptime(date_str, '%d %B %Y')
            alarm_date = specific_date.date()
        except ValueError:
            try:
                specific_date = datetime.strptime(date_str, '%d %b %Y')
                alarm_date = specific_date.date()
            except ValueError:
                day_names = list(calendar.day_name)
                short_day_names = list(calendar.day_abbr)
                day_name_match = None

                for i, day in enumerate(day_names):
                    if date_str.lower() == f"next {day.lower()}":
                        day_name_match = i
                        break
                if not day_name_match:
                    for i, day in enumerate(short_day_names):
                        if date_str.lower() == f"next {day.lower()}":
                            day_name_match = i
                            break

                if day_name_match is not None:
                    days_ahead = day_name_match - now.weekday()
                    if days_ahead <= 0:
                        days_ahead += 7
                    alarm_date = now.date() + timedelta(days=days_ahead)
                else:
                    return None

    alarm_time = datetime.combine(alarm_date, datetime.min.time()) + timedelta(hours=hour, minutes=minute)
    return alarm_time

def voice_activation():
    recognizer = sr.Recognizer()
    mic = sr.Microphone(device_index=1)  # Explicitly specify the microphone index

    while True:
        with mic as source:
            recognizer.adjust_for_ambient_noise(source)
            print("Listening for wake word...")
            update_display("Listening for wake word...")
            audio = recognizer.listen(source)

        try:
            command = recognizer.recognize_google(audio)
            command = command.lower()
            print(f"Heard: {command}")

            if "daisy on" in command:
                toggle_program()
            elif "daisy stop" in command:
                update_display("Powering off.")
                text_to_speech("Powering off the computer...")
                os.system("sudo poweroff")
            elif "daisy pause" in command:
                pause_music()
            elif "daisy resume" in command:
                resume_music()
            elif "daisy set alarm" in command:
                update_display("Setting alarm")
                text_to_speech("Please say the alarm in 24 hour format")
                record_audio("alarm_time.wav", duration=5)
                alarm_time_str = speech_to_text("alarm_time.wav")
                print(alarm_time_str)
                text_to_speech("Please say the date")
                record_audio("alarm_date.wav", duration=5)
                alarm_date_str = speech_to_text("alarm_date.wav")
                print(alarm_date_str)
                alarm_time = parse_date_time(alarm_date_str, alarm_time_str)
                print(alarm_time)
                if alarm_time:
                    schedule_alarm(alarm_time)
                    text_to_speech(f"Alarm set for {alarm_time.strftime('%Y-%m-%d %H:%M')}")
                    update_display(f"Alarm set for {alarm_time.strftime('%Y-%m-%d %H:%M')}")
                alarm_time = parse_date_time(alarm_date_str, alarm_time_str)
                print(alarm_time)
                if alarm_time:
                    schedule_alarm(alarm_time)
                    text_to_speech(f"Alarm set for {alarm_time.strftime('%Y-%m-%d %H:%M')}")
                    update_display(f"Alarm set for {alarm_time.strftime('%Y-%m-%d %H:%M')}")
                else:
                    text_to_speech("Could not understand the date or time. Please try again.")
                    update_display("Alarm not set. Please try again.")
        except sr.UnknownValueError:
            print("Sorry, could not understand the audio (UnknownValueError).")
        except sr.RequestError as e:
            print(f"Could not request results from Google Speech Recognition service; {e}")
        except Exception as e:
            print(f"An error occurred during wake word detection: {e}")      
      # Start the voice activation in a separate thread
voice_thread = Thread(target=voice_activation)
voice_thread.daemon = True
voice_thread.start()

# When the button is pressed, toggle the program
button.when_pressed = toggle_program

# Keep the script running
try:
    while True:
        time.sleep(0.1)  # Add a short delay to reduce CPU usage
except KeyboardInterrupt:
    if process is not None:
        os.killpg(os.getpgid(process.pid), signal.SIGTERM)
        process.wait()
    if alarm_timer is not None:
        alarm_timer.cancel()
    GPIO.cleanup()
    print("Program terminated.")
    
