//misc utilities

#ifndef UTIL_H
#define	UTIL_H
#include <xc.h>
#include "io.h"

#define _XTAL_FREQ 4000000

/* Useful Defines */
#define startup_delay 500   // give things time to sort themselve sout
#define settle_time 100   // give things time to sort themselve sout
#define timer_delay_ms 50
#define vent_on_boot_time 3000   // 3 seconds is long enouugh to be heard
#define short_vent_on_boot_time 1000   // 3 seconds is long enouugh to be heard
#define Time_10Min_Runtime (long int) ((long int)10 * (long int)60 * (long int)10)  
#define Time_20Min_Runtime (long int) ((long int)20 * (long int)60 * (long int)10)  
#define Time_30Min_Runtime (long int) ((long int)30 * (long int)60 * (long int)10)  
#define Time_60Min_Runtime (long int) ((long int)60 * (long int)60 * (long int)10)  


#define Counting_Timer   100           /* Use 100ms time steps */

typedef enum
{
	/* Application's state machine's initial state. */
	TIMER_STATE_INIT=0,         // Initial state
	TIMER_STATE_IDLE,           // Idle
    TIMER_STATE_COUNTING        // counting drying cycle
            
	/* TODO: Define states used by the application state machine. */
} TIMER_STATES;


typedef struct
{
    TIMER_STATES        state;              /* The application's current state */
    long int            Timer_Runtime;      /* Time to run - units 100ms */
    long int            Timer_Time;         /* Actual Time */
    long int            Timer_Temp;         /* Start time for set duration */
    long int            Second_Counter;     /* Timer for 1 second */
    int                 Heater_Output_Disable;  /* Heater output state 1 = OFF */ 
    int                 Starting;           /* This is a cheat - monitors first entry to idle  - should use the state machine for this*/
} TIMER_DATA;

TIMER_DATA Timer_Data;   /* refer defines in util.h */

/* define the PORA A bits here    */
/* Note io.c sets these port bits */
#define Start       0x01    /* port A bit 0  <- input from push buttom*/
#define Relay_Out   0x02    /* Port A bit 1 -> output to drive relay */
#define PIR_Input   0x04    /* Port A bit 2 -> PIR Input - senses activity */
#define Time_0     0x10     /* Port A but 4 <- delay time input 0 */
#define Time_1     0x20     /* Port A but 5 <- delay time input 1 */

#define Read_Port_A_Inputs (PORTA & (Start + PIR_Input + Time_0 + Time_1))

#define PIR_IN PORTAbits.RA2
#define Start_Read PORTAbits.RA0
#define Movement_Detected PORTAbits.RA2
#define Time_60_Min  (((Read_Port_A_Inputs) & (Time_0 + Time_1)) == (Time_0 + Time_1)) 
#define Time_30_Min  (((Read_Port_A_Inputs) & (Time_0 + Time_1)) == Time_1)
#define Time_20_Min  (((Read_Port_A_Inputs) & (Time_0 + Time_1)) == Time_0 )
#define Time_10_Min  (!((Read_Port_A_Inputs) & (Time_0 + Time_1)))

#define Relay_On  RA1 = 1
#define Relay_Off RA1 = 0

#endif

