/*
 * File:   main.c
 * Author: pproser
 *
 * Created Nov, 2024
 * V1.0 Start with Tool Timer
 * !1.0 Final version 08 Jan 2025
 * 
 * 
 */

#include "config.h"
#include "io.h"
#include "util.h"  
#include <xc.h>


/*******************************************************************************
  Function:
    void Timer_Initialize ( void )

  Remarks:
    See prototype in util.h.
******************************************************************************/
void Timer_Initialize ( void )
{
    /* Place the App state machine in its initial state. */
    Timer_Data.state                    = TIMER_STATE_INIT;
    Timer_Data.Timer_Runtime            = 0;
    Timer_Data.Timer_Time               = 0;
    Timer_Data.Timer_Temp               = 0;
    Timer_Data.Second_Counter           = 0; 
    Timer_Data.Heater_Output_Disable    = 1; /* definitely start off! */
    Timer_Data.Starting                 = 1; /* note first entry to idle */
}


void main(void) {
int PortA_Read;    
    
    // initialise the data structures and state machine
    Timer_Initialize();
    __delay_ms(startup_delay);
    /* Check the application's current state. */
    do{
        switch ( Timer_Data.state )
        {
            /* Application's initial state. */
            case TIMER_STATE_INIT:
            {
                // some configuration stuff to get things rolling 
                WDTCON=0;       //off under software control
                OSCFRQ=2;       //4MHz - this should be fine for this application
                __delay_ms(settle_time);  /* let the port settle */
                ioinit();
                /* make sure the relay is off */
                Relay_Off;

                Timer_Data.state = TIMER_STATE_IDLE;                             
            }
            break;

            
            case TIMER_STATE_IDLE:
            {
                Relay_Off;
                Timer_Data.Timer_Time = 0;  /* reset timer */
                PortA_Read =  Read_Port_A_Inputs;
                if ((!Start_Read ) || (Timer_Data.Starting))
                {
                    /* clear starting */
                    Timer_Data.Starting = 0;
                    if (Time_10_Min)
                    {
                        Timer_Data.Timer_Runtime = Time_10Min_Runtime;
                        Timer_Data.state = TIMER_STATE_COUNTING ;                    }
                    else if (Time_20_Min)
                    {
                        Timer_Data.Timer_Runtime = Time_20Min_Runtime;
                        Timer_Data.state = TIMER_STATE_COUNTING ;                    }
                    else if (Time_30_Min)
                    {
                        Timer_Data.Timer_Runtime = Time_30Min_Runtime;
                        Timer_Data.state = TIMER_STATE_COUNTING ;                    }
                    else if (Time_60_Min)
                    {
                        Timer_Data.Timer_Runtime = Time_60Min_Runtime;
                        Timer_Data.state = TIMER_STATE_COUNTING ;                    }
                    else   /* SEND IT BACK TO IDLE */
                    {
                        Timer_Data.state = TIMER_STATE_IDLE ;
                        Timer_Data.Timer_Runtime = 0;
                        Relay_Off;
                    };
                }                
            }
            break;
            
            case TIMER_STATE_COUNTING:
            {
                Relay_On;
                __delay_ms(Counting_Timer);  /* 100ms time steps */

                if (PIR_IN)
                {
                    if (Time_10_Min)
                    {
                        Timer_Data.Timer_Runtime = Time_10Min_Runtime;
                        Timer_Data.state = TIMER_STATE_COUNTING ;                    }
                    else if (Time_20_Min)
                    {
                        Timer_Data.Timer_Runtime = Time_20Min_Runtime;
                        Timer_Data.state = TIMER_STATE_COUNTING ;                    }
                    else if (Time_30_Min)
                    {
                        Timer_Data.Timer_Runtime = Time_30Min_Runtime;
                        Timer_Data.state = TIMER_STATE_COUNTING ;                    }
                    else if (Time_60_Min)
                    {
                        Timer_Data.Timer_Runtime = Time_60Min_Runtime;
                        Timer_Data.state = TIMER_STATE_COUNTING ;                    }
                    else   /* SEND IT BACK TO IDLE */
                    {
                        Timer_Data.state = TIMER_STATE_IDLE ;
                        Timer_Data.Timer_Runtime = 0;
                        Relay_Off;
                    };
                }
                
                Timer_Data.Timer_Runtime --; /* decrement heater timer */
                if (Timer_Data.Timer_Runtime == 0)
                {
                    /* we are done here */
                    Relay_Off;
                    Timer_Data.Timer_Runtime = 0;
                    Timer_Data.state = TIMER_STATE_IDLE ;  /* go back to idle */
                };
            }
            break;
        }
        
    } while(1); // for ever
    
    return;
}
