void readDefaultData()
{
  Serial.println ("**** In readDefaultData() ****") ;
  Serial.println ("***********Reading EEPROM DEFAULT DATA**********");
  // **********Defaults **********
  timeZone =  EEPROM.read(1) + (256 * EEPROM.read (2));

  if (timeZone < -120 or timeZone > 140 )
  {
    timeZone = 95;
  }

  Serial.println ("Time Zone: " + String (timeZone));
  //brightness =  readEEPROMI2C(eeprom, 3); // + (256 * readEEPROMI2C(eeprom, 4));//was 2 bytes
  brightness =  EEPROM.read(3);// + (256 * EEPROM.read (4));
  if (brightness > 100 )
  {
    brightness = 100;
  }
  if (brightness < 10)
  {
    brightness = 15;
  }
  Serial.println ("Brightness: " + String (brightness));

  scrollDelay =  EEPROM.read(5) + (256 * EEPROM.read (6));
  if (scrollDelay > 1000 )
  {
    scrollDelay = 1000;
  }
  Serial.println ("Scroll Delay: " + String (scrollDelay));

  pixelDelay =  EEPROM.read(7) + (256 * EEPROM.read (8));
  if (pixelDelay > 1000 )
  {
    pixelDelay = 1000;
  }
  Serial.println ("Pixel Delay: " + String (pixelDelay));

  fadeDelay =  EEPROM.read(9) + (256 * EEPROM.read (10));
  if (fadeDelay > 1000 )
  {
    fadeDelay = 1000;
  }
  Serial.println ("Fade Delay: " + String (fadeDelay));
  //COLOURS LOCATIONS 11 TO 19
  //String buttonBackColour = "rgb(200,150,20)";
  //String buttonTextColour = "rgb(255,255,255)";
  //String screenBackColour = "rgb(200,10,0)";

  //buttonBackColour: rgb(55,43,0)
  //buttonTextColour: rgb(255,255,255)
  //screenBackColour: rgb(246,182,13)

  int r = EEPROM.read(11);
  int g = EEPROM.read(12);
  int b = EEPROM.read(13);
  buttonBackColour = "rgb(" + String (r ) + "," + String (g) + "," + String (b) + ")";
  r = EEPROM.read(14);
  g = EEPROM.read(15);
  b = EEPROM.read(16);
  buttonTextColour = "rgb(" + String (r ) + "," + String (g) + "," + String (b) + ")";
  r = EEPROM.read(17);
  g = EEPROM.read(18);
  b = EEPROM.read(19);
  screenBackColour = "rgb(" + String (r ) + "," + String (g) + "," + String (b) + ")";
  Serial.println ("buttonBackColour: " + buttonBackColour);
  Serial.println ("buttonTextColour: " + buttonTextColour);
  Serial.println ("screenBackColour: " + screenBackColour);
  hourMode = EEPROM.read(20);
  if (hourMode == 12 or hourMode == 24)
  {
    hourMode = 12;
  }
  alarmHour = EEPROM.read(21);
  if (alarmHour <0 or alarmHour >23)
  {
    alarmHour = 8;
  }
  alarmMinute = EEPROM.read(22);
  if (alarmMinute <0 or alarmMinute >59)
  {
    alarmMinute = 0;
  }
  Serial.println("Alarm Time is: " + String(alarmHour) + String (alarmMinute));
  int alarmTemp = EEPROM.read(23);
  if (alarmTemp == 1)
  {
    alarmOn = true;
    Serial.println("Alarm is On.");
  }
  else
  {
    alarmOn = false;
    Serial.println("Alarm is Off.");
  }
  int cTemp = EEPROM.read(24);

  if (cTemp == 1) //Clock Type
  {
    digitalClock = true;
    Serial.println("Clock Mode is Digital");
  }
  else
  {
    digitalClock = false;
    Serial.println("Clock Mode is Analog");
  }

  pixelMode = readEEPROMString (50);
  if (pixelMode.length() > 45)
  {
    pixelMode = "Time";
  }
  Serial.println ("Pixel Mode: " + pixelMode);

  //ScrollText

  for (unsigned int i = 0; i < 10; i++)
  {
    scrollArray[i] = readEEPROMString(100 + (i * 50));
    if (scrollArray[i].length() > 50)
    {
      scrollArray[i] = "Undefined";
    }
  }
  wifiSSID = readEEPROMString (600);
  if (wifiSSID.length() > 50)
  {
    wifiSSID = "SSID exceeds 50";
  }
  Serial.print ("SSID: ");
  Serial.println (wifiSSID);

  wifiPassword = readEEPROMString (625);
  if (wifiPassword.length() > 50)
  {
    wifiPassword = "PW exceeds 50";
  }

  Serial.print ("Password: ");
  Serial.println (wifiPassword);


  //IP Address
  wifiAdd = readEEPROMString (650);
  if (wifiAdd.length() > 50)
  {
    wifiAdd = "(10.0.0.78)";
  }
  /*
  IPAddress tempIPAdd = str2IP(wifiAdd);
  ipAdd[0] = tempIPAdd[0];
  ipAdd[1] = tempIPAdd[1];
  ipAdd[2] = tempIPAdd[2];
  ipAdd[3] = tempIPAdd[3];
  Serial.print ("IP Address: ");
  Serial.println (ipAdd);
  */
  //Gateway
  wifiGW = readEEPROMString (675);
  if (wifiGW.length() > 50)
  {
    wifiGW = "(10.0.0.138)";
  }
  /*
  IPAddress tempIPGW = str2IP(wifiGW);
  //Serial.print ("GW Address: ");
  ipGw[0] = tempIPGW[0];
  ipGw[1] = tempIPGW[1];
  ipGw[2] = tempIPGW[2];
  ipGw[3] = tempIPGW[3];
  Serial.print ("Gate Way: ");
  Serial.println (ipGw);
*/
  readSPIDNames("/DNames.txt", "Load");
  readSPICodingAll("Read");
  Serial.println ("**** Exiting readDefaultData() ****");
}
