void webSocketEvent(uint8_t num, WStype_t type, uint8_t * payload, size_t length)
{
  Serial.println ("webSocketEvent Received:");
  IPAddress ip;
  uint16_t f;
  switch (type)
  {
    case WStype_DISCONNECTED:
      Serial.printf("[%u] Disconnected!\n", num);
      delay(10);//was 50
      break;
    case WStype_CONNECTED:
      ip = webSocket.remoteIP(num);
      Serial.printf("[%u] Connected from %d.%d.%d.%d url: %s\n", num, ip[0], ip[1], ip[2], ip[3], payload);
      updateClientData = true;//send the full packet
      break;
    case WStype_TEXT:
      player = num;
      Serial.println ("Player: " + String (player));
      Serial.printf("[%u] Request Text: %s\n", num, payload);
      /*  FOR EXISTING APPS, UNCOMMENT THIS LINE, DELETE THE payload[] cases
           AND ADD THE ':' END OF MESSAGE TO THE html files as well as send message, etc.
      */
      String r_state = ""; //received state
      for (int i = 0; i < 100; i++)
      {
        if (char(payload[i] ) == ':' )
        {
          break;
        }
        else
        {
          r_state += char(payload[i]);
          //Serial.println ("ip[0] =" + String (ip[0]) + " - " + "payload:" + String (i) + " = " + String (char(payload[i])));
        }
      }
      // Serial.println("Request is: " + r_state);
      handleRequest(r_state);
      break;
  }
}
