//Settings HTML Page
const char SETTINGS_page [] PROGMEM = R"====(

<h2><label  id ="pagetitle">Pixel Controller - Settings</label></h2>

<!--***Start of Message Table-->
<h4><table><tr><th style = 'width: 480px' > Messages. </th></tr>
<tr><td><span id = "message">Message</span></td></tr>
</table></h4>
<!--Start of Controls -->

<fieldset><legend>Controls:</legend>
<table>
<tr>
<td><button type= "button" onclick = " ClientToServer('back')" id ='sbut0'>Home</button></td>
<td><button type= "button" onclick = " ClientToServer('24hourmode')" id ='sbut1'>24 Hour Mode</button></td>
<td><button type= "button" onclick = " ClientToServer('12hourmode')" id ='sbut2'>12 Hour Mode</button></td>
<td><button type= "button" onclick = " ClientToServer('digitalclock')" id ='sbut3'>Digital Clock</button></td>
<td rowspan="3">
<canvas id="clockcanvas" width="150" height="150"
style="background-color:#333">
</canvas>
</td>
</tr>
<tr>
<td><button type= "button" onclick = " ClientToServer('analogclock')" id ='sbut4'>Analog Clock</button></td>
<td><button type= "button" onclick = " ClientToServer('version')" id ='sbut5'>Version</button></td>
<td><button type= "button" onclick = " ClientToServer('alarmon')" id ='sbut6'>Turn Alarm On</button></td>
<td><button type= "button" onclick = " ClientToServer('alarmoff')" id ='sbut7'>Turn Alarm Off</button></td>
</tr>
<tr>
<td><button type= "button" onclick = " ClientToServer('networkscan')" id ='sbut8'>Network Re-Scan</button></td>
<td><button type= "button" onclick = " ClientToServer('clearnetworksettings')" id ='sbut9'>Clear Network</button></td>
<td><button type= "button" onclick = " ClientToServer('submitnetworksettings')" id ='sbut10'>Submit Network</button></td>
<td><button type= "button" onclick = " ClientToServer('rebootesp')" id ='sbut11'>Re-Boot Micro</td>
</tr>

</table>
</fieldset>
<br>
<!--TIMEZONE-->
<!--ALARM-->
<fieldset><legend>Time Settings:</legend>
<!--<label for='timezone'>TimeZone is: " +String (timeZone/10)+ "." + String (timeZone%10) + " UTC</label>-->
<!--style ='color:rgb(255,255,0); border: 2px solid black ; font-size:18px ; background-color:rgb(0,255,0)'-->
<label for='timezonelabel'>TimeZone is: <span id ="timezonelabel"></span></label> 

<br>
<select id='timezoneselect' onchange = "SendTimeZone()"></select>
<script>
     addTz =document.getElementById('timezoneselect');
     for (var i= -120;i<140;i+=5 )
     {
      dOption =document.createElement('option');
      
      dOption.text = (i/10);
      if (dOption.text.indexOf(".") == -1)
      {
        dOption.text= dOption.text +".0";
      }
      dOption.value = i ;
      addTz.add(dOption);
     }
    function SendTimeZone(){ClientToServer("timezone=" + document.getElementById("timezoneselect").value);}
</script>
 <br>
 <br>
  <label for='alarmonoff'><span id ="alarmonoff"></span></label>
  <br>
  <label for='alarmsetting'>Alarm is: <span id ="alarmsetting"></span></label>
  <br>
<label for='alarmhour'>Alarm Hour:</label> 
<select id='alarmhourselect'  onchange =" SendAlarmHour()" name='alarmhour' >Select Hour:</select>
<script>
     addaH =document.getElementById('alarmhourselect');
     for (var i= 0;i<24;i++ )
     {
      hOption =document.createElement('option');
      hOption.text= (i);
      hOption.value = i ;
      addaH.add(hOption);
     }
     <!--document.getElementById("alarmhourselect").selectedIndex = 8; -->
     function SendAlarmHour(){ClientToServer("alarmhour=" + document.getElementById("alarmhourselect").value);}

</script>
<label for='alarmminutes'>Alarm Minutes:</label> 
<select id='alarmminuteselect' onchange = " SendAlarmMinute()" name='alarmminute' >Select Minutes:</select>
<script>
     addaM =document.getElementById('alarmminuteselect');
     for (var i= 0;i<60;i++ )
     {
      mOption =document.createElement('option');
      mOption.text= (i);
      mOption.value = i ;
      addaM.add(mOption);
     }
     document.get
     function SendAlarmMinute(){ClientToServer("alarmminute=" + document.getElementById("alarmminuteselect").value);}

</script>
</fieldset>


<fieldset><legend>WiFi Network Settings:</legend>
<label for "networks" >SSIDs found:</label>
<select id='networkslist' onChange="SendNetworksName()"></select>
<br>
<label for="ssid"> SSID: </label>
<input type = "text" id='ssid' onchange= 'sendssid()'>
<br>
<label for="password"> Password:</label>
<input type = "password" id="password" onchange= "sendpassword()">
<br>
<label for="ipaddress"> IP Address: </label>
<input type = "text" id="ipaddress" onchange= "sendipaddress()">
<br>
<label for="ipgw"> IP Gateway: </label>
<input type = "text" id="ipgw" onchange= "sendipgw()">

<script>
    function SendNetworksName(){ClientToServer("ssidnum=" + document.getElementById("networkslist").value);}
    function sendssid(){ClientToServer("ssid=" + document.getElementById("ssid").value);}
    function sendpassword(){ClientToServer("password=" + document.getElementById("password").value);}
    function sendipaddress(){ClientToServer("ipaddress=" + document.getElementById("ipaddress").value);}
    function sendipgw(){ClientToServer("ipgw=" + document.getElementById("ipgw").value);}
</script>

</fieldset>

<!--START OF CLOCK TEST-->
<script>
var clockcanvas = document.getElementById("clockcanvas");
var ctxc = clockcanvas.getContext("2d");
var radius = clockcanvas.height / 2;
ctxc.translate(radius, radius);
radius = radius * 0.90
setInterval(drawClock, 1000);

function drawClock() 
{
  drawFace(ctxc, radius);
  drawNumbers(ctxc, radius);
  drawTime(ctxc, radius);
}

function drawFace(ctxc, radius) 
{
  var grad;
  ctxc.beginPath();
  ctxc.arc(0, 0, radius, 0, 2*Math.PI);
  ctxc.fillStyle = 'white';
  ctxc.fill();
  grad = ctxc.createRadialGradient(0,0,radius*0.95, 0,0,radius*1.05);
  grad.addColorStop(0, '#333');
  grad.addColorStop(0.5, 'white');
  grad.addColorStop(1, '#333');
  ctxc.strokeStyle = grad;
  ctxc.lineWidth = radius*0.1;
  ctxc.stroke();
  ctxc.beginPath();
  ctxc.arc(0, 0, radius*0.1, 0, 2*Math.PI);
  ctxc.fillStyle = '#333';
  ctxc.fill();
}

function drawNumbers(ctxc, radius) 
{
  var ang;
  var num;
  ctxc.font = radius*0.28 + "px arial";
  ctxc.textBaseline="middle";
  ctxc.textAlign="center";
  for(num = 1; num < 13; num++)
  {
    ang = num * Math.PI / 6;
    ctxc.rotate(ang);
    ctxc.translate(0, -radius*0.80);
    ctxc.rotate(-ang);
    ctxc.fillText(num.toString(), 0, 0);
    ctxc.rotate(ang);
    ctxc.translate(0, radius*0.80);
    ctxc.rotate(-ang);
  }
}

function drawTime(ctxc, radius)
{
    var now = new Date();
    var hour = now.getHours();
    var minute = now.getMinutes();
    var second = now.getSeconds();
    //hour
    hour=hour%12;
    hour=(hour*Math.PI/6)+
    (minute*Math.PI/(6*60))+
    (second*Math.PI/(360*60));
    drawHand(ctxc, hour, radius*0.5, radius*0.07);
    //minute
    minute=(minute*Math.PI/30)+(second*Math.PI/(30*60));
    drawHand(ctxc, minute, radius*0.8, radius*0.07);
    // second
    second=(second*Math.PI/30);
    drawHand(ctxc, second, radius*0.9, radius*0.02);
}

function drawHand(ctxc, pos, length, width) 
{
    ctxc.beginPath();
    ctxc.lineWidth = width;
    ctxc.lineCap = "round";
    ctxc.moveTo(0,0);
    ctxc.rotate(pos);
    ctxc.lineTo(0, -length);
    ctxc.stroke();
    ctxc.rotate(-pos);
}
</script>

<!-- END OF CLOCK TEST-->

<script>
var connection =
new WebSocket('ws://'+location.hostname+':81/', ['arduino']);
</script>
<script>
function ClientToServer(out) 
{
  connection.send(out +":");
   if (out =="back")
  {
     location.reload();
  }
}
connection.onmessage = function (state) 
{
    var str=state.data.split("~");
        var htmlMode = str[0];
        if (htmlMode == "Settings View" && str[1] =="1")
    {
        document.getElementById("pagetitle").innerHTML = str[2];
        document.getElementById("message").innerHTML = str[3];
        document.getElementById("alarmsetting").innerHTML = str[5];
        document.getElementById("timezonelabel").innerHTML = (str[6]/10) + " UTC";
        document.getElementById("ssid").value = str[7];
        document.getElementById("password").value = str[8];
        document.getElementById("ipaddress").value = str[9];
        document.getElementById("ipgw").value = str[10];
         document.getElementById("alarmonoff").innerHTML = str[11];
        document.getElementById("timezoneselect").value = str[6];
        document.getElementById("alarmhourselect").value = str[12];
        document.getElementById("alarmminuteselect").value = str[13];

         
          
              <!--RE-DO THE NETWORKS LIST-->
              var nL  =document.getElementById('networkslist');
              var i, L = nL.options.length - 1;
              for(i = L; i >= 0; i--) 
                {
                  nL.remove(i);
                }
              for (var i= 0;i<40;i++)
                {
                  if (str[i+20] != "")
                  {
                    iOption =document.createElement('option');
                    iOption.text =   str[i+20];
                    iOption.value = i;
                    nL.add(iOption);
                  }
                }

   }
  }
  
</script>
</body>
</html>
)====";
