/*
  Pixel 8 * 8 Colour LED  Panel
  Web Socket Ver 5 OTA
  P Webb 2024
  Arduino 1.8.19
  ESP32 Ver 2.0.6 ESP32 Dev Module
  if ESP32-S2 use ESP32-S2 Dev Module Board -Problems with sPIFFS
  Changed coding to SPIFF from EEPROM
  Added Import to Design Screen
  Revised sreen button layouts
  Added versionNum to settings page open
  Added handleWebSocket function to peridically handle Web Socket events
  Changed packets to full and part to avoid text field continual update
  Changed to Web Socket
  Added alarmRun variable to indicate alarm has been triggerd cf alarm On/alarm Off
  Added simple 1 screen Clock.  Minutes around outside, Hours in Middle
  Added ESP 32 Re-boot in settings
  Added Pin D12 for speaker / beep function with modular amplifier
  Added Alarm Function to Flash Time of Day Clock Display
  Added Gesture Module
  Changed Design Icons into one array only, loaded from EEPROM or SPIFF when necessary using designIndex
  Was pixDesign[0][64] that is pixDesign[designIndex][64]
  now pixDesignShort[64] given to pixTemp[64] for loading and display
  ESP32 SPIFF Only + EEPROM.  I2CEEPROM commented.
  Added Copy Colour in Design View
  Addedd EEPROM memory 25 and 26 to check if data exists
*/

#include <WiFi.h>
#include <WebSocketsServer.h>//https://github.com/Links2004/arduinoWebSockets
#include <WebServer.h>//https://github.com/espressif/arduino-esp32
#include <TimeLib.h>//https://github.com/PaulStoffregen/Time/tree/master
#include <WiFiUdp.h>
#include <Adafruit_NeoPixel.h>//https://github.com/adafruit/Adafruit_NeoPixel
#include <EEPROM.h>
#include <Wire.h>
#include "paj7620.h"  //https://www.arduinolibraries.info/libraries/gesture-paj7620
//Then click on the Downloads Gesture_PAJ7620-1.0.0.zip or directly with next link
//https://downloads.arduino.cc/libraries/github.com/Seeed-Studio/Gesture_PAJ7620-1.0.0.zip
//Note my paj7620 module would not work with the GroveGesture Library from Seeed-Studio
//GitHub depository
#include <ESPmDNS.h>
#include <ArduinoOTA.h>
#include <SPIFFS.h>//for ESP32
//********** Web Pages
#include "htmlMain.h" //Main web page
#include "htmlDesign.h" //Design web page
#include "htmlCoding.h" //Coding web page
#include "htmlSettings.h" //Settings web page
#include "htmlScreen.h" //Screen web page
#include "htmlGame.h" //Game web page

#define eeprom 0x50 //defines the base address of the EEPROM

String versionNum = "WebSocket Ver 5 OTA 12/11/2024";

//WiFi Credentials
//The WiFi credentials are fixed.  If DHCP is used, then the IP address will change making it harder to
//find the Pixel Controller.  Fixing the IP solves that problem.
//The Pixel Controller is accessed only from your local WiFi network.
//To allow remote access requires port forwarding to be set in your router and
//also may require Dynamic DNS to keep track of your Internet connection IP address.
//The following variables are string values here but are converted to char and IP addresses later
//in WiFi.begin(ssid,password) and WiFi.config(ipAddress, ipGateWay,IP SNM, IP DNS)
//Note DNS is the same as Gateway IP Address

//The next 5 lines must be modified to suit your network connection or changed in Network Page setup
String wifiSSID = "SSID here";//Enter your WiFi SSID
String wifiPassword = "Password here";//Enter your WiFi Password
String wifiAdd = "10.0.0.78";//Enter the Pixel Controller IP Address required.
//in the dot separated IP notation indicated
String wifiGW = "10.0.0.138";//Enter Router GateWay IP Address.
String wifiSNM = "255.255.255.0";//Enter Router Sub Net Mask.Usually 255.255.255.0

//Other WiFi Variables
unsigned int wifiSSIDIndex = 0;
const int wifiListMax = 50;
String wifiSSIDList[wifiListMax];//50 should be enough
String wifiRSSIList[wifiListMax];//50 should be enough
int       rssiLevel = -200;
const int rssiAll = -200;
const int rssiMedium = -85;
const int rssiStrong = -50;
/*
    Notice: When you want to recognize the Forward/Backward gestures, your gestures' reaction time must less than GES_ENTRY_TIME(0.8s).
    You also can adjust the reaction time according to the actual circumstance.
*/
#define GES_REACTION_TIME    200       // You can adjust the reaction time according to the actual circumstance.
#define GES_ENTRY_TIME      100//200       // When you want to recognize the Forward/Backward gestures, your gestures' reaction time must less than GES_ENTRY_TIME(0.8s). 
#define GES_QUIT_TIME    200// 1000
String gest = "";
byte gestButtonNum = 1;
//paj7620 Gesture;


//Coding Variables
String codingText[15];//Coding files
unsigned int codingIndex = 0;
unsigned int designIndex = 99;//show a tick first up when wifi connected
String codingError = "";

//Design Variables
String designName[100];
unsigned int pixClipboard [64];

//Various Variables
unsigned int buttonNum = 1;// 0 to 19
String oldPixelMode = "Nothing" ; // previous pixelMode
bool refresh = false;//used to refresh icon when brightness changes
bool updateClientData = true;//false for limited data package
bool updateIconData = false; //true for main page icon update

//Server Settings
const unsigned int serverPort = 85;
WebServer server(85);
WebSocketsServer webSocket = WebSocketsServer(81);
int prevMillis;

bool holdResponse = false;
String espMode = "Client";  //or "AP" or "Client"

// NTP Servers - Time Variables:
static const char ntpServerName[] = "us.pool.ntp.org";
int timeZone = 105;  // 10.5 hours ahead of GMT
WiFiUDP Udp;
unsigned int localPort = 8888;  // local port to listen for UDP packets
time_t getNtpTime();
time_t prevDisplay = 0; // when the digital clock was displayed
const int NTP_PACKET_SIZE = 48; // NTP time is in the first 48 bytes of message
byte packetBuffer[NTP_PACKET_SIZE]; //buffer to hold incoming & outgoing packets

//Clock - Alarm
bool digitalClock = true; //or analog Clock
int Hour = 0;
int Hour24 = 0;
int Min = 0;
int alarmHour = 0;
int alarmMinute = 0;
int alarmDuration = 60;//Second
int hourMode = 12;
bool alarmOn = false;//alarm Is Off
String alarmRun = "Stop";//Stop, Pause, or Run
String timeStr = "";

//Serial Input
String inputString = "";         // a String to hold incoming data
bool stringComplete = false;  // whether the string is complete


//HTML settings
bool commandSuccess = false; //Send a /Done to prevent web page re-fresh and stop commands repeating
unsigned int htmlRefresh = 10; //The HTML page automatic refresh rate
String htmlMode = "Main View";
String clientPackage = ""; //choose extent of data sent to client
String message = versionNum;
//Variables
String pixelMode = "Time";
int pixSel = 0; //Currently selected Pixel index in Design Mode
unsigned int brightness = 50;
unsigned int tempBrightness = 100;
String currentScrollText = "";
unsigned int r = 50;
unsigned int g = 50;
unsigned int b = 50;
bool rRandom = false;
bool gRandom = false;
bool bRandom = false;
bool fade = false;
bool mirror = false;
unsigned int scrollDelay = 350;
unsigned int pixelDelay = 300; // Time (in milliseconds) to pause between pixels
unsigned int  fadeDelay = 100; // rate of fading
String clockColour = "rgb(255,255,255)";
String buttonBackColour = "rgb(5,24,41)";//dark blue
String buttonTextColour = "rgb(255,255,255)";//white
String screenBackColour = "rgb(162,172,180)";//grey
String pixelColour = "FF0000";
int pixelColour332 = 255;//  the 332 rgb colour
int pixelColourDrop332 = 255;//the design pixel colour
bool showColour = false; //sets pixelColourDrop332 = pixelcolour332
String dropDownButtonTextColour = buttonTextColour;//
String buttonLabel[15]; // array for programmable buttons
String memType = "S"; // or "I"  SPIFF or Internal (EEEPROM)Note Basic settings are always stored to ESP32 EEPROM
String scrollArray[15];
unsigned int schemeIndex = 1;

//Game Variables
bool multiPlayer = false;
byte player = 0;//webSocket of player
byte player0BatPix = 31;
byte espBatPix = 24;
byte ballPix = 38;
String ballDir = "Right";
String ballUpDn = "";
String controlDirection = ""; //Up Down Left Right
byte defenderLocation = 59;//starting pixel for Invaders Defender
byte invaders[8][8] = {0};
byte lives = 5;
byte lifeCounter = 0;
byte level = 0; //games level
byte wave = 0;//game wave
unsigned int score = 0; //game score
unsigned int gameSpeed = 2000; //milliseconds delay before advance
bool playGame = false;

//Colour Schemes
//ButtonBackcolour, ButtonTextColour, ScreenBackColour
const String schemes[36] =
{ "e21937", "ffd200", "32619c", "Adelaide",
  "a30046", "ffffff", "fdbe57", "Brisbane",
  "051829", "FFFFFF", "A2ACB4", "Carlton",
  "2A0D54", "FFFFFF", "A2ACB4",  "Freemantle",
  "372B00", "FFFFFF", "F6B60D", "Hawthorn",
  "000000", "ffffff", "008aab", "Port",
  "ffffff", "000000", "ed171f", "Sydney",
  "077B8A", "FFFFFF", "A2D5C6", "Custom 1",
  "12A4D9", "FFFFFF", "ADCBE3", "Custom 2"
};
//custom 1 Index 28 to 31
//custom 2 Index 32 to 35

//Pixel Variables
// How many NeoPixels are attached to the Arduino?
#define numberOfPixels 64
// Which pin on the Arduino is connected to the Pixel?
#define pixelPin   13
Adafruit_NeoPixel pixels(numberOfPixels, pixelPin, NEO_GRB + NEO_KHZ800);
//Tones
#define tonePin 12

//Icon Variables
unsigned int selectedScrollIndex = 0; // The Main View Selected Sroll Index
unsigned int selectedIcon = 0; //Icon selected from Main view Icon/design drop down list.
const String icons[175] = {
  "D0", "D1",  "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "D10",
  "D11",  "D12", "D13", "D14", "D15", "D16", "D17", "D18", "D19", "D20",
  "D21",  "D22", "D23", "D24", "D25", "D26", "D27", "D28", "D29", "D30",
  "D31",  "D32", "D33", "D34", "D35", "D36", "D37", "D38", "D39", "D40",
  "D41",  "D42", "D43", "D44", "D45", "D46", "D47", "D48", "D49", "D50",
  "D51",  "D52", "D53", "D54", "D55", "D56", "D57", "D58", "D59", "D60",
  "D61",  "D62", "D63", "D64", "D65", "D66", "D67", "D68", "D69", "D70",
  "D71",  "D72", "D73", "D74", "D75", "D76", "D77", "D78", "D79", "D80",
  "D81",  "D82", "D83", "D84", "D85", "D86", "D87", "D88", "D89", "D90",
  "D91",  "D92", "D93", "D94", "D95", "D96", "D97", "D98", "D99",
  "Alternate", "Boat", "Flag", "Hour Glass", "House",  "Pixels",  "Spiral", "", "", "?",
  "A", "B", "C", "D", "E", "F", "G", "H", "I", "J",
  "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T",
  "U", "V", "W", "X", "Y", "Z", "0", "1", "2", "3",
  "4", "5", "6", "7", "8", "9", ".", ":", "a", "b",
  "c", "d", "e", "f", "g", "h", "i", "j", "k", "l",
  "m", "n", "o", "p", "q", "r", "s", "t", "u", "v",
  "w", "x", "y", "z", ""
};
//Temporary letter array used in scroll
unsigned int pixTemp[64];

const unsigned int pixQM[11] = {2, 3, 4, 9, 13, 17, 21, 28, 35, 43, 59}; //?
const unsigned int pixA[34] = {3, 4, 10, 11, 12, 13, 17, 18, 21, 22, 25, 26, 29, 30, 33, 34, 35, 36, 37, 38, 41, 42, 43, 44, 45, 46, 49, 50, 53, 54, 57, 58, 61, 62,}; //A
const unsigned int pixa[14] = {26, 27, 29, 33, 36, 37, 41, 45, 49, 52, 53, 58, 59, 61,}; //a
const unsigned int pixB[41] = { 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 14, 17, 18, 21, 22, 25, 26, 27, 28, 29, 33, 34, 35, 36, 37, 38, 41, 42, 45, 46, 49, 50, 51, 52, 53, 54, 57, 58, 59, 60, 61,}; //B
const unsigned int pixb[15] = { 9, 17, 25, 27, 28, 33, 34, 37, 41, 45, 49, 53, 58, 59, 60,}; //b
const unsigned int pixC[32] = { 2, 3, 4, 5, 9, 10, 11, 12, 13, 14, 17, 18, 21, 22, 25, 26, 33, 34, 41, 42, 45, 46, 49, 50, 51, 52, 53, 54, 58, 59, 60, 61,}; //C
const unsigned int pixc[9] = { 26, 27, 28, 33, 41, 49, 58, 59, 60,}; //c
const unsigned int pixD[38] = { 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 14, 17, 18, 21, 22, 25, 26, 29, 30, 33, 34, 37, 38, 41, 42, 45, 46, 49, 50, 51, 52, 53, 54, 57, 58, 59, 60, 61}; //D
const unsigned int pixd[16] = { 13, 21, 26, 27, 29, 33, 36, 37,  41, 45, 49, 52, 53, 58, 59, 61,}; //d
const unsigned int pixE[34] = { 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 17, 18, 25, 26, 27, 28, 29, 33, 34, 35, 36, 37, 41, 42, 49, 50, 51, 52, 53, 57, 58, 59, 60, 61,}; //E
const unsigned int pixe[12] = { 26, 27, 33, 36, 41, 42, 43, 44, 49, 58, 59, 60,}; //e
const unsigned int pixF[32] = { 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 17, 18, 25, 26, 27, 28, 29, 30, 33, 34, 35, 36, 37, 38, 41, 42, 49, 50, 57, 58}; //F
const unsigned int pixf[14] = { 10, 11, 12, 18, 25, 26, 27, 28, 34, 42, 50, 57, 58, 59,}; //f
const unsigned int pixG[40] = { 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 17, 18, 25, 26, 28, 29, 30, 33, 34, 36, 37, 38, 41, 42, 45, 46, 49, 50, 51, 52, 53, 54, 57, 58, 59, 60, 61, 62}; //G
const unsigned int pixg[13] = { 18, 19, 25, 28, 33, 36, 42, 43, 44, 52, 57, 58, 59,}; //g
const unsigned int pixH[ 36] = { 1, 2, 5, 6,  9, 10, 13, 14,  17, 18, 21, 22, 25, 26, 27, 28, 29, 30, 33, 34, 35, 36, 37, 38, 41, 42, 45, 46, 49, 50, 53, 54, 57, 58, 61, 62,}; //H
const unsigned int pixh[ 12] =
{ 17,
  25,
  33,   35, 36,
  41, 42,     45,
  49,         53,
  57,         61,
};
const unsigned int pixI[32] = { 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 19, 20, 27, 28, 35, 36, 43, 44, 49, 50, 51, 52, 53, 54, 57, 58, 59, 60, 61, 62,}; //I
const unsigned int pixi[7] = { 19, 35, 43, 51, 58, 59, 60,}; //i
const unsigned int pixJ[28] = { 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 19, 20, 27, 28, 35, 36, 41, 42, 43, 44, 49, 50, 51, 52, 58, 59,}; //J
const unsigned int pixj[9] = { 18, 19, 20, 27, 35, 43, 51, 57, 58,}; //j
const unsigned int pixK[33] = { 1, 2, 5, 6, 9, 10, 12, 13, 17, 18, 19, 20, 25, 26, 27, 28, 33, 34, 35, 36, 37, 41, 42, 44, 45, 49, 50, 53, 54, 57, 58, 61, 62,};
const unsigned int pixk[12] = { 17, 25, 28, 33, 35, 41, 42, 43, 49, 51, 57, 60,};
const unsigned int pixL[24] = { 1, 2, 9, 10, 17, 18, 25, 26, 33, 34, 41, 42, 49, 50, 51, 52, 53, 54, 57, 58, 59, 60, 61, 62,};
const unsigned int pixl[9] = { 17, 25, 33, 41, 49, 57, 58, 59, 60,};
const unsigned int pixM[34] = { 1, 6, 9, 10, 13, 14, 17, 18, 19, 20, 21, 22, 25, 26, 27, 28, 29, 30, 33, 34, 37, 38, 41, 42, 45, 46, 49, 50, 53, 54, 57, 58, 61, 62,};
const unsigned int pixm[13] = { 25, 29, 33, 34, 36, 37, 41, 43, 45, 49, 53, 57, 61,};
const unsigned int pixN[37] = { 1, 2, 5, 6, 9, 10, 13, 14, 17, 18, 19, 21, 22, 25, 26, 27, 28, 29, 30, 33, 34, 36, 37, 38, 41, 42, 44, 45, 46, 49, 50, 53, 54, 57, 58, 61, 62,};
const unsigned int pixn[14] = { 25, 29, 33, 34, 37, 41, 43, 45, 49, 51, 53, 57, 60, 61,};
const unsigned int pixO[36] = { 2, 3, 4, 5, 9, 10, 11, 12, 13, 14, 17, 18, 21, 22, 25, 26, 29, 30, 33, 34, 37, 38, 41, 42, 45, 46, 49, 50, 51, 52, 53, 54, 58, 59, 60, 61,};
const unsigned int pixo[12] = { 26, 27, 28, 33, 37, 41, 45, 49, 53, 58, 59, 60,};
const unsigned int pixP[32] = { 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 14, 17, 18, 21, 22, 25, 26, 27, 28, 29, 30, 33, 34, 35, 36, 37, 41, 42, 49, 50, 57, 58,};
const unsigned int pixp[12] = { 17, 18, 19, 25, 28, 33, 36, 41, 42, 43, 49, 57,};
const unsigned int pixQ[36] = { 2, 3, 4, 5, 9, 10, 11, 12, 13, 14, 17, 18, 21, 22, 25, 26, 29, 30, 33, 34, 37, 38, 41, 42, 44, 45, 49, 50, 51, 52, 53, 54, 58, 59, 60, 62,};
const unsigned int pixq[12] = { 18, 19, 25, 28, 33, 36, 42, 43, 44, 52, 53, 60,};
const unsigned int pixR[38] = { 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 14, 17, 18, 21, 22, 25, 26, 27, 28, 29, 30, 33, 34, 35, 36, 37, 41, 42, 44, 45, 49, 50, 53, 54, 57, 58, 61, 62,};
const unsigned int pixr[7] = { 26, 27, 33, 36, 41, 49, 57,};
const unsigned int pixS[28] = { 2, 3, 4, 9, 10, 11, 12, 13, 17, 18, 25, 26, 27, 28, 34, 35, 36, 37, 44, 45, 49, 50, 51, 52, 53, 58, 59, 60,};
const unsigned int pixs[11] = { 18, 19, 25, 28, 33, 42, 43, 52, 57, 58, 59,};
const unsigned int pixT[24] = { 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 19, 20, 27, 28, 35, 36, 43, 44, 51, 52, 59, 60,};
const unsigned int pixt[10] = { 18, 25, 26, 27, 28, 34, 42, 50, 58, 59,};
const unsigned int pixU[34] = { 1, 2, 5, 6, 9, 10, 13, 14, 17, 18, 21, 22, 25, 26, 29, 30, 33, 34, 37, 38, 41, 42, 45, 46, 49, 50, 51, 52, 53, 54, 58, 59, 60, 61,};
const unsigned int pixu[10] = { 25, 28, 33, 36, 41, 44, 49, 52, 58, 59,};
const unsigned int pixV[30] = { 1, 2, 5, 6, 9, 10, 13, 14, 17, 18, 21, 22, 25, 26, 29, 30, 33, 34, 37, 38, 42, 43, 44, 45, 50, 51, 52, 53, 59, 60,};
const unsigned int pixv[9] = { 25, 29, 33, 37, 42, 44, 50, 52, 59,};
const unsigned int pixw[11] = { 25, 29, 33, 37, 41, 43, 45, 50, 52, 58, 60,};
const unsigned int pixW[34] = { 1, 2, 5, 6, 9, 10,  13, 14,  17, 18, 21, 22, 25, 26,   29, 30,  33, 34, 35, 36, 37, 38,  41, 42, 43, 44, 45, 46,  49, 50,  53, 54,  57,  62,};
const unsigned int pixX[24] = { 1, 6, 9, 10, 13, 14, 18, 19, 20, 21, 27, 28, 35, 36, 42, 43, 44, 45, 49, 50, 53, 54, 57, 62,};
const unsigned int pixx[9] = { 25, 29, 34, 36, 43, 50, 52, 57, 61,};
const unsigned int pixY[26] = { 1, 2, 5, 6,  9, 10, 13, 14,  17, 18, 21, 22,  26, 27, 28, 29,  34, 35, 36, 37,  43, 44,  51, 52,  59, 60,};
const unsigned int pixy[8] = {  25, 29, 34, 36, 43, 51, 57, 58,};
const unsigned int pixZ[32] = { 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 21, 22, 28, 29, 35, 36, 42, 43, 49, 50, 51, 52, 53, 54, 57, 58, 59, 60, 61, 62,};
const unsigned int pixz[13] = {  25, 26, 27, 28, 29,  36,  43, 50, 57, 58, 59, 60, 61,};
const unsigned int pixColon[2] = {27, 43};
const unsigned int pixDot[1] = {59};
const unsigned int pixHouse[40] = { 3, 4, 10, 11, 12, 13, 17, 18, 19, 20, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 41, 43, 44, 46, 49, 50, 51, 52, 54, 57, 58, 59, 60, 61, 62,};
const unsigned int pixFlag[28] = { 1, 3, 5, 9, 10, 11, 12, 13, 14, 17, 18, 19, 20, 21, 22, 25, 26, 27, 28, 29, 30, 33, 34, 36, 38, 41, 49, 57,};
const unsigned int pixBoat[34] = { 3, 10, 11, 12, 17, 18, 19, 20, 21, 24, 25, 26, 27, 28, 29, 30, 35, 40, 41, 42, 43, 44, 45, 46, 49, 50, 51, 52, 53, 54, 58, 59, 60, 61,};
const unsigned int pixHourGlass[39] = { 0, 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 17, 18, 19, 20, 21, 26, 28, 34, 36, 41, 45, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 60, 61, 62,};
const unsigned int pix0[16] = {  9, 10, 11, 12, 17, 20, 25, 28, 33,  36, 41,   44, 49, 50, 51, 52,};
const unsigned int pix1[9] = {  10,  17, 18, 26, 34, 42, 49, 50, 51,};
const unsigned int pix2[15] = { 9, 10, 11, 12, 20, 25, 26, 27, 28, 33, 41, 49, 50, 51, 52,};
const unsigned int pix3[15] = {  9, 10, 11, 12, 20, 25, 26, 27, 28, 36, 44, 49, 50, 51, 52,};
const unsigned int pix4[10] = { 11,  18, 19,  25, 26, 27, 28,  35,  43,  51,};
const unsigned int pix5[15] = {  9, 10, 11, 12,  17,  25, 26, 27, 28,  36,  44,  49, 50, 51, 52,};
const unsigned int pix6[17] = {  9, 10, 11, 12,  17,  25, 26, 27, 28,  33,   36,  41,  44,  49, 50, 51, 52,};
const unsigned int pix7[9] = {  9, 10, 11, 12,  20,  27,  34,  41,  49,};
const unsigned int pix8[18] = {  9, 10, 11, 12, 17,  20, 25, 26, 27, 28, 33, 36,  41, 44, 49, 50, 51, 52};
const unsigned int pix9[16] = { 9, 10, 11, 12, 17,  20, 25, 26, 27, 28, 36, 44, 49, 50, 51, 52};

void setup()
{
  Serial.begin(115200);
  Serial.println (" ");
  Serial.println ("***Booting Pixel Controller***");
  SPIFFS.begin();
  Serial.println ("******LISTING SPIFFS FILES FOUND ****");
  getSPIFFSFiles("List");//Reads the Directory Shows the files if Serial.print included
  Serial.println ("******END SPIFFS FILES LISTING ****");
  EEPROM.begin(2560);
  if (EEPROM.read(25) == 25 and EEPROM.read(26) == 26)//Data Exists for
  {
    Serial.println ("EEPROM Locations 25 & 26 Match. Default Data Exists");
    readDefaultData();//Comment this line out to restore default settings . Re-instate and reflash after.
  }
  else
  {
    saveDefaultData();//Save Default Data
    readDefaultData();
  }

  Wire.begin(); //creates a Wire object
  //**************EEPROMI2C Test
  i2cScanner();
  //*****paj7620

  uint8_t error = 0;
  error = paj7620Init();      // initialize Paj7620 registers
  if (error)
  {
    Serial.print("INIT ERROR,CODE:");
    Serial.println(error);
  } else
  {
    Serial.println("INIT OK");
  }
  error = paj7620WriteReg(0x65, 0x12);


  pinMode (pixelPin, OUTPUT);
  pinMode (tonePin, OUTPUT);
  pixels.begin(); // INITIALIZE object
  hourGlass(2, 25, 25, 25);
  Wire.begin(); //creates a Wire object
  scanWiFi();

  WiFi.config(str2IP(wifiAdd), str2IP(wifiGW), str2IP(wifiSNM), str2IP(wifiGW));

  //wifiSSID is a string but must be a char for the WiFibegin(); function
  char ssid[wifiSSID.length() + 1];
  memset(ssid, 0, wifiSSID.length() + 1);
  for (unsigned int i = 0; i < wifiSSID.length(); i++)
  {
    ssid[i] = wifiSSID.charAt(i);
  }
  //wifiPassword is a string but must be a char for the WiFibegin(); function
  //wifiPassword="";//Testing Purposes
  char password[wifiPassword.length() + 1];
  memset(password, 0, wifiPassword.length() + 1);
  for (unsigned int i = 0; i < wifiPassword.length(); i++)
  {
    password[i] = wifiPassword.charAt(i);
  }

  WiFi.begin(ssid, password);
  espMode = "Client";
  Serial.println("********Attempting WiFi Connection ******");
  Serial.println ("******* Network Credentials are: *******");
  Serial.print("SSID:" );
  Serial.println (ssid);
  Serial.print("Password:");
  Serial.println (password);
  Serial.print("IP Address:");
  Serial.println (str2IP(wifiAdd));
  Serial.print("GateWay:");
  Serial.println (str2IP(wifiGW));
  Serial.print("SNM:");
  Serial.println (str2IP(wifiSNM));
  Serial.print("DNS:");
  Serial.println (str2IP(wifiGW));//DNS same as GW

  Serial.println("*************************");
  //check wi-fi is connected to wi-fi network
  unsigned int counter = 0; //wifi connection counter
  pixels.clear(); // Set all pixel colors to 'off'
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    hourGlass(1, 25, 25, 25);
    counter ++;
    if (counter > 30) // Failed to connect to WiFi - go into AP mode
    {
      espMode = "AP";
      setupAPMode();
      break;
    }
  }
  if (espMode == "Client")
  {
    Serial.println ("WiFi connected");
    Serial.print("IP Address: ");
    Serial.println( WiFi.localIP());
    Serial.println ("Port: " + String (serverPort));
  }
  Serial.println ("ESP Mode is " + espMode);

  oldPixelMode = pixelMode; //To stop changing mode at first loop
  if (espMode == "Client")
  {
    flashLed(5);
    Udp.begin(localPort);
    setSyncProvider(getNtpTime);
    setSyncInterval(120);
  }
  pixels.clear();
  pixels.show();

  // start webSocket server
  webSocket.begin();
  webSocket.onEvent(webSocketEvent);
  Serial.println("Web Socket started.");

  server.on("/", handlePage);
  server.begin();
  Serial.println("HTTP server started");
  pixelMode = "Time";

  ArduinoOTA
  .onStart([]() {
    String type;
    if (ArduinoOTA.getCommand() == U_FLASH)
      type = "sketch";
    else // U_SPIFFS
      type = "filesystem";

    // NOTE: if updating SPIFFS this would be the place to unmount SPIFFS using SPIFFS.end()
    Serial.println("Start updating " + type);
  })
  .onEnd([]() {
    Serial.println("\nEnd");
  })
  .onProgress([](unsigned int progress, unsigned int total) {
    Serial.printf("Progress: % u % % \r", (progress / (total / 100)));
  })
  .onError([](ota_error_t error) {
    Serial.printf("Error[ % u]: ", error);
    if (error == OTA_AUTH_ERROR) Serial.println("Auth Failed");
    else if (error == OTA_BEGIN_ERROR) Serial.println("Begin Failed");
    else if (error == OTA_CONNECT_ERROR) Serial.println("Connect Failed");
    else if (error == OTA_RECEIVE_ERROR) Serial.println("Receive Failed");
    else if (error == OTA_END_ERROR) Serial.println("End Failed");
  });
  ArduinoOTA.begin();
}
//************ LOOP ***********
void loop()
{
  ArduinoOTA.handle();
  handleWebSocket();
  if (espMode == "AP")
  {
    pixelMode = "Scroll";
    oldPixelMode = pixelMode;
    scrollText("Scroll 192.168.4.1: 85", 50, 50, 50);
    return;
  }
  if (alarmRun != "Stop" and (alarmHour != Hour24 or alarmMinute != Min))//Stop the Alarm
  {
    alarmRun = "Stop";
  }
  if (alarmOn and alarmHour == Hour24 and alarmMinute == Min and alarmRun == "Stop")
  {
    alarmRun = "Run";
    pixelMode = "Time Now";
  }
  if (pixelMode != oldPixelMode)
  {
    //message= "PixelMode was: " + oldPixelMode + " is now: " + pixelMode;// Pixel Mode is changed in accordance with the Web page Buttons pressed.
    message = "PixelMode is now: " + pixelMode; // Pixel Mode is changed in accordance with the Web page Buttons pressed.
    Serial.println (message);
    oldPixelMode = pixelMode;
  }

  if (instr(pixelMode, "Game Pong") > -1 )//Game
  {
    gamePong();
  }
  if (instr(pixelMode, "Game Invaders") > -1 )//Game
  {
    gameInvaders();
  }
  else if (instr(pixelMode, "Ani ") > -1 )//Animation
  {
    animation();
  }
  else if (instr(pixelMode, "Time") > -1 )//show the time
  {
    if (digitalClock == true)
    {
      showTime(r, g, b);
    }
    else
    {
      showTimeAnalog(r, g, b);
    }
  }
  else if (instr(pixelMode, "Scroll") > -1 )
  {
    scrollText(pixelMode, r, g, b);
  }
  else if (instr(pixelMode, "Spell") > -1 )
  {
    spell(pixelMode, r, g, b);
  }
  else if (instr(pixelMode, "Letter") > -1 )
  {
    letter(pixelMode, r, g, b);
  }
  else if (pixelMode == "Icon Pixels")
  {
    countPixels();
  }
  else if (pixelMode == "Icon Alternate")
  {
    alternate();
  }
  else if (pixelMode == "Icon Flag")
  {
    pixelMode = "Letter Flag";
  }
  else if (pixelMode == "Icon Boat")
  {
    pixelMode = "Letter Boat";
  }
  else if (pixelMode == "Icon House")
  {
    pixelMode = "Letter House";
  }
  else if (pixelMode == "Icon Hour Glass")
  {
    pixelMode = "Letter Hour Glass";
  }
  else if (pixelMode == "Icon Spiral")
  {
    spiral();
  }
  else if (instr(pixelMode, "Icon") > -1 and refresh == true)//( pixelMode != oldPixelMode or refresh))
  {
    Serial.println("In Loop.  PixelMode = : " + pixelMode);
    refresh = false;
    designIndex = pixelMode.substring(6).toInt(); //was -1
    Serial.println ("designIndex " + String (designIndex) + "  readDesignIndex() in Loop()");
    readDesignIndex();
    icon();
  }
  else
  {
  }
  handleControls(); //check gestures and other scontrols
  checkDataImport();  //Check if Serial data received for Import:  Future Addition

}
