void handleRequest(String request)
{
  //This is the String received from the Client
  //Only Fires when an event occurs in one of the web pages Main, Coding etc

  if (request == "0")
  {
    //No Data from Client
    return;
    // updateClientData = false;//limited data packet
  }
  //updateClientData = true; //Data changed. Client processes full data packet Moved to end of function
  //************GAME**************

  if (request == "upbutton")
  {
    controlDirection = "Up";
    message = "Up";
  }
  else if (request == "downbutton")
  {
    controlDirection = "Down";
    message = "Down";
  }
  if (request == "leftbutton")
  {
    controlDirection = "Left";
    message = "Left";
  }
  else if (request == "rightbutton")
  {
    controlDirection = "Right";
    message = "Right";
  }
  else if (request == "firebutton")
  {
    controlDirection = "Fire";
    message = "Fire";
  }
  else if (request == "fireleftbutton")
  {
    controlDirection = "FireLeft";
  }
  else if (request == "firerightbutton")
  {
    controlDirection = "FireRight";
  }
  else if (request == "multiplayer")
  {
    multiPlayer = true;
  }
  else if (request == "singeplayer")
  {
    multiPlayer = false;
  }

  else if (instr(request, "startgame") > -1)
  {
    if (pixelMode == "Game Pong")
    {
      controlDirection = "Left";
      ballUpDn = "";
    }
    lifeCounter = lives;
    score = 0;
    level = 0;
    wave = 0;
    playGame = true;
    message = "Start Game";
    pixels.clear(); // Set all pixel colors to 'off'
    pixels.show();
  }
  else if (request.indexOf("gamespeed") > -1)
  {
    int tempSpeed = request.substring(10).toInt();
    message = "Game Speed = " + request;
    //Serial.println (String(tempSpeed));
    gameSpeed = map(tempSpeed, 10, 100, 4000, 250);
    //Serial.println ("Game Speed =" + String (gameSpeed));
  }
  //****************CHANGE VIEW *****************
  else if (request == "design")
  {
    htmlMode = "Design View";
    message = htmlMode;
    pixelMode = "Dummy";
    readDesignIndex(); //gets the pixel array for the designIndex
  }
  else if (request == "coding")
  {
    htmlMode = "Coding View";
    message = htmlMode;
  }

  else if (request == "back")
  {
    htmlMode = "Main View";
    //server.send(200, "text/html", MAIN_page);
    pixelMode = "Time";
    String dummy = hexToRgb( clockColour);//if HEX converts and rempaps rgb to no more than 50
    //If already rgb then hexToRgb simply maps rgb to no more than 50 each.
    mapRgb();
    playGame = false;
    mirror = false;//Turn mirror off reduce traffic
    message = htmlMode;
  }
  else if (request == "settings")
  {
    htmlMode = "Settings View";
    message = htmlMode;
  }
  else if (request == "screen")
  {
    htmlMode = "Screen View";
    message = htmlMode;
  }
  else if (request == "game")
  {
    htmlMode = "Game View";
    message = htmlMode;
    //pixelMode = "Game Pong";
  }

  //****************MAIN VIEW *****************
  else if (request == "clock")//Clock
  {
    brightness = 25;
    pixelMode = "Time";
    // message = "Time is " + timeStr ;
    message = "Clock Display.";
    updateClientData = true;
    updateIconData = true; //refreshes the icon grid on main page
  }
  //buttons 0 to 14 but0 to but14
  else if (instr(request, "mbut") > -1) //main screen button
  {
    Serial.println ("***********HANDLING BUTTON 0 to 14");
    int btnNum = request.substring(4).toInt();//0 to 14
    if (btnNum >= 0 and btnNum < 15)
    {
      message = "Selected Button is: " + buttonLabel[btnNum];
      buttonNum = btnNum;//0 to 14 was 1 to 15
      codingIndex = btnNum;//0 to 14
      Serial.println ("In handleControls button processing. Button is : " +  String (buttonNum));
      analyseCoding(codingText[btnNum], "Pixels");//That is don't save the Code
      refresh = true;
      updateIconData = true; //refreshes the icon grid on main page
      if (pixelMode == "Game Pong" or pixelMode == "Game Invaders")
      {
        playGame = false;
        htmlMode = "Game View";
      }
    }
  }
  else if (request.indexOf("pixelcolourm=") > -1)
  {
    pixelColour = request.substring(instr (request, "=") + 1);//already rgb
    message = "Pixel Colour = " + pixelColour;
    String dummy = hexToRgb( pixelColour);//if HEX converts and rempaps rgb to no more than 50
    //If already rgb then hexToRgb simply maps rgb to no more than 50 each.
    mapRgb();
    if (pixelMode == "Time")
    {
      clockColour = pixelColour;
      //save clockcolour here ToDo nad read back
    }
  }
  else if (instr(request, "brightness=" ) > -1)
  {
    brightness = request.substring (instr(request, "=") + 1).toInt();
    EEPROM.write(3, brightness);
    message = "Brightness: " + String(brightness) + " % ";
    Serial.println ("Brightness is now: " + String (brightness));
    refresh = true;
  }
  else if (instr(request, "scrolldelay=") > -1)
  {
    scrollDelay =  request.substring (instr(request, "=") + 1).toInt();

    EEPROM.write(5, lowByte(scrollDelay));
    EEPROM.write(6, highByte(scrollDelay));

    EEPROM.commit();
    message = "Scroll Delay: " + String(scrollDelay);
    Serial.println ("Scroll Delay is now: " + String (scrollDelay) + "ms");
  }
  else if (instr(request, "pixeldelay=") > -1)
  {
    pixelDelay =  request.substring (instr(request, "=") + 1).toInt();
    EEPROM.write(7, lowByte(pixelDelay));
    EEPROM.write(8, highByte(pixelDelay));
    EEPROM.commit();
    message = "Pixel Delay: " + String(pixelDelay);
    Serial.println ("Pixel Delay is now: " + String (pixelDelay) + "ms");

  }
  else if (instr(request, "fadedelay=") > -1)
  {
    fadeDelay =  request.substring (instr(request, "=") + 1).toInt();

    EEPROM.write(9, lowByte(fadeDelay));
    EEPROM.write(10, highByte(fadeDelay));
    EEPROM.commit();
    message = "Fade Delay: " + String(fadeDelay);
    Serial.println ("Fade Delay is now: " + String (fadeDelay) + "ms");
  }
  else if (instr(request, "mirror") > -1)
  {
    if (request.indexOf("true") > -1)
    {
      mirror = true;
      message = "Mirror is On.";
    }
    if (request.indexOf("false") > -1)
    {
      mirror = false;
      message = "Mirror is Off.";
    }
  }
  else if (instr(request, "redrandom") > -1)
  {
    if (request.indexOf("true") > -1) {
      rRandom = true;
      message = "Red Random is On.";
    }
    if (request.indexOf("false") > -1) {
      rRandom = false;
      message = "Red Random is Off.";
    }
  }
  else if (instr(request, "greenrandom") > -1)
  {
    if (request.indexOf("true") > -1) {
      gRandom = true;
      message = "Green Random is On.";
    }
    if (request.indexOf("false") > -1) {
      gRandom = false;
      message = "Green Random is Off.";
    }
  }
  else if (instr(request, "bluerandom") > -1)
  {
    if (request.indexOf("true") > -1) {
      bRandom = true;
      message = "Blue Random is On.";
    }
    if (request.indexOf("false") > -1) {
      bRandom = false;
      message = "Blue Random is Off.";
    }
  }
  else if (instr(request, "fadetrue") > -1 or instr(request, "fadefalse") > -1 )
  {
    if (request.indexOf("true") > -1) {
      fade = true;
      message += "Fade is On.";
    }
    if (request.indexOf("false") > -1) {
      fade = false;
      message += "Fade is Off.";
    }
  }
  else if (instr(request, "scrolltext=") > -1)
  {
    selectedScrollIndex = request.substring (instr(request, "=") + 1).toInt();
    pixelMode = "Scroll " + scrollArray[selectedScrollIndex] ;
    message = pixelMode;
  }

  else if (instr(request, "stext=") > -1)
  {
    request = request.substring (instr(request, "=") + 1);
    //request.toUpperCase();
    pixelMode = "Scroll " +  request;
    message = pixelMode;
    bool foundScroll = false;
    for (unsigned int i = 0; i < 10; i++)
    {
      if (request == scrollArray[i])
      {
        foundScroll = true;
      }
    }
    if (!foundScroll)
    {
      for (unsigned int i = 9; i > 0 ; i--) // Shuffle scroll Array text down
      {
        scrollArray[i] = scrollArray[i - 1];
      }
      scrollArray[0] = request;//Add ltest to first of list
      //Save array to EEPROM
      for (unsigned int i = 0; i < 10; i++)
      {
        writeEEPROMString(scrollArray[i], 100 + (i * 50)); //0 == mem 100, 1 = mem 150, 2 == mem 200 etc 9 = mem 550
      }
    }

  }
  else if (instr(request, "iconitem=") > -1)//Choose item from Icon List.
  {
    refresh = true;
    rRandom = false;
    bRandom = false;
    gRandom = false;
    r = 50;
    g = 50;
    b = 50;
    //iconItem=
    selectedIcon = request.substring (instr(request, "=") + 1).toInt();
    String iName = icons [selectedIcon];
    message = iName;
    if (selectedIcon < 109)
    {
      pixelMode = ("Icon " + iName);
    }
    else
    {
      pixelMode = ("Letter " + iName );
    }

  }
  else if (request == "clearscrolltext")
  {
    //Clear the scroll list
    for (unsigned int i = 0; i < 10; i++)
    {
      scrollArray[i] = "Spare";
      writeEEPROMString(scrollArray[i], 100 + (i * 50)); //0 == mem 100, 1 = mem 150, 2 == mem 200 etc 9 = mem 550
    }
  }


  //**************** DESIGN VIEW ***************
  else if (instr(request, "designpixel=") > -1)//Set or Reset Design=xx Pixel
  {
    pixSel =  request.substring (instr(request, "=") + 1).toInt();

    //Serial.println ("Selected Pixel Number:" + String(pixSel));
    //Serial.println ("Pixel Colour is:" + String (pixelColour332));
    //if (showColour)
    //{
    //  Serial.println ( "Show Colour " + String (pixTemp[pixSel]));
    pixelColourDrop332 = pixTemp[pixSel];

    //}
    if (pixTemp[pixSel] != pixelColour332 )//==1
    {
      pixelColourDrop332 = pixTemp[pixSel];
      message = "Changing Pixel " + String(pixSel);
      //pixDesign[designIndex][pixSel] = pixelColour332;
      // Serial.println ("Setting Pixel to pixelColour332");
      // Serial.println ("pixTemp[" + String (pixSel) + "] is now: " + pixelColour332);
      pixTemp[pixSel] = pixelColour332;
    }
    else
    {

      message = "Clearing Pixel " + String(pixSel);
      //Serial.println ("Setting Pixel to zero");
      //pixelColourDrop332 = pixTemp[pixSel];
      pixTemp[pixSel] = 0;//1

    }
    if (showColour)
    {
      Serial.println ("Pixel Colour is:" + String (pixelColourDrop332));
      showColour = false;
    }
    htmlMode = "Design View";
    clientPackage = "onePixel";
    icon();

  }
  else if (instr(request, "designlistindex=") > -1)//choose the Design Index
  {
    designIndex = request.substring (instr(request, "=") + 1  ).toInt();
    //Load the design from EEPROM
    //Serial.println ("readDesignIndex in handleControls: designlistindex = ");
    if (memType == "I")//Not Used
    {
      readDesignIndex();//read the icon array
    }
    else //"S"
    {
      Serial.println ("readSPIFile in handleControls: designIndex = " + String (designIndex));
      message = "Reading SPIFFS File /D" + String (designIndex) + ".txt";
      readSPIFile ("/D" + String (designIndex) + ".txt", "Load");
      Serial.println ("Finished reading File");
    }
    icon();//shows the icon
  }
  else if (instr(request, "savedesign") > -1)//save the current Design Index to array
  {
    Serial.println ("Saving Design #:" + String (designIndex));
    if (memType == "I")//Not Used
    {
      for (int i = 0; i < 64; i++)
      {
        //Serial.println ("Saving Design toI2C EEPROM: " + String (designIndex) + " - Pixel " + String (i) + " - " + String (pixTemp[i]) + " to: " + String (2500 + (100 * designIndex) + i));
        writeEEPROMI2C(eeprom, 2500 + (100 * designIndex) + i, pixTemp[i]);
      }
    }
    else
    {
      //Serial.println ("/D" + String (designIndex));
      message = "Saving Design File to SPIFFS /D" + String (designIndex) + ".txt";
      writeSPIFile("/D" + String (designIndex) + ".txt");
    }

  }
  else if (instr(request, "designname=") > -1)//Save Design Name
  {
    if (instr(request, ",") == -1)
    {
      designName[designIndex] =  request.substring (request.indexOf("=") + 1);
      Serial.println ("******************");
      Serial.println ("*******DESIGN NAME***:" + designName[designIndex] + " Index: " + String (designIndex));
      Serial.println ("******************");
      message = "Saving Design Names to SPIFFS /DNames.txt";
      if (memType == "I")//Not Used
      {
        String source = designName[designIndex];
        char buf[source.length()];
        for (unsigned int i = 0; i < source.length(); i++)
        {
          //Serial.println(itoa(source[i], buf, 10));
          //EEPROM.write (memLoc + i, atoi (itoa(source[i], buf, 10)));//writes the ascii code for a character at index i in source
          writeEEPROMI2C(eeprom, 2565 + (100 * designIndex) + i, atoi (itoa(source[i], buf, 10)));
        }
        writeEEPROMI2C(eeprom, 2565 + (100 * designIndex) + source.length(), 96);//write end of message character
      }
      else
      {
        writeSPIDNames("/DNames.txt");
      }
    }
    else
    {
      message = "Illegal use of Comma in Name";
    }
  }
  else if (instr(request, "copydesign") > -1)
  {
    //copy to clipboard
    message = "Copying Design to Clipboard";
    for (int i = 0; i < 64; i++)
    {
      pixClipboard[i] = pixTemp[i];
    }

  }
  else if (instr(request, "pastedesign") > -1)
  {
    //paste from clipboard
    message = "Pasting Design to Clipboard";
    for (int i = 0; i < 64; i++)
    {
      pixTemp[i] = pixClipboard[i];
    }
    Serial.println ("Paste Complete: ");
    icon();
  }
  else if (instr(request, "importdesign") > -1)
  {
    message = "Importing Design Names";
    //delay (1000);



    message = "Importing Design Pixels";
    delay (1000);
    message = "Importing Complete";
  }
  else if (request.indexOf("showcolour") > -1)
  {
    showColour = true;
    //for (int i =0;i<10;i++)
    //{
    //   message += String(pixClipboard[i]) +",";
    //}
    //pixelColourDrop332;
    //message = String (pixelColour332);

  }
  else if (instr(request, "exportdesign") > -1)
  {
    message = "Exporting HTML";
    delay (1000);
    readSPIHTMLFile("/designHtmlHead.txt", "Export");
    message = "Exporting Pixel Names";
    delay (1000);
    Serial.println ("Start of Coding Text Export");
    exportCoding();//writeSPICoding();
    message = "End of Export Coding Text";

    readSPIDNames("/DNames.txt", "Export");
    Serial.println ("Exporting Pixel Name: ");//required for SPIFFS transfer
    message = "Exporting Designs";
    for (byte i = 0; i < 100; i++)
    {
      readSPIFile ("/D" + String (i) + ".txt", "Export");
    }
    Serial.println ("Export Pixels Complete: ");//Used in SPIFFS Transfer App
    message = "Exporting Designs Completed.";
  }
  else if (request.indexOf("codingexport") > -1)
  {
    Serial.println ("Start of Coding Text Export");
    exportCoding();//writeSPICoding();
    //for (int i = 0 ; i < 15; i++)
    //{
    //
    //  Serial.println ("Coding Text for Index: " + String (i));
    //  Serial.println (codingText[i]);
    //}
    message = "End of Export Coding Text";
  }
  else if (instr(request, "nextdesign") > -1 and designIndex < 99)
  {
    designIndex ++;
    message = "Design is now Index " + String (designIndex);
    readDesignIndex();//read the icon array
    icon();//shows the icon
  }
  else if (instr(request, "prevdesign") > -1 and designIndex > 0)
  {
    designIndex --;
    readDesignIndex();//read the icon array
    message = "Design is now Index " + String (designIndex);
    icon();//shows the icon
  }
  else if (instr(request, "firstdesign") > -1 )
  {
    designIndex = 0;
    message = "Design is now Index " + String (designIndex);
    readDesignIndex();//read the icon array
    icon();//shows the icon
  }
  else if (instr(request, "lastdesign") > -1 )
  {
    designIndex = 99;
    readDesignIndex();//read the icon array
    message = "Design is now Index " + String (designIndex);
    icon();//shows the icon
  }
  else if (instr(request, "memdesign") > -1 )
  {
    /*
      if (memType == "S")
      {
      memType = "I";
      message = "Memory is Internal";
      }
      else
      {
      memType = "S";
      message = "Memory is SPIFFS";
      }
    */
  }
  else if (instr(request, "pixelcolourdesign=") > -1)//Selected from Colour Pallette
  {
    pixelColour = request.substring(instr (request, "=") + 1);//rgb
    //Serial.println ("pixelColour rgb =: " + pixelColour);
    pixelColour332 = convert332();
    message = "Pixel Colour is " + pixelColour;
    //Serial.println ("pixelcolourdesign: = " + String (pixelColour332));
  }
  else if (instr(request, "cleardesign") > -1)
  {
    for (int i = 0; i < 64; i++)
    {
      //pixDesign[designIndex][i] = 0;
      message = "Clearing Design ";
      pixTemp[i] = 0;
    }
  }
  else if (instr(request, "rundesign") > -1)
  {
    //for (int i = 0; i < 64; i++)
    //{
    //  pixTemp[i] = pixDesign[designIndex][i];
    //}
    //pixelMode = "Letter D1";
    //letter(pixelMode, r, g, b);
    //pixelMode = ("Run Design");
    message = "Running Design";
    icon();

  }

  else if (instr(request, "pixelcolour=") > -1)
  {
    pixelColour = request.substring(instr (request, "=") + 1);//Hex
    String dummy = hexToRgb( request.substring (instr(request, "=") + 1));
    //map(value, fromLow, fromHigh, toLow, toHigh)
    mapRgb();
  }
  else if (instr(request, "iconitem=") > -1)//Choose item from Icon List.
  {
    refresh = true;//used to initiate icon display once only
    rRandom = false;
    bRandom = false;
    gRandom = false;
    r = 50;
    g = 50;
    b = 50;
    //iconItem=
    unsigned int selNum = request.substring (instr(request, "=") + 1).toInt();
    String iName = icons [selNum];
    message = iName;
    if (selNum < 109)
    {
      pixelMode = ("Icon " + iName);
    }
    else
    {
      pixelMode = ("Letter " + iName );
    }

  }
  //************ CODING VIEW *****************
  else if (instr(request, "codinglistindex=") > -1)//Select Coding Index
  {
    codingIndex =  request.substring (instr(request, "=") + 1) .toInt(); //0 to 13  +1 is to get Index substring.toint()
    codingError = "";
    Serial.println ("codingIndex is: " + String (codingIndex));
    buttonNum = codingIndex;
    Serial.println ("Setting buttonNum " + String (buttonNum));
    //message = "Setting button " + String (buttonNum);
    analyseCoding(codingText[codingIndex], "Pixels");
    message = "PixelMode is now: " + pixelMode; // Pixel Mode is changed in accordance with the Web page Buttons pressed.

  }

  //****************CODING SAVE AND RUN*********
  else if (instr(request, "ctext=") > -1)//Analyse Coding Text (text area)
  {
    Serial.println (request);
    if (request.length() > 12)
    {
      codingText[codingIndex] = request.substring (instr(request, "=") + 1);
      Serial.println ("CodingText in handleControls: " + codingText[codingIndex]);
      codingText[codingIndex].trim();
      if (codingText[codingIndex].length() > 99)
      {
        codingText[codingIndex] = codingText[codingIndex].substring(0, 99 );
      }
      analyseCoding(codingText[codingIndex], "Save"); //Save and allocate label
      message = "Saving Coding Button " + String(codingIndex);
    }
  }
  //**************CODING SET TO SPARE********
  else if (instr(request, "csetspare") > -1)//Set code to Default
  {
    //Serial.println ("Btn to SPARE: " + String(codingIndex + 1));
    codingText[codingIndex] = "<N>Button" + String (codingIndex) + "\n<L>Spare\n<A>Spell\n<T>spare\n<I>50\n<R>50\n<G>50\n<B>50\n<F>No\n";
    codingText[codingIndex].trim();
    Serial.println ( codingText[codingIndex]);
    analyseCoding(codingText[codingIndex], "Save"); //Save and allocate label
    message = "Setting to Spare. Button " + String(codingIndex);
  }


  //*********SETTINGS VIEW ***************

  else if (instr(request, "version") > -1)
  {

    message = "Version is: " + versionNum;

  }
  else if (instr(request, "12hourmode") > -1)
  {
    hourMode = 12;
    //EEPROM.write(20, hourMode);
    writeEEPROMInt( 20, hourMode);
    message = "12/24 Hour Mode is: " + String(hourMode);

  }
  else if (instr(request, "24hourmode") > -1)
  {
    hourMode = 24;
    //EEPROM.write(20, hourMode);
    writeEEPROMInt( 20, hourMode);
    message = "12/24 Hour Mode is: " + String(hourMode);

  }
  else if (instr(request, "digitalclock") > -1)
  {
    Serial.println ("Digital Clock is ON!");
    digitalClock = true;
    writeEEPROMInt(24, 1);
    message = "Clock Mode is: Digital";
  }
  else if (request.indexOf( "analogclock") > -1)
  {
    digitalClock = false;
    writeEEPROMInt(24, 0);
    message = "Clock Mode is: Analog";
  }

  else if (instr(request, "timezone") > -1)
  {
    timeZone = request.substring (instr(request, "=") + 1).toInt();

    if (timeZone > 140)
    {
      timeZone = 140;
    }
    if (timeZone < -120)
    {
      timeZone = -120;
    }

    EEPROM.write(1, lowByte(timeZone));
    EEPROM.write(2, highByte(timeZone));
    EEPROM.commit();
    getNtpTime();
    message = "TimeZone Changed (wait 5 Mins): " +  String(timeZone / 10) + "." +  String (abs(timeZone % 10)) + " UTC";

  }
  else if (instr(request, "alarmhour=") > -1)
  {
    alarmHour = request.substring(instr(request, "=") + 1).toInt();
    if (alarmHour <0 or alarmHour >24)
    {
      alarmHour = 8;
    }
    EEPROM.write(21, alarmHour);

    String aH = String(alarmHour);
    if (aH.length () == 1)
    {
      aH = "0" + aH;
    }
    String aM = String(alarmMinute);
    if (aM.length () == 1)
    {
      aM = "0" + aM;
    }
    message = "Time is " + timeStr + "  Alarm Time is " + aH + ":" + aM;

  }
  else if (instr(request, "alarmminute=") > -1 )
  {
    alarmMinute = request.substring(instr(request, "=") + 1).toInt();
    if (alarmMinute <0 or alarmMinute >59)
    {
      alarmMinute = 0;
    }
    EEPROM.write(22, alarmMinute);
    String aH = String(alarmHour);
    if (aH.length () == 1)
    {
      aH = "0" + aH;
    }
    String aM = String(alarmMinute);
    if (aM.length () == 1)
    {
      aM = "0" + aM;
    }
    message = "Time is " + timeStr + "  Alarm Time is " + aH + ":" + aM;
    // message = "Alarm Time is " + aH + ":" + aM;

  }
  else if (instr(request, "alarmon") > -1 )
  {
    alarmOn = true;
    String aH = String(alarmHour);
    if (aH.length () == 1)
    {
      aH = "0" + aH;
    }
    String aM = String(alarmMinute);
    if (aM.length () == 1)
    {
      aM = "0" + aM;
    }
    EEPROM.write(23, 1);
    message = "Time is " + timeStr + "  Alarm Time is " + aH + ":" + aM + "  Alarm is On";

    //message = "Alarm is On: "  + aH + ": " + aM;
  }
  else if (instr(request, "alarmoff") > -1 )
  {
    alarmOn = false;
    EEPROM.write(23, 0);
    message = "Time is " + timeStr + "  Alarm is Off";
    //message = "Alarm is Off: ";
  }
  else if (instr(request, "ssidlist = ") > -1 and instr(request, "ClearNetworkSettings") == -1)
  {
    scanWiFi();

  }
  else if (instr(request, "submitnetworksettings") > -1)
  {
    //Restart ESP
    flashLed(10);
    ESP.restart();
    delay (1000);

  }
  else if (instr(request, "networkscan") > -1)
  {
    scanWiFi();
  }
  else if (instr(request, "rebootesp") > -1)
  {
    if (htmlMode == "Settings View")
    {
      ESP.restart();
      delay (1000);
    }
  }
  else if (instr(request, "clearnetworksettings") > -1)
  {
    wifiSSID = "";
    wifiPassword = "";
    //ipAdd = 10, 0, 0, 77;
    //ipGw = 10, 0, 0, 138;

  }
  else if (instr(request, "ssid=") > -1) //SSID
  {
    wifiSSID =  request.substring (instr(request, "=") + 1);// get the SSID as String
    writeEEPROMString(wifiSSID, 600); //Write string to SSID mem = 600

  }
  else if (instr(request, "ssidnum=") > -1) //SSID
  {
    int thisNum =  request.substring (instr(request, "=") + 1).toInt();// get the SSID as String
    wifiSSID = wifiSSIDList[thisNum];
    writeEEPROMString(wifiSSID, 600); //Write string to SSID mem = 600

  }
  else if (instr(request, "password=") > -1) //PASSWORD
  {
    wifiPassword =  request.substring (instr(request, "=") + 1);
    writeEEPROMString(wifiPassword, 625);

  }
  else if (instr(request, "ipaddress=") > -1) //IP Address
  {
    wifiAdd =  request.substring (instr(request, "=") + 1); //is string
    //unsigned int str_len = wifiAdd.length() + 1;
    //char  charwifiAdd[str_len];
    //wifiAdd.toCharArray(charwifiAdd, str_len);
    //scrollText("Scroll " + wifiAdd, 50, 50, 50);
    //ipAdd = str2IP(wifiAdd);
    writeEEPROMString(wifiAdd, 650);

  }
  else if (instr(request, "ipgw=") > -1) //GW Address
  {
    wifiGW =  request.substring (instr(request, "=") + 1); //is string
    //unsigned int str_len = wifiAdd.length() + 1;
    //char  charwifiAdd[str_len];
    //wifiAdd.toCharArray(charwifiAdd, str_len);
    //ipGw = str2IP(wifiGW);
    writeEEPROMString(wifiGW, 675);
  }

  //********SCREEN VIEW ***************
  //  out = "buttoncolour="+ c4.style.backgroundColor + "textcolour=" + c4.style.color +  "backgroundcolour=" + c5;
  else if (request.indexOf("textcolour=") > -1)
  {
    message = "Saving Colours:";
    buttonBackColour = request.substring(request.indexOf("=") + 1, request.indexOf("textcolour="));
    Serial.println ("buttonBackColour = " + buttonBackColour);
    saveColour("buttonBackColour");
    if (request.indexOf("textcolour=") > -1)
    {
      buttonTextColour = request.substring(request.indexOf("textcolour=") + 11, request.indexOf("backgroundcolour="));
      Serial.println ("buttonTextColour = " + buttonTextColour);
      saveColour("buttonTextColour");
    }
    if (request.indexOf("backgroundcolour=") > -1)
    {
      screenBackColour = request.substring( request.indexOf("backgroundcolour=") + 17);
      Serial.println ("screenBackColour = " + screenBackColour);
      saveColour("screenBackColour");
    }
  }

  //colourscheme=9  Index 1  to 9
  //buttonBackColour,buttonTextColour,screenBackColour
  // "e21937", "ffd200", "32619c", "Adelaide",
  //"a30046", "ffffff", "fdbe57", "Brisbane",
  //"051829", "FFFFFF", "A2ACB4", "Carlton",//deep blue,white,grey
  //"ffffff", "250553", "a4aeb5", "Freemantle",
  //"372B00", "FFFFFF", "F6B60D", "Hawthorn",
  // "000000", "ffffff", "008aab", "Port",
  //"ffffff", "000000", "ed171f", "Sydney"
  //buttonBackColour: rgb(55,43,0)//brown
  //buttonTextColour: rgb(255,255,255)//white
  //screenBackColour: rgb(246,182,13)//Gold
  else if (request.indexOf("colourscheme=") > -1)
  {
    int rI = request.substring(request.indexOf("=") + 1).toInt();
    if (rI > 0 and rI < 10)
    {
      buttonBackColour = hexToRgb(schemes[(rI - 1) * 4 ]);
      Serial.println ("buttonBackColour = " + buttonBackColour);
      saveColour("buttonBackColour");

      buttonTextColour = hexToRgb(schemes[((rI - 1) * 4) + 1]);
      Serial.println ("buttonTextColour = " + buttonTextColour);
      saveColour("buttonTextColour");


      screenBackColour = hexToRgb(schemes[((rI - 1) * 4) + 2]) ;
      Serial.println ("screenBackColour = " + screenBackColour);
      saveColour("screenBackColour");
    }

  }



  /*
    if (instr(request, "btnDown") > -1)
    {
    //pixelMode = "Game Pong";
    Serial.println ("Down");
    controlDirection = "Down";
    commandSuccess = false;
    return true;
    }
    else if (instr(request, "btnUp") > -1)
    {
    //pixelMode = "Game Pong";
    controlDirection = "Up";
    Serial.println ("Up");
    commandSuccess = false;
      return true;
    }
  */

  updateClientData = true; //Data changed. Client processes full data packet
  //Placed here to ensure icon drawn before updateClientData





}
