void analyseCoding(String cT, String aMode)//cT is coding Text
{
  //Parses the codingText array into commands and properties.
  //aMode == Action Mode
  //aMode = "Labels" or "Pixels" or "Save"
  //"Save" saves the Coding string to EEPROM for selected button (codingIndex).
  //
  //Serial.println ("********");
  Serial.println ("In Analyse Coding. Analysing Coding Text: ");
  Serial.println (cT);
  codingError = "";
  unsigned int sep1[20];
  unsigned int sep2[20];
  unsigned int count = 0;
  String command[20];
  String property[20] ;

  cT = cT + "<>";
  codingText[codingIndex] = "";
  //parse out code text into commands and properties

  for (unsigned int i = 0; i < cT.length(); i++)
  {
    if (cT.substring(i, i + 1) == "<")
    {
      sep1[count] = i;
      //if (aMode == "Save")Serial.println (sep1[count]);
    }
    if (cT.substring(i, i + 1) == ">")
    {
      sep2[count] = i;
      //if (aMode == "Save")Serial.println (sep2[count]);
      count++;
    }
  }

  for (unsigned int i = 0; i < count - 1; i ++ )
  {
    if (sep2[i] > 0)
    {
      command[i] = cT.substring(sep1[i] + 1, sep2[i]);
      command[i].toUpperCase();
      command[i].trim();
      //if (aMode == "Save")Serial.println("Command " + String(i) + " = " + command[i]);
    }
    if (sep2[i] > 0)
    {
      property[i] = cT.substring( sep2[i] + 1, sep1[i + 1]);
      property[i].trim();
    }
  }


  if (aMode == "Save")Serial.println ("*******END of Parsing coding Text ******");

  String doCommand = "";
  String doText;
  String doLabel;

  for (unsigned int i = 0 ; i < count - 1; i++)
  {

    //Name
    if (command[i] == "N")
    {
      if (property[i].length() > 20) //limit length of Name
      {
        property[i] = property[i].substring(0, 20);
      }
    }
    //Label
    if (command[i] == "L" )
    {
      doLabel = property[i];

    }

    //Actions
    if (command[i] == "A")
    {
      String testA = property[i];
      testA.toUpperCase();
      //Set action
      if (instr(testA, "SCROLL") > -1)
      {
        doCommand = "Scroll";
      }
      else if (instr(testA, "SPELL") > -1)
      {
        doCommand = "Spell";
      }
      else  if (instr(testA, "LETTER") > -1)
      {
        doCommand = "Letter";
      }
      else if (instr(testA, "ICON") > -1)
      {
        doCommand = "Icon";
      }
      else if (instr(testA, "ANI") > -1)
      {
        doCommand = "Ani";
      }
      else if (instr(testA, "GAME") > -1)
      {
        doCommand = "Game";
        //htmlMode = "Game View";// Required to Load "Game View" Web Page.
      }
      else
      {
        codingError = "Error in Action Tag Entry";
      }
    }
    //TEXT
    if (command[i] == "T" or command[i] == "TEXT")
    {
      doText = property[i];
    }
    //Brightness
    if (command[i] == "I")
    {
      brightness = property[i].toInt();
      if (brightness <5 or brightness >100)
      {
        brightness = 50;
      }
    }
    //set colours
    if (command[i] == "R" or command[i] == "COLOURR")
    {
      r = property[i].toInt();
      rRandom = false;
    }
    if (command[i] == "RR" or command[i] == "COLOURRR")
    {
      r = property[i].toInt();
      rRandom = true;
    }
    if (command[i] == "G" or command[i] == "COLOURG")
    {
      g = property[i].toInt();
      gRandom = false;
    }
    if (command[i] == "GR" or command[i] == "COLOURGR")
    {
      g = property[i].toInt();
      gRandom = true;
    }

    if (command[i] == "B" or command[i] == "COLOURB")
    {
      b = property[i].toInt();
      bRandom = false;
    }
    if (command[i] == "BR" or command[i] == "COLOURBR")
    {
      b = property[i].toInt();

      bRandom = true;
    }
    if (r > 100)r = 100;
    if (g > 100)g = 100;
    if (b > 100)b = 100;

    if (command[i] == "F" or command[i] == "FADE")
    {
      if (property[i] == "YES")
      {
        fade = true;
      }
      else
      {
        fade = false;
      }
    }
    //Assemble codingText
    codingText[codingIndex] += "<" + command[i] + ">" + property[i] + "\n";
  }
  if (aMode == "Save")
  {
   //Serial.println ("In analyseCoding - Writing Code to EEPROM: ");
   // writeEEPROMString(codingText[codingIndex], 1000 + (100 * codingIndex));
     Serial.println ("In analyseCoding - Writing Code to SPIFF: ");
    writeSPICoding();//writes codingIndex file only
  }
  //compile pixel mode
  if (doCommand != "")//scrollText(pixelMode, random(50), random(50), random(50));
  {
    if (aMode == "Labels" or "Save")// Labels or Pixels
    {
      //if (buttonNum >= 1 and buttonNum <= 15)
      if (buttonNum >= 0 and buttonNum <15)
      {
       // buttonLabel[buttonNum - 1] = doLabel;
       doLabel.trim();
        buttonLabel[buttonNum] = doLabel;
      }
    }
    if (aMode == "Pixels" or "Save")
    {
      oldPixelMode = pixelMode;
      pixelMode = doCommand + " " + doText;
      Serial.println ("In analyse Coding: PixelMode is: " + pixelMode);
    }
  }
  //if (aMode == "Save")Serial.println ("****************PixelMode from Coding is: " + pixelMode);
  //if (aMode == "Save")Serial.println ("R:" + String (r) + " G: " + String (g) + " B " + String (b));
}
