#include "RF433any.h"
#define PIN_RFINPUT  2

#define RF_A_OUTPUT 7
#define RF_B_OUTPUT 9
#define RF_C_OUTPUT 11
#define RF_D_OUTPUT 13

#define PP_1_ON  0xF
#define PP_1_OFF 0xE
#define PP_2_ON  0xD
#define PP_2_OFF 0xC
#define PP_3_ON  0xB
#define PP_3_OFF 0xA
#define PP_4_ON  0x7
#define PP_4_OFF 0x6
#define PP_ALL_ON  0x4
#define PP_ALL_OFF 0x8

char msgs[16][8]={
  "?","?","?","?",
  "ALL ON","?",
  "D OFF","D ON",
  "ALL OFF","?",
  "C OFF","C ON",
  "B OFF","B ON",
  "A OFF","A ON"
};

#include <EEPROM.h>
#define SLOT_COUNT 5
unsigned long activeCodes[SLOT_COUNT]; //load from EEPROM later

Track track(PIN_RFINPUT, RAIL_MOOD_STRICT);
BitVector* rx;  //this is where RF433any stores the raw received data
unsigned long rx_code=0;  //and we decode it into an unsigned long
unsigned long last_code=0;

void setup() {
  byte i;
  pinMode(PIN_RFINPUT, INPUT);
  digitalWrite(RF_A_OUTPUT,LOW);
  digitalWrite(RF_B_OUTPUT,LOW);
  digitalWrite(RF_C_OUTPUT,LOW);
  digitalWrite(RF_D_OUTPUT,LOW);
  pinMode(RF_A_OUTPUT, OUTPUT);
  pinMode(RF_B_OUTPUT, OUTPUT);
  pinMode(RF_C_OUTPUT, OUTPUT);
  pinMode(RF_D_OUTPUT, OUTPUT);
  Serial.begin(115200);
  for(i=0;i<SLOT_COUNT;i++){
    EEPROM.get(i*sizeof(activeCodes[0]),activeCodes[i]);
  }
  debugData();
  Serial.println("~ for debug data");
  Serial.println("s to save last code to a slot");
  Serial.println("0-4 to clear a slot");
  delay(2000);
  track.treset();
}

void loop() {
  int d;
  byte i;
  if(Serial.available()){
    d=Serial.read();
    if(d=='~'){
      debugData();
    }else if(d=='s'){
      if(code_is_valid(last_code)){
        if(save_code(last_code)){
          Serial.println("Saved");
        }else{
          Serial.println("All slots full, please clear one.");
        }
      }else{
        Serial.println("Code not valid");
      }
    }else if((d>='0')&&(d<='9')){
      i=d-'0';
      if(i<SLOT_COUNT){
        EEPROM.put(i*sizeof(activeCodes[i]),(unsigned long)(0));  //clear
        activeCodes[i]=0;
        Serial.print("Slot ");
        Serial.print(i);
        Serial.println(" cleared.");
        debugData();
      }
    }
  }
  if(track.do_events()){
    //scan events
    Decoder *pdec0 = track.get_data(RF433ANY_FD_TRI); //only look for tribit format
    Decoder *pdec = pdec0;
    while (pdec){
      rx=pdec->get_pdata();
      rx_code=getCode(rx);
      last_code=(rx_code>>12);
      Serial.println(rx_code,HEX);
      if(code_is_valid(last_code)){
        for(i=0;i<SLOT_COUNT;i++){
          if(last_code==activeCodes[i]){    //if one of the codes matches
            Serial.print(i);
            Serial.print(": ");
            codeAction((rx_code>>8)&0xF);   //do the encoded action
          }      
        }
      }
      pdec=pdec->get_next();  //check for more
    }
    delete pdec0;
    track.treset();
  }
}

void codeAction(unsigned int a){
  //Serial.println(a);
  Serial.println(msgs[a]);
  switch(a){
    case PP_1_ON:
      digitalWrite(RF_A_OUTPUT,HIGH);
      break;
    case PP_1_OFF:
      digitalWrite(RF_A_OUTPUT,LOW);
      break;
    case PP_2_ON:
      digitalWrite(RF_B_OUTPUT,HIGH);
      break;
    case PP_2_OFF:
      digitalWrite(RF_B_OUTPUT,LOW);
      break;
    case PP_3_ON:
      digitalWrite(RF_C_OUTPUT,HIGH);
      break;
    case PP_3_OFF:
      digitalWrite(RF_C_OUTPUT,LOW);
      break;
    case PP_4_ON:
      digitalWrite(RF_D_OUTPUT,HIGH);
      break;
    case PP_4_OFF:
      digitalWrite(RF_D_OUTPUT,LOW);
      break;
    case PP_ALL_ON:
      digitalWrite(RF_A_OUTPUT,HIGH);
      digitalWrite(RF_B_OUTPUT,HIGH);
      digitalWrite(RF_C_OUTPUT,HIGH);
      digitalWrite(RF_D_OUTPUT,HIGH);
      break;
    case PP_ALL_OFF:
      digitalWrite(RF_A_OUTPUT,LOW);
      digitalWrite(RF_B_OUTPUT,LOW);
      digitalWrite(RF_C_OUTPUT,LOW);
      digitalWrite(RF_D_OUTPUT,LOW);
      break;
    default: break; //do nothing
  }
}

void debugData(void){
  byte i;
  Serial.print("A: ");Serial.println(digitalRead(RF_A_OUTPUT)?"ON":"OFF");
  Serial.print("B: ");Serial.println(digitalRead(RF_B_OUTPUT)?"ON":"OFF");
  Serial.print("C: ");Serial.println(digitalRead(RF_C_OUTPUT)?"ON":"OFF");
  Serial.print("D: ");Serial.println(digitalRead(RF_D_OUTPUT)?"ON":"OFF");
  for(i=0;i<SLOT_COUNT;i++){
    Serial.print(i);
    Serial.print(" CODE: 0x");
    if(code_is_valid(activeCodes[i])){
      Serial.println(activeCodes[i],HEX);
    }else{
      Serial.println("-----");
    }        
  }
  Serial.print("Last code: 0x");
  Serial.println(last_code,HEX);
}

bool code_is_valid(unsigned long n){
  if(n==0){return 0;}
  if(n>0xFFFFF){return 0;}
  return 1;
}

bool save_code(unsigned long n){
  byte i;
  for(i=0;i<SLOT_COUNT;i++){
    if(!code_is_valid(activeCodes[i])){
      activeCodes[i]=n;
      EEPROM.put(i*sizeof(activeCodes[0]),n);
      Serial.print("Added to slot ");
      Serial.println(i);
      return 1; //success
    }
  }
  return 0;
}

unsigned long getCode(BitVector* b){  //put the bits into a useable format
  unsigned long n=0;
  char i;
  if((b->get_nb_bits())<33){return 0;}
  //brute force extract desired bits
  for(i=32;i>0;i--){
    n=n<<1;
    n=n|b->get_nth_bit(i);
  }
  return n;
}

int freeRam() { //debugging
  extern int __heap_start,*__brkval;
  int v;
  return (int)&v - (__brkval == 0  
    ? (int)&__heap_start : (int) __brkval);  
}