; Lady Beetle
; LEDy Beetle using LEDs

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB3  & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Define variables at memory locations

EEPROM1		equ	H'00'	; non-volatile storage for type of running  

; Bank 0 RAM

MEASURED	equ	H'20'	; A/D measured value 
STORE1		equ	H'21'	; delay counter
STORE2		equ	H'22'	; delay counter
REPEAT		equ	H'23'	; sequence repeat
BRIGHT		equ H'24'	; brightness
SCROLL		equ	H'25'	; scrolling
PULSE		equ	H'26'	; pulse
FLASH1		equ	H'27'	; flash period
FLASH2		equ	H'28'	; flash period
DIRECTION	equ	H'29'	; wing dimming direction
SCROLL2		equ	H'2A'	; scroll period/value
CHASE		equ	H'2B'	; chaser rate
FLAG		equ	H'2C'	; sequence flag
DIM			equ	H'2D'	; wing wave dimming
DIVIDE		equ	H'2E'	; rate divider
SWITCH_P	equ	H'2F'	; switch pressed flag
CHASER		equ	H'30'	; wing flapping chaser effect	

; math routines
TEMP		equ	H'5E'	; temp file
REMB0		equ	H'5F'	; remainder ms
REMB1		equ	H'60'
REMB2		equ	H'61'	; remainder
REMB3		equ	H'62'	; remainder ls
TEMP1		equ H'63'	; temporary
TEMPD		equ	H'64'
AARGB3		equ	H'65'	; ls of argument A
AARGB2      equ H'66'
AARGB1      equ H'67'
AARGB0      equ H'68'	; most significant byte of argument A
TEMPB1      equ H'69'	; temporary
TEMPB0      equ H'6A'
BARGB3      equ H'6B'	; least significant byte of argument B
BARGB2      equ H'6C'	; 
BARGB1      equ H'6D'	; 
BARGB0      equ H'6E'	; most significant byte of argument B
LOOPCOUNT   equ H'6F'  	; loop counter	

; preset EEPROM
	ORG     2100
 
	DE	H'FF'	; initially set

	org	0
	goto	SETUP
	nop
	nop
	nop	
	org	4	;interrupt

INTERRUPT
	bcf		INTCON,GIE	; interrupts disabled
	movlw	H'FF'		; LEDs off
	movwf	PORTA
	movwf	PORTB
	movlw	D'150'		; delay 
	call	DELAY2
	bcf		INTCON,INTF	; flag cleared
	clrf	FLAG		; sequence flag
	goto	END_RUN		; zipper close
	
SETUP
	bsf		FLAG,0		; set flag
	movlw	H'FF'		; set all outputs high
	movwf	PORTA
	movwf	PORTB

	movlw	D'50'
	call	DELAY2

; set inputs/outputs
	movlw	H'FF'		; set all outputs high
	movwf	PORTA
	movwf	PORTB
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'00000001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	movlw	B'00000000'	; 
	movwf	OPTION_REG	; pullups enabled and interupt on falling edge for RB0
	movlw   B'00101000'	; I/O 
	movwf   TRISA		; port A data direction register
; analog inputs, A/D
	movlw	B'00000000'	;  AN3 analog input later
	movwf	ANSEL
	movlw	B'00000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'11011000'	; Fosc, channel 3 etc
	movwf	ADCON0
; oscillator
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00100000'	; for 250kHz
	movwf	OSCCON		; osc
; interrupt
	bcf		INTCON,GIE	; interrupts disabled
	bcf		INTCON,INTF	; flag cleared
	bsf		INTCON,INTE	; RBO interrupt only
; pwm set
	movlw	H'3F'
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	movlw	H'3F'		; set duty 
	movwf	CCPR1L		; ms byte of PWM
	movlw	B'00000000'
	movwf	T2CON
	bsf		T2CON,2		; enable timer 2
	movlw	B'00111100'	; set PWM mode
	movwf	CCP1CON		; enable PWM operation


	movlw	D'1'
	movwf	TEMPB0
INIT_DELAY
	movlw	D'100'
	call	DELAY2
	decfsz	TEMPB0,f
	goto	INIT_DELAY

	goto	NORMAL_OP


SW_PRESSED
; when S1 is pressed to change cycle
; swap running from once only (off after sequence) to continue after sequence
	btfsc	PORTB,0
	goto	NORMAL_OP

; reset RB4 as output and RA3/AN3 as A/D input
	bsf		STATUS,RP0	; select memory bank 1

	movlw	B'00000000'	; interrupt on falling edge, pullups enabled
	movwf	OPTION_REG	;
	movlw	B'00000001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	movlw   B'00101000'	; I/O 
	movwf   TRISA		; port A data direction register
; analog inputs, A/D
	movlw	B'00001000'	;  AN3 analog input 
	movwf	ANSEL
	bcf		STATUS,RP0	; select memory bank 0

; set outputs high
	movlw	H'3F'		; 0% duty 
	movwf	CCPR1L		; ms byte of PWM
	movlw	B'00111100'	; set ls bits of PWM high
	movwf	CCP1CON		; PWM operation
	movlw	H'FF'		; set all outputs high
	movwf	PORTA
	movwf	PORTB
	movlw	D'20'
	call	DELAY2
	bcf		INTCON,INTF	; flag cleared 
; read EEPROM

	movlw	D'00'
	call 	EEREAD		; read EEPROM
	movwf	TEMP
	incf	TEMP,w
	movwf	TEMP
	call	EEWRITE		; write to EEPROM
	movlw	D'100'
	call	DELAY2

; show left EYE
; 

	movlw	H'00'		; 100% duty 
	movwf	CCPR1L		; ms byte of PWM
	movlw	B'00001100'	; set ls bits of PWM low
	movwf	CCP1CON		; PWM operation
	movlw	D'200'
	call	DELAY2
SHOW_SETTING
	movlw	B'11101111'	; RB4 low
	movwf	PORTB
	movlw	D'100'
	call	DELAY2
NO_FLASH
	movlw	H'FF'		; set all outputs high
	movwf	PORTB
	movlw	D'50'
	call	DELAY2
	btfsc	PORTB,0		; check switch open or closed
	goto	NORMAL_OP	; open
	btfsc	TEMP,0		; if clear repeat flash till switch is opened	
	goto	NO_FLASH	; single flash to indicate single cycle
	goto	SHOW_SETTING; continuously show LED flashing to indicate repeat setting
; PWM off
	movlw	H'3F'		; 0% duty 
	movwf	CCPR1L		; ms byte of PWM
	movlw	B'00111100'	; set ls bits of PWM high
	movwf	CCP1CON		; PWM operation

NORMAL_OP
; initial conditions

	movlw	H'FF'		; set all outputs high
	movwf	PORTA
	movwf	PORTB

CYCLE; program returns here
	bcf		INTCON,GIE	; interrupts disabled
	bcf		INTCON,INTF	; flag cleared

; reset RB4 as output and RA3/AN3 as A/D input
	bsf		STATUS,RP0	; select memory bank 1

	movlw	B'00000000'	; interrupt on falling edge, pullups enabled
	movwf	OPTION_REG	;
	movlw	B'00000001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	movlw   B'00101000'	; I/O 
	movwf   TRISA		; port A data direction register
; analog inputs, A/D
	movlw	B'00001000'	;  AN3 analog input 
	movwf	ANSEL
	bcf		STATUS,RP0	; select memory bank 0

; set outputs high
	movlw	H'3F'		; 0% duty 
	movwf	CCPR1L		; ms byte of PWM
	movlw	B'00111100'	; set ls bits of PWM high
	movwf	CCP1CON		; PWM operation
	movlw	H'FF'		; set all outputs high
	movwf	PORTA
	movwf	PORTB
	movlw	D'20'
	call	DELAY2
	bcf		INTCON,INTF	; flag cleared 

; check sequence

	btfss	FLAG,0		; if cleared entered here via interrupt
	goto	STOP
	movlw	D'00'
	call 	EEREAD		; read EEPROM
	movwf	TEMP
	btfss	TEMP,0
	goto	CONT_RUN
STOP
	sleep
	nop					; awakes on RB0 low with switch S1 pressed
	bcf		INTCON,INTF	; flag cleared 

CONT_RUN

	movlw	D'1'
	movwf	SWITCH_P	; switch pressed flag set

; set flag

	bsf		FLAG,0


; read voltage across 220 ohm resistor
	movlw	D'00'
	movwf	CCPR1L		; ms byte of PWM
	movlw	B'00001100'	; set PWM mode. ls bits low
	movwf	CCP1CON

	movlw	D'20'
	call	DELAY2

; dim up eyes
	movlw	D'1'
	movwf	FLASH1	; initial LED brightness
	movlw	D'105'
	movwf	FLASH2
	movlw	D'100'	; period (must be < Flash 2)
	movwf	SCROLL

EYE_DIM_START	
; Left eye on
	movlw	B'11101111'	; RB4
	movwf	PORTB
	movf	FLASH1,w
	call	DELAYX
; eye off
	movlw	H'FF'
	movwf	PORTB
	movf	FLASH2,w
	call	DELAYX

; increase FLASH1, decrease FLASH2
	incf	FLASH1,f
	decf	FLASH2,f
	decfsz	SCROLL,f
	goto	EYE_DIM_START

	movlw	B'11101111'
	movwf	PORTB		; Left eye LED on
	call	ACQUIRE_AD	; get voltage across resistor
	movwf	MEASURED	; A/D value

; allow all off with switch

	bcf		INTCON,INTF	; interrupt flag
	bsf		INTCON,GIE	; interrupts enabled

; low value means a low battery/cell voltage
; typically the reading is 1V for a 3V cell with 2V across LED, 1V across 220 ohm resistor

; subtract a minimum

	movlw	D'25'
	subwf	MEASURED,f
	clrw	
	btfss	STATUS,C			
	movwf	MEASURED	; clear if subtraction is negative

; multiplier for A/D versus PWM gain x 2.2 = x 22 /10
	clrf	AARGB0
	clrf	BARGB0
	movf	MEASURED,w
	movwf	AARGB1		; A/D value
	btfsc	STATUS,Z	; if zero bypass
	goto	BY_ZERO
	movlw	D'22'		; multiplier
	movwf	BARGB1
	call	FXM1616U
;
; move multiplied bytes
	movf	AARGB2,w
	movwf	AARGB0
	movf	AARGB3,w
	movwf	AARGB1

	movlw	D'10'		; 10
	movwf	BARGB0		; divisor
	call	DIV16_8	

	movf	AARGB0,w
	movlw	H'FF'
	btfss	STATUS,Z	; if zero ok as it has not overranged from AARGB1
	movwf	AARGB1		; otherwise set AARGB1 at max
	movf	AARGB1,w

	movwf	MEASURED	; store value
BY_ZERO
	movwf	BRIGHT 
	
; set RB4 as an input and RA3/AN3 as an output
	bsf		PORTA,3		; RA3 high
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00010001'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	movlw   B'00100000'	; I/O 
	movwf   TRISA		; port A data direction register
; analog inputs, A/D
	movlw	B'00000000'	;  AN3 analog input off
	movwf	ANSEL
	bcf		STATUS,RP0	; select memory bank 0


; drive LEDs

; 
; drive all LEDs
; set PWM to cater for cell/battery voltage (PWM duty is inverted via transistor Q1)

; divided by 4 to cater for resolution at 8-bits. 
; CCP1CON bits 4,5 set ls bits

;
	movf	MEASURED,w
	movwf	BRIGHT

; move to PWM
	bsf		CCP1CON,5	; ls PWM bits set 
	bsf		CCP1CON,4

	bcf		STATUS,C
	rrf		BRIGHT,f
	btfss	STATUS,C
	bcf		CCP1CON,5
	bcf		STATUS,C
	rrf		BRIGHT,f
	btfss	STATUS,C
	bcf		CCP1CON,4
	movf	BRIGHT,w
	movwf	CCPR1L		; ms byte of PWM

	movlw	B'11110111'
	movwf	PORTA		; left eye on

; enable switchoff with S1

	movlw	D'100'
	call	DELAY2

; check switch still pressed
	btfsc	PORTB,0
	clrf 	SWITCH_P	; cleared if open	


; dim up 

; dim up Right eye
	movlw	D'1'
	movwf	FLASH1	; initial LED brightness
	movlw	D'205'
	movwf	FLASH2
	movlw	D'200'	; scroll period must be < Flash 2
	movwf	SCROLL

EYE_RIGHT	

; right eye	on
	movlw	B'10111111'	; RB6
	movwf	PORTB
	movf	FLASH1,w
	call	DELAYX
	
; check switch still pressed
	btfsc	PORTB,0
	clrf 	SWITCH_P	; cleared if open

; eye off
	movlw	H'FF'
	movwf	PORTB

	movf	FLASH2,w
	call	DELAYX

; increase FLASH1, decrease Flash2
	incf	FLASH1,f
	decf	FLASH2,f
	decfsz	SCROLL,f
	goto	EYE_RIGHT

	movf	SWITCH_P,w	; if cleared continue
	btfss	STATUS,Z
	goto	SW_PRESSED	; toggle continuous/single run option
;_____________________________



Display
;___________________________
; open elytra (front wings or wing protectors)
	movlw	D'1'
	movwf	SCROLL
CENTRE_UNZIP
; left eye on
	movlw	B'11110111'	; RA3
	movwf	PORTA
; right eye	on
	movlw	B'10111111'	; RB6
	movwf	PORTB
	movlw	D'50'
	call	DELAY2
	call	LEDE1_2
	movlw	D'20'
	call	DELAY2
	call	LEDE3_4
	movlw	D'20'
	call 	DELAY2
	call	LEDE5_6
	movlw	D'20'
	call	DELAY2	
	call	LEDE7_8
	movlw	D'100'
	call	DELAY2
	decfsz	SCROLL,f
	goto	CENTRE_UNZIP	
; LEDs off except eyes
	movlw	B'10111111'	; left EYE
	movwf	PORTB
	movlw	B'11110111'	; right eye
	movwf	PORTA

; delay
	movlw	D'250'
	call	DELAY2

;_______________________

; right hind wing check
	movlw	D'50'
	movwf	SCROLL
	movlw	D'250'
	movwf	FLASH1
	movlw	D'2'
	movwf	PULSE
	movlw	D'25'
	movwf	CHASER
	clrf	DIRECTION
WING_R
	call	LEDE18_20
	movf	CHASER,w
	call 	DELAYY
	call	LEDE14_16
	movf	CHASER,w
	call	DELAYY
	call	LEDE10_12
	movf	CHASER,w
	call	DELAYY
	call	FLASH_EYE1
; delay
	movf	FLASH1,w
	call	DELAYY
	decfsz	PULSE,f
	goto	WING_R
	movlw	D'2'
	movwf	PULSE

; increase or reduce flash value
	btfsc	DIRECTION,0
	goto	OPP_R
	movlw	D'10'		; decrease flash delay
	subwf	FLASH1,f
	movlw	D'10'
	btfss	STATUS,C	; if carry then negative
	movwf	FLASH1
	btfsc	STATUS,Z
	movwf	FLASH1
; increase chaser rate 
	movlw	D'1'
	subwf	CHASER,f	; increase chaser rate
	movlw	D'5'		
	subwf	CHASER,w	; check for minimum
	movlw	D'5'		; 5 minimum
	btfss	STATUS,C	; if carry then negative
	movwf	CHASER
	btfsc	STATUS,Z
	movwf	CHASER
;
		
	decfsz	SCROLL,f
	goto	WING_R

	movlw	D'10'
	movwf	SCROLL
	bsf		DIRECTION,0	; opposite direction

; reduce wing rate
OPP_R
	movlw	D'25'		; increase flash delay
	addwf	FLASH1,f
	movlw	H'FF'
	btfsc	STATUS,C	; if carry then over
	movwf	FLASH1

; reduce chaser rate
	movlw	D'1'
	addwf	CHASER,f
	movf	CHASER,w
	sublw	D'25'		; max value
	movlw	D'25'
	btfss	STATUS,C	; if positive ok
	movwf	CHASER		; set at 25
;
	decfsz	SCROLL,f
	goto	WING_R
; delay
	movlw	D'25'
	call	DELAY2
;___________________________


; left hind wing check
	movlw	D'50'
	movwf	SCROLL
	movlw	D'250'
	movwf	FLASH1
	movlw	D'2'
	movwf	PULSE
	movlw	D'25'
	movwf	CHASER
	clrf	DIRECTION
WING_L
	call	LEDE17_19
	movf	CHASER,w
	call 	DELAYY
	call	LEDE13_15
	movf	CHASER,w
	call	DELAYY
	call	LEDE9_11
	movf	CHASER,w
	call	DELAYY
	call	FLASH_EYE1
; delay
	movf	FLASH1,w
	call	DELAYY
	decfsz	PULSE,f
	goto	WING_L
	movlw	D'2'
	movwf	PULSE

; increase or reduce flash value
	btfsc	DIRECTION,0
	goto	OPP_L
	movlw	D'10'		; decrease flash delay
	subwf	FLASH1,f
	movlw	D'10'
	btfss	STATUS,C	; if carry then negative
	movwf	FLASH1
	btfsc	STATUS,Z
	movwf	FLASH1
; increase chaser rate 
	movlw	D'1'
	subwf	CHASER,f	; increase chaser rate
	movlw	D'5'		
	subwf	CHASER,w	; check for minimum
	movlw	D'5'		; 5 minimum
	btfss	STATUS,C	; if carry then negative
	movwf	CHASER
	btfsc	STATUS,Z
	movwf	CHASER		
	decfsz	SCROLL,f
	goto	WING_L

	movlw	D'10'
	movwf	SCROLL
	bsf		DIRECTION,0	; opposite direction

; reduce wing rate
OPP_L
	movlw	D'25'		; increase flash delay
	addwf	FLASH1,f
	movlw	H'FF'
	btfsc	STATUS,C	; if carry then over
	movwf	FLASH1
; reduce chaser rate
	movlw	D'1'
	addwf	CHASER,f
	movf	CHASER,w
	sublw	D'25'		; max value
	movlw	D'25'
	btfss	STATUS,C	; if positive ok
	movwf	CHASER		; set at 25
;
	decfsz	SCROLL,f
	goto	WING_L
; ______________

; both wings check
	movlw	D'80'
	call	DELAY2

	movlw	D'50'
	movwf	SCROLL
	movlw	D'250'
	movwf	FLASH1
	movlw	D'2'
	movwf	PULSE
	movlw	D'25'
	movwf	CHASER
WING_B
; centre LEDs on as rate increases	

	movlw	D'200'		; compare flash delay
	subwf	FLASH1,w
	btfsc	STATUS,C	; if carry then negative
	goto	X1
	call	LEDC17_20
	goto	X2
X1	call	LED17_20
X2
	movf	CHASER,w
	call 	DELAYY

	movlw	D'150'		; compare flash delay
	subwf	FLASH1,w
	btfsc	STATUS,C	; if carry then negative
	goto	X3
	call	LEDC13_16
	goto	X4
X3	call	LED13_16
X4
	movf	CHASER,w
	call	DELAYY

	movlw	D'100'		; compare flash delay
	subwf	FLASH1,w
	btfsc	STATUS,C	; if carry then negative
	goto	X5
	call	LEDC9_12
	goto	X6
X5	call	LED9_12
X6
	movf	CHASER,w
	call	DELAYY

	movlw	D'50'		; compare flash delay
	subwf	FLASH1,w
	btfsc	STATUS,C	; if carry then negative
	goto	X7
	call	LED7_8
	goto	X8
X7	movlw	H'FF'
	movwf	PORTA
X8
	movlw	D'5'
	call	DELAYY

; delay
	call	FLASH_EYE1

	movf	FLASH1,w
	call	DELAYY
	decfsz	PULSE,f
	goto	WING_B
	movlw	D'2'
	movwf	PULSE
; reduce flash value

	movlw	D'20'		; decrease flash delay
	subwf	FLASH1,f
	movlw	D'10'
	btfss	STATUS,C	; if carry then negative
	movwf	FLASH1
	btfsc	STATUS,Z
	movwf	FLASH1
; increase chaser rate 
	movlw	D'1'
	subwf	CHASER,f	; increase chaser rate
	movlw	D'5'		
	subwf	CHASER,w	; check for minimum
	movlw	D'5'		; 5 minimum
	btfss	STATUS,C	; if carry then negative
	movwf	CHASER
	btfsc	STATUS,Z
	movwf	CHASER
;		
	decfsz	SCROLL,f
	goto	WING_B

; ______________
; Flying (both wings flash and centre zip movements)
FLY
	movlw	D'50'	; period
	call	FLYING_BACKWARD
	call	FLYING_FORWARD_SLOW
	call	FLYING_FORWARD
	goto	WING_WAVE

FLYING_BACKWARD; slow
	movwf	SCROLL
	clrf	CHASE
	movlw	D'2'
	movwf	PULSE
WING_ALL_B
	movf	CHASE,f
	btfss	STATUS,Z
	goto	BY_7_8
; zero
	call	LED7_8
	movlw	D'10'
	call	DELAYY
; 1
BY_7_8
	movlw	D'3'	
	xorwf	CHASE,w		; use other drive every 3 cycles
	btfsc	STATUS,Z
	goto	BC9_12
	call	LED9_12		; both wings without center LEDs
	goto	BNC9_12
BC9_12; wings plus show centre LEDs
	call	LEDC9_12
BNC9_12
	movlw	D'5'
	call	DELAYY
; 2
	movlw	D'7'	
	xorwf	CHASE,w		; use other drive every 4 cycles
	btfsc	STATUS,Z
	goto	BC13_16
	call	LED13_16		; both wings without center LEDs
	goto	BNC13_16
BC13_16; wings plus show centre LEDs
	call	LEDC13_16
BNC13_16
	movlw	D'5'
	call	DELAYY
;3
	movlw	D'11'	
	xorwf	CHASE,w		; use other drive every 4 cycles
	btfsc	STATUS,Z
	goto	BC17_20
	call	LED17_20		; both wings without center LEDs
	goto	BNC17_20
BC17_20; wings plus show centre LEDs
	call	LEDC17_20
	movlw	H'FF'
	movwf	CHASE
BNC17_20
	movlw	D'5'
	call 	DELAYY

; delay
	incf	CHASE,f		; next count
	call	FLASH_EYE1

	movf	FLASH1,w
	call	DELAYY
	decfsz	PULSE,f
	goto	WING_ALL_B
	movlw	D'2'
	movwf	PULSE

	movf	SCROLL,w
	btfss	STATUS,Z	; when 0 do not decrease
	decf	SCROLL,f

	movf	SCROLL,w
	btfss	STATUS,Z	; when 0 check CHASE, end when zero
	goto	WING_ALL_B

	movf	CHASE,w
	btfss	STATUS,Z
	goto	WING_ALL_B

	return
;
	
FLYING_FORWARD_SLOW
	movlw	D'25'	; period
	movwf	SCROLL
	clrf	CHASE
	movlw	D'2'
	movwf	PULSE
WING_ALL_S
	movf	CHASE,f
	btfsc	STATUS,Z
	goto	SC17_20
	call	LED17_20		; both wings without center LEDs
	goto	SNC17_20
SC17_20; wings plus show centre LEDs
	call	LEDC17_20
SNC17_20
	movlw	D'5'
	call 	DELAYY
	movlw	D'3'	
	xorwf	CHASE,w		; use other drive every 4 cycles
	btfsc	STATUS,Z
	goto	SC13_16
	call	LED13_16		; both wings without center LEDs
	goto	SNC13_16
SC13_16; wings plus show centre LEDs
	call	LEDC13_16
SNC13_16
	movlw	D'5'
	call	DELAYY

	movlw	D'6'	
	xorwf	CHASE,w		; use other drive every 3 cycles
	btfsc	STATUS,Z
	goto	SC9_12
	call	LED9_12		; both wings without center LEDs
	goto	SNC9_12
SC9_12; wings plus show centre LEDs
	call	LEDC9_12
SNC9_12
	movlw	D'5'
	call	DELAYY

	movlw	D'9'	
	xorwf	CHASE,w		; use other drive every 3 cycles
	btfss	STATUS,Z
	goto	WING_ALL_EXTRA_S
	call	LED7_8
	movlw	D'10'
	call	DELAYY
	movlw	H'FF'
	movwf	CHASE

WING_ALL_EXTRA_S
; delay
	incf	CHASE,f		; next count
	call	FLASH_EYE1

	movf	FLASH1,w
	call	DELAYY
	decfsz	PULSE,f
	goto	WING_ALL_S
	movlw	D'2'
	movwf	PULSE
	decfsz	SCROLL,f
	goto	WING_ALL_S
	return

FLYING_FORWARD
; fast
	movlw	D'100'	; period
	movwf	SCROLL
	clrf	CHASE
	movlw	D'2'
	movwf	PULSE
WING_ALL
	movf	CHASE,f
	btfsc	STATUS,Z
	goto	C17_20
	call	LED17_20		; both wings without center LEDs
	goto	NC17_20
C17_20; wings plus show centre LEDs
	call	LEDC17_20
NC17_20
	movlw	D'5'
	call 	DELAYY
	movlw	D'1'	
	xorwf	CHASE,w		; use other drive every 4 cycles
	btfsc	STATUS,Z
	goto	C13_16
	call	LED13_16		; both wings without center LEDs
	goto	NC13_16
C13_16; wings plus show centre LEDs
	call	LEDC13_16
NC13_16
	movlw	D'5'
	call	DELAYY

	movlw	D'2'	
	xorwf	CHASE,w		; use other drive every 3 cycles
	btfsc	STATUS,Z
	goto	C9_12
	call	LED9_12		; both wings without center LEDs
	goto	NC9_12
C9_12; wings plus show centre LEDs
	call	LEDC9_12
NC9_12
	movlw	D'5'
	call	DELAYY

	movlw	D'3'	
	xorwf	CHASE,w		; use other drive every 3 cycles
	btfss	STATUS,Z
	goto	WING_ALL_EXTRA
	call	LED7_8
	movlw	D'10'
	call	DELAYY
	movlw	H'FF'
	movwf	CHASE

WING_ALL_EXTRA
; delay
	incf	CHASE,f		; next count
	call	FLASH_EYE1

	movf	FLASH1,w
	call	DELAYY
	decfsz	PULSE,f
	goto	WING_ALL
	movlw	D'2'
	movwf	PULSE
	decfsz	SCROLL,f
	goto	WING_ALL
	return
; _____________________________

WING_WAVE
; left wing
; both wings flash and centre zip movements and left/ right wave
	clrf	CHASE		; chaser rate
	movlw	D'30'
	movwf	SCROLL		; display length/period
	movlw	D'2'
	movwf	PULSE
	movlw	D'50'
	movwf	DIM
	clrf	DIRECTION	; dimming direction
	clrf	DIVIDE
	
WING_WAVE1
	movf	CHASE,f
	btfsc	STATUS,Z
	goto	WWC17_19
	call	LED17_19		; left wing without center LEDs
	goto	WWNC17_19
WWC17_19; wing left plus show centre LEDs
	call	LEDC17_19
WWNC17_19
	movf	DIM,w
	call	DELAYX
; flash for right wing
	call	LED18_20

	movlw	D'5'
	call 	DELAYY

	movlw	D'1'	
	xorwf	CHASE,w		; use other drive every 4 cycles
	btfsc	STATUS,Z
	goto	WWC13_15
	call	LED13_15	;  wing without center LEDs
	goto	WWNC13_15
WWC13_15; wing plus show centre LEDs
	call	LEDC13_15
WWNC13_15
	movf	DIM,w
	call	DELAYX

; short flash for right wing
	call	LED14_16

	movlw	D'5'
	call	DELAYY


	movlw	D'2'	
	xorwf	CHASE,w		; use other drive every 3 cycles
	btfsc	STATUS,Z
	goto	WWC9_11
	call	LED9_11		; wing without center LEDs
	goto	WWNC9_11
WWC9_11; wings plus show centre LEDs
	call	LEDC9_11
WWNC9_11
	movf	DIM,w
	call	DELAYX
; short flash for right wing
	call	LED10_12

	movlw	D'5'
	call	DELAYY

	movlw	D'3'	
	xorwf	CHASE,w		; use other drive every 3 cycles
	btfss	STATUS,Z
	goto	WING_WAVE_EXTRA
	call	LED7_8
	movf	DIM,w
	call	DELAYX
	movlw	H'FF'
	movwf	CHASE

WING_WAVE_EXTRA
; delay
	incf	CHASE,f		; next count
	call	FLASH_EYE1

	movf	FLASH1,w
	call	DELAYY
	decfsz	PULSE,f
	goto	WING_WAVE1
	movlw	D'2'
	movwf	PULSE

;	incf	DIVIDE,f
;	btfss	DIVIDE,1
;	goto	WING_WAVE1

CK_DIR

	btfsc	DIRECTION,0
	goto	INC_L
; reduce dimming
	movlw	D'5'
	subwf	DIM,f
	movf	DIM,w
	sublw	D'1'	; minimum
	btfsc	STATUS,C
	bsf		DIRECTION,0	; reverse dimming
	goto	DIM_L_OUT
; increase dimming
INC_L
	movlw	D'5'
	addwf	DIM,f
	movf	DIM,w
	sublw	D'50'
	movlw	D'50'
	btfsc	STATUS,C
	movwf	DIM			; set at 50 Max

DIM_L_OUT
	decfsz	SCROLL,f
	goto	WING_WAVE1

; _______

; WING WAVE Right wing

	movlw	D'30'
	movwf	SCROLL
	movlw	D'2'
	movwf	PULSE
	movlw	D'50'		; dimming intial value
	movwf	DIM
	clrf	DIRECTION
	clrf	DIVIDE

WING_WAVE2
	movf	CHASE,f
	btfsc	STATUS,Z
	goto	WWC18_20
	call	LED18_20		; right wing without center LEDs
	goto	WWNC18_20
WWC18_20; wing right plus show centre LEDs
	call	LEDC18_20
WWNC18_20
	movf	DIM,w
	call	DELAYX

; short flash for left wing
	call	LED17_19
	movlw	D'5'
	call 	DELAYY

	movlw	D'1'	
	xorwf	CHASE,w		; use other drive every 4 cycles
	btfsc	STATUS,Z
	goto	WWC14_16
	call	LED14_16	;  wing without center LEDs
	goto	WWNC14_16
WWC14_16; wing plus show centre LEDs
	call	LEDC14_16
WWNC14_16
	movf	DIM,w
	call	DELAYX

; short flash for left wing
	call	LED13_15
	movlw	D'5'
	call	DELAYY

	movlw	D'2'	
	xorwf	CHASE,w		; use other drive every 3 cycles
	btfsc	STATUS,Z
	goto	WWC10_12
	call	LED10_12		; wing without center LEDs
	goto	WWNC10_12
WWC10_12; wings plus show centre LEDs
	call	LEDC10_12
WWNC10_12
	movf	DIM,w
	call	DELAYX
; short flash for left wing
	call	LED9_11
	movlw	D'5'
	call	DELAYY

	movlw	D'3'	
	xorwf	CHASE,w		; use other drive every 3 cycles
	btfss	STATUS,Z
	goto	WING_WAVE_EXTRA2
	call	LED7_8
	movf	DIM,w
	call	DELAYX
	movlw	H'FF'
	movwf	CHASE

WING_WAVE_EXTRA2
; delay
	incf	CHASE,f		; next count
	call	FLASH_EYE1

	movf	FLASH1,w
	call	DELAYY

	decfsz	PULSE,f
	goto	WING_WAVE2
	movlw	D'2'
	movwf	PULSE

;	incf	DIVIDE,f
;	btfss	DIVIDE,1
;	goto	WING_WAVE2

	btfsc	DIRECTION,0
	goto	INC_R
; reduce dimming
	movlw	D'5'
	subwf	DIM,f
	movf	DIM,w
	sublw	D'1'	; minimum 
	btfsc	STATUS,C
	bsf		DIRECTION,0	; reverse dimming
	goto	DIM_R_OUT
; increase dimming
INC_R
	movlw	D'5'
	addwf	DIM,f
	movf	DIM,w
	sublw	D'50'
	movlw	D'50'
	btfsc	STATUS,C
	movwf	DIM			; set at 50 Max
DIM_R_OUT
	decfsz	SCROLL,f
	goto	WING_WAVE2

; _____________________________
; straight ahead again
	movlw	D'50'	; period
	call	FLYING_FORWARD
; _________________________________
Landing
	call	FLYING_FORWARD_SLOW
	movlw	D'50'	; period
	call	FLYING_BACKWARD; slow
	movlw	D'5'
	movwf	CHASER

	call	LEDC17_20	
	movf	CHASER,w
	call	DELAYY
	call	LED13_16
	movf	CHASER,w
	call	DELAYY
	call	LED9_12
	movf	CHASER,w
	call	DELAYY


	movlw	D'40'
	movwf	SCROLL
LANDED 
	call	LED17_20	
	movf	CHASER,w
	call	DELAYY
	call	LED13_16
	movf	CHASER,w
	call	DELAYY
	call	LED9_12
	movf	CHASER,w
	call	DELAYY

	call	FLASH_EYE1


	movlw	D'5'		; increase flash delay
	addwf	FLASH1,f
	movlw	H'FF'
	btfsc	STATUS,C	; if carry then over
	movwf	FLASH1
	movf	FLASH1,w
	call	DELAYY

; reduce chaser rate
	movlw	D'1'
	addwf	CHASER,f
	movf	CHASER,w
	sublw	D'25'		; max value
	movlw	D'25'
	btfss	STATUS,C	; if positive ok
	movwf	CHASER		; set at 25
;
	decfsz	SCROLL,f
	goto	LANDED

	movlw	D'50'
	call	DELAY2
	
; ________________________________
END_RUN

	movlw	D'1'
	movwf	SCROLL
CENTRE_ZIP
	call	LED7_8
	movlw	D'50'
	call	DELAY2
	call	LED5_6
	movlw	D'20'
	call 	DELAY2
	call	LED3_4
	movlw	D'20'
	call	DELAY2	
	call	LED1_2
	movlw	D'20'
	call	DELAY2
	call	FLASH_EYE
	movlw	D'5'
	call	DELAY2	
	decfsz	SCROLL,f
	goto	CENTRE_ZIP
	
; right eye
	movlw	B'11110111'	; RA3
	movwf	PORTA
; left eye
	movlw	B'10111111'	; RB6
	movwf	PORTB
	movlw	D'20'
	call	DELAY2
	
	movlw	B'11111111'
	movwf	PORTA
	movwf	PORTB		


	movlw	D'00'
	call 	EEREAD		; read EEPROM
	movwf	TEMP
	btfss	TEMP,0
	goto	CYCLE
; delay when repeat cycle
	movlw	D'5'
	movwf	TEMPB0
END_DELAY
	movlw	D'200'
	call	DELAY2
	decfsz	TEMPB0,f
	goto	END_DELAY	
	goto	CYCLE

; >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
; LED drive subroutines
EYE_L
	movlw	H'FF'
	movwf	PORTB
	movlw	B'11110111'	; RA3
	movwf	PORTA
	return
EYE_R
	movlw	H'FF'
	movwf	PORTA
	movlw	B'10111111'	; RB6
	movwf	PORTB
	return
FLASH_EYE
	call	EYE_L
	movlw	D'1'
	call	DELAY2
	call	EYE_R
	movlw	D'1'
	call	DELAY2
	return
FLASH_EYE1
	movlw	B'11110111'	; RA3
	movwf	PORTA
	movlw	B'10111111'	; RB6
	movwf	PORTB
	return
LED1_2
	movlw	H'FF'
	movwf	PORTA
	movlw	B'11011111'	; RB5
	movwf	PORTB
	return
LED3_4	
	movlw	H'FF'
	movwf	PORTB
	movlw	B'10111111'	; RA6
	movwf	PORTA
	return
LED5_6	
	movlw	H'FF'
	movwf	PORTB
	movlw	B'11111101'	; RA1
	movwf	PORTA
	return
LED7_8	
	movlw	H'FF'
	movwf	PORTB
	movlw	B'11111011'	; RA2
	movwf	PORTA
	return

; add eyes to LEDs
LEDE1_2
	movlw	B'10111111'	; RB6
	movwf	PORTB
	movlw	B'11010111'	; RB5, RA3
	movwf	PORTB
	return
LEDE3_4	
	movlw	B'10111111'	; RB6
	movwf	PORTB
	movlw	B'10110111'	; RA6, RA3
	movwf	PORTA
	return
LEDE5_6	
	movlw	B'10111111'	; RB6
	movwf	PORTB
	movlw	B'11110101'	; RA1, RA3
	movwf	PORTA
	return
LEDE7_8	
	movlw	B'10111111'	; RB6
	movwf	PORTB
	movlw	B'11110011'	; RA2, RA3
	movwf	PORTA
	return

LED9_11	
	movlw	H'FF'
	movwf	PORTB
	movlw	B'11101111'	; RA4
	movwf	PORTA
	return
LEDE9_11	
	movlw	B'10111111'	; RB6
	movwf	PORTB
	movlw	B'11100111'	; RA4, RA3
	movwf	PORTA
	return
LED10_12
	movlw	H'FF'
	movwf	PORTB	
	movlw	B'11111110'	; RA0
	movwf	PORTA
	return
LEDE10_12
	movlw	B'10111111'	; RB6
	movwf	PORTB	
	movlw	B'11110110'	; RA0, RA3
	movwf	PORTA
	return
LED13_15
	movlw	H'FF'
	movwf	PORTA	
	movlw	B'11111101'	; RB1
	movwf	PORTB
	return
LEDE13_15; plus eyes
	movlw	B'11110111'	; RA3
	movwf	PORTA	
	movlw	B'10111101'	; RB1, RB6
	movwf	PORTB
	return
LED14_16	
	movlw	H'FF'
	movwf	PORTB
	movlw	B'01111111'	; RA7
	movwf	PORTA
	return
LEDE14_16 ; plus eyes	
	movlw	B'10111111'	; RB6
	movwf	PORTB
	movlw	B'01110111'	; RA7,RA3
	movwf	PORTA
	return
LED17_19	
	movlw	H'FF'
	movwf	PORTA
	movlw	B'11111011'	; RB2
	movwf	PORTB
	return
LEDE17_19; plus eyes	
	movlw	B'11110111'	; RA3
	movwf	PORTA
	movlw	B'10111011'	; RB2,RB6
	movwf	PORTB
	return
LED18_20	
	movlw	H'FF'
	movwf	PORTA
	movlw	B'01111111'	; RB7
	movwf	PORTB
	return
LEDE18_20 ; plus eyes	
	
	movlw	B'00111111'	; RB7,RB6
	movwf	PORTB
	movlw	B'11110111'	; RA3
	movwf	PORTA
	return
LED17_20	
	movlw	H'FF'
	movwf	PORTA
	movlw	B'01111011'	; RB2,RB7
	movwf	PORTB
	return
LEDC17_20 ; plus centre LEDs 1 & 2	
	movlw	H'FF'
	movwf	PORTA
	movlw	B'01011011'	; RB2,RB7, RB5
	movwf	PORTB
	return
LED13_16
	movlw	B'11111101'	; RB1
	movwf	PORTB
	movlw	B'01111111'	; RA7
	movwf	PORTA
	return
LEDC13_16 ; plus LEDs 3 & 4
	movlw	B'11111101'	; RB1
	movwf	PORTB
	movlw	B'00111111'	; RA7, RA6
	movwf	PORTA
	return
LED9_12	
	movlw	H'FF'
	movwf	PORTB
	movlw	B'11101110'	; RA4,RA0
	movwf	PORTA
	return
LEDC9_12 ; plus LEDs 5 & 6	
	movlw	H'FF'
	movwf	PORTB
	movlw	B'11101100'	; RA4,RA0, RA1
	movwf	PORTA
	return

; plus centre LEDs
LEDC9_11; + LEDS 5 & 6	
	movlw	H'FF'
	movwf	PORTB
	movlw	B'11101101'	; RA4, RA1
	movwf	PORTA
	return
LEDC10_12 ; + LEDs 5 & 6
	movlw	H'FF'
	movwf	PORTB	
	movlw	B'11111100'	; RA0, RA1
	movwf	PORTA
	return
LEDC13_15 ; + LEDs 3 & 4
	movlw	B'11111101'	; RB1
	movwf	PORTB
	movlw	B'10111111'	; RA6
	movwf	PORTA
	return
LEDC14_16 ; + LEDs 3 & 4	
	movlw	H'FF'
	movwf	PORTB
	movlw	B'00111111'	; RA7, RA6
	movwf	PORTA
	return
LEDC17_19 ; + LEDs 1 & 2	
	movlw	H'FF'
	movwf	PORTA
	movlw	B'11011011'	; RB2, 5
	movwf	PORTB
	return
LEDC18_20	
	movlw	H'FF'
	movwf	PORTA
	movlw	B'01011111'	; RB7, 5
	movwf	PORTB
	return
			
; ****************************************************

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,ADON	; A/D on
	movlw	D'50'
	call	DELAY2
	bsf		ADCON0,2	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	bcf		ADCON0,ADON	; A/D off
	movf	ADRESH,w
	return

DELAY1
	movlw	D'5'
DELAY2
	movwf	STORE1
LOOP2
	movlw	D'100'
	movwf	STORE2
LOOP1
	decfsz	STORE2,f
	goto	LOOP1
	decfsz	STORE1,f
	goto	LOOP2
	return


DELAYX
	movwf	STORE1
LOOPX2
	decfsz	STORE1,f
	goto	LOOPX2
	return

DELAYY
	movwf	STORE1
LOOPY2
	movlw	D'25'
	movwf	STORE2
LOOPY1
	decfsz	STORE2,f
	goto	LOOPY1
	decfsz	STORE1,f
	goto	LOOPY2
	return

; subroutine to read EEPROM memory 

EEREAD
	bsf 	STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM
EWRITE
EEWRITE	
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register

	bsf 	STATUS,RP0	; select memory bank 3
WR3	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE	; disable interrupts
	bcf		EECON1,EEPGD
	bsf		EECON1,WREN	; enable write
	movlw	H'55'		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
;	bsf 	INTCON,GIE	; enable interrupts
WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 	STATUS,RP0	; select memory bank 0
	return				; value written 

; multiply
;
;       Input:  fixed point arguments in AARG and BARG
;
;       Output: product AARGxBARG in AARG
;

;       16x16 Bit Unsigned Fixed Point Multiply 

;       Input:  16 bit unsigned fixed point multiplicand in AARGB0,1
;               16 bit unsigned fixed point multiplier in BARGB0,1

;       Use:    CALL    FXM1616U

;       Output: 32 bit unsigned fixed point product in AARGB0,1,2,3

FXM1616U 	
			    CLRF    AARGB2          ; clear partial product
                CLRF    AARGB3
                MOVF    AARGB0,W
                MOVWF   TEMPB0
                MOVF    AARGB1,W
                MOVWF   TEMPB1
                MOVLW   H'08'
                MOVWF   LOOPCOUNT
LOOPUM1616A     RRF     BARGB1, F
                BTFSC   STATUS,C
                GOTO    ALUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616A
                MOVWF   LOOPCOUNT
LOOPUM1616B     RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    BLUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616B
                CLRF    AARGB0
                CLRF    AARGB1
				RETLW   H'00'
BLUM1616NAP     BCF     STATUS,C
                GOTO    BLUM1616NA
ALUM1616NAP     BCF     STATUS,C
                GOTO    ALUM1616NA
ALOOPUM1616     RRF     BARGB1, F
                BTFSS   STATUS,C
                GOTO    ALUM1616NA
                MOVF    TEMPB1,W
                ADDWF   AARGB1, F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0, F
ALUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                DECFSZ LOOPCOUNT, F
                GOTO   ALOOPUM1616
                MOVLW  H'08'
                MOVWF  LOOPCOUNT
BLOOPUM1616     RRF    BARGB0, F
                BTFSS  STATUS,C
                GOTO   BLUM1616NA
                MOVF   TEMPB1,W
                ADDWF  AARGB1, F
                MOVF   TEMPB0,W
                BTFSC  STATUS,C
                INCFSZ TEMPB0,W
                ADDWF  AARGB0, F
BLUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                RRF    AARGB3, F
                DECFSZ LOOPCOUNT, F
                GOTO   BLOOPUM1616
				RETURN

;       16/8 Bit Unsigned Fixed Point Divide 16/8 -> 16.08

;       Input:  16 bit unsigned fixed point dividend in AARGB0, AARGB1
;               8 bit unsigned fixed point divisor in BARGB0

;      ;       Output: 16 bit unsigned fixed point quotient in AARGB0, AARGB1
;               8 bit unsigned fixed point remainder in REMB0

;       Result: AARG, REM  <--  AARG / BARG

DIV16_8		 
	  			CLRF            REMB0
                MOVLW           H'08'
                MOVWF           LOOPCOUNT

LOOPU1608A      RLF             AARGB0,W
                RLF             REMB0, F
                MOVF            BARGB0,W
                SUBWF           REMB0, F

                BTFSC           STATUS,C
                GOTO            UOK68A          
                ADDWF           REMB0, F
                BCF             STATUS,C
UOK68A          RLF             AARGB0,F

                DECFSZ          LOOPCOUNT,F
                GOTO            LOOPU1608A
                CLRF            TEMP1
                MOVLW           H'08'
                MOVWF           LOOPCOUNT

LOOPU1608B      RLF             AARGB1,W
                RLF             REMB0, F
                RLF             TEMP1, F
                MOVF            BARGB0,W
                SUBWF           REMB0, F
                CLRF            AARGB3
                CLRW
                BTFSS           STATUS,C
                INCFSZ          AARGB3,W
                SUBWF           TEMP1, F

                BTFSC           STATUS,C
                GOTO            UOK68B          
                MOVF            BARGB0,W
                ADDWF           REMB0,F
                CLRF            AARGB3
                CLRW
                BTFSC           STATUS,C
                INCFSZ          AARGB3,W
                ADDWF           TEMP1,F

                BCF             STATUS,C
UOK68B          RLF             AARGB1,F

                DECFSZ          LOOPCOUNT,F
                GOTO            LOOPU1608B
                return


	end
