
/* Arduino_UVI_meter_sketch.ino
   a sketch for an Arduino based UVI meter using the
   UVM30A UV sensor module, or one of the many similar
   modules using the GUVA-S12SD UV sensor.
   Written by Jim Rowe (Silicon Chip)
   Version 1.0, updated 28/10/2022 at 1:25 pm
 
   Note: the project is designed to use a 16x2 LCD module with a
   serial I2C 'piggyback' interface based on a PCF8574T serial to
   parallel converter. These have an I2C address in the range from
   20-27h, with the highest address corresponding to all three
   links on the piggyback PCB being OPEN.
   However some modules have a PCF8574AT converter chip instead,
   and these have a different I2C address range: from 38-3Fh.
   If you have one of these latter modules, the only change that
   should need to be made is to change the address in line 20 below.
 */
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2);   // set the LCD address to 0x27,
                                    // with 2 x 16 char lines
//pinMode(A0,INPUT);    // set A0 as an analog input
// ====================================================================
// declaration of global variables

int Vout;     // voltage reading from UVM-30A
String UVI = "0";  // string to store the UVI level

// ====================================================================
// setup function begins here
// ====================================================================
void setup()
{
  lcd.begin();
  Serial.begin(9600);   // starts up serial comms to PC for testing   
  lcd.backlight();    // turn on LCD's LED backlight
  lcd.setCursor(2,0);     // and show opening screen
  lcd.print("Silicon Chip");
  lcd.setCursor(0,1);
  lcd.print("  UVI Meter");

  Serial.println("Silicon Chip UVI Meter");  // for testing
  delay(2000);            // then pause for 2 seconds

} // end of setup function

 // ===================================================================
 // main loop() function begins here
 // ===================================================================
void loop()
{
  lcd.clear();                // first clear LCD screen
  
  Vout = (analogRead(0)) * (5.0 / 1023.0) * 1000; // read Vout (from UVM-30A, in mV)
  if(Vout <= 227)  // if Vout is less than 227mV
    {
    UVI = "0";
    }  
  else if (Vout>227 && Vout<=318)
    {
      UVI = "1";
    }
  else if (Vout>318 && Vout<=408)
    {
      UVI = "2";
    }
  else if (Vout>408 && Vout<=500)
    {
      UVI = "3";
    }
  else if  (Vout>500 && Vout<=600)
    {
      UVI = "4";
    }
  else if (Vout>600 && Vout<=700)
    {
      UVI = "5";     
    }
  else if (Vout>700 && Vout<=800)
    {
      UVI = "6";
    }
  else if (Vout>800 && Vout<=880)
    {
      UVI = "7";
    }
  else if (Vout>880 && Vout<=975)
    {
      UVI = "8";
    }
  else if (Vout>975 && Vout<=1075)
    {
      UVI = "9";
    }
  else if (Vout>1075 && Vout<=1170)
    {
      UVI = "10";
    }
  else
    {
      UVI = "11+";   
    }
  lcd.setCursor(2,0);     // set LCD cursor to first line
  lcd.print("UV Index = " + UVI); // and print UV index
  lcd.setCursor(0,1);     // then move to second line
  lcd.print("  (Vout = " + String(Vout) + "mV)");
  
  Serial.println(String(Vout) + " mV so UV Index = " + UVI);
  delay(1500);
}      // end of main loop

// =====================================================================
//    end of code
