//Tim Blythman
#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  

//pinouts:
//RC4 MOSI
//RC5 SCK
//RC3 CS
//RC2 AREF (1.6V AN6)
//RB4 AC_OUT (OUT AN10)
//RC0 3V3 (3.3V AN4/VREF+)
//RB5 SW1
//RB6 SW2
//RC6 LED1
//RC7 LED2
//RB7 LED3

//ADC channels
#define MID_REF (6)
#define AC_OUT (10)

#define MOSI LATCbits.LATC4
#define SCK LATCbits.LATC5
#define CS LATCbits.LATC3
#define SW1 PORTBbits.RB5
#define SW2 PORTBbits.RB6
#define LED1 LATCbits.LATC6
#define LED2 LATCbits.LATC7
#define LED3 LATBbits.LATB7

//#define ADC_OS (16)
#define ADC_OS (1)

#define _XTAL_FREQ (48000000UL)

void ioinit(void);
int getADC(char n);   //turn on ADC and get result from selected channel
void setDP(unsigned char c, unsigned char v);   // set channel c to position v

#endif	/* IO_H */

