//Tim Blythman
#include "io.h"
//pinouts:
//RC4 MOSI
//RC5 SCK
//RC3 CS
//RC2 AREF (1.6V AN6)
//RB4 AC_OUT (OUT AN10)
//RC0 3V3 (3.3V AN4/VREF+)
//RB5 SW1
//RB6 SW2
//RC6 LED1
//RC7 LED2
//RB7 LED3

void ioinit(void){
    ANSELA=0;
    ANSELB=0;
    ANSELC=0;
    
    //analog
    ANSELCbits.ANSC2=1; //AREF 1.6V
    ANSELBbits.ANSB4=1; //AC_OUT
    ANSELCbits.ANSC0=1; //3.3V AN4/VREF+
    
    //digital inputs for SW1/SW2
    TRISBbits.TRISB5=1;
    TRISBbits.TRISB6=1;
    WPUBbits.WPUB5=1;
    WPUBbits.WPUB6=1;
    OPTION_REGbits.nWPUEN=0;

    //digital outputs
    TRISCbits.TRISC4=0;
    TRISCbits.TRISC5=0;
    TRISCbits.TRISC3=0;
    TRISCbits.TRISC6=0;
    TRISCbits.TRISC7=0;
    TRISBbits.TRISB7=0;
    MOSI=0;
    SCK=0;
    CS=1;       //idle high/off
    //LED1=1;
    //LED2=1;
    //LED3=1;

    //ADC
    ADCON0=0;   //off
    ADCON1=0b11100010;   //Right justify,FOSC/64,VREF+
    //ADCON1=0b11100000;   //Right justify,FOSC/64,VDD
    ADCON2=0;           //no trigger
    ADCON0bits.ADON=1;  //ready

    //TIMER2
    T2CON=0;    //reset
    //T2CONbits.T2CKPS=1; //4
    T2CONbits.T2CKPS=2; //16
    //T2CONbits.T2OUTPS=9;    //10
    TMR2=0;
    //PR2=249;    //4x250=1000, nominally 12kHz
    PR2=124;    //16x125=2000, nominally 6kHz
    PIR1bits.TMR2IF=0;
    PIE1bits.TMR2IE=1;
    INTCONbits.PEIE=1;
    GIE=1;
    T2CONbits.TMR2ON=1;
}

int getADC(char n){   //get result from preselected channel
    int i,j;
    j=0;
    ADCON0bits.CHS=n;
    ADCON0bits.ADGO=1;              //start a dummy reading
    while(ADCON0bits.ADGO){}        //wait till done
    for(i=0;i<ADC_OS;i++){
        ADCON0bits.ADGO=1;          //start
        while(ADCON0bits.ADGO){}    //wait till done
        j=j+ADRES;        
    }
    return j;    
}

void setDP(unsigned char c, unsigned char v){   // set channel c to position v
    //10 bit data stream easily done by bitbanging
    CS=0;
    if(c&  2){MOSI=1;}else{MOSI=0;}SCK=1;SCK=0;
    if(c&  1){MOSI=1;}else{MOSI=0;}SCK=1;SCK=0;
    if(v&128){MOSI=1;}else{MOSI=0;}SCK=1;SCK=0;
    if(v& 64){MOSI=1;}else{MOSI=0;}SCK=1;SCK=0;
    if(v& 32){MOSI=1;}else{MOSI=0;}SCK=1;SCK=0;
    if(v& 16){MOSI=1;}else{MOSI=0;}SCK=1;SCK=0;
    if(v&  8){MOSI=1;}else{MOSI=0;}SCK=1;SCK=0;
    if(v&  4){MOSI=1;}else{MOSI=0;}SCK=1;SCK=0;
    if(v&  2){MOSI=1;}else{MOSI=0;}SCK=1;SCK=0;
    if(v&  1){MOSI=1;}else{MOSI=0;}SCK=1;SCK=0;    
    CS=1;
}