' PICAXE-08 based ultrasonic rangefinder
' By Andrew Partridge

symbol receiver		= 1		'pin number of the receiver pin
symbol receiver_in	= PIN1
symbol receiver_high	= %00000010
symbol receiver_low	= %00000000

symbol transmitter	= 4		'pin number of the transmitter pin
symbol transmitter_high	= %00010000
symbol transmitter_low	= %00000000
symbol sample_count	= w0
symbol time_to_echo	= w1
symbol burst_time		= w2
symbol distance		= w3

' Charge C2 until receiver pin is high. 
   
charge:
 pause 100					'allow any echoes to subside
 let dirs = receiver_low + transmitter_high	'receiver pin is input,
						'transmitter pin is output

 let pins = receiver_high + transmitter_high	'transmitter pin high

charge_loop:
  output receiver			'set receiver pin briefly to high output,
  input receiver			'then to input

  if receiver_in = 0 then charge_loop	'loop until C2 voltage exceeds high
					'input threshold of receiver pin

' Discharge C2 to below the high input threshold of the receiver pin.
' Discharge for a pulse, then ensure receiver pin doesn't go high for
' 30 tests. If it goes high before 30 tests, discharge some more.

  let pins = receiver_low + transmitter_high	'receiver pin will go low when
					    	'it is made an output
discharge_pulse:
  output receiver			'set receiver pin briefly to low output
  input receiver			'then to input
  let sample_count = 0

discharge_loop:
  if receiver_in = 1 then discharge_pulse
  let sample_count = sample_count + 1
  if sample_count < 30 then discharge_loop

' C2 is now initialised.
' Transmit a burst of ultrasonic energy and measure how long before it
' returns. For now the measurement is displayed in the debug window in
' register w3 in millimetres.

  low transmitter			'initiate 300us burst of 40kHz sound
  input transmitter			'5ms from now
  pulsin receiver,0,time_to_echo	'measure time between end of burst
					'and first pulse at receiver
  high transmitter

' Measure length of transmit burst and add to time

  if time_to_echo = 0 then no_echo	'only adjust if echo received
  low transmitter			'initiate transmit burst
  input transmitter

  pulsin receiver,1,burst_time		'measure length of transmit burst
  high transmitter
  let time_to_echo = time_to_echo + burst_time

no_echo:

' Calculate distance in millimetres.
' At 20 degrees C the speed of sound is about 343m/s. The echo travels
' the distance to the obstacle twice, and time is in 10us units, so
' multiply count by 3.4 / 2 to obtain the distance in millimetres.

  let distance = time_to_echo * 17	'multiply count by 1.7 to get
  let distance = distance / 10		'distance in mm.
  debug distance
  goto charge
