'Pulse length measurement and display
'By Brett Cupitt

'PICAXE-28X

'Registers,b10,b11 (w5) = pulse length
'b5 = 7 segment display, segment config data 
'b0 = temporary/working register
'b1-b4 = digits to be displayed; b1=MSB, b3=LSB


init:
  let w5=0		'clear W5 value

measure:		'pulse length measure routine
  pulsin 0,1,w5		'read pulse length on input 0 into w5
  if w5>0 then decode:	'if we have a reading, process it
  goto measure:		'loop if no value

decode:			'are we measuring uS or mS
  if w5>99 then ms:	'if its a value in mS, go to mS section
  low portc 2 		'OK, its a value in uS, turn uS LED on
  let b1=w5/10		'MSB
  let b2=w5//10		'2nd digit
  let b3=0		'LSB
  goto display:		'now display it

ms:
  high portc 2		'turn mS LED on
  if w5>9999 then high_ms 'is it a big or little number?
  high portc 3		'decimal point on
  let b0=w5/100		'get the 1st 2 digits
  let b1=b0/10		'MSB
  let b2=b0//10		'2nd
  let b3=w5//100/10	'LSB
  goto display:		'now display it

high_ms:
  let b0=w5/1000	'get 1st 2 digits
  let b1=b0/10		'get MSB
  let b2=b0//10 	'get 2nd digit
  let w4=b0*1000	'calculate the 1000's
  let w4=w5-w4		'take these away from the total
  let b3=w4/100		'the hundreds are left, get the MSB

display:		'start of data display routine
  lookup b3,($7e,$0C,$B6,$9E,$CC,$DA,$FA,$0E,$FE,$DE),b5
  low portc 6		'turn off MSB
  let pins=b5		'output 7 segment display sequence
  high portc 4		'turn on LSB
  pause 6		'hold for 6mS

  lookup b2,($7e,$0C,$B6,$9E,$CC,$DA,$FA,$0E,$FE,$DE),b5
  low portc 4		'clear LSB
  let pins=b5		'output 7 segment display sequence
  high portc 5		'turn on 2nd digit
  pause 4		'hold for 4mS

  lookup b1,($7e,$0C,$B6,$9E,$CC,$DA,$FA,$0E,$FE,$DE),b5
  low portc 5		'turn off 2nd digit
  if b1=0 then display:	'blank leading zeroes
  let pins=b5		'output 7 segment display sequence
  high portc 6		'turn on MSB
  pause 4		'hold for 4mS
  goto display:		'cycle

