' Water Pump Controller  v1.00
' By Jeff Monegal

' PICAXE-08

start:
  symbol	cntr = b2			  
  symbol	time = w0
  symbol	pump = 2
  symbol	bell = 0
  symbol	reset = pin3

begin:
  low	pump			'make sure pump is enabled
  cntr = 0			'clear the "pump off time" counter

main_lp:
  if pin4 = 0 then run		'if pin 4 goes low the pump is running
  goto	main_lp

run:
  pause 	2000		'debounce the pump for 2 seconds
  if pin4 = 1 then main_lp	'if pin4 = 1 then false start
  gosub	read_time		'read the "time set switch"

time_loop:
  time = time - 1
  if time = 0 then alarm
  if pin4 = 1 then is_pump_stopped 'pump off for > 20 secs?
  cntr = 0
  goto	all_ok

is_pump_stopped:
  pause	100			'pump debounce delay
  if pin4 = 0 then all_ok	'if pump still on the continue
  cntr = cntr + 1		'count seconds pump is off
  if cntr = 20 then begin	'if > 20 secs put system in standby

all_ok:
  pause	1000
  goto	time_loop

alarm:
  high	pump			'disable the pump

loop:
  pulsout	bell,50		'sound the buzzer
  pause	300
  pulsout	bell,50		'sound the buzzer again
  if reset = 0 then begin	'if reset switch pressed, reset system
  pause	3000
  goto	loop

'This routine looks at the select time switch (S1)
'and loads required value into "time" variable

read_time:
  readadc	1,b0
  if b0 > 30 then four
  time = 5400
  return
		
four:
  if b0 > 55 then three
  time = 2700
  return

three:
  if b0 > 83 then two
  time = 1800
  return

two:
  if b0 > 110 then one
  time = 1200
  return	

one:
  time = 900
  return	
