'Six Station Sprinkler Controller
'By Ron Russo

'PICAXE-08

' NOTE: Values shown for b2 (minutes variable) are for maximum
' allowable time of 20 minutes each but they can be any length
' as long as the total time for the six does not exceed 119 minutes.
' If less stations are needed, then change the program or just put
' the same last time into redundant stations.

Symbol Work_Led = 4	'pin for indicator LED
dirs = %00010111	'set for 4 outputs

Main:
  if pin3=1 then Sec_Pulse 'is Pin3 is high goto Sec_Pulse 
  low Work_Led		'if not then turn LED off
  goto Main

Sec_Pulse:
  high Work_Led		'a pulse so turn LED on
  pause 50		'wait 50 ms (30 ms clock pulse ended) 
  let b1=b1+1		'increment seconds
  if b1=60 then Min_Up	'if 60 seconds are up goto Min_Up
 
ChK_Day:
  if b3=0 then Station_1  'if time first day goto Station_1 
  if b3=24 then Station_1 'if time second day goto Station_1 
  if b3=48 then Station_1 'if time last day goto Station_1  
  goto Main

Min_Up:
  let b1=0		'minute is up so reset seconds variable
  let b2=b2+ 1		'increment minutes variable 
  if b2=120 then Hours2_Up  'if 2 hour block is up goto Hours2_Up 
  goto ChK_Day		'if not goto Chk_day to see if is a water day 

Station_1:
  if b2>20 then Station_2 'if minutes > 20 goto second station
  let pins=1		'else set pins to turn on Station 1
  goto Main

Station_2:
  if b2>40 then Station_3 'if minutes > 40 goto third station
  let pins=2		'else set pins to turn on Station 2
  goto Main

Station_3:
  if b2>60 then Station_4 'if minutes > 60 goto forth station
  let pins=3		'else set pins to turn on Station 3 
  goto Main

Station_4:
  if b2>80 then Station_5 'if minutes > 80 goto Fifth Station
  let pins=4		'else set pins to turn on Station 4 
  goto Main

Station_5:
  if b2>100 then Station_6 'if minutes > 100 goto sixth station
  let pins=5		  'else set pins to turn on Station 5 
  goto Main

' (Last station minute variable value must be less than 120)
Station_6:
  if b2>118 then Station_OFF 'if minutes > 118 go turn off station
  let pins=6		  'else set Pins to turn on Station 6 
  goto Main

Hours2_Up:
  let b2=0		'previous 2 hours up, reset minutes 
  let b3=b3+1		'increment 2 hour block
  if b3<83 then main
  let b3 = 0

Station_OFF:
  let pins=0		'last station time up, clear pins to turn off 	
  goto Main



