'PICAXE-18X Datalogger Humidity Control Program
'Silicon Chip, March 2004 

SYMBOL temperature = w0
SYMBOL temperatureLSB = b0
SYMBOL temperatureMSB = b1
SYMBOL humidity = w1
SYMBOL scratchpad = w2
SYMBOL address = w3
SYMBOL counter = w4

main:
  for counter = 1 to 12	'(12 x 5 seconds = 1 minute)

'Read and correct RH value

do_RH:
  readadc 1,humidity
  let humidity = humidity - 41 * 100 / 157

'Switch fan on or off as ncessary

control_fan:
  if humidity < 60 then fan_on

fan_off:
  low 0			'switch fan on
  goto do_temp

fan_on:
  high 0		'switch fan off

'Read raw 12 bit data from DS18B20 temperature sensor

do_temp:
  readtemp12 7,temperature

'Correct data into two bytes:
' temperatureMSB = value before decimal place
' scratchpad = value after decimal place

  temperatureMSB = temperature / 16
  temperatureLSB = temperatureLSB & $0F
  scratchpad = temperatureLSB * 625 / 10

'Display humidity and temp on serial LCD

do_display:
  serout 6,N2400,(254,128,"RH%  = ", #humidity)
  serout 6,N2400,(254,192,"Temp = ", #temperatureMSB, ".")

  if scratchpad > 0 then skip00
  serout 6,N2400,("0")	'display leading 0 if required

skip00:
  if scratchpad > 100 then skip0
  serout 6,N2400,("0")	'display leading 0 if required

skip0:
  serout 6,N2400,(#scratchpad)

  pause 5000		'wait 5 seconds
  next counter		'next loop

'1 minute is up so log temperature and humidity

log_data:
  high 3				'LED green
  low 5					'write enable

  i2cslave %10100010, i2cfast, i2cword	'set block1 parameters
  writei2c address,(humidity)		'write the value
  pause 10		'wait EEPROM write time

  i2cslave %10100100, i2cfast, i2cword	'set block2 parameters
  writei2c address,(temperatureLSB)	'write the value
  pause 10		'wait write time

  i2cslave %10100110, i2cfast, i2cword	'set block3 parameters
  writei2c address,(temperatureMSB)	'write the value
  pause 10		'wait write time

  high 5		'write protect EEPROM
  low 3			'LED off

  let address = address + 1		'increment address
  if address < 65535 then main		'if memory not full loop

end
