'-----------------------------------------------------------
'Train motor controller for use with Picaxe 08 micro and 
'Oatley TX7 & RX7 UHF remote control modules.
'23/2/04
'-----------------------------------------------------------
'assumes 4 outputs from R/C (active high inputs to picaxe)
'Accelerate	- pin 2
'Brake		- pin 3 (input only)
'Forward	- pin 4
'Reverse	- no pin
'
'2 outputs from picaxe
'Motor 		- pin 0 (output only)
'Reverse relay	- pin 1 (is also the analogue capable pin)
'-----------------------------------------------------------

symbol motor=0		'motor is pin 0
symbol relay=1		'reversing relay on pin 1
   
symbol rawspeed=b0	'value 0 to 255 (max speed) 
symbol MARK=b1		'MARK is motor on time
'			'0 to period = rawspeed*Period/256 
symbol Space=b2		'SPACE is Period-MARK
symbol k=b3		'loop counter
symbol Period=16 	'ms of motor control period MARK+SPACE=Period
symbol Numloops=8	'loops before reading inputs
			'ACCTC=10s  time to go from 0 to full in sec
			'BRTC=5s  time to stop from full speed in sec
symbol ACCstep=4	'(10s) '=255*Numloops*Period/ACCTC/1000
symbol BRstep=6		'(5s)  '=255*Numloops-Period/BRTC/1000
symbol Maxspeed=224	'define when reached max speed...

'-----------------------------------------------------------
'read input buttons, do direction first.

buttons:
  if rawspeed>16 and pin4=1 then Emergency 'trying to reverse at speed=STOP!
  if rawspeed>30 then accel		'if moving, don't look at reversing!
  if pin4=1 and pin3=0 then forwarder	'forward Tx button pressed
  if pin4=1 and pin3=1 then reverser	'reverse Rx button pressed -
  goto accel				'no call for direction change

Emergency:
  PAUSE 10				'10ms delay to ensure is not interference
  if pin4=0 then buttons
  rawspeed = rawspeed/2			'emergency brake if hit direction buttons
  goto control				'will stop from max in 1/2 sec approx.


forwarder:
  LOW relay				'deenergise rev relay
  goto accel

reverser:
  HIGH relay				'energise rev relay
  Pause 500				'delay so that if pin4 released before pin3
'					'it doesn't go back to Forward direction.

'-----------------------------------------------------------
'now look at accel and brake buttons

accel:	
  if rawspeed>=MaxSpeed then chkBrakeButton  'already at top speed
  if pin2=1 then speedup
  if rawspeed<16 then control		'0-15 means already stopped.
'					'(Note: 16=256/Period)
  goto chkBrakeButton

speedup:  
  rawspeed = rawspeed+ACCstep   'increase raw speed by step chosen.
  goto control

chkBrakeButton: 
  if pin3<>1 then control	'brake button not pressed.
  if rawspeed<48 then reduceBr  'reduce brake rate for last two speed steps
  rawspeed = rawspeed-BRstep	'decrease rawspeed by usual step
  goto control

reduceBr:  
  rawspeed=rawspeed-2		'reduce brake rate as approach stop

'-----------------------------------------------------------
'now send control pulse to motor

control:
  if rawspeed<16 then buttons		'stopped so don't process motor
  MARK = rawspeed/16
  Space = period-MARK	

  for k=1 to numloops
  High motor
  if rawspeed>=MaxSpeed then buttons	'leave on all the time for max speed
  pause MARK				'motor on pulse for MARK ms
  Low motor
  Pause Space
  next k

  goto buttons
