'                         GARAGE DOOR MONITOR - PICAXE 14M2
'                               (gdmonitor_14m2.bas)
'----------------------------------------------------------------------------------
' This program should be down loaded to both transmit and receive microprocessors.  
' The logic level on the C.0 input will select either transmit or receive programs.
' You may select your own PIN code - change in both transmit and receive programs.
' Transmitter operates once a second to allow other transmitters on same frequency. 
'----------------------------------------------------------------------------------

set_up:' ------------- select either the transmit or receive programs -------------
pause 10
if pinC.0 = 1 then goto xmit_main
if pinC.0 = 0 then: high C.4: goto recv_main: endif

'--------------------------------- TRANSMIT PROGRAM -------------------------------
'Communication uses 8 bytes of Manchester encoded data transmitted once each second.

xmit_main:'----------- check door limits and output status each second.------------
for b0 = 0 to 100
if pinC.1 = 1 then: b1 = 1:else b1 = 0: endif'  (open1)
if pinC.2 = 1 then: b2 = 1:else b2 = 0: endif'  (close1)
if pinC.3 = 1 then: b3 = 1:else b3 = 0: endif'  (open2)
if pinC.4 = 1 then: b4 = 1:else b4 = 0: endif'  (close2)
pause 10
next b0
'goto pin_code

pin_code:'-------- also include a four digit PIN code (2468 is default) -----------
pause 2 
b5 = 2: b6 = 4: b7 = 6: b8 = 8 
'goto xmit_mode

xmit_mode:'-------- flash TXL LED and transmit door status and PIN code -----------
high B.5: high B.1
rfout B.2, (b1,b2,b3,b4,b5,b6,b7,b8)
low B.5: low B.1 
goto xmit_main

'--------------------------------- RECEIVE PROGRAM---------------------------------           
'Press the run PB and release when door LEDs light - LEDs will remain on for 15 sec.

recv_main:'--------- receiver waits for a transmission to be picked up ------------
pause 2
rfin C.3, b1,b2,b3,b4,b5,b6,b7,b8
'goto pin_check

pin_check:'--------- test PIN code (2468 is the default) retry if wrong -----------
pause 2 
if b5 = 2 and b6 = 4 and b7 = 6 and b8 = 8 then goto recv_mode 
goto recv_main

recv_mode:'-------- flash RXL LED and drive DOOR LEDs (keep on 15 sec) -----------
high C.0
high C.4
if b1 = 1 then: high B.5: else low B.5: endif'             (open1)
if b2 = 1 then: high B.3: else low B.3: endif'             (close1)
if b3 = 1 then: high B.2: else low B.2: endif'             (open2)
if b4 = 1 then: high B.0: else low B.0: endif'             (close2)
if b1 = 0 and b2 = 0 then: high B.4: else low B.4: endif'  (midway1)
if b3 = 0 and b4 = 0 then: high B.1: else low B.1: endif'  (midway2)
pause 50
low C.4
inc b0
if b0 > 15 then: low C.0: endif
goto recv_main 



    
'------------------------------------- VARIABLES ----------------------------------     
' b0  -   -   -   =  temporary variable 
' b1, b2, b3, b4  =  door status 
' b5, b6, b7, b8  =  PIN code 
'----------------------------------------------------------------------------------




'NOTE; Both the transmitter and receiver were built into plastic jiffy boxes, 
'      using a metal enclosure would complicate the provision of the antenna. 




'                         TYPICAL RECEIVER FRONT PANEL LAYOUT
'                             (components are in brackets)             
'---------------!-----------------------------------------------------!------------ 
'               !                                                     !
'               !      DOOR 1            RXL              DOOR 2      !
'               !                                                     ! 
'               !                                                     !        
'               !   (LED1)  Open        (LED7)         Open  (LED4)   ! 
'               !                                                     !
'               !                                                     !                         
'               !   (LED2)  Midway                   Midway  (LED5)   ! 
'               !                                                     !
'               !                                                     !                             
'               !   (LED3)  Close       (SW1)         Close  (LED6)   !                              
'               !                                                     ! 
'               !                                                     !             
'               !      DOOR 1            RUN              DOOR 2      !
'               !                                                     !              
----------------!-----------------------------------------------------!------------              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
