'Simon Says Game for AXE106K & PICAXE-18A

' *** Define the variables used ***
symbol randword = w0		'random number (word)
symbol randbyte = b0		'random number (byte, part of w0)
symbol value = b2		'switch value 0-1-2-3 
symbol playerstep = b3		'position of player in game
symbol freq = b4		'sound variable
symbol topstep = b5		'number of steps in sequence
symbol counter = b6		'general purpose counter
symbol speed = b7		'playback speed


' *** Section 1 **********************
' Wait for any switch to be pushed

init:
  let pins = %00001111		'light all LEDs
  random randword		'randomise
  if pin0 = 1 then preload	'check switches
  if pin1 = 1 then preload
  if pin6 = 1 then preload
  if pin7 = 1 then preload
  goto init

' *** Section 2 ****************************
' Load EEPROM data memory with 100 numbers

preload:
  let pins = %00000000		'LEDs off
  for counter = 0 to 100	'for..next loop

  let value = 0
  random randword		'get random number 
  if randbyte > 180 then set0
  if randbyte > 120 then set1
  if randbyte > 60 then set2

set3: 	let value = value + 1	'1+1+1 = 3
set2: 	let value = value + 1	'1+1 = 2
set1:	let value = value + 1	'1
set0:				'0

  write counter,value		'save in data memory
  next counter			'next loop

' *** Section 3 ****************************
' This section plays back a sequence 

  let pins = %00000000		'LEDs off
  let topstep = 1		'reset step number to 1

playback:
  readadc 2,speed		'read speed value from preset

  for counter = 1 to topstep	'for...next loop
  read counter,value		'get value
  gosub beep			'make the noise
  pause 300			'short delay
  next counter			'loop

' *** Section 4 *****************************************
' Now the user responds

  playerstep = 1

' If playerstep is greater than topstep then all done
gameloop:
  if playerstep > topstep then success	
  read playerstep,value	'recall correct value		

loop:
  if pin7 = 1 then pushed0	'wait for switch press
  if pin0 = 1 then pushed1
  if pin1 = 1 then pushed2
  if pin6 = 1 then pushed3
  goto loop

' Now check correct value depending on which switch was pressed
pushed0:				
  if value <> 0 then fail
  let playerstep = playerstep + 1
  gosub beep
  goto gameloop

pushed1:
  if value <> 1 then fail
  let playerstep = playerstep + 1
  gosub beep
  goto gameloop

pushed2:
  if value <> 2 then fail
  let playerstep = playerstep + 1
  gosub beep
  goto gameloop

pushed3:
  if value <> 3 then fail
  let playerstep = playerstep + 1
  gosub beep
  goto gameloop

' Failed so make noise and jump back to start
fail: 
  let pins = %0000000		'all LEDs off
  sound 7,(80,100)		'make a noise
  sound 7,(50,100)
  goto init			'back to start

' Succeeded so add another step to sequence and loop
success:
  pause 100			'short delay
  let pins = %00001111		'all LEDs on
  sound 7,(120,50)		'success beep
  let pins = %00000000		'all LEDs off
  pause 100			'short delay
  let topstep = topstep + 1	'add another step
  goto playback			'loop again

' *** Section 5 ****************
'Sub-procedure to light correct LED and make beep

beep:
  high value			'switch on LED
  freq = value + 1 * 25		'generate sound freq.
  sound 7,(freq,speed)		'play sound
  low value			'switch off LED
  return			'return
