VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form Form1 
   Caption         =   "Silicon Chip ECG Sampler"
   ClientHeight    =   8340
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   10710
   LinkTopic       =   "Form1"
   ScaleHeight     =   8340
   ScaleWidth      =   10710
   StartUpPosition =   3  'Windows Default
   Begin MSComctlLib.ProgressBar pbSampleProgress 
      Height          =   255
      Left            =   2040
      TabIndex        =   6
      Top             =   7920
      Visible         =   0   'False
      Width           =   8415
      _ExtentX        =   14843
      _ExtentY        =   450
      _Version        =   393216
      BorderStyle     =   1
      Appearance      =   1
   End
   Begin VB.CommandButton cmdGoSample 
      Caption         =   "Start Sampling"
      Height          =   735
      Left            =   120
      TabIndex        =   5
      Top             =   3720
      Width           =   1095
   End
   Begin MSComDlg.CommonDialog dbComDlog1 
      Left            =   720
      Top             =   6360
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      DialogTitle     =   "Print a Sample File"
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   600
      Top             =   7200
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
   End
   Begin VB.PictureBox picDisplay 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      DrawWidth       =   2
      FillColor       =   &H0080FF80&
      FillStyle       =   0  'Solid
      ForeColor       =   &H0080FF80&
      Height          =   7200
      Left            =   1440
      ScaleHeight     =   7200
      ScaleMode       =   0  'User
      ScaleWidth      =   9000
      TabIndex        =   0
      Top             =   600
      Width           =   9000
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "Sampler Gain set to:"
      Height          =   375
      Left            =   120
      TabIndex        =   10
      Top             =   2160
      Width           =   1095
   End
   Begin VB.Label lblGainDisplay 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "(Not Set)"
      Height          =   255
      Left            =   120
      TabIndex        =   9
      Top             =   2640
      Width           =   1095
   End
   Begin VB.Label lblSampleRateDisplay 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "(Not Selected)"
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   1320
      Width           =   1095
   End
   Begin VB.Label lblSamplingRate 
      Caption         =   "Sampling Rate:"
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   1080
      Width           =   1215
   End
   Begin VB.Label lblSettingsDisplay 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "9600,N,8,1"
      Height          =   255
      Left            =   8520
      TabIndex        =   4
      Top             =   120
      Width           =   1935
   End
   Begin VB.Label lblSettingsLabel 
      Caption         =   "Settings (bps,parity,data bits,stop bits):"
      Height          =   255
      Left            =   5640
      TabIndex        =   3
      Top             =   120
      Width           =   2775
   End
   Begin VB.Label lblPortDisplay 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "5"
      Height          =   255
      Left            =   4680
      TabIndex        =   2
      Top             =   120
      Width           =   495
   End
   Begin VB.Label lblPortLabel 
      Caption         =   "USB Sampler Virtual COM Port:"
      Height          =   255
      Left            =   2280
      TabIndex        =   1
      Top             =   120
      Width           =   2295
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu FileOpen 
         Caption         =   "&Open a data sample file"
      End
      Begin VB.Menu mnuPrint 
         Caption         =   "&Print these samples"
      End
      Begin VB.Menu mnuSave 
         Caption         =   "&Save data sample file"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "&Exit"
      End
   End
   Begin VB.Menu mnuSettings 
      Caption         =   "&Settings"
      Begin VB.Menu mnuSetComPort 
         Caption         =   "Set Virtual &Com Port"
      End
      Begin VB.Menu mnuAdjustBaudrate 
         Caption         =   "Set &Baud Rate"
         Begin VB.Menu mnuSet9600 
            Caption         =   "&9600 bps"
         End
         Begin VB.Menu mnuSet28800 
            Caption         =   "&28800 bps"
         End
         Begin VB.Menu mnuSet38400 
            Caption         =   "&38400 bps"
         End
      End
      Begin VB.Menu mnuSetSamplingRate 
         Caption         =   "Set &Sampling Rate"
         Begin VB.Menu mnu500SamplesPerSec 
            Caption         =   "&500 samples/sec"
         End
         Begin VB.Menu mnu1000SamplesPerSec 
            Caption         =   "&1000 samples/sec"
         End
         Begin VB.Menu mnu2000SamplesPerSec 
            Caption         =   "&2000 samples/sec"
         End
      End
      Begin VB.Menu mnuSetGain 
         Caption         =   "Set &Gain"
         Begin VB.Menu mnuSetHighGain 
            Caption         =   "&High (4000)"
         End
         Begin VB.Menu mnuSetLowGain 
            Caption         =   "&Low (2000)"
         End
      End
      Begin VB.Menu mnuSetPrintFont 
         Caption         =   "Set &Printer Font"
      End
   End
   Begin VB.Menu mnuAbout 
      Caption         =   "&About"
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Control/Display Software for USB-linked ECG Sampler
'written for Silicon Chip magazine by Jim Rowe
'Last revised 29/12/2004

Option Explicit
Dim intSampleCounter As Integer:            'data array counter/pointer
Dim intCOMPort As Integer:                  'current COM port for USB sampler
Dim intGain As Integer:                     'current gain setting
Dim intResp As Integer:                     'response variable from dialog boxes
Dim strPrompt As String:                    'prompt string for dialog boxes etc
Dim strCrLf As String:                      'string for Cr & Lf
Dim strBaud As String:                      'current baud rate setting for COM port
Dim strSaveFileName As String:              'filename for saving a set of samples
Dim strSampleRateCode As String:            'sample rate code to send to Sampler
Dim strPrintFontName As String:             'user selected printer font
Dim bytSamples(0 To 8191) As Byte:          'array for storage of data samples

Private Sub Form_Load()
    Dim strFetchStrg As String
    Call ClearDataArray
    Call DisplayData
    strSaveFileName = ""
    strCrLf = Chr(13) + Chr(10)
    strSampleRateCode = "1":                'code for default sampling rate
    intCOMPort = 5:                         'default COM port setting for USB
    strBaud = "38400":                      'default baud rate
    intGain = 2000:                         'and gain setting
    On Error GoTo ErrorHandler
    Open "ECGSAMPL.cfg" For Input As #3:    'if there's a config file, open it
        Input #3, strFetchStrg:             'skip past header line
        Input #3, strFetchStrg:             'and date/time stamp line
        Input #3, strSaveFileName:          'get name of last data file used
        Input #3, intCOMPort:               'and last COM port used
        Input #3, strBaud:                  'and its baud setting
        Input #3, strSampleRateCode:        'and last sampling rate code
        Input #3, intGain:                  'and last gain settings
        Input #3, strPrintFontName:         'finally last printer font used
    Close #3
    lblPortDisplay.Caption = CStr(intCOMPort)
    Call ShowPortSettings
    With MSComm1:                           'now set up COM port control
        .CommPort = intCOMPort:             'set COM port number
        .RThreshold = 1:                    'set Rx threshold to 1 char
        .SThreshold = 2:                    'and Tx threshold to 2 chars
        .Handshaking = comNone:             'set for no handshaking
        .InBufferSize = 8192:               'set input buffer for 8192 samples
        .InputLen = 8192:                   '& getting 8192 bytes at a time
        .InputMode = comInputModeBinary:    'set for binary input
    End With
    Call ShowSampleRate
    Call ShowGainSetting
    Call DisplayData:                       'show blank display
    Exit Sub:                               'this is normal exit
    
ErrorHandler:
    Close #3:                               'no config file, or corrupted; so
    Call DisplayData:                       'show blank display only
End Sub

Private Sub mnu1000SamplesPerSec_Click()
    strSampleRateCode = "1"
    Call ShowSampleRate
    Call DisplayData
End Sub

Private Sub mnu2000SamplesPerSec_Click()
    strSampleRateCode = "2"
    Call ShowSampleRate
    Call DisplayData
End Sub

Private Sub mnu500SamplesPerSec_Click()
    strSampleRateCode = "5"
    Call ShowSampleRate
    Call DisplayData
End Sub

Private Sub mnuAbout_Click()
    strPrompt = "Control Program for Silicon Chip's USB Driven ECG Sampler" + strCrLf
    strPrompt = strPrompt + "Version 1.0, written by Jim Rowe" + strCrLf
    strPrompt = strPrompt + "Last Modified 14/12/2004"
    intResp = MsgBox(strPrompt, vbOKOnly, "About this program")
End Sub

Private Sub mnuPrint_Click()
    Dim intNumCopies As Integer
    Dim intLineCtr As Integer, bytData As Byte
    Dim intXval As Integer, intYval As Integer
    Dim currDateTime As Variant
    dbComDlog1.CancelError = True
    On Error GoTo dbErrorHandler
    dbComDlog1.ShowPrinter:                     'show printer dialog box
    intNumCopies = dbComDlog1.Copies:           'and set number of copies
    Printer.DrawWidth = 1:                      'now set line width to 1
    Printer.Orientation = vbPRORLandscape:      '& set up printer
    Printer.ScaleHeight = 9600
    Printer.ScaleLeft = -200
    Printer.ScaleWidth = 17400
    Printer.ScaleTop = -500
        Printer.ForeColor = &HC0C0C0:            'set colour to light grey
        For intLineCtr = 1 To 81
            intXval = 600 + (intLineCtr * 200): 'do light vert grat lines
            Printer.Line (intXval, 100)-(intXval, 6500)
        Next intLineCtr
        For intLineCtr = 0 To 24
            intYval = 228 + (intLineCtr * 256): '& light horiz lines
            Printer.Line (600, intYval)-(16984, intYval)
        Next intLineCtr
        Printer.ForeColor = &H808080:           'set colour to midgrey
        Printer.DrawWidth = 8:                  '& set line width to 5
        Printer.Line (600, 100)-(16984, 100):    'then draw main plot frame
        Printer.Line (16984, 100)-(16984, 6500)
        Printer.Line (16984, 6500)-(600, 6500)
        Printer.Line (600, 6500)-(600, 100)
        For intLineCtr = 1 To 8
            intXval = 600 + (intLineCtr * 2000):    'draw main vert grat lines
            Printer.Line (intXval, 100)-(intXval, 6575)
        Next intLineCtr
        For intLineCtr = 0 To 4
            intYval = 740 + (intLineCtr * 1280):    '& main horiz grat lines
            Printer.Line (525, intYval)-(16984, intYval)
        Next intLineCtr
        Printer.ForeColor = &H0&:                   'change colour to black
        Printer.FontName = strPrintFontName:        'and set printer font
        Printer.FontSize = 10: Printer.FontBold = True    'then print legends
        Printer.CurrentX = 250: Printer.CurrentY = 3200
        Printer.Print "0"
        Printer.CurrentX = 200: Printer.CurrentY = 20
        Printer.Print "mV"
        Printer.CurrentX = 200: Printer.CurrentY = 6380
        Printer.Print "mV"
        Printer.FontBold = False
        Printer.FontSize = 8
        If intGain = 2000 Then
            Printer.CurrentX = 100: Printer.CurrentY = 625
            Printer.Print "+1.0"
            Printer.CurrentX = 100: Printer.CurrentY = 1900
            Printer.Print "+0.5"
        Else
            Printer.CurrentX = 100: Printer.CurrentY = 625
            Printer.Print "+0.5"
            Printer.CurrentX = 20: Printer.CurrentY = 1900
            Printer.Print "+0.25"
        End If
        If intGain = 2000 Then
            Printer.CurrentX = 120: Printer.CurrentY = 5750
            Printer.Print "-1.0"
            Printer.CurrentX = 120: Printer.CurrentY = 4475
            Printer.Print "-0.5"
        Else
            Printer.CurrentX = 120: Printer.CurrentY = 5750
            Printer.Print "-0.5"
            Printer.CurrentX = 40: Printer.CurrentY = 4475
            Printer.Print "-0.25"
        End If
        Printer.CurrentX = 13000: Printer.CurrentY = 6850
        Printer.FontBold = True
        Printer.Print "SECONDS"
        Printer.FontBold = False
        Select Case strSampleRateCode
            Case "5"
                For intLineCtr = 0 To 16
                    Printer.CurrentX = 550 + (intLineCtr * 998)
                    Printer.CurrentY = 6580
                    Printer.Print CStr(intLineCtr)
                Next intLineCtr
            Case "1"
                For intLineCtr = 0 To 8
                    Printer.CurrentX = 550 + (intLineCtr * 1999)
                    Printer.CurrentY = 6580
                    Printer.Print CStr(intLineCtr)
                Next intLineCtr
            Case "2"
                For intLineCtr = 0 To 4
                    Printer.CurrentX = 550 + (intLineCtr * 4000)
                    Printer.CurrentY = 6580
                    Printer.Print CStr(intLineCtr)
                Next intLineCtr
        End Select
        
        Printer.FontSize = 12:                      'now print ID line
        Printer.FontBold = True
        currDateTime = Now
        Printer.CurrentX = 550: Printer.CurrentY = 6900
        Printer.Print "Silicon Chip ECG Sampler: " + CStr(currDateTime)
        
        For intSampleCounter = 0 To 8191:           'now plot data
            Printer.ForeColor = &H0&:               'set colour to black
            intXval = 600 + (intSampleCounter * 2): 'get X position
            bytData = bytSamples(intSampleCounter): 'get data value
            intYval = 6500 - (bytData * 25):        'and hence Y position
            Printer.Circle (intXval, intYval), 5:   'then plot, as tiny circle
        Next intSampleCounter:                      'loop until all samples done
        Printer.EndDoc:                             'then send it all to printer
    Exit Sub:                                       'leave when done
    
dbErrorHandler:
    Exit Sub:                               'user pressed Cancel button, so leave
End Sub

Private Sub mnuSet28800_Click()
    strBaud = "28800"
    Call ShowPortSettings
    
End Sub

Private Sub mnuSet38400_Click()
    strBaud = "38400"
    Call ShowPortSettings
End Sub

Private Sub mnuSet9600_Click()
    strBaud = "9600"
    Call ShowPortSettings
End Sub

Private Sub mnuSetComPort_Click()
    Dim strDefault As String, intPortEntry As Integer
    strPrompt = "Set virtual COM port to which USB Sampler is connected:"
    strPrompt = strPrompt + strCrLf + "1-15"
    strDefault = "5"
    intPortEntry = CInt(InputBox(strPrompt, "Set COM Port", strDefault))
    If intPortEntry < 1 Or intPortEntry > 15 Then Exit Sub
    intCOMPort = intPortEntry
    lblPortDisplay.Caption = CStr(intCOMPort)
    MSComm1.CommPort = intCOMPort
End Sub

Private Sub mnuExit_Click()
    Dim intQuitConfirm As Integer, intSaveConfirm As Integer
    Dim currDateTime As Variant
    strPrompt = "Sure you want to quit now?"
    intQuitConfirm = MsgBox(strPrompt, vbYesNoCancel, "Quit check")
    If intQuitConfirm = 6 Then
        strPrompt = "Want to save current display data before leaving?"
        intSaveConfirm = MsgBox(strPrompt, vbYesNo, "Save check")
        If intSaveConfirm = 6 Then
            Call SaveData:                  'yes, so go do it
        End If
        currDateTime = Now
        Open "ECGSAMPL.cfg" For Output As #3:   'now save config file
        Print #3, "Config file for ECG Sampler Display Program V1.0"
        Print #3, "Saved " + CStr(currDateTime)
        Print #3, strSaveFileName
        Print #3, intCOMPort
        Print #3, strBaud
        Print #3, strSampleRateCode
        Print #3, intGain
        Print #3, strPrintFontName
        Close #3
        If MSComm1.PortOpen = True Then MSComm1.PortOpen = False:  'close port
        End                                 'before we leave
    End If                                  'user didn't really want to go
        
End Sub

Private Sub cmdGoSample_Click()
    If MSComm1.PortOpen = False Then MSComm1.PortOpen = True: 'open port if nec
    MSComm1.Output = "C" + strSampleRateCode:   'send command string to sampler
    MSComm1.DTREnable = True:                   'then set DTR true
    intSampleCounter = 0:                       'reset data array pointer
    pbSampleProgress.Value = 0:                 'reset progress bar
End Sub

Private Sub FileOpen_Click()
    Call OpenDataFile:                          'first open a file
    Call DisplayData:                           'then show data on screen
End Sub

Public Sub ClearDataArray()
    For intSampleCounter = 0 To 8191
        bytSamples(intSampleCounter) = 128
    Next intSampleCounter
    
End Sub

Public Sub OpenDataFile()
    Dim bytData As Byte
    dbComDlog1.Filter = "ECG Sample Data File (*.ECG)| *.ECG"
    dbComDlog1.CancelError = True
    dbComDlog1.DialogTitle = "Open a Data file: Select Filename"
    dbComDlog1.Flags = &H1000
    dbComDlog1.FileName = strSaveFileName:      'offer last filename as default
    On Error GoTo dbErrorHandler
    dbComDlog1.ShowOpen:                        'open com dialog box for opening
    strSaveFileName = dbComDlog1.FileName:      'and get data file name
    Open strSaveFileName For Input As #1:       'open up data file
    Input #1, strSampleRateCode:                'then get sample rate
    Input #1, intGain:                          'and gain setting
    Call ShowSampleRate: Call ShowGainSetting:  'then show them, before
    For intSampleCounter = 0 To 8191
        Input #1, bytData:                      'reading in data bytes
        bytSamples(intSampleCounter) = bytData: 'and storing them in array
    Next intSampleCounter
    Close #1                                    'then close file before
    Call DisplayData:                           'displaying data
    Exit Sub:                                   'and leaving
    
dbErrorHandler:
    Exit Sub:                                   'must have hit Cancel, so leave
End Sub

Public Sub SaveData()
    Dim bytData As Byte
    dbComDlog1.Filter = "ECG Sample Data File (*.ECG)| *.ECG"
    dbComDlog1.CancelError = True
    dbComDlog1.DialogTitle = "Save Data: Give a Filename"
    On Error GoTo dbErrorHandler
    dbComDlog1.ShowSave:                        'open com dialog box for saving
    strSaveFileName = dbComDlog1.FileName:      'and get data file name
    Open strSaveFileName For Output As #1:      'then open it for saving
    Print #1, strSampleRateCode:                'save sample rate
    Print #1, intGain:                          'and gain setting
    For intSampleCounter = 0 To 8191:           'then save all samples too...
        bytData = bytSamples(intSampleCounter)
        Print #1, bytData
    Next intSampleCounter
    Close #1:                                   'finally close file before exit
    Exit Sub
    
dbErrorHandler:
    Exit Sub:                                   'must have hit Cancel, so bail out
    
End Sub

Private Sub mnuSave_Click()
    Call SaveData
End Sub

Public Sub DisplayData()
    picDisplay.Cls
    Call ShowGraticule
    For intSampleCounter = 0 To 8191
        Call PlotSample
    Next intSampleCounter
    
End Sub

Public Sub ShowGraticule()
    Dim intLineCtr As Integer
    Dim intXval As Integer, intYval As Integer
    picDisplay.DrawWidth = 1:                       'now set line width to 1
   picDisplay.ForeColor = &H80C0FF:                   'set colour to light orange
    For intLineCtr = 1 To 81
        intXval = 600 + (intLineCtr * 100):            'draw light vert lines
        picDisplay.Line (intXval, 100)-(intXval, 6500)
    Next intLineCtr
      For intLineCtr = 0 To 24
        intYval = 228 + (intLineCtr * 256):            '& light horiz lines
        picDisplay.Line (600, intYval)-(8792, intYval)
    Next intLineCtr
    picDisplay.ForeColor = &H80FF&:                    'set colour to orange
    picDisplay.DrawWidth = 2:                       '& set line width to 2
    picDisplay.Line (600, 100)-(8792, 100):         'then draw main frame
    picDisplay.Line (8792, 100)-(8792, 6500)
    picDisplay.Line (8792, 6500)-(600, 6500)
    picDisplay.Line (600, 6500)-(600, 100)
    For intLineCtr = 1 To 8
        intXval = 600 + (intLineCtr * 1000):             'draw main vert lines
        picDisplay.Line (intXval, 100)-(intXval, 6575)
    Next intLineCtr
    For intLineCtr = 0 To 4
        intYval = 740 + (intLineCtr * 1280):             '& main horiz lines
        picDisplay.Line (525, intYval)-(8792, intYval)
    Next intLineCtr
 
    picDisplay.ForeColor = &HFFFFFF:                    'change colour to white
    picDisplay.FontSize = 10: picDisplay.FontBold = True    'then print legends
    picDisplay.CurrentX = 250: picDisplay.CurrentY = 3200
    picDisplay.Print "0"
    picDisplay.CurrentX = 200: picDisplay.CurrentY = 20
    picDisplay.Print "mV"
    picDisplay.CurrentX = 200: picDisplay.CurrentY = 6380
    picDisplay.Print "mV"
    picDisplay.FontBold = False
    If intGain = 2000 Then
        picDisplay.CurrentX = 100: picDisplay.CurrentY = 625
        picDisplay.Print "+1.0"
        picDisplay.CurrentX = 100: picDisplay.CurrentY = 1900
        picDisplay.Print "+0.5"
    Else
        picDisplay.CurrentX = 100: picDisplay.CurrentY = 625
        picDisplay.Print "+0.5"
        picDisplay.CurrentX = 20: picDisplay.CurrentY = 1900
        picDisplay.Print "+0.25"
    End If
    If intGain = 2000 Then
        picDisplay.CurrentX = 120: picDisplay.CurrentY = 5750
        picDisplay.Print "-1.0"
        picDisplay.CurrentX = 120: picDisplay.CurrentY = 4475
        picDisplay.Print "-0.5"
    Else
        picDisplay.CurrentX = 120: picDisplay.CurrentY = 5750
        picDisplay.Print "-0.5"
        picDisplay.CurrentX = 40: picDisplay.CurrentY = 4475
        picDisplay.Print "-0.25"
    End If
    picDisplay.CurrentX = 7050: picDisplay.CurrentY = 6850
    picDisplay.FontBold = True
    picDisplay.Print "SECONDS"
    picDisplay.FontBold = False
    Select Case strSampleRateCode
        Case "5"
            For intLineCtr = 0 To 16
                picDisplay.CurrentX = 550 + (intLineCtr * 498)
                picDisplay.CurrentY = 6580
                picDisplay.Print CStr(intLineCtr)
            Next intLineCtr
        Case "1"
            For intLineCtr = 0 To 8
                picDisplay.CurrentX = 550 + (intLineCtr * 999)
                picDisplay.CurrentY = 6580
                picDisplay.Print CStr(intLineCtr)
            Next intLineCtr
        Case "2"
            For intLineCtr = 0 To 4
                picDisplay.CurrentX = 550 + (intLineCtr * 2000)
                picDisplay.CurrentY = 6580
                picDisplay.Print CStr(intLineCtr)
            Next intLineCtr
    End Select
    
End Sub

Public Sub PlotSample()
    Dim intXvalue As Integer, intYvalue As Integer
    Dim bytData As Byte
    picDisplay.ForeColor = &HFF00&                  'set colour to green
    intXvalue = 600 + intSampleCounter:             'get X position
    bytData = bytSamples(intSampleCounter)
    intYvalue = 6500 - (bytData * 25):              'and Y position
    picDisplay.Circle (intXvalue, intYvalue), 1:    'then plot, as tiny circle
    
End Sub


Private Sub mnuSetHighGain_Click()
    intGain = 4000
    Call ShowGainSetting
    Call DisplayData
    
End Sub

Private Sub mnuSetLowGain_Click()
    intGain = 2000
    Call ShowGainSetting
    Call DisplayData
    
End Sub

Private Sub mnuSetPrintFont_Click()
    dbComDlog1.CancelError = True
    dbComDlog1.DialogTitle = "Select A Printer Font"
    dbComDlog1.Flags = cdlCFPrinterFonts
    On Error GoTo dbErrorHandler
    dbComDlog1.ShowFont:                                'open com dialog for fonts
    strPrintFontName = dbComDlog1.FontName
    Exit Sub
    
dbErrorHandler:
    Exit Sub:                                           'must have hit cancel...
End Sub

Private Sub MSComm1_OnComm()
    Dim bytInput() As Byte
    Dim lngCharCtr As Long
    If MSComm1.CommEvent = comEvReceive Then            'make sure it's data coming
        pbSampleProgress.Max = 100:                     'if so, initialise prog bar
        pbSampleProgress.Visible = True:                '& make it visible
        MSComm1.InBufferCount = 0:                      'clear Rx buffer
        lngCharCtr = 1:                                 'reset timing counter
        'now wait until all samples are in buffer
        Do While MSComm1.InBufferCount < 8160
            pbSampleProgress.Value = CInt(100 * (MSComm1.InBufferCount / 8192))
        Loop
        lngCharCtr = CLng(MSComm1.InBufferCount)
        bytInput() = MSComm1.Input:                     'now get data from Rx buffer
        MSComm1.PortOpen = False:                       'close port
        'now transfer from one array to the other
        For intSampleCounter = 0 To CInt(lngCharCtr - 1)
            bytSamples(intSampleCounter) = bytInput(intSampleCounter)
            pbSampleProgress.Value = CInt(100 * (intSampleCounter / 8192))
        Next intSampleCounter:                          'do all samples
        pbSampleProgress.Visible = False:               'finally hide progress bar
        Call DisplayData:                               'and display new data
    End If
End Sub

Public Sub ShowSampleRate()
    Select Case strSampleRateCode
    Case "1"
        lblSampleRateDisplay.Caption = "1000 per sec"
    Case "2"
        lblSampleRateDisplay.Caption = "2000 per sec"
    Case "5"
        lblSampleRateDisplay.Caption = "500 per sec"
    Case Else
        lblSampleRateDisplay.Caption = "Not Selected"
    End Select
    
End Sub

Public Sub ShowPortSettings()
    Dim strCOMParams As String
    strCOMParams = strBaud + ",N,8,1"
    lblSettingsDisplay.Caption = strCOMParams
    MSComm1.Settings = strCOMParams:                'where we actually set them
End Sub

Public Sub ShowGainSetting()
    lblGainDisplay.Caption = CStr(intGain)
End Sub

Public Sub ShowErrorMsg()
    Dim intConf As Integer
    strPrompt = "Sampler may have stopped prematurely!"
    intConf = MsgBox(strPrompt, vbOKOnly, "Sampler Problem")
End Sub
