'=> uhfcbds.bas <=  477MHz licence free UHF CB & DS18B20 combo- Ver 1.0  Boxing Day 2004 
'For Silicon Chip Picaxe article (March 2005 ?) via Stan. Swan => s.t.swan@massey.ac.nz 
'UHF CB sends audible Ch.22/23 temperature data via Dallas Semi.DS18B20 & Picaxe-08M
'interfaced (as human readable audio tones) to a Jaycar DC1030 UHF CB 1/2W transceiver.
'NOTE: ACA/RFS regs.say "UHF CB data Ch.22/23 max. duty cycle just 3 seconds an hour"...
'Temp range tested from subzero freezer (~-4C) to high 30s C, but OK even higher ~55 C?
'DS18B20 draws ~9mA,so Ch.4 used to just switch on as needed & thus enhance battery life
'Many audible ways to pass data of course,but our simple approach suits kids & oldies!
'Morse involves *#%@^! training,while technique here just involves listening & counting
'Considerable enhancement scope as 08M memory barely half used! Store & forward EEPROM?
'See David Lincoln's Vol.2 'Expts in Mechatronics' P.18-25 for number massaging insights 
'Refer circuit layout =>www.picaxe.orcon.net.nz/uhfcbds.jpg & program .../uhfcbds.bas
' --------------------------------------------------------------------------------------
'b0 = direct Celsius temp value read from 3 lead DS18B20 temperature IC
'b1 = 10s values (heard as longer pulses ) obtained by integer division
'b2 = units value (shorter beeps up to 9 in value) by isolating remainder
'b3 = loop multiplier for 10s- thus 20 C will have 2 longer beeps
'b4 = loop multipier for units- so  17 C will have 1 long & 7 short beeps
'b5 = -ve temps subzero correcting factor
'b6 = -ve temps subzero loop multiplier to give "urgent" beeps
'---------------------------------------------------------------------------------------
tempds:
wait 2			'transmitter "tail" hold on to avoid click confusion with beeps
low 2:low 4			'ensure ch.2 LED & ch.4 supply (to DS18B20) are both off 
sleep 2			'master delay -alter to suit (units 2.3 sec)for other intervals
high 2: high 4		'turn on LED/LDR combo & also DS18B20
wait 1			'transmitter & DS18B20 settling time before reading
sound 0,(95,3,0,3,100,3,0,3,105,3,0,3,110,3) ' warble alert pre data arrival 
wait 1			'1 sec pause to allow listener attention for data 

readtemp 1,b0		'Picaxe 08M (or perhaps 18X) command to read ch.1 DS18B20
if b0=0 then zero		'test if  DS18B20 at zero Celsius (water freezing point) 
if b0>128 then subzero	'test for DS18B20 sensor subzero correction as b0 values >128

b1= b0/10			'divide original b0 temp to get 10s value
b2= b0//10			'divide original b0 temp so remainder yields units value
if b0<10 then units	'bypass tens sounds if temps below 10 Celsius
'debug			'suitable spot to note b0 etc variable values when fine tuning?
'---------------------------------------------------------------------------------------
tens:
 for b3=1 to b1
  sound 0,(100,50,0,50)	' longer beeps for 10s. Thus 20 Celsius = 2 long beeps
 next b3
'---------------------------------------------------------------------------------------
units:
if b2=0 then tempds	'units nulling factor if temps are exact multiples of 10C
 for b4=1 to b2
  sound 0,(100,5,0,50)	'shorter beeps for units, so 9 C = 9 short beeps
 next b4
goto tempds			'read sensor again
'---------------------------------------------------------------------------------------
zero: 
 sound 0,(100,500)	'prolonged tone to indicate zero Celsius
goto tempds			'read sensor again
'---------------------------------------------------------------------------------------
subzero:
 b5=b0-128			'correcting factor for DS18B20 when reading subzero
 for b6=1 to b5
  sound 0,(120,5,0,50) 	'more alarming 'frosty' beeps,since now below freezing !
 next b6
goto tempds			'read sensor again




