;		PICAXE-08 CODE for LAP COUNTER
;     using 4553 and 4511 to drive 2 ZD1850 displays
;
;Define inputs and outputs
;
	symbol	msin = pin4
	symbol  evenodd = pin3
	symbol  blankdisp = 0
	symbol  addcount = 2
	symbol  odd = 1
;
;Set output states
;
	high	blankdisp
	high 	odd
	low	addcount
;
;
	wait	3			;allow IC2 to reset
;
init:	if evenodd > 0 then initeven	;if jumper missing start at 0 & inc by 2
	if msin = 0 then initodd
	goto	init			;
;
initodd:low	odd			;else jumper fitted, IC2 pin 11 high
	pause	10			;hold high for 10 mS
	high	odd			;then take low, 1 clocked into counter
	goto	unblank			;(Q2 inverts logic)
;
initeven:if msin = 0 then inccount	;wait for microswitch to close
	goto	initeven		;
;
inccount:high	addcount		;2 counts must be added to the display
	pause 	10			;take IC2 pin 12 low for 10mS (Q3 inverts)
	low 	addcount		;then high for 2 mS
	pause 	2			;
	high	addcount		;then low for another 10 mS
	pause 	10			;
	low	addcount		;then high again
	goto	unblank			;now show the new count
;
unblank:low	blankdisp		;take IC3 pin 4 high for 5 seconds
	wait 	5			;(Q1 inverts logic)
	high	blankdisp		;turn display off
	goto 	initeven		;wait for next closure of microswitch

