
'***************************************************************************************
' Title		Security Lights Controller
'
' Start date	18 May 2004
'
' Author	Jeff MONEGAL
'
' Processor	PICAXE 08
'
'**************************************************************************************

symbol timer = w6		'used as a lights on timer

'--------------------------------------------------------------------------------------
' The value in the B0 register from the readadc command below may need to be changed to
' suit different types of LDR. Just use the debug command to monitor the value given by
' your particular LDR. Don't forget to change the rest of the readadc values throughout
' the program.
'--------------------------------------------------------------------------------------

start:
  readadc 1,b0			'read the LDR
  debug b0			'look at the value given by your LDR
  if b0 < 140 then night_time	'if less than 140 then it is night time
  goto start

night_time:
  if input2 = 0 then detect		
  readadc 1,b0
  if b0 > 140 then maybe_daytime
  goto night_time

detect:
  pause 100			'short delay then look at the PIR again to confirm
  if input2 = 0 then yes_detect	'a movement detection and not just noise
  goto night_time

yes_detect:
  timer = 0			'clear timer counter
  high 4			'turn on the lights

time_loop:
  readadc 1,b0
  if b0 > 140 then maybe_daytime
  timer = timer + 1		'add one to the time counter
  if timer > 3000 then time_out	'change to suit your installation
  pause 100			'(3000 x 200mS = 600s)
  if input2 = 1 then time_loop
  pause 100			'short delay then look again for movement
  if input2 = 1 then time_loop
  timer = 0			'reset timer if movement detected
  goto time_loop

time_out:
  low 4				'turn the lights off
  pause 3000			'3s before lights can be triggered again
  goto night_time

maybe_daytime:
  pause 2000
  readadc 1,b0
  if b0 > 140 then is_daytime
  goto	night_time

is_daytime:
  low 4				'turn lights off in case they are on
  goto start











