' PICAXE Colour Sensor
' Silicon Chip, June 2005

' Listing 1

'********************************************
' PICAXE-08M input/output pins
'********************************************

symbol LED = 0		'colour sensor white LEDs (output 0)
symbol S2 = 1		'colour sensor select S2 (output 1)
symbol ser = 2		'servo or serial LCD (output 2)
symbol CSI = 3		'colour sensor pulse (input 3)
symbol S3 = 4		'colour sensor select S3 (output 4)

'********************************************
' Variables (w4-w6 uses b8-b13!)

symbol red_value = w4	'colour sensor red content
symbol blue_value = w5	'colour sensor blue content
symbol green_value = w6	'colour sensor green content

'********************************************
' Scan and display every second

main:
  gosub colour		'scan the colour
  sertxd ("Red =", 9, #red_value, 9)
  sertxd ("Blue =", 9, #blue_value, 9)
  sertxd ("Green =", 9, #green_value, CR, LF)
  pause 1000
  goto main

' ********************************************
' Sub to scan colours

colour:
  high LED			'LED on
  low S2			'read red into w4
  low S3
  count 3, 50, red_value
  high S3			'read blue into w5
  count 3, 50, blue_value
  high S2			'read green into w6
  count 3, 50, green_value
  low LED			'LED off
  return
